/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiOldInferenceHelper
implements PsiInferenceHelper {
    private static final Logger LOG = Logger.getInstance("#" + PsiOldInferenceHelper.class.getName());
    public static final Pair<PsiType, ConstraintType> RAW_INFERENCE = new Pair<Object, ConstraintType>(null, ConstraintType.EQUALS);
    private final PsiManager myManager;
    private static final Pair<PsiType, ConstraintType> FAILED_INFERENCE = new Pair<PsiPrimitiveType, ConstraintType>(PsiType.NULL, ConstraintType.EQUALS);
    private static final Key<Boolean> inferSubtyping = Key.create("infer.subtyping.marker");

    public PsiOldInferenceHelper(PsiManager manager) {
        this.myManager = manager;
    }

    private Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        PsiType[] paramTypes = PsiType.createArray(arguments2.length);
        PsiType[] argTypes = PsiType.createArray(arguments2.length);
        if (parameters2.length > 0) {
            for (int j = 0; j < argTypes.length; ++j) {
                PsiExpression argument = arguments2[j];
                if (argument == null || argument instanceof PsiMethodCallExpression && PsiResolveHelper.ourGuard.currentStack().contains(argument)) continue;
                RecursionGuard.StackStamp stackStamp = PsiDiamondType.ourDiamondGuard.markStack();
                argTypes[j] = argument.getType();
                if (!stackStamp.mayCacheNow()) {
                    argTypes[j] = null;
                    continue;
                }
                PsiParameter parameter = parameters2[Math.min(j, parameters2.length - 1)];
                if (j >= parameters2.length && !parameter.isVarArgs()) break;
                paramTypes[j] = parameter.getType();
                if (!(paramTypes[j] instanceof PsiEllipsisType)) continue;
                paramTypes[j] = ((PsiEllipsisType)paramTypes[j]).getComponentType();
                if (arguments2.length != parameters2.length || !(argTypes[j] instanceof PsiArrayType) || ((PsiArrayType)argTypes[j]).getComponentType() instanceof PsiPrimitiveType) continue;
                argTypes[j] = ((PsiArrayType)argTypes[j]).getComponentType();
            }
        }
        return this.inferTypeForMethodTypeParameterInner(typeParameter, paramTypes, argTypes, partialSubstitutor, parent, policy);
    }

    private Pair<PsiType, ConstraintType> inferTypeForMethodTypeParameterInner(@NotNull PsiTypeParameter typeParameter, @NotNull PsiType[] paramTypes, @NotNull PsiType[] argTypes, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        Pair<PsiType, ConstraintType> constraint;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        if (paramTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paramTypes", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        if (argTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argTypes", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameterInner"));
        }
        PsiType wildcardToCapture = null;
        Pair<PsiType, ConstraintType> rawInference = null;
        PsiType lowerBound = PsiType.NULL;
        PsiType upperBound = PsiType.NULL;
        if (paramTypes.length > 0) {
            block5: for (int j = 0; j < argTypes.length; ++j) {
                Pair<PsiType, ConstraintType> currentSubstitution;
                PsiType parameterType;
                PsiType argumentType = argTypes[j];
                if (argumentType == null) continue;
                if (j >= paramTypes.length || (parameterType = paramTypes[j]) == null) break;
                if (parameterType instanceof PsiEllipsisType) {
                    parameterType = ((PsiEllipsisType)parameterType).getComponentType();
                    if (argTypes.length == paramTypes.length && argumentType instanceof PsiArrayType && !(((PsiArrayType)argumentType).getComponentType() instanceof PsiPrimitiveType)) {
                        argumentType = ((PsiArrayType)argumentType).getComponentType();
                    }
                }
                if ((currentSubstitution = this.getSubstitutionForTypeParameterConstraint(typeParameter, parameterType, argumentType, true, PsiUtil.getLanguageLevel(typeParameter))) == null) continue;
                if (currentSubstitution == FAILED_INFERENCE) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                ConstraintType constraintType = currentSubstitution.getSecond();
                PsiType type2 = currentSubstitution.getFirst();
                if (type2 == null) {
                    rawInference = RAW_INFERENCE;
                    continue;
                }
                switch (constraintType) {
                    case EQUALS: {
                        if (!(type2 instanceof PsiWildcardType)) {
                            return currentSubstitution;
                        }
                        if (wildcardToCapture != null) {
                            return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                        }
                        wildcardToCapture = (PsiWildcardType)type2;
                        continue block5;
                    }
                    case SUPERTYPE: {
                        if (PsiType.NULL.equals(lowerBound)) {
                            lowerBound = type2;
                            continue block5;
                        }
                        if (((Object)lowerBound).equals(type2) || (lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, type2, this.myManager)) != null) continue block5;
                        return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                    }
                    case SUBTYPE: {
                        if (!PsiType.NULL.equals(upperBound) && !TypeConversionUtil.isAssignable(upperBound, type2)) continue block5;
                        upperBound = type2;
                    }
                }
            }
        }
        if (wildcardToCapture != null) {
            if (lowerBound != PsiType.NULL) {
                if (!wildcardToCapture.isAssignableFrom(lowerBound)) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                if (((PsiWildcardType)wildcardToCapture).isSuper()) {
                    return new Pair<PsiType, ConstraintType>(wildcardToCapture, ConstraintType.SUPERTYPE);
                }
                lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, wildcardToCapture, this.myManager);
            } else {
                if (upperBound != PsiType.NULL && !upperBound.isAssignableFrom(wildcardToCapture)) {
                    return PsiOldInferenceHelper.getFailedInferenceConstraint(typeParameter);
                }
                return new Pair<PsiType, ConstraintType>(wildcardToCapture, ConstraintType.EQUALS);
            }
        }
        if (rawInference != null) {
            return rawInference;
        }
        if (lowerBound != PsiType.NULL) {
            return Pair.create(lowerBound, ConstraintType.EQUALS);
        }
        if (parent != null && (constraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy)) != null) {
            if (constraint.getSecond() != ConstraintType.SUBTYPE) {
                return constraint;
            }
            if (upperBound != PsiType.NULL) {
                return Pair.create(upperBound, ConstraintType.SUBTYPE);
            }
            return constraint;
        }
        if (upperBound != PsiType.NULL) {
            return Pair.create(upperBound, ConstraintType.SUBTYPE);
        }
        return null;
    }

    private static Pair<PsiType, ConstraintType> getFailedInferenceConstraint(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "getFailedInferenceConstraint"));
        }
        return new Pair<PsiType, ConstraintType>(JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter), ConstraintType.EQUALS);
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        Pair<PsiType, ConstraintType> constraint = this.inferTypeForMethodTypeParameterInner(typeParameter, parameters2, arguments2, partialSubstitutor, parent, policy);
        if (constraint == null) {
            return PsiType.NULL;
        }
        return constraint.getFirst();
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        PsiType substitution;
        PsiTypeParameter typeParameter;
        int i;
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        PsiType[] substitutions = PsiType.createArray(typeParameters.length);
        Pair[] constraints = new Pair[typeParameters.length];
        for (i = 0; i < typeParameters.length; ++i) {
            Pair<PsiType, ConstraintType> constraint;
            if (substitutions[i] != null) continue;
            constraints[i] = constraint = this.inferTypeForMethodTypeParameterInner(typeParameters[i], parameters2, arguments2, partialSubstitutor, null, policy);
            if (constraint == null || constraint.getSecond() == ConstraintType.SUBTYPE) continue;
            substitutions[i] = constraint.getFirst();
            if (substitutions[i] == null || !languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameters[i], substitutions[i]);
            i = -1;
        }
        for (i = 0; i < typeParameters.length; ++i) {
            typeParameter = typeParameters[i];
            if (substitutions[i] != null) continue;
            PsiType substitutionFromBounds = PsiType.NULL;
            block2: for (int j = 0; j < typeParameters.length; ++j) {
                PsiClassType[] bounds;
                if (i == j) continue;
                PsiTypeParameter other = typeParameters[j];
                PsiType otherSubstitution = substitutions[j];
                if (otherSubstitution == null) continue;
                for (PsiClassType bound : bounds = other.getExtendsListTypes()) {
                    PsiType substitutedBound = partialSubstitutor.substitute(bound);
                    Pair<PsiType, ConstraintType> currentConstraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, substitutedBound, otherSubstitution, true, languageLevel);
                    if (currentConstraint == null) continue;
                    PsiType currentSubstitution = currentConstraint.getFirst();
                    ConstraintType currentConstraintType = currentConstraint.getSecond();
                    if (currentConstraintType == ConstraintType.EQUALS) {
                        substitutionFromBounds = currentSubstitution;
                        if (currentSubstitution != null) break block2;
                        constraints[i] = FAILED_INFERENCE;
                        break block2;
                    }
                    if (currentConstraintType != ConstraintType.SUPERTYPE || JavaVersionService.getInstance().isAtLeast(parent, JavaSdkVersion.JDK_1_7)) continue;
                    substitutionFromBounds = PsiType.NULL.equals(substitutionFromBounds) ? currentSubstitution : GenericsUtil.getLeastUpperBound(substitutionFromBounds, currentSubstitution, this.myManager);
                }
            }
            if (substitutionFromBounds == PsiType.NULL) continue;
            substitutions[i] = substitutionFromBounds;
        }
        for (i = 0; i < typeParameters.length; ++i) {
            typeParameter = typeParameters[i];
            substitution = substitutions[i];
            if (substitution == PsiType.NULL) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameter, substitution);
        }
        for (i = 0; i < typeParameters.length; ++i) {
            Pair<PsiType, ConstraintType> otherConstraint;
            typeParameter = typeParameters[i];
            substitution = substitutions[i];
            if (substitution != null) continue;
            Pair<PsiType, ConstraintType> constraint = constraints[i];
            if (constraint == null) {
                constraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy);
            } else if (constraint.getSecond() == ConstraintType.SUBTYPE && (otherConstraint = this.inferMethodTypeParameterFromParent(typeParameter, partialSubstitutor, parent, policy)) != null && (otherConstraint.getSecond() == ConstraintType.EQUALS || otherConstraint.getSecond() == ConstraintType.SUPERTYPE || PsiOldInferenceHelper.compareSubtypes(constraint.getFirst(), otherConstraint.getFirst()))) {
                constraint = otherConstraint;
            }
            if (constraint != null) {
                substitution = constraint.getFirst();
            }
            if (substitution == null) {
                PsiElementFactory factory = JavaPsiFacade.getInstance(this.myManager.getProject()).getElementFactory();
                PsiSubstitutor psiSubstitutor = factory.createRawSubstitutor(partialSubstitutor, typeParameters);
                if (psiSubstitutor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
                }
                return psiSubstitutor;
            }
            if (substitution == PsiType.NULL) continue;
            partialSubstitutor = partialSubstitutor.put(typeParameter, substitution);
        }
        PsiSubstitutor psiSubstitutor = partialSubstitutor;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    private static boolean compareSubtypes(PsiType type2, PsiType parentType) {
        return type2 != null && parentType != null && TypeConversionUtil.isAssignable(type2, parentType);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftTypes", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightTypes", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        if (leftTypes.length != rightTypes.length) {
            throw new IllegalArgumentException("Types must be of the same length");
        }
        PsiSubstitutor substitutor2 = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : typeParameters) {
            PsiType substitution = PsiType.NULL;
            PsiType lowerBound = PsiType.NULL;
            for (int i1 = 0; i1 < leftTypes.length; ++i1) {
                PsiType leftType = leftTypes[i1];
                PsiType rightType = rightTypes[i1];
                Pair<PsiType, ConstraintType> constraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, leftType, rightType, true, languageLevel);
                if (constraint == null) continue;
                ConstraintType constraintType = constraint.getSecond();
                PsiType current = constraint.getFirst();
                if (constraintType == ConstraintType.EQUALS) {
                    substitution = current;
                    break;
                }
                if (constraintType == ConstraintType.SUBTYPE) {
                    if (PsiType.NULL.equals(substitution)) {
                        substitution = current;
                        continue;
                    }
                    substitution = GenericsUtil.getLeastUpperBound(substitution, current, this.myManager);
                    continue;
                }
                lowerBound = PsiType.NULL.equals(lowerBound) ? current : GenericsUtil.getLeastUpperBound(lowerBound, current, this.myManager);
            }
            if (PsiType.NULL.equals(substitution)) {
                substitution = lowerBound;
            }
            if (substitution == PsiType.NULL) continue;
            substitutor2 = substitutor2.put(typeParameter, substitution);
        }
        for (int i = 0; i < typeParameters.length; ++i) {
            PsiTypeParameter typeParameter = typeParameters[i];
            if (substitutor2.getSubstitutionMap().containsKey(typeParameter)) continue;
            PsiType substitutionFromBounds = PsiType.NULL;
            block3: for (int j = 0; j < typeParameters.length; ++j) {
                PsiClassType[] bounds;
                PsiTypeParameter other;
                PsiType otherSubstitution;
                if (i == j || (otherSubstitution = substitutor2.substitute(other = typeParameters[j])) == null) continue;
                for (PsiClassType bound : bounds = other.getExtendsListTypes()) {
                    PsiType substitutedBound = substitutor2.substitute(bound);
                    Pair<PsiType, ConstraintType> currentConstraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, substitutedBound, otherSubstitution, true, languageLevel);
                    if (currentConstraint == null) continue;
                    PsiType currentSubstitution = currentConstraint.getFirst();
                    ConstraintType currentConstraintType = currentConstraint.getSecond();
                    if (currentConstraintType == ConstraintType.EQUALS) {
                        substitutionFromBounds = currentSubstitution;
                        break block3;
                    }
                    if (currentConstraintType != ConstraintType.SUPERTYPE) continue;
                    substitutionFromBounds = PsiType.NULL.equals(substitutionFromBounds) ? currentSubstitution : GenericsUtil.getLeastUpperBound(substitutionFromBounds, currentSubstitution, this.myManager);
                }
            }
            if (substitutionFromBounds == PsiType.NULL) continue;
            substitutor2 = substitutor2.put(typeParameter, substitutionFromBounds);
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Nullable
    private static Pair<PsiType, ConstraintType> processArgType(PsiType arg, ConstraintType constraintType, boolean captureWildcard) {
        if (arg instanceof PsiWildcardType && !captureWildcard) {
            return FAILED_INFERENCE;
        }
        if (arg != PsiType.NULL) {
            return Pair.create(arg, constraintType);
        }
        return null;
    }

    private Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor2, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        Pair<PsiType, ConstraintType> substitution = null;
        if (owner instanceof PsiMethod && parent instanceof PsiCallExpression) {
            PsiCallExpression methodCall = (PsiCallExpression)parent;
            substitution = this.inferMethodTypeParameterFromParent(PsiUtil.skipParenthesizedExprUp(methodCall.getParent()), methodCall, typeParameter, substitutor2, policy);
        }
        return substitution;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        Pair<PsiType, ConstraintType> constraint = this.getSubstitutionForTypeParameterConstraint(typeParam, param, arg, isContraVariantPosition, languageLevel);
        return constraint == null ? PsiType.NULL : constraint.getFirst();
    }

    @Nullable
    public Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterConstraint(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiClassType.ClassResolveResult paramResult;
        PsiClass paramClass;
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameterConstraint(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return null;
        }
        PsiManager manager = this.myManager;
        if (arg instanceof PsiPrimitiveType) {
            if (!JavaVersionService.getInstance().isAtLeast(typeParam, JavaSdkVersion.JDK_1_7) && !isContraVariantPosition) {
                return null;
            }
            if ((arg = ((PsiPrimitiveType)arg).getBoxedType(typeParam)) == null) {
                return null;
            }
        }
        if (typeParam == (paramClass = (PsiClass)(paramResult = ((PsiClassType)param).resolveGenerics()).getElement())) {
            PsiClass psiClass = PsiUtil.resolveClassInType(arg);
            if (arg == null || arg.getDeepComponentType() instanceof PsiPrimitiveType || arg instanceof PsiIntersectionType || psiClass != null && (isContraVariantPosition || !"java.lang.Object".equals(psiClass.getQualifiedName()) || arg instanceof PsiArrayType)) {
                PsiType bound = PsiOldInferenceHelper.intersectAllExtends(typeParam, arg);
                return Pair.create(bound, ConstraintType.SUPERTYPE);
            }
            if (psiClass == null && arg instanceof PsiClassType) {
                return Pair.create(arg, ConstraintType.EQUALS);
            }
            return null;
        }
        if (paramClass == null) {
            return null;
        }
        if (!(arg instanceof PsiClassType)) {
            return null;
        }
        PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
        PsiClass argClass = (PsiClass)argResult.getElement();
        if (argClass == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiClassType patternType = factory.createType(typeParam);
        if (isContraVariantPosition) {
            PsiSubstitutor substitutor2 = TypeConversionUtil.getClassSubstitutor(paramClass, argClass, argResult.getSubstitutor());
            if (substitutor2 == null) {
                return null;
            }
            arg = factory.createType(paramClass, substitutor2, languageLevel);
        } else {
            PsiSubstitutor substitutor3 = TypeConversionUtil.getClassSubstitutor(argClass, paramClass, paramResult.getSubstitutor());
            if (substitutor3 == null) {
                return null;
            }
            param = factory.createType(argClass, substitutor3, languageLevel);
        }
        return this.getSubstitutionForTypeParameterInner(param, arg, patternType, ConstraintType.SUPERTYPE, 0);
    }

    private static PsiType intersectAllExtends(PsiTypeParameter typeParam, PsiType arg) {
        if (arg == null) {
            return null;
        }
        PsiClassType[] superTypes = typeParam.getSuperTypes();
        PsiType[] erasureTypes = PsiType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            erasureTypes[i] = TypeConversionUtil.erasure(superTypes[i]);
        }
        PsiType[] types2 = ArrayUtil.append(erasureTypes, arg, PsiType.class);
        assert (types2.length != 0);
        return PsiIntersectionType.createIntersection(types2);
    }

    @Nullable
    private Pair<PsiType, ConstraintType> getSubstitutionForTypeParameterInner(PsiType param, PsiType arg, PsiType patternType, ConstraintType constraintType, int depth) {
        if (patternType.equals(param)) {
            return PsiOldInferenceHelper.processArgType(arg, constraintType, depth < 2);
        }
        if (arg instanceof PsiCapturedWildcardType && (depth < 2 || constraintType != ConstraintType.EQUALS || param instanceof PsiWildcardType)) {
            arg = ((PsiCapturedWildcardType)arg).getWildcard();
        }
        if (param instanceof PsiWildcardType) {
            PsiClassType.ClassResolveResult argResult;
            PsiClass argClass;
            PsiClassType.ClassResolveResult boundResult;
            PsiClass boundClass;
            Pair<PsiType, ConstraintType> res;
            ConstraintType constrType;
            PsiWildcardType wildcardParam = (PsiWildcardType)param;
            PsiType paramBound = wildcardParam.getBound();
            if (paramBound == null) {
                return null;
            }
            ConstraintType constraintType2 = constrType = wildcardParam.isExtends() ? ConstraintType.SUPERTYPE : ConstraintType.SUBTYPE;
            if (arg instanceof PsiWildcardType) {
                if (((PsiWildcardType)arg).isExtends() == wildcardParam.isExtends() && ((PsiWildcardType)arg).isBounded() == wildcardParam.isBounded() && (res = this.getSubstitutionForTypeParameterInner(paramBound, ((PsiWildcardType)arg).getBound(), patternType, constrType, depth)) != null) {
                    return res;
                }
            } else if (patternType.equals(paramBound)) {
                res = this.getSubstitutionForTypeParameterInner(paramBound, arg, patternType, constrType, depth);
                if (res != null) {
                    return res;
                }
            } else if (paramBound instanceof PsiArrayType && arg instanceof PsiArrayType) {
                res = this.getSubstitutionForTypeParameterInner(((PsiArrayType)paramBound).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constrType, depth);
                if (res != null) {
                    return res;
                }
            } else if (paramBound instanceof PsiClassType && arg instanceof PsiClassType && (boundClass = (boundResult = ((PsiClassType)paramBound).resolveGenerics()).getElement()) != null && (argClass = (argResult = ((PsiClassType)arg).resolveGenerics()).getElement()) != null) {
                Pair<PsiType, ConstraintType> res2;
                PsiType substituted;
                PsiSubstitutor superSubstitutor;
                if (wildcardParam.isExtends()) {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor(boundClass, argClass, argResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(boundClass)) {
                            substituted = superSubstitutor.substitute(typeParameter);
                            if (substituted == null || (res2 = this.getSubstitutionForTypeParameterInner(boundResult.getSubstitutor().substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                            return res2;
                        }
                    }
                } else {
                    superSubstitutor = TypeConversionUtil.getClassSubstitutor(argClass, boundClass, boundResult.getSubstitutor());
                    if (superSubstitutor != null) {
                        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(argClass)) {
                            substituted = argResult.getSubstitutor().substitute(typeParameter);
                            if (substituted == null || (res2 = this.getSubstitutionForTypeParameterInner(superSubstitutor.substitute(typeParameter), substituted, patternType, ConstraintType.EQUALS, depth + 1)) == null || res2 == FAILED_INFERENCE) continue;
                            return res2;
                        }
                    }
                }
            }
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameterInner(((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), patternType, constraintType, depth);
        }
        if (param instanceof PsiClassType && arg instanceof PsiClassType) {
            PsiClassType.ClassResolveResult paramResult = ((PsiClassType)param).resolveGenerics();
            PsiClass paramClass = paramResult.getElement();
            if (paramClass == null) {
                return null;
            }
            PsiClassType.ClassResolveResult argResult = ((PsiClassType)arg).resolveGenerics();
            PsiClass argClass = argResult.getElement();
            if (!paramClass.isEquivalentTo(argClass)) {
                return this.inferBySubtypingConstraint(patternType, constraintType, depth, paramClass, argClass);
            }
            PsiType lowerBound = PsiType.NULL;
            PsiType upperBound = PsiType.NULL;
            Pair<PsiType, ConstraintType> wildcardCaptured = null;
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(paramClass)) {
                Pair<PsiType, ConstraintType> res;
                PsiType paramType = paramResult.getSubstitutor().substitute(typeParameter);
                PsiType argType = argResult.getSubstitutor().substituteWithBoundsPromotion(typeParameter);
                if (wildcardCaptured != null) {
                    boolean alreadyFound = false;
                    for (PsiTypeParameter typeParam : PsiUtil.typeParametersIterable(paramClass)) {
                        if (typeParam == typeParameter || paramType == null || argResult.getSubstitutor().substituteWithBoundsPromotion(typeParam) != argType || !paramType.equals(paramResult.getSubstitutor().substitute(typeParam))) continue;
                        alreadyFound = true;
                    }
                    if (alreadyFound) continue;
                }
                if ((res = this.getSubstitutionForTypeParameterInner(paramType, argType, patternType, ConstraintType.EQUALS, depth + 1)) == null) continue;
                PsiType type2 = res.getFirst();
                switch (res.getSecond()) {
                    case EQUALS: {
                        if (!(type2 instanceof PsiWildcardType)) {
                            return res;
                        }
                        if (wildcardCaptured != null) {
                            return FAILED_INFERENCE;
                        }
                        wildcardCaptured = res;
                        break;
                    }
                    case SUPERTYPE: {
                        wildcardCaptured = res;
                        if (PsiType.NULL.equals(lowerBound)) {
                            lowerBound = type2;
                            break;
                        }
                        if (((Object)lowerBound).equals(type2) || (lowerBound = GenericsUtil.getLeastUpperBound(lowerBound, type2, this.myManager)) != null) break;
                        return FAILED_INFERENCE;
                    }
                    case SUBTYPE: {
                        wildcardCaptured = res;
                        if (!PsiType.NULL.equals(upperBound) && !TypeConversionUtil.isAssignable(upperBound, type2)) break;
                        upperBound = type2;
                    }
                }
            }
            if (lowerBound != PsiType.NULL) {
                return Pair.create(lowerBound, ConstraintType.SUPERTYPE);
            }
            if (upperBound != PsiType.NULL) {
                return Pair.create(upperBound, ConstraintType.SUBTYPE);
            }
            return wildcardCaptured;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<PsiType, ConstraintType> inferBySubtypingConstraint(PsiType patternType, ConstraintType constraintType, int depth, PsiClass paramClass, PsiClass argClass) {
        if (argClass instanceof PsiTypeParameter && paramClass instanceof PsiTypeParameter && PsiUtil.isLanguageLevel8OrHigher(argClass)) {
            PsiClassType[] paramExtendsListTypes;
            Boolean alreadyInferBySubtyping = paramClass.getCopyableUserData(inferSubtyping);
            if (alreadyInferBySubtyping != null) {
                return null;
            }
            PsiClassType[] argExtendsListTypes = argClass.getExtendsListTypes();
            if (argExtendsListTypes.length == (paramExtendsListTypes = paramClass.getExtendsListTypes()).length) {
                try {
                    paramClass.putCopyableUserData(inferSubtyping, true);
                    for (int i = 0; i < argExtendsListTypes.length; ++i) {
                        Pair<PsiType, ConstraintType> constraint;
                        PsiClassType argBoundType = argExtendsListTypes[i];
                        PsiClassType paramBoundType = paramExtendsListTypes[i];
                        PsiClassType.ClassResolveResult argResolveResult = argBoundType.resolveGenerics();
                        PsiClassType.ClassResolveResult paramResolveResult = paramBoundType.resolveGenerics();
                        PsiClass paramBoundClass = paramResolveResult.getElement();
                        PsiClass argBoundClass = argResolveResult.getElement();
                        if (argBoundClass != null && paramBoundClass != null && paramBoundClass != argBoundClass) {
                            PsiSubstitutor superClassSubstitutor;
                            if (argBoundClass.isInheritor(paramBoundClass, true)) {
                                superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(paramBoundClass, argBoundClass, argResolveResult.getSubstitutor());
                                argBoundType = JavaPsiFacade.getElementFactory(argClass.getProject()).createType(paramBoundClass, superClassSubstitutor);
                            } else {
                                superClassSubstitutor = null;
                                return superClassSubstitutor;
                            }
                        }
                        if ((constraint = this.getSubstitutionForTypeParameterInner(paramBoundType, argBoundType, patternType, constraintType, depth)) == null) continue;
                        Pair<PsiType, ConstraintType> pair = constraint;
                        return pair;
                    }
                }
                finally {
                    paramClass.putCopyableUserData(inferSubtyping, null);
                }
            }
        }
        return null;
    }

    private Pair<PsiType, ConstraintType> inferMethodTypeParameterFromParent(@NotNull PsiElement parent, @NotNull PsiExpression methodCall, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor2, @NotNull ParameterTypeInferencePolicy policy) {
        PsiType guess;
        PsiElement pParent;
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        if (substitutor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/PsiOldInferenceHelper", "inferMethodTypeParameterFromParent"));
        }
        Pair<PsiType, ConstraintType> constraint = null;
        PsiType expectedType = PsiTypesUtil.getExpectedTypeByParent(methodCall);
        if (expectedType == null && parent instanceof PsiExpressionList && (pParent = parent.getParent()) instanceof PsiCallExpression && parent.equals(((PsiCallExpression)pParent).getArgumentList())) {
            constraint = policy.inferTypeConstraintFromCallContext(methodCall, (PsiExpressionList)parent, (PsiCallExpression)pParent, typeParameter);
        }
        GlobalSearchScope scope2 = parent.getResolveScope();
        PsiType returnType2 = null;
        if (constraint == null) {
            if (expectedType == null) {
                PsiType psiType = expectedType = methodCall instanceof PsiCallExpression ? policy.getDefaultExpectedType((PsiCallExpression)methodCall) : null;
            }
            if ((constraint = this.getSubstitutionForTypeParameterConstraint(typeParameter, returnType2 = ((PsiMethod)typeParameter.getOwner()).getReturnType(), expectedType, false, PsiUtil.getLanguageLevel(parent))) != null && (guess = constraint.getFirst()) != null && !guess.equals(PsiType.NULL) && constraint.getSecond() == ConstraintType.SUPERTYPE && guess instanceof PsiIntersectionType && !JavaVersionService.getInstance().isAtLeast(parent, JavaSdkVersion.JDK_1_7)) {
                for (PsiType conjuct : ((PsiIntersectionType)guess).getConjuncts()) {
                    if (conjuct.isAssignableFrom(expectedType)) continue;
                    return FAILED_INFERENCE;
                }
            }
        }
        if (constraint == null) {
            if (methodCall instanceof PsiCallExpression) {
                PsiClassType[] superTypes = typeParameter.getSuperTypes();
                if (superTypes.length == 0) {
                    return null;
                }
                PsiType[] types2 = PsiType.createArray(superTypes.length);
                for (int i = 0; i < superTypes.length; ++i) {
                    PsiType superType = substitutor2.substitute(superTypes[i]);
                    if (superType instanceof PsiClassType && ((PsiClassType)superType).isRaw()) {
                        superType = TypeConversionUtil.erasure(superType);
                    }
                    if (superType == null) {
                        superType = PsiType.getJavaLangObject(this.myManager, scope2);
                    }
                    types2[i] = superType;
                }
                return policy.getInferredTypeWithNoConstraint(this.myManager, PsiIntersectionType.createIntersection(types2));
            }
            return null;
        }
        guess = (PsiType)constraint.getFirst();
        guess = policy.adjustInferredType(this.myManager, guess, (ConstraintType)((Object)constraint.getSecond()));
        if (returnType2 instanceof PsiClassType && typeParameter.equals(((PsiClassType)returnType2).resolve())) {
            PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
            PsiSubstitutor newSubstitutor = substitutor2.put(typeParameter, guess);
            for (PsiClassType extendsType1 : extendsTypes) {
                PsiType extendsType = newSubstitutor.substitute(extendsType1);
                if (guess == null || extendsType.isAssignableFrom(guess)) continue;
                if (!guess.isAssignableFrom(extendsType)) break;
                guess = extendsType;
                newSubstitutor = substitutor2.put(typeParameter, guess);
            }
        }
        return Pair.create(guess, constraint.getSecond());
    }
}

