/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.containers.SLRUCache;
import com.intellij.util.containers.hash.EqualityPolicy;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public abstract class FileAccessorCache<K, T>
implements EqualityPolicy<K> {
    private final SLRUCache<K, Handle<T>> myCache;
    private final Object myLock = new Object();

    public FileAccessorCache(int protectedQueueSize, int probationalQueueSize) {
        this.myCache = new SLRUCache<K, Handle<T>>(protectedQueueSize, probationalQueueSize, this){

            @Override
            @NotNull
            public final Handle<T> createValue(K path) {
                Handle handle;
                block2: {
                    try {
                        handle = new Handle(FileAccessorCache.this.createAccessor(path), FileAccessorCache.this);
                        if (handle != null) break block2;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/FileAccessorCache$1", "createValue"));
                }
                return handle;
            }

            @Override
            protected final void onDropFromCache(K key, Handle<T> value) {
                value.release();
            }
        };
    }

    protected abstract T createAccessor(K var1) throws IOException;

    protected abstract void disposeAccessor(T var1);

    protected void disposeCloseable(Closeable fileAccessor) {
        try {
            fileAccessor.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public final Handle<T> get(K key) {
        Object object = this.myLock;
        // MONITORENTER : object
        Handle<T> value = this.myCache.get(key);
        ((Handle)value).allocate();
        Handle<T> handle = value;
        // MONITOREXIT : object
        if (handle != null) return handle;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/FileAccessorCache", "get"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCache.remove(key);
        }
    }

    @Override
    public int getHashCode(K value) {
        return value.hashCode();
    }

    @Override
    public boolean isEqual(K val1, K val2) {
        return val1.equals(val2);
    }

    public static final class Handle<T> {
        private final FileAccessorCache<?, T> myOwner;
        private final T myFileAccessor;
        private final AtomicInteger myRefCount = new AtomicInteger(1);

        public Handle(T fileAccessor, FileAccessorCache<?, T> owner) {
            this.myFileAccessor = fileAccessor;
            this.myOwner = owner;
        }

        private void allocate() {
            this.myRefCount.incrementAndGet();
        }

        public final void release() {
            if (this.myRefCount.decrementAndGet() == 0) {
                this.myOwner.disposeAccessor(this.myFileAccessor);
            }
        }

        public T get() {
            return this.myFileAccessor;
        }
    }
}

