/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackProxy;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

class CallbackReference
extends WeakReference {
    static final Map callbackMap = new WeakHashMap();
    static final Map allocations = new WeakHashMap();
    private static final Method PROXY_CALLBACK_METHOD;
    private static final Map initializers;
    Pointer cbstruct;
    CallbackProxy proxy;
    Method method;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$com$sun$jna$CallbackProxy;
    static /* synthetic */ Class class$com$sun$jna$AltCallingConvention;
    static /* synthetic */ Class class$com$sun$jna$Structure;
    static /* synthetic */ Class class$com$sun$jna$Structure$ByValue;
    static /* synthetic */ Class class$com$sun$jna$Pointer;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$sun$jna$WString;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Lcom$sun$jna$WString;
    static /* synthetic */ Class class$com$sun$jna$Callback;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public static Callback getCallback(Class type2, Pointer p) {
        return CallbackReference.getCallback(type2, p, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Callback getCallback(Class type2, Pointer p, boolean direct) {
        Map map2;
        if (p == null) {
            return null;
        }
        if (!type2.isInterface()) {
            throw new IllegalArgumentException("Callback type must be an interface");
        }
        Map map3 = map2 = callbackMap;
        synchronized (map3) {
            for (Callback cb : map2.keySet()) {
                CallbackReference cbref;
                Pointer cbp;
                if (!type2.isAssignableFrom(cb.getClass()) || !p.equals(cbp = (cbref = (CallbackReference)map2.get(cb)) != null ? cbref.getTrampoline() : CallbackReference.getNativeFunctionPointer(cb))) continue;
                return cb;
            }
            int ctype = (class$com$sun$jna$AltCallingConvention == null ? (class$com$sun$jna$AltCallingConvention = CallbackReference.class$("com.sun.jna.AltCallingConvention")) : class$com$sun$jna$AltCallingConvention).isAssignableFrom(type2) ? 1 : 0;
            HashMap<String, Method> foptions = new HashMap<String, Method>();
            Map options = Native.getLibraryOptions(type2);
            if (options != null) {
                foptions.putAll(options);
            }
            foptions.put("invoking-method", CallbackReference.getCallbackMethod(type2));
            NativeFunctionHandler h = new NativeFunctionHandler(p, ctype, foptions);
            Callback cb = (Callback)Proxy.newProxyInstance(type2.getClassLoader(), new Class[]{type2}, (InvocationHandler)h);
            map2.put(cb, null);
            return cb;
        }
    }

    private CallbackReference(Callback callback, int callingConvention, boolean direct) {
        super(callback);
        boolean ppc;
        TypeMapper mapper = Native.getTypeMapper(callback.getClass());
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean bl = ppc = "ppc".equals(arch) || "powerpc".equals(arch);
        if (direct) {
            Method m = CallbackReference.getCallbackMethod(callback);
            Class<?>[] ptypes = m.getParameterTypes();
            for (int i = 0; i < ptypes.length; ++i) {
                if (ppc && (ptypes[i] == Float.TYPE || ptypes[i] == Double.TYPE)) {
                    direct = false;
                    break;
                }
                if (mapper == null || mapper.getFromNativeConverter(ptypes[i]) == null) continue;
                direct = false;
                break;
            }
            if (mapper != null && mapper.getToNativeConverter(m.getReturnType()) != null) {
                direct = false;
            }
        }
        if (direct) {
            Class<?> returnType2;
            this.method = CallbackReference.getCallbackMethod(callback);
            Class[] nativeParamTypes = this.method.getParameterTypes();
            long peer = Native.createNativeCallback(callback, this.method, nativeParamTypes, returnType2 = this.method.getReturnType(), callingConvention, true);
            this.cbstruct = peer != 0L ? new Pointer(peer) : null;
        } else {
            this.proxy = callback instanceof CallbackProxy ? (CallbackProxy)callback : new DefaultCallbackProxy(CallbackReference.getCallbackMethod(callback), mapper);
            Class[] nativeParamTypes = this.proxy.getParameterTypes();
            Class returnType3 = this.proxy.getReturnType();
            if (mapper != null) {
                for (int i = 0; i < nativeParamTypes.length; ++i) {
                    FromNativeConverter rc = mapper.getFromNativeConverter(nativeParamTypes[i]);
                    if (rc == null) continue;
                    nativeParamTypes[i] = rc.nativeType();
                }
                ToNativeConverter tn = mapper.getToNativeConverter(returnType3);
                if (tn != null) {
                    returnType3 = tn.nativeType();
                }
            }
            for (int i = 0; i < nativeParamTypes.length; ++i) {
                nativeParamTypes[i] = this.getNativeType(nativeParamTypes[i]);
                if (CallbackReference.isAllowableNativeType(nativeParamTypes[i])) continue;
                String msg = new StringBuffer().append("Callback argument ").append(nativeParamTypes[i]).append(" requires custom type conversion").toString();
                throw new IllegalArgumentException(msg);
            }
            if (!CallbackReference.isAllowableNativeType(returnType3 = this.getNativeType(returnType3))) {
                String msg = new StringBuffer().append("Callback return type ").append(returnType3).append(" requires custom type conversion").toString();
                throw new IllegalArgumentException(msg);
            }
            long peer = Native.createNativeCallback(this.proxy, PROXY_CALLBACK_METHOD, nativeParamTypes, returnType3, callingConvention, false);
            this.cbstruct = peer != 0L ? new Pointer(peer) : null;
        }
    }

    private Class getNativeType(Class cls) {
        if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = CallbackReference.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
            Structure.newInstance(cls);
            if (!(class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = CallbackReference.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(cls)) {
                return class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = CallbackReference.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer;
            }
        } else {
            if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = CallbackReference.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(cls)) {
                return NativeMappedConverter.getInstance(cls).nativeType();
            }
            if (cls == (class$java$lang$String == null ? (class$java$lang$String = CallbackReference.class$("java.lang.String")) : class$java$lang$String) || cls == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString) || cls == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = CallbackReference.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || cls == (array$Lcom$sun$jna$WString == null ? (array$Lcom$sun$jna$WString = CallbackReference.class$("[Lcom.sun.jna.WString;")) : array$Lcom$sun$jna$WString) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = CallbackReference.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls)) {
                return class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = CallbackReference.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer;
            }
        }
        return cls;
    }

    private static Method checkMethod(Method m) {
        if (m.getParameterTypes().length > 256) {
            String msg = new StringBuffer().append("Method signature exceeds the maximum parameter count: ").append(m).toString();
            throw new UnsupportedOperationException(msg);
        }
        return m;
    }

    static Class findCallbackClass(Class type2) {
        if (!(class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = CallbackReference.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(type2)) {
            throw new IllegalArgumentException(new StringBuffer().append(type2.getName()).append(" is not derived from com.sun.jna.Callback").toString());
        }
        if (type2.isInterface()) {
            return type2;
        }
        Class<?>[] ifaces = type2.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (!(class$com$sun$jna$Callback == null ? CallbackReference.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(ifaces[i])) continue;
            try {
                CallbackReference.getCallbackMethod(ifaces[i]);
                return ifaces[i];
            }
            catch (IllegalArgumentException e) {
                break;
            }
        }
        if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = CallbackReference.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(type2.getSuperclass())) {
            return CallbackReference.findCallbackClass(type2.getSuperclass());
        }
        return type2;
    }

    private static Method getCallbackMethod(Callback callback) {
        return CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass()));
    }

    private static Method getCallbackMethod(Class cls) {
        Method[] pubMethods = cls.getDeclaredMethods();
        Method[] classMethods = cls.getMethods();
        HashSet<Method> pmethods = new HashSet<Method>(Arrays.asList(pubMethods));
        pmethods.retainAll(Arrays.asList(classMethods));
        Iterator i = pmethods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!Callback.FORBIDDEN_NAMES.contains(m.getName())) continue;
            i.remove();
        }
        Method[] methods = pmethods.toArray(new Method[pmethods.size()]);
        if (methods.length == 1) {
            return CallbackReference.checkMethod(methods[0]);
        }
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method m = methods[i2];
            if (!"callback".equals(m.getName())) continue;
            return CallbackReference.checkMethod(m);
        }
        String msg = "Callback must implement a single public method, or one public method named 'callback'";
        throw new IllegalArgumentException(msg);
    }

    private void setCallbackOptions(int options) {
        this.cbstruct.setInt(Pointer.SIZE, options);
    }

    public Pointer getTrampoline() {
        return this.cbstruct.getPointer(0L);
    }

    protected void finalize() {
        this.dispose();
    }

    protected synchronized void dispose() {
        if (this.cbstruct != null) {
            Native.freeNativeCallback(this.cbstruct.peer);
            this.cbstruct.peer = 0L;
            this.cbstruct = null;
        }
    }

    private static Pointer getNativeFunctionPointer(Callback cb) {
        InvocationHandler handler2;
        if (Proxy.isProxyClass(cb.getClass()) && (handler2 = Proxy.getInvocationHandler(cb)) instanceof NativeFunctionHandler) {
            return ((NativeFunctionHandler)handler2).getPointer();
        }
        return null;
    }

    public static Pointer getFunctionPointer(Callback cb) {
        return CallbackReference.getFunctionPointer(cb, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pointer getFunctionPointer(Callback cb, boolean direct) {
        Map map2;
        Pointer fp = null;
        if (cb == null) {
            return null;
        }
        fp = CallbackReference.getNativeFunctionPointer(cb);
        if (fp != null) {
            return fp;
        }
        int callingConvention = cb instanceof AltCallingConvention ? 1 : 0;
        Map map3 = map2 = callbackMap;
        synchronized (map3) {
            CallbackReference cbref = (CallbackReference)map2.get(cb);
            if (cbref == null) {
                cbref = new CallbackReference(cb, callingConvention, direct);
                map2.put(cb, cbref);
                if (initializers.containsKey(cb)) {
                    cbref.setCallbackOptions(1);
                }
            }
            return cbref.getTrampoline();
        }
    }

    private static boolean isAllowableNativeType(Class cls) {
        return cls == Void.TYPE || cls == (class$java$lang$Void == null ? (class$java$lang$Void = CallbackReference.class$("java.lang.Void")) : class$java$lang$Void) || cls == Boolean.TYPE || cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CallbackReference.class$("java.lang.Boolean")) : class$java$lang$Boolean) || cls == Byte.TYPE || cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = CallbackReference.class$("java.lang.Byte")) : class$java$lang$Byte) || cls == Short.TYPE || cls == (class$java$lang$Short == null ? (class$java$lang$Short = CallbackReference.class$("java.lang.Short")) : class$java$lang$Short) || cls == Character.TYPE || cls == (class$java$lang$Character == null ? (class$java$lang$Character = CallbackReference.class$("java.lang.Character")) : class$java$lang$Character) || cls == Integer.TYPE || cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = CallbackReference.class$("java.lang.Integer")) : class$java$lang$Integer) || cls == Long.TYPE || cls == (class$java$lang$Long == null ? (class$java$lang$Long = CallbackReference.class$("java.lang.Long")) : class$java$lang$Long) || cls == Float.TYPE || cls == (class$java$lang$Float == null ? (class$java$lang$Float = CallbackReference.class$("java.lang.Float")) : class$java$lang$Float) || cls == Double.TYPE || cls == (class$java$lang$Double == null ? (class$java$lang$Double = CallbackReference.class$("java.lang.Double")) : class$java$lang$Double) || (class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = CallbackReference.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(cls) && (class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = CallbackReference.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls) || (class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = CallbackReference.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer).isAssignableFrom(cls);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        try {
            PROXY_CALLBACK_METHOD = (class$com$sun$jna$CallbackProxy == null ? (class$com$sun$jna$CallbackProxy = CallbackReference.class$("com.sun.jna.CallbackProxy")) : class$com$sun$jna$CallbackProxy).getMethod("callback", array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = CallbackReference.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object);
        }
        catch (Exception e) {
            throw new Error("Error looking up CallbackProxy.callback() method");
        }
        initializers = new WeakHashMap();
    }

    private static class NativeFunctionHandler
    implements InvocationHandler {
        private Function function;
        private Map options;

        public NativeFunctionHandler(Pointer address, int callingConvention, Map options) {
            this.function = new Function(address, callingConvention);
            this.options = options;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Library.Handler.OBJECT_TOSTRING.equals(method)) {
                String str = new StringBuffer().append("Proxy interface to ").append(this.function).toString();
                Method m = (Method)this.options.get("invoking-method");
                Class cls = CallbackReference.findCallbackClass(m.getDeclaringClass());
                str = new StringBuffer().append(str).append(" (").append(cls.getName()).append(")").toString();
                return str;
            }
            if (Library.Handler.OBJECT_HASHCODE.equals(method)) {
                return new Integer(this.hashCode());
            }
            if (Library.Handler.OBJECT_EQUALS.equals(method)) {
                Object o = args[0];
                if (o != null && Proxy.isProxyClass(o.getClass())) {
                    return Function.valueOf(Proxy.getInvocationHandler(o) == this);
                }
                return Boolean.FALSE;
            }
            if (Function.isVarArgs(method)) {
                args = Function.concatenateVarArgs(args);
            }
            return this.function.invoke(method.getReturnType(), args, this.options);
        }

        public Pointer getPointer() {
            return this.function;
        }
    }

    private class DefaultCallbackProxy
    implements CallbackProxy {
        private Method callbackMethod;
        private ToNativeConverter toNative;
        private FromNativeConverter[] fromNative;

        public DefaultCallbackProxy(Method callbackMethod, TypeMapper mapper) {
            this.callbackMethod = callbackMethod;
            Class<?>[] argTypes = callbackMethod.getParameterTypes();
            Class<?> returnType2 = callbackMethod.getReturnType();
            this.fromNative = new FromNativeConverter[argTypes.length];
            if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = CallbackReference.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(returnType2)) {
                this.toNative = NativeMappedConverter.getInstance(returnType2);
            } else if (mapper != null) {
                this.toNative = mapper.getToNativeConverter(returnType2);
            }
            for (int i = 0; i < this.fromNative.length; ++i) {
                if ((class$com$sun$jna$NativeMapped == null ? CallbackReference.class$("com.sun.jna.NativeMapped") : class$com$sun$jna$NativeMapped).isAssignableFrom(argTypes[i])) {
                    this.fromNative[i] = new NativeMappedConverter(argTypes[i]);
                    continue;
                }
                if (mapper == null) continue;
                this.fromNative[i] = mapper.getFromNativeConverter(argTypes[i]);
            }
            if (!callbackMethod.isAccessible()) {
                try {
                    callbackMethod.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException(new StringBuffer().append("Callback method is inaccessible, make sure the interface is public: ").append(callbackMethod).toString());
                }
            }
        }

        @Override
        public Class[] getParameterTypes() {
            return this.callbackMethod.getParameterTypes();
        }

        @Override
        public Class getReturnType() {
            return this.callbackMethod.getReturnType();
        }
    }
}

