/*
 * Decompiled with CFR 0.152.
 */
package kotlin.jvm.internal;

import java.util.Arrays;
import java.util.List;
import kotlin.KotlinNullPointerException;
import kotlin.UninitializedPropertyAccessException;

public class Intrinsics {
    private Intrinsics() {
    }

    public static String stringPlus(String self, Object other) {
        return String.valueOf(self) + String.valueOf(other);
    }

    public static void throwNpe() {
        throw Intrinsics.sanitizeStackTrace(new KotlinNullPointerException());
    }

    public static void throwUninitializedPropertyAccessException(String propertyName) {
        throw Intrinsics.sanitizeStackTrace(new UninitializedPropertyAccessException(propertyName));
    }

    public static void checkExpressionValueIsNotNull(Object value, String message) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException(message + " must not be null");
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static void checkReturnedValueIsNotNull(Object value, String className, String methodName) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException("Method specified as non-null returned null: " + className + "." + methodName);
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static void checkFieldIsNotNull(Object value, String className, String fieldName) {
        if (value == null) {
            IllegalStateException exception = new IllegalStateException("Field specified as non-null is null: " + className + "." + fieldName);
            throw Intrinsics.sanitizeStackTrace(exception);
        }
    }

    public static void checkParameterIsNotNull(Object value, String paramName) {
        if (value == null) {
            Intrinsics.throwParameterIsNullException(paramName);
        }
    }

    private static void throwParameterIsNullException(String paramName) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StackTraceElement caller2 = stackTraceElements[3];
        String className = caller2.getClassName();
        String methodName = caller2.getMethodName();
        IllegalArgumentException exception = new IllegalArgumentException("Parameter specified as non-null is null: method " + className + "." + methodName + ", parameter " + paramName);
        throw Intrinsics.sanitizeStackTrace(exception);
    }

    public static int compare(long thisVal, long anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static int compare(int thisVal, int anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static boolean areEqual(Object first, Object second) {
        return first == null ? second == null : first.equals(second);
    }

    private static void throwUndefinedForReified() {
        throw new UnsupportedOperationException("You should not use functions with reified parameter without inline");
    }

    public static void reifyNewArray(String typeParameterIdentifier) {
        Intrinsics.throwUndefinedForReified();
    }

    public static void reifyCheckcast(String typeParameterIdentifier) {
        Intrinsics.throwUndefinedForReified();
    }

    public static void reifyInstanceof(String typeParameterIdentifier) {
        Intrinsics.throwUndefinedForReified();
    }

    public static void reifyJavaClass(String typeParameterIdentifier) {
        Intrinsics.throwUndefinedForReified();
    }

    public static void needClassReification() {
        Intrinsics.throwUndefinedForReified();
    }

    private static <T extends Throwable> T sanitizeStackTrace(T throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int size = stackTrace.length;
        int lastIntrinsic = -1;
        for (int i = 0; i < size; ++i) {
            if (!Intrinsics.class.getName().equals(stackTrace[i].getClassName())) continue;
            lastIntrinsic = i;
        }
        List<StackTraceElement> list = Arrays.asList(stackTrace).subList(lastIntrinsic + 1, size);
        throwable.setStackTrace(list.toArray(new StackTraceElement[list.size()]));
        return throwable;
    }
}

