/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.utils.UtilsPackage;
import org.jetbrains.annotations.NotNull;

public final class PackageData {
    private final NameResolver nameResolver;
    private final ProtoBuf.Package packageProto;

    @NotNull
    public static PackageData read(@NotNull byte[] bytes, @NotNull ExtensionRegistryLite registry) {
        PackageData packageData;
        block4: {
            if (bytes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "kotlin/reflect/jvm/internal/impl/serialization/PackageData", "read"));
            }
            if (registry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "kotlin/reflect/jvm/internal/impl/serialization/PackageData", "read"));
            }
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                NameResolver nameResolver = NameResolver.read(in);
                ProtoBuf.Package packageProto = ProtoBuf.Package.parseFrom(in, registry);
                packageData = new PackageData(nameResolver, packageProto);
                if (packageData != null) break block4;
            }
            catch (IOException e) {
                throw UtilsPackage.rethrow(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/PackageData", "read"));
        }
        return packageData;
    }

    public PackageData(@NotNull NameResolver nameResolver, @NotNull ProtoBuf.Package packageProto) {
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "kotlin/reflect/jvm/internal/impl/serialization/PackageData", "<init>"));
        }
        if (packageProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageProto", "kotlin/reflect/jvm/internal/impl/serialization/PackageData", "<init>"));
        }
        this.nameResolver = nameResolver;
        this.packageProto = packageProto;
    }

    @NotNull
    public NameResolver getNameResolver() {
        NameResolver nameResolver = this.nameResolver;
        if (nameResolver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/PackageData", "getNameResolver"));
        }
        return nameResolver;
    }

    @NotNull
    public ProtoBuf.Package getPackageProto() {
        ProtoBuf.Package package_ = this.packageProto;
        if (package_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "kotlin/reflect/jvm/internal/impl/serialization/PackageData", "getPackageProto"));
        }
        return package_;
    }
}

