/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.ConstraintSystemImpl;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.InferencePackage;
import kotlin.reflect.jvm.internal.impl.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ChainedScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.JetScope;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.JetTypeImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.TypesPackage;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.JetTypeChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeIntersector {
    private final KotlinBuiltIns builtIns;

    public TypeIntersector(@NotNull KotlinBuiltIns builtIns) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector", "<init>"));
        }
        this.builtIns = builtIns;
    }

    public boolean isIntersectionEmpty(@NotNull JetType typeA, @NotNull JetType typeB) {
        if (typeA == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeA", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector", "isIntersectionEmpty"));
        }
        if (typeB == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeB", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector", "isIntersectionEmpty"));
        }
        return this.intersect(JetTypeChecker.DEFAULT, new LinkedHashSet<JetType>(Arrays.asList(typeA, typeB))) == null;
    }

    @Nullable
    public static JetType intersectTypes(@NotNull KotlinBuiltIns builtIns, @NotNull JetTypeChecker typeChecker, @NotNull Set<JetType> types2) {
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector", "intersectTypes"));
        }
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeChecker", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector", "intersectTypes"));
        }
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector", "intersectTypes"));
        }
        return new TypeIntersector(builtIns).intersect(typeChecker, types2);
    }

    @Nullable
    public JetType intersect(@NotNull JetTypeChecker typeChecker, @NotNull Set<JetType> types2) {
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeChecker", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector", "intersect"));
        }
        if (types2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector", "intersect"));
        }
        if (types2.isEmpty()) {
            return this.builtIns.getNullableAnyType();
        }
        if (types2.size() == 1) {
            return types2.iterator().next();
        }
        boolean allNullable = true;
        boolean nothingTypePresent = false;
        ArrayList<JetType> nullabilityStripped = new ArrayList<JetType>(types2.size());
        for (JetType type2 : types2) {
            if (type2.isError()) continue;
            nothingTypePresent |= KotlinBuiltIns.isNothingOrNullableNothing(type2);
            allNullable &= type2.isMarkedNullable();
            nullabilityStripped.add(TypeUtils.makeNotNullable(type2));
        }
        if (nothingTypePresent) {
            return allNullable ? this.builtIns.getNullableNothingType() : this.builtIns.getNothingType();
        }
        if (nullabilityStripped.isEmpty()) {
            return ErrorUtils.createErrorType("Intersection of errors types: " + types2);
        }
        ArrayList<JetType> resultingTypes = new ArrayList<JetType>();
        block1: for (JetType type3 : nullabilityStripped) {
            if (!TypeUtils.canHaveSubtypes(typeChecker, type3)) {
                for (JetType other : nullabilityStripped) {
                    if (TypeUnifier.mayBeEqual(type3, other) || typeChecker.isSubtypeOf(type3, other) || typeChecker.isSubtypeOf(other, type3)) continue;
                    return null;
                }
                return TypeUtils.makeNullableAsSpecified(type3, allNullable);
            }
            for (JetType other : nullabilityStripped) {
                if (((Object)type3).equals(other) || !typeChecker.isSubtypeOf(other, type3)) continue;
                continue block1;
            }
            for (JetType other : resultingTypes) {
                if (!typeChecker.equalTypes(other, type3)) continue;
                continue block1;
            }
            resultingTypes.add(type3);
        }
        if (resultingTypes.isEmpty()) {
            JetType bestRepresentative = TypesPackage.singleBestRepresentative(nullabilityStripped);
            if (bestRepresentative == null) {
                throw new AssertionError((Object)("Empty intersection for types " + types2));
            }
            return TypeUtils.makeNullableAsSpecified(bestRepresentative, allNullable);
        }
        if (resultingTypes.size() == 1) {
            return TypeUtils.makeNullableAsSpecified((JetType)resultingTypes.get(0), allNullable);
        }
        IntersectionTypeConstructor constructor = new IntersectionTypeConstructor(Annotations.EMPTY, resultingTypes);
        JetScope[] scopes = new JetScope[resultingTypes.size()];
        int i = 0;
        for (JetType type4 : resultingTypes) {
            scopes[i] = type4.getMemberScope();
            ++i;
        }
        return JetTypeImpl.create(Annotations.EMPTY, constructor, allNullable, Collections.emptyList(), new IntersectionScope(constructor, scopes));
    }

    private static class TypeUnifier {
        private TypeUnifier() {
        }

        public static boolean mayBeEqual(@NotNull JetType type2, @NotNull JetType other) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector$TypeUnifier", "mayBeEqual"));
            }
            if (other == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector$TypeUnifier", "mayBeEqual"));
            }
            return TypeUnifier.unify(type2, other);
        }

        private static boolean unify(JetType withParameters, JetType expected) {
            final HashMap parameters2 = new HashMap();
            Function1<TypeParameterUsage, Unit> processor = new Function1<TypeParameterUsage, Unit>(){

                @Override
                public Unit invoke(TypeParameterUsage parameterUsage) {
                    Variance howTheTypeIsUsedBefore = (Variance)((Object)parameters2.get(parameterUsage.typeParameterDescriptor));
                    if (howTheTypeIsUsedBefore == null) {
                        howTheTypeIsUsedBefore = Variance.INVARIANT;
                    }
                    parameters2.put(parameterUsage.typeParameterDescriptor, parameterUsage.howTheTypeParameterIsUsed.superpose(howTheTypeIsUsedBefore));
                    return Unit.INSTANCE$;
                }
            };
            TypeUnifier.processAllTypeParameters(withParameters, Variance.INVARIANT, processor);
            TypeUnifier.processAllTypeParameters(expected, Variance.INVARIANT, processor);
            ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
            InferencePackage.registerTypeVariables(constraintSystem, parameters2);
            constraintSystem.addSubtypeConstraint(withParameters, expected, ConstraintPositionKind.SPECIAL.position());
            return constraintSystem.getStatus().isSuccessful();
        }

        private static void processAllTypeParameters(JetType type2, Variance howThisTypeIsUsed, Function1<TypeParameterUsage, Unit> result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof TypeParameterDescriptor) {
                result2.invoke(new TypeParameterUsage((TypeParameterDescriptor)descriptor2, howThisTypeIsUsed));
            }
            for (TypeProjection projection : type2.getArguments()) {
                if (projection.isStarProjection()) continue;
                TypeUnifier.processAllTypeParameters(projection.getType(), projection.getProjectionKind(), result2);
            }
        }

        private static class TypeParameterUsage {
            private final TypeParameterDescriptor typeParameterDescriptor;
            private final Variance howTheTypeParameterIsUsed;

            public TypeParameterUsage(TypeParameterDescriptor typeParameterDescriptor, Variance howTheTypeParameterIsUsed) {
                this.typeParameterDescriptor = typeParameterDescriptor;
                this.howTheTypeParameterIsUsed = howTheTypeParameterIsUsed;
            }
        }
    }

    private static class IntersectionScope
    extends ChainedScope {
        public IntersectionScope(@NotNull TypeConstructor constructor, @NotNull JetScope[] scopes) {
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector$IntersectionScope", "<init>"));
            }
            if (scopes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopes", "kotlin/reflect/jvm/internal/impl/types/TypeIntersector$IntersectionScope", "<init>"));
            }
            super(null, "member scope for intersection type " + constructor, scopes);
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            throw new UnsupportedOperationException("Should not call getContainingDeclaration on intersection scope " + this);
        }
    }
}

