/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.DebugInfoUtil;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.AbstractDiagnosticWithParametersRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;

public class CheckerTestUtil {
    public static final Comparator<Diagnostic> DIAGNOSTIC_COMPARATOR = new Comparator<Diagnostic>(){

        @Override
        public int compare(@NotNull Diagnostic o1, @NotNull Diagnostic o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/kotlin/checkers/CheckerTestUtil$1", "compare"));
            }
            List<TextRange> ranges1 = o1.getTextRanges();
            List<TextRange> ranges2 = o2.getTextRanges();
            int minNumberOfRanges = ranges1.size() < ranges2.size() ? ranges1.size() : ranges2.size();
            for (int i = 0; i < minNumberOfRanges; ++i) {
                int endOffset2;
                int startOffset2;
                TextRange range1 = ranges1.get(i);
                TextRange range2 = ranges2.get(i);
                int startOffset1 = range1.getStartOffset();
                if (startOffset1 != (startOffset2 = range2.getStartOffset())) {
                    return startOffset1 - range2.getStartOffset();
                }
                int endOffset1 = range1.getEndOffset();
                if (endOffset1 == (endOffset2 = range2.getEndOffset())) continue;
                return endOffset2 - endOffset1;
            }
            return ranges1.size() - ranges2.size();
        }
    };
    private static final Pattern RANGE_START_OR_END_PATTERN = Pattern.compile("(<!(\\w+)(\\([^\\)\\(;]+(;\\s*[^\\)\\(;]+)*\\))?(,\\s*(\\w+)(\\([^\\)\\(;]+(;\\s*[^\\)\\(;]+)*\\))?)*!>)|(<!>)");
    private static final Pattern INDIVIDUAL_DIAGNOSTIC_PATTERN = Pattern.compile("(\\w+)(\\([^\\)\\(;]+(;\\s*[^\\)\\(;]+)*\\))?");
    private static final Pattern INDIVIDUAL_PARAMETER_PATTERN = Pattern.compile("[^\\)\\(;]+");

    @NotNull
    public static List<Diagnostic> getDiagnosticsIncludingSyntaxErrors(@NotNull BindingContext bindingContext, final @NotNull PsiElement root, boolean markDynamicCalls, @Nullable List<DeclarationDescriptor> dynamicCallDescriptors) {
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.addAll(Collections2.filter(bindingContext.getDiagnostics().all(), new Predicate<Diagnostic>(){

            @Override
            public boolean apply(Diagnostic diagnostic) {
                return PsiTreeUtil.isAncestor(root, diagnostic.getPsiElement(), false);
            }
        }));
        for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges(root)) {
            diagnostics.add(new SyntaxErrorDiagnostic(errorElement));
        }
        List<Diagnostic> debugAnnotations = CheckerTestUtil.getDebugInfoDiagnostics(root, bindingContext, markDynamicCalls, dynamicCallDescriptors);
        diagnostics.addAll(debugAnnotations);
        ArrayList<Diagnostic> arrayList = diagnostics;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDiagnosticsIncludingSyntaxErrors"));
        }
        return arrayList;
    }

    @NotNull
    private static List<Diagnostic> getDebugInfoDiagnostics(@NotNull PsiElement root, @NotNull BindingContext bindingContext, final boolean markDynamicCalls, final @Nullable List<DeclarationDescriptor> dynamicCallDescriptors) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        if (bindingContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        final ArrayList<Diagnostic> debugAnnotations = Lists.newArrayList();
        DebugInfoUtil.markDebugAnnotations(root, bindingContext, new DebugInfoUtil.DebugInfoReporter(){

            @Override
            public void reportElementWithErrorType(@NotNull JetReferenceExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportElementWithErrorType"));
                }
                this.newDiagnostic(expression, DebugInfoDiagnosticFactory.ELEMENT_WITH_ERROR_TYPE);
            }

            @Override
            public void reportMissingUnresolved(@NotNull JetReferenceExpression expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportMissingUnresolved"));
                }
                this.newDiagnostic(expression, DebugInfoDiagnosticFactory.MISSING_UNRESOLVED);
            }

            @Override
            public void reportUnresolvedWithTarget(@NotNull JetReferenceExpression expression, @NotNull String target) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportUnresolvedWithTarget"));
                }
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportUnresolvedWithTarget"));
                }
                this.newDiagnostic(expression, DebugInfoDiagnosticFactory.UNRESOLVED_WITH_TARGET);
            }

            @Override
            public void reportDynamicCall(@NotNull JetElement element, DeclarationDescriptor declarationDescriptor) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$3", "reportDynamicCall"));
                }
                if (dynamicCallDescriptors != null) {
                    dynamicCallDescriptors.add(declarationDescriptor);
                }
                if (markDynamicCalls) {
                    this.newDiagnostic(element, DebugInfoDiagnosticFactory.DYNAMIC);
                }
            }

            private void newDiagnostic(JetElement element, DebugInfoDiagnosticFactory factory) {
                debugAnnotations.add(new DebugInfoDiagnostic(element, factory));
            }
        });
        for (JetExpression expression : bindingContext.getSliceContents(BindingContext.SMARTCAST).keySet()) {
            if (!PsiTreeUtil.isAncestor(root, expression, false)) continue;
            debugAnnotations.add(new DebugInfoDiagnostic(expression, DebugInfoDiagnosticFactory.SMARTCAST));
        }
        ArrayList<Diagnostic> arrayList = debugAnnotations;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getDebugInfoDiagnostics"));
        }
        return arrayList;
    }

    public static void diagnosticsDiff(Map<Diagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, List<DiagnosedRange> expected, Collection<Diagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        CheckerTestUtil.assertSameFile(actual);
        Iterator<DiagnosedRange> expectedDiagnostics = expected.iterator();
        List<DiagnosticDescriptor> sortedDiagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(actual);
        Iterator<DiagnosticDescriptor> actualDiagnostics = sortedDiagnosticDescriptors.iterator();
        DiagnosedRange currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
        DiagnosticDescriptor currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        while (currentExpected != null || currentActual != null) {
            if (currentExpected != null) {
                if (currentActual == null) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                int expectedStart = currentExpected.getStart();
                int actualStart = currentActual.getStart();
                int expectedEnd = currentExpected.getEnd();
                int actualEnd = currentActual.getEnd();
                if (expectedStart < actualStart) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedStart > actualStart) {
                    CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                if (expectedEnd > actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedEnd < actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                CheckerTestUtil.compareDiagnostics(callbacks, currentExpected, currentActual, diagnosticToExpectedDiagnostic);
                currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                continue;
            }
            assert (currentActual != null);
            CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
            currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        }
    }

    private static void compareDiagnostics(@NotNull DiagnosticDiffCallbacks callbacks, @NotNull DiagnosedRange currentExpected, @NotNull DiagnosticDescriptor currentActual, @NotNull Map<Diagnostic, TextDiagnostic> diagnosticToInput) {
        if (callbacks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callbacks", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (currentExpected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentExpected", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (currentActual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentActual", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        if (diagnosticToInput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticToInput", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareDiagnostics"));
        }
        int expectedStart = currentExpected.getStart();
        int expectedEnd = currentExpected.getEnd();
        int actualStart = currentActual.getStart();
        int actualEnd = currentActual.getEnd();
        assert (expectedStart == actualStart && expectedEnd == actualEnd);
        Map<Diagnostic, TextDiagnostic> actualDiagnostics = currentActual.getTextDiagnosticsMap();
        List<TextDiagnostic> expectedDiagnostics = currentExpected.getDiagnostics();
        for (TextDiagnostic expectedDiagnostic : expectedDiagnostics) {
            boolean diagnosticFound = false;
            for (Diagnostic actualDiagnostic : actualDiagnostics.keySet()) {
                TextDiagnostic actualTextDiagnostic = actualDiagnostics.get(actualDiagnostic);
                if (!expectedDiagnostic.getName().equals(actualTextDiagnostic.getName())) continue;
                if (!CheckerTestUtil.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic)) {
                    callbacks.wrongParametersDiagnostic(expectedDiagnostic, actualTextDiagnostic, expectedStart, expectedEnd);
                }
                actualDiagnostics.remove(actualDiagnostic);
                diagnosticToInput.put(actualDiagnostic, expectedDiagnostic);
                diagnosticFound = true;
                break;
            }
            if (diagnosticFound) continue;
            callbacks.missingDiagnostic(expectedDiagnostic, expectedStart, expectedEnd);
        }
        for (TextDiagnostic unexpectedDiagnostic : actualDiagnostics.values()) {
            callbacks.unexpectedDiagnostic(unexpectedDiagnostic, actualStart, actualEnd);
        }
    }

    private static boolean compareTextDiagnostic(@NotNull TextDiagnostic expected, @NotNull TextDiagnostic actual) {
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareTextDiagnostic"));
        }
        if (actual == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actual", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "compareTextDiagnostic"));
        }
        if (!expected.getName().equals(actual.getName())) {
            return false;
        }
        if (expected.getParameters() == null) {
            return true;
        }
        if (actual.getParameters() == null || expected.getParameters().size() != actual.getParameters().size()) {
            return false;
        }
        for (int index2 = 0; index2 < expected.getParameters().size(); ++index2) {
            String expectedParameter = expected.getParameters().get(index2);
            String actualParameter = actual.getParameters().get(index2);
            if (expectedParameter.equals("IGNORE") || expectedParameter.equals(actualParameter)) continue;
            return false;
        }
        return true;
    }

    private static void assertSameFile(Collection<Diagnostic> actual) {
        if (actual.isEmpty()) {
            return;
        }
        PsiFile file = actual.iterator().next().getPsiElement().getContainingFile();
        for (Diagnostic diagnostic : actual) {
            assert (diagnostic.getPsiFile().equals(file)) : "All diagnostics should come from the same file: " + diagnostic.getPsiFile() + ", " + file;
        }
    }

    private static void unexpectedDiagnostics(List<Diagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        for (Diagnostic diagnostic : actual) {
            List<TextRange> textRanges = diagnostic.getTextRanges();
            for (TextRange textRange : textRanges) {
                callbacks.unexpectedDiagnostic(TextDiagnostic.asTextDiagnostic(diagnostic), textRange.getStartOffset(), textRange.getEndOffset());
            }
        }
    }

    private static void missingDiagnostics(DiagnosticDiffCallbacks callbacks, DiagnosedRange currentExpected) {
        for (TextDiagnostic diagnostic : currentExpected.getDiagnostics()) {
            callbacks.missingDiagnostic(diagnostic, currentExpected.getStart(), currentExpected.getEnd());
        }
    }

    private static <T> T safeAdvance(Iterator<T> iterator2) {
        return iterator2.hasNext() ? (T)iterator2.next() : null;
    }

    public static String parseDiagnosedRanges(String text, List<DiagnosedRange> result2) {
        Matcher matcher = RANGE_START_OR_END_PATTERN.matcher(text);
        Stack<DiagnosedRange> opened = new Stack<DiagnosedRange>();
        int offsetCompensation = 0;
        while (matcher.find()) {
            int effectiveOffset = matcher.start() - offsetCompensation;
            String matchedText = matcher.group();
            if ("<!>".equals(matchedText)) {
                ((DiagnosedRange)opened.pop()).setEnd(effectiveOffset);
            } else {
                Matcher diagnosticTypeMatcher = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(matchedText);
                DiagnosedRange range = new DiagnosedRange(effectiveOffset);
                while (diagnosticTypeMatcher.find()) {
                    range.addDiagnostic(diagnosticTypeMatcher.group());
                }
                opened.push(range);
                result2.add(range);
            }
            offsetCompensation += matchedText.length();
        }
        assert (opened.isEmpty()) : "Stack is not empty";
        matcher.reset();
        return matcher.replaceAll("");
    }

    public static StringBuffer addDiagnosticMarkersToText(@NotNull PsiFile psiFile, @NotNull Collection<Diagnostic> diagnostics) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        return CheckerTestUtil.addDiagnosticMarkersToText(psiFile, diagnostics, Collections.<Diagnostic, TextDiagnostic>emptyMap(), new Function<PsiFile, String>(){

            @Override
            public String fun(PsiFile file) {
                return file.getText();
            }
        });
    }

    public static StringBuffer addDiagnosticMarkersToText(final @NotNull PsiFile psiFile, @NotNull Collection<Diagnostic> diagnostics, @NotNull Map<Diagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic, @NotNull Function<PsiFile, String> getFileText) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (diagnosticToExpectedDiagnostic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnosticToExpectedDiagnostic", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        if (getFileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getFileText", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "addDiagnosticMarkersToText"));
        }
        String text = getFileText.fun(psiFile);
        StringBuffer result2 = new StringBuffer();
        if (!(diagnostics = Collections2.filter(diagnostics, new Predicate<Diagnostic>(){

            @Override
            public boolean apply(Diagnostic diagnostic) {
                return psiFile.equals(diagnostic.getPsiFile());
            }
        })).isEmpty()) {
            List<DiagnosticDescriptor> diagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(diagnostics);
            Stack<DiagnosticDescriptor> opened = new Stack<DiagnosticDescriptor>();
            ListIterator<DiagnosticDescriptor> iterator2 = diagnosticDescriptors.listIterator();
            DiagnosticDescriptor currentDescriptor = iterator2.next();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                while (!opened.isEmpty() && i == ((DiagnosticDescriptor)opened.peek()).end) {
                    CheckerTestUtil.closeDiagnosticString(result2);
                    opened.pop();
                }
                while (currentDescriptor != null && i == currentDescriptor.start) {
                    CheckerTestUtil.openDiagnosticsString(result2, currentDescriptor, diagnosticToExpectedDiagnostic);
                    if (currentDescriptor.getEnd() == i) {
                        CheckerTestUtil.closeDiagnosticString(result2);
                    } else {
                        opened.push(currentDescriptor);
                    }
                    if (iterator2.hasNext()) {
                        currentDescriptor = iterator2.next();
                        continue;
                    }
                    currentDescriptor = null;
                }
                result2.append(c);
            }
            if (currentDescriptor != null) {
                assert (currentDescriptor.start == text.length());
                assert (currentDescriptor.end == text.length());
                CheckerTestUtil.openDiagnosticsString(result2, currentDescriptor, diagnosticToExpectedDiagnostic);
                opened.push(currentDescriptor);
            }
            while (!opened.isEmpty() && text.length() == ((DiagnosticDescriptor)opened.peek()).end) {
                CheckerTestUtil.closeDiagnosticString(result2);
                opened.pop();
            }
            assert (opened.isEmpty()) : "Stack is not empty: " + opened;
        } else {
            result2.append(text);
        }
        return result2;
    }

    private static void openDiagnosticsString(StringBuffer result2, DiagnosticDescriptor currentDescriptor, Map<Diagnostic, TextDiagnostic> diagnosticToExpectedDiagnostic) {
        result2.append("<!");
        Iterator iterator2 = currentDescriptor.diagnostics.iterator();
        while (iterator2.hasNext()) {
            Diagnostic diagnostic = (Diagnostic)iterator2.next();
            if (diagnosticToExpectedDiagnostic.containsKey(diagnostic)) {
                TextDiagnostic actualTextDiagnostic;
                TextDiagnostic expectedDiagnostic = diagnosticToExpectedDiagnostic.get(diagnostic);
                if (CheckerTestUtil.compareTextDiagnostic(expectedDiagnostic, actualTextDiagnostic = TextDiagnostic.asTextDiagnostic(diagnostic))) {
                    result2.append(expectedDiagnostic.asString());
                } else {
                    result2.append(actualTextDiagnostic.asString());
                }
            } else {
                result2.append(diagnostic.getFactory().getName());
            }
            if (!iterator2.hasNext()) continue;
            result2.append(", ");
        }
        result2.append("!>");
    }

    private static void closeDiagnosticString(StringBuffer result2) {
        result2.append("<!>");
    }

    @NotNull
    private static List<DiagnosticDescriptor> getSortedDiagnosticDescriptors(@NotNull Collection<Diagnostic> diagnostics) {
        if (diagnostics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostics", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getSortedDiagnosticDescriptors"));
        }
        LinkedListMultimap<TextRange, Diagnostic> diagnosticsGroupedByRanges = LinkedListMultimap.create();
        for (Diagnostic diagnostic : diagnostics) {
            if (!diagnostic.isValid()) continue;
            for (TextRange textRange : diagnostic.getTextRanges()) {
                diagnosticsGroupedByRanges.put(textRange, diagnostic);
            }
        }
        ArrayList<DiagnosticDescriptor> diagnosticDescriptors = Lists.newArrayList();
        for (TextRange range : diagnosticsGroupedByRanges.keySet()) {
            diagnosticDescriptors.add(new DiagnosticDescriptor(range.getStartOffset(), range.getEndOffset(), (List<Diagnostic>)diagnosticsGroupedByRanges.get((Object)range)));
        }
        Collections.sort(diagnosticDescriptors, new Comparator<DiagnosticDescriptor>(){

            @Override
            public int compare(@NotNull DiagnosticDescriptor d1, @NotNull DiagnosticDescriptor d2) {
                if (d1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d1", "org/jetbrains/kotlin/checkers/CheckerTestUtil$6", "compare"));
                }
                if (d2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d2", "org/jetbrains/kotlin/checkers/CheckerTestUtil$6", "compare"));
                }
                return d1.start != d2.start ? d1.start - d2.start : d2.end - d1.end;
            }
        });
        ArrayList<DiagnosticDescriptor> arrayList = diagnosticDescriptors;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil", "getSortedDiagnosticDescriptors"));
        }
        return arrayList;
    }

    public static class DiagnosedRange {
        private final int start;
        private int end;
        private final List<TextDiagnostic> diagnostics = ContainerUtil.newSmartList();
        private PsiFile file;

        protected DiagnosedRange(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<TextDiagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void addDiagnostic(String diagnostic) {
            this.diagnostics.add(TextDiagnostic.parseDiagnostic(diagnostic));
        }

        public void setFile(@NotNull PsiFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DiagnosedRange", "setFile"));
            }
            this.file = file;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.file;
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DiagnosedRange", "getFile"));
            }
            return psiFile;
        }
    }

    public static class TextDiagnostic {
        @NotNull
        private final String name;
        @Nullable
        private final List<String> parameters;

        @NotNull
        private static TextDiagnostic parseDiagnostic(String text) {
            Matcher matcher = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(text);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Could not parse diagnostic: " + text);
            }
            String name = matcher.group(1);
            String parameters2 = matcher.group(2);
            if (parameters2 == null) {
                TextDiagnostic textDiagnostic = new TextDiagnostic(name, null);
                if (textDiagnostic == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "parseDiagnostic"));
                }
                return textDiagnostic;
            }
            SmartList<String> parsedParameters = new SmartList<String>();
            Matcher parametersMatcher = INDIVIDUAL_PARAMETER_PATTERN.matcher(parameters2);
            while (parametersMatcher.find()) {
                parsedParameters.add(parametersMatcher.group().trim());
            }
            TextDiagnostic textDiagnostic = new TextDiagnostic(name, parsedParameters);
            if (textDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "parseDiagnostic"));
            }
            return textDiagnostic;
        }

        @NotNull
        public static TextDiagnostic asTextDiagnostic(@NotNull Diagnostic diagnostic) {
            if (diagnostic == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
            }
            DiagnosticRenderer renderer = DefaultErrorMessages.getRendererForDiagnostic(diagnostic);
            String diagnosticName = diagnostic.getFactory().getName();
            if (renderer instanceof AbstractDiagnosticWithParametersRenderer) {
                Object[] renderParameters = ((AbstractDiagnosticWithParametersRenderer)renderer).renderParameters(diagnostic);
                List<String> parameters2 = ContainerUtil.map(renderParameters, new Function<Object, String>(){

                    @Override
                    public String fun(Object o) {
                        return o != null ? o.toString() : "null";
                    }
                });
                TextDiagnostic textDiagnostic = new TextDiagnostic(diagnosticName, parameters2);
                if (textDiagnostic == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
                }
                return textDiagnostic;
            }
            TextDiagnostic textDiagnostic = new TextDiagnostic(diagnosticName, null);
            if (textDiagnostic == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asTextDiagnostic"));
            }
            return textDiagnostic;
        }

        public TextDiagnostic(@NotNull String name, @Nullable List<String> parameters2) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "<init>"));
            }
            this.name = name;
            this.parameters = parameters2;
        }

        @NotNull
        public String getName() {
            String string = this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "getName"));
            }
            return string;
        }

        @Nullable
        public List<String> getParameters() {
            return this.parameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextDiagnostic that = (TextDiagnostic)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return !(this.parameters != null ? !((Object)this.parameters).equals(that.parameters) : that.parameters != null);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = 31 * result2 + (this.parameters != null ? ((Object)this.parameters).hashCode() : 0);
            return result2;
        }

        @NotNull
        public String asString() {
            if (this.parameters == null) {
                String string = this.name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asString"));
                }
                return string;
            }
            String string = this.name + '(' + StringUtil.join(this.parameters, "; ") + ')';
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$TextDiagnostic", "asString"));
            }
            return string;
        }
    }

    private static class DiagnosticDescriptor {
        private final int start;
        private final int end;
        private final List<Diagnostic> diagnostics;

        DiagnosticDescriptor(int start, int end, List<Diagnostic> diagnostics) {
            this.start = start;
            this.end = end;
            this.diagnostics = diagnostics;
        }

        public Map<Diagnostic, TextDiagnostic> getTextDiagnosticsMap() {
            IdentityHashMap<Diagnostic, TextDiagnostic> diagnosticMap = new IdentityHashMap<Diagnostic, TextDiagnostic>();
            for (Diagnostic diagnostic : this.diagnostics) {
                diagnosticMap.put(diagnostic, TextDiagnostic.asTextDiagnostic(diagnostic));
            }
            return diagnosticMap;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<Diagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public TextRange getTextRange() {
            return new TextRange(this.start, this.end);
        }
    }

    public static class DebugInfoDiagnostic
    extends AbstractDiagnosticForTests {
        public DebugInfoDiagnostic(@NotNull JetElement element, @NotNull DebugInfoDiagnosticFactory factory) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnostic", "<init>"));
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnostic", "<init>"));
            }
            super(element, factory);
        }
    }

    public static class DebugInfoDiagnosticFactory
    extends DiagnosticFactory<DebugInfoDiagnostic> {
        public static final DebugInfoDiagnosticFactory SMARTCAST = new DebugInfoDiagnosticFactory("SMARTCAST");
        public static final DebugInfoDiagnosticFactory ELEMENT_WITH_ERROR_TYPE = new DebugInfoDiagnosticFactory("ELEMENT_WITH_ERROR_TYPE");
        public static final DebugInfoDiagnosticFactory UNRESOLVED_WITH_TARGET = new DebugInfoDiagnosticFactory("UNRESOLVED_WITH_TARGET");
        public static final DebugInfoDiagnosticFactory MISSING_UNRESOLVED = new DebugInfoDiagnosticFactory("MISSING_UNRESOLVED");
        public static final DebugInfoDiagnosticFactory DYNAMIC = new DebugInfoDiagnosticFactory("DYNAMIC");
        private final String name;

        private DebugInfoDiagnosticFactory(String name, Severity severity) {
            super(severity);
            this.name = name;
        }

        private DebugInfoDiagnosticFactory(String name) {
            this(name, Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            String string = "DEBUG_INFO_" + this.name;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$DebugInfoDiagnosticFactory", "getName"));
            }
            return string;
        }
    }

    public static class SyntaxErrorDiagnostic
    extends AbstractDiagnosticForTests {
        public SyntaxErrorDiagnostic(@NotNull PsiErrorElement errorElement) {
            if (errorElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorElement", "org/jetbrains/kotlin/checkers/CheckerTestUtil$SyntaxErrorDiagnostic", "<init>"));
            }
            super(errorElement, SyntaxErrorDiagnosticFactory.INSTANCE);
        }
    }

    public static class SyntaxErrorDiagnosticFactory
    extends DiagnosticFactory<SyntaxErrorDiagnostic> {
        public static final SyntaxErrorDiagnosticFactory INSTANCE = new SyntaxErrorDiagnosticFactory();

        private SyntaxErrorDiagnosticFactory() {
            super(Severity.ERROR);
        }

        @Override
        @NotNull
        public String getName() {
            if ("SYNTAX" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$SyntaxErrorDiagnosticFactory", "getName"));
            }
            return "SYNTAX";
        }
    }

    public static class AbstractDiagnosticForTests
    implements Diagnostic {
        private final PsiElement element;
        private final DiagnosticFactory<?> factory;

        public AbstractDiagnosticForTests(@NotNull PsiElement element, @NotNull DiagnosticFactory<?> factory) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "<init>"));
            }
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "<init>"));
            }
            this.element = element;
            this.factory = factory;
        }

        @Override
        @NotNull
        public DiagnosticFactory<?> getFactory() {
            DiagnosticFactory<?> diagnosticFactory = this.factory;
            if (diagnosticFactory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getFactory"));
            }
            return diagnosticFactory;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            Severity severity = Severity.ERROR;
            if (severity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getSeverity"));
            }
            return severity;
        }

        @Override
        @NotNull
        public PsiElement getPsiElement() {
            PsiElement psiElement = this.element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getPsiElement"));
            }
            return psiElement;
        }

        @Override
        @NotNull
        public List<TextRange> getTextRanges() {
            List<TextRange> list = Collections.singletonList(this.element.getTextRange());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getTextRanges"));
            }
            return list;
        }

        @Override
        @NotNull
        public PsiFile getPsiFile() {
            PsiFile psiFile = this.element.getContainingFile();
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/checkers/CheckerTestUtil$AbstractDiagnosticForTests", "getPsiFile"));
            }
            return psiFile;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    public static interface DiagnosticDiffCallbacks {
        public void missingDiagnostic(TextDiagnostic var1, int var2, int var3);

        public void wrongParametersDiagnostic(TextDiagnostic var1, TextDiagnostic var2, int var3, int var4);

        public void unexpectedDiagnostic(TextDiagnostic var1, int var2, int var3);
    }
}

