/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import com.google.common.collect.ImmutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

public class ProgressionIteratorBasicValue
extends BasicValue {
    private static final ImmutableMap<String, Type> VALUES_TYPENAME_TO_TYPE = ImmutableMap.builder().put("Byte", Type.BYTE_TYPE).put("Char", Type.CHAR_TYPE).put("Short", Type.SHORT_TYPE).put("Int", Type.INT_TYPE).put("Long", Type.LONG_TYPE).put("Float", Type.FLOAT_TYPE).put("Double", Type.DOUBLE_TYPE).build();
    private final Type valuesPrimitiveType;
    private final String valuesPrimitiveTypeName;

    @NotNull
    private static Type getValuesType(@NotNull String valuesTypeName) {
        if (valuesTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesTypeName", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getValuesType"));
        }
        Type type2 = VALUES_TYPENAME_TO_TYPE.get(valuesTypeName);
        assert (type2 != null) : "Unexpected type " + valuesTypeName;
        Type type3 = type2;
        if (type3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getValuesType"));
        }
        return type3;
    }

    public ProgressionIteratorBasicValue(@NotNull String valuesPrimitiveTypeName) {
        if (valuesPrimitiveTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valuesPrimitiveTypeName", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "<init>"));
        }
        super(Type.getObjectType("kotlin/" + valuesPrimitiveTypeName + "Iterator"));
        this.valuesPrimitiveType = ProgressionIteratorBasicValue.getValuesType(valuesPrimitiveTypeName);
        this.valuesPrimitiveTypeName = valuesPrimitiveTypeName;
    }

    public Type getValuesPrimitiveType() {
        return this.valuesPrimitiveType;
    }

    public String getValuesPrimitiveTypeName() {
        return this.valuesPrimitiveTypeName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgressionIteratorBasicValue value = (ProgressionIteratorBasicValue)o;
        return this.valuesPrimitiveType.equals(value.valuesPrimitiveType);
    }

    @NotNull
    public String getNextMethodName() {
        String string = "next" + this.getValuesPrimitiveTypeName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getNextMethodName"));
        }
        return string;
    }

    @NotNull
    public String getNextMethodDesc() {
        String string = "()" + this.getValuesPrimitiveType().getDescriptor();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue", "getNextMethodDesc"));
        }
        return string;
    }
}

