/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.util.ArrayList;
import kotlin.KotlinPackage;
import kotlin.Lazy;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.SingletonDescriptor;
import org.jetbrains.kotlin.container.SingletonDescriptor$WhenMappings;
import org.jetbrains.kotlin.container.ValueResolveContext;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"f\b)\u00192+\u001b8hY\u0016$xN\u001c#fg\u000e\u0014\u0018\u000e\u001d;pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0005d_:$\u0018-\u001b8fe*\u00192i\\7q_:,g\u000e\u001e#fg\u000e\u0014\u0018\u000e\u001d;pe*I1\t\\8tK\u0006\u0014G.\u001a\u0006\u0005U\u00064\u0018M\u0003\u0002j_*1A(\u001b8jizR!cQ8na>tWM\u001c;D_:$\u0018-\u001b8fe*aq-\u001a;D_:$\u0018-\u001b8fe*\tB-[:q_N\f'\r\\3PE*,7\r^:\u000b\u0013\u0005\u0013(/Y=MSN$(\u0002B;uS2T!\u0004Z5ta>\u001c\u0018M\u00197f\u001f\nTWm\u0019;tI\u0011,G.Z4bi\u0016TA\u0001T1{s*!r-\u001a;ESN\u0004xn]1cY\u0016|%M[3diNT\u0001\"\u001b8ti\u0006t7-\u001a\u0006\u0004\u0003:L(\u0002\u00027b]\u001eTaa\u00142kK\u000e$(BF:i_VdG-\u00138kK\u000e$\bK]8qKJ$\u0018.Z:\u000b\u000f\t{w\u000e\\3b]*Ir-\u001a;TQ>,H\u000eZ%oU\u0016\u001cG\u000f\u0015:pa\u0016\u0014H/[3t\u0015\u0015\u0019H/\u0019;f\u00159\u0019u.\u001c9p]\u0016tGo\u0015;bi\u0016T\u0001bZ3u'R\fG/\u001a\u0006\tg\u0016$8\u000b^1uK*)1\r\\8tK*!QK\\5u\u00159\u0019'/Z1uK&s7\u000f^1oG\u0016TqaY8oi\u0016DHOC\nWC2,XMU3t_24XmQ8oi\u0016DHOC\u0006eSN\u0004xn]3J[Bd'\u0002C4fiZ\u000bG.^3\u000b1I,w-[:uKJ$\u0015n\u001d9pg\u0006\u0014G.Z(cU\u0016\u001cGOC\u0006po:,Gm\u00142kK\u000e$(6\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\r!\u0019\u0001\u0003\u0001\r\u0001\u0015\u0019A1\u0001E\u0003\u0019\u0001)\u0011\u0001c\u0002\u0006\u0005\u0011\u0019\u0001\u0002B\u0003\u0004\t\u000fA1\u0001\u0004\u0001\u0006\u0007\u0011\r\u0001\"\u0002\u0007\u0001\u000b\t!\u0019\u0001C\u0003\u0006\u0005\u0011\u0019\u0001bB\u0003\u0004\t\u0017Ai\u0001\u0004\u0001\u0006\u0003!\rQA\u0001C\u0007\u0011!)!\u0001b\u0003\t\u000e\u0015\u0019AQ\u0002E\n\u0019\u0001)!\u0001B\u0002\t\u0015\u0015\u0011A\u0011\u0003E\u000b\u000b\r!i\u0001c\u0006\r\u0001\u0015\u0019A1\u0001\u0005\u000e\u0019\u0001)!\u0001b\u0001\t\u001b\u0015\u0019AQ\u0002\u0005\u0010\u0019\u0001)1\u0001b\u0001\t\"1\u0001QA\u0001C\u0002\u0011C)!\u0001b\u0002\t\u0007\u0011\u0019BBA\r\u0004\u000b\u0005A)\u0001'\u0002\u001a\u0007\u0015\t\u0001\u0002\u0002\r\u0005[A!1\r\u0002\r\u0003C\r)\u0011\u0001#\u0003\u0019\nU\u001b\u0001\"B\u0002\u0005\u0005%\t\u0001\"B\u0007\u0004\t\u0017I\u0011\u0001C\u0003.-\u0011\tG\u0001\u0007\u0004\"\u0011\u0015\t\u0001BB\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0003\u0019\ta1A%I+\u0004\u0011\u0015\u0019AqB\u0005\u0002\u0011\u001di1\u0001\"\u0005\n\u0003!=Q&\u0004\u0003B\u001aaI\u0011\u0005B\u0003\u0002\u0011!a\t\u0001\u0007\u0005V\u0007\u0011)1\u0001B\u0005\n\u0003!IQ&\u0004\u0003l\taY\u0011eA\u0003\u0002\u0011'A\u001a\u0002J\u0016V\u0007\u0011i1\u0001\u0002\u0007\n\u0003\u0011\u0005QF\u0006\u0003C\u001aae\u0011eA\u0003\u0002\u0011)A\"\"V\u0002\u000f\u000b\r!I\"C\u0001\t\u00165\u0019A1D\u0005\u0002\u0011+\tR\u0001\u0002\b\n\u0003\u0011\u0001Q\"\u0001E\u000b[+!1\u0002'\b\"\u0007\u0015\t\u0001b\u0003\r\f#\u000e\u0019AQD\u0005\u0002\t\u0001iS\u0003B\u0001\u0019 u=A\u0001\u0001\u0005\u0003\u001b\r)\u0011\u0001#\u0003\u0019\nA\u001b\u0001!I\u0002\u0006\u0003!Y\u0001dC)\u0004\u000b\u0011}\u0011\"\u0001\u0003\u0001\u001b\u0005AQ!L\u000b\u0005%a}Qt\u0002\u0003\u0001\u0011Ai1!B\u0001\t\u0018a]\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\u0002\u0003\r\t#\u000e)AqD\u0005\u0002\u0011%i\u0011\u0001\u0003\u0007.\u0016\u0011\t\u0001$E\u0011\u0004\u000b\u0005A1\u0002G\u0006R\u0007\r!\u0011#C\u0001\u0005\u00015VAa\u0003M\u0012C\r)\u0011\u0001\u0003\u0005\u0019\u0011E\u001b1\u0001b\t\n\u0003!IQ&\u0006\u0003\u00031Iiz\u0001\u0002\u0001\t&5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001A\u0011\u0004\u000b\u0005A1\u0002G\u0006R\u0007\u0015!!#C\u0001\u0005\u00015\t\u0001\u0012D[\u0017\u000bW!1\u001d\u0001M\u0005;\u001f!\u0001\u0001\u0003\u0002\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0001\u0011eA\u0003\u0002\u0011\tA\"!U\u0002\u0006\t\u0013I\u0011\u0001\u0002\u0001\u000e\u0003!)\u0001"})
public abstract class SingletonDescriptor
implements Closeable,
ComponentDescriptor {
    public static final /* synthetic */ KClass $kotlinClass;
    private Object instance;
    @NotNull
    private ComponentState state;
    private final Lazy<? extends ArrayList<Closeable>> disposableObjects$delegate;
    @NotNull
    private final ComponentContainer container;
    private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

    static {
        $kotlinClass = Reflection.createKotlinClass(SingletonDescriptor.class);
        $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("disposableObjects")};
    }

    @NotNull
    protected final ComponentState getState() {
        return this.state;
    }

    protected final void setState(@NotNull ComponentState componentState) {
        Intrinsics.checkParameterIsNotNull((Object)componentState, "<set-?>");
        this.state = componentState;
    }

    private final ArrayList<Closeable> getDisposableObjects() {
        return KotlinPackage.get(this.disposableObjects$delegate, this, $propertyMetadata[0]);
    }

    @Override
    @NotNull
    public Object getValue() {
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentState.Corrupted)) {
            throw (Throwable)new ContainerConsistencyException("Component descriptor " + this + " is corrupted and cannot be accessed");
        }
        if (Intrinsics.areEqual((Object)this.state, (Object)ComponentState.Disposed)) {
            throw (Throwable)new ContainerConsistencyException("Component descriptor " + this + " is disposed and cannot be accessed");
        }
        if (this.instance == null) {
            this.createInstance(this.container);
        }
        Object object = this.instance;
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return object;
    }

    protected final void registerDisposableObject(@NotNull Closeable ownedObject) {
        Intrinsics.checkParameterIsNotNull(ownedObject, "ownedObject");
        this.getDisposableObjects().add(ownedObject);
    }

    @NotNull
    protected abstract Object createInstance(@NotNull ValueResolveContext var1);

    private final void createInstance(ComponentContainer container) {
        switch (SingletonDescriptor$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                try {
                    this.instance = this.createInstance(container.createResolveContext(this));
                    return;
                }
                catch (Throwable ex) {
                    this.state = ComponentState.Corrupted;
                    for (Closeable disposable : this.getDisposableObjects()) {
                        disposable.close();
                    }
                    throw ex;
                }
            }
            case 2: {
                throw (Throwable)new ContainerConsistencyException("Could not create the component " + this + " because it is being initialized. Do we have undetected circular dependency?");
            }
            case 3: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + ". Instance is null in Initialized state");
            }
            case 4: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is corrupted");
            }
            case 5: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is being disposed");
            }
            case 6: {
                throw (Throwable)new ContainerConsistencyException("Could not get the component " + this + " because it is already disposed");
            }
        }
    }

    private final void disposeImpl() {
        Object wereInstance = this.instance;
        this.state = ComponentState.Disposing;
        this.instance = null;
        try {
            if (wereInstance instanceof Closeable) {
                ((Closeable)wereInstance).close();
            }
            for (Closeable disposable : this.getDisposableObjects()) {
                disposable.close();
            }
        }
        catch (Throwable ex) {
            this.state = ComponentState.Corrupted;
            throw ex;
        }
        this.state = ComponentState.Disposed;
    }

    @Override
    public void close() {
        switch (SingletonDescriptor$WhenMappings.$EnumSwitchMapping$1[this.state.ordinal()]) {
            case 1: {
                this.disposeImpl();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                throw (Throwable)new ContainerConsistencyException("The component is being initialized and cannot be disposed.");
            }
            case 5: {
                throw (Throwable)new ContainerConsistencyException("The component is already in disposing state.");
            }
            case 6: {
                throw (Throwable)new ContainerConsistencyException("The component has already been destroyed.");
            }
        }
    }

    @Override
    public boolean getShouldInjectProperties() {
        return true;
    }

    @NotNull
    public final ComponentContainer getContainer() {
        return this.container;
    }

    public SingletonDescriptor(@NotNull ComponentContainer container) {
        Intrinsics.checkParameterIsNotNull(container, "container");
        this.container = container;
        this.state = ComponentState.Null;
        this.disposableObjects$delegate = KotlinPackage.lazy(disposableObjects.1.INSTANCE$);
    }
}

