/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallCheckerKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallData;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataWithCode;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"z\u0006)\u0019\"j]\"pI\u0016,%O]8s%\u0016\u0004xN\u001d;fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0002kg*9!/Z:pYZ,'b\u00033jC\u001etwn\u001d;jGNTQ\"\u0012:s_J\u0014V\r]8si\u0016\u0014(bA2p[*1qm\\8hY\u0016T1aZ<u\u0015\r!WM\u001e\u0006\u0006e\"Lgn\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u00199|G-\u001a+p%\u0016\u0004xN\u001d;\u000b\u001b)+G/\u0012=qe\u0016\u001c8/[8o\u0015\r\u00018/\u001b\u0006\u0005G>$WM\u0003\u0004TiJLgn\u001a\u0006\u0006iJ\f7-\u001a\u0006\r\u0005&tG-\u001b8h)J\f7-\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\u0002D\"pI\u0016\u0004vn]5uS>t'BD1cg>dW\u000f^3PM\u001a\u001cX\r\u001e\u0006\u0004\u0013:$(\"E4fi\u0006\u00137o\u001c7vi\u0016|eMZ:fi*)QM\u001d:pe*9Q.Z:tC\u001e,'\"D:uCJ$\bk\\:ji&|gNC\u0006f]\u0012\u0004vn]5uS>t'\u0002B+oSRTaA]3q_J$(\"\u00053jC\u001etwn\u001d;jG\u001a\u000b7\r^8ss*\u0011B)[1h]>\u001cH/[2GC\u000e$xN]=2\u0015)Q5oQ1mY\u0012\u000bG/\u0019\u0006\bo\u0006\u0014h.\u001b8h%\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001Q!\u0001\u0005\u0005\u000b\t!9\u0001#\u0003\u0006\u0005\u0011!\u0001\"B\u0003\u0003\t\u0013AY!\u0002\u0002\u0005\u000b!\u0011QA\u0001C\u0006\u0011\u0019)1\u0001\u0002\u0004\t\b1\u0001QA\u0001\u0003\u0002\u0011!)1\u0001B\u0004\t\u00101\u0001Q!\u0001E\u0002\u000b\r!\u0001\u0002C\u0005\r\u0001\u0015\u0011A!\u0001E\u0003\u000b\r!\u0011\u0002\u0003\u0006\r\u0001\u0015\u0011Aa\u0002E\b\u000b\u0005A)\"\u0002\u0002\u0005\u0016!YQA\u0001\u0003\f\u0011%)!\u0001B\u0005\t\u0015\u0015\u0019AA\u0002E\f\u0019\u0001)1\u0001\u0002\u0005\t\u001a1\u0001QA\u0001\u0003\u0007\u0011/)1\u0001\u0002\u0005\t 1\u0001QA\u0001\u0003\u0002\u0011\r)1\u0001\"\b\t#1\u0001Qa\u0001C\u0003\u0011Ga\u0001!\u0002\u0002\u0005\u001e!\tBa\u0001\u0007\u00043\r)\u0011\u0001#\u0004\u0019\u000e5bA!\u0019\u0003\u0019\u0012\u0005\u001aQ!\u0001E\t1#)6\u0001B\u0003\u0004\t#I\u0011\u0001c\u0006.\u0019\u0011\tG\u0001G\u0004\"\u0007\u0015\t\u0001r\u0002M\b+\u000e!Qa\u0001\u0003\b\u0013\u0005A!\"\f\u0007\u0005C\u0012A\u001a\"I\u0002\u0006\u0003!M\u00014C+\u0004\t\u0015\u0019A1C\u0005\u0002\u00111i3\u0003B1\u0005+\r)\u0011\u0001#\u0007\u0019\u001aaa\u0011eA\u0003\u0002\u00115AR\u0002J\u0011V\u0007\u0019iQ\u0001B\u0007\n\u0003\u0011\u0015Q\"\u0001E\u000e[)\"1\u0002g\u0007\u001e\u0010\u0011\u0001\u0001BD\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t\u001e5\u0019Q!\u0001E\r13\u00016\u0011AO\b\t\u0001Aq\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0003\u0005\u001aQ!\u0001\u0005\u000f19\t6!\u0003C\u000e\u0013\u0005!\u0001!D\u0001\t\u00185\t\u00012D\u0007\u0002\u00117ik\bB\u0001\u0019!u\rB\u0001\u0001E\u0011\u001b5)\u0011\u0001C\b\n\t%\u0019Q!\u0001E\b1\u001fIA!C\u0002\u0006\u0003!}\u0001t\u0004\r\u0010!\u000e\u0001Qt\u0002\u0003\u0001\u00119i1!B\u0001\t\u0012aE\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001RD\u0007\u0004\u000b\u0005AI\u0002'\u0007Q\u0007\u0005iz\u0001\u0002\u0001\t\u001f5\u0019Q!\u0001E\r13\u000161A\u0011\u0004\u000b\u0005Aa\u0002\u0007\bR\u0007-!\u0001#C\u0001\u0005\u00015\t\u0001\u0002E\u0007\u0002\u0011/i\u0011\u0001c\u0007\u000e\u0003!mQF\u000b\u0003\f1Iiz\u0001\u0002\u0001\t\u001d5\u0019Q!\u0001E\t1#\u00016\u0001AO\b\t\u0001Ai\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0002u=A\u0001\u0001\u0005\u0010\u001b\r)\u0011\u0001#\u0007\u0019\u001aA\u001b\u0011!I\u0002\u0006\u0003!q\u0001DD)\u0004\u0013\u0011\u0011\u0012\"\u0001\u0003\u0001\u001b\u0005A9\"D\u0001\t\u001c5\t\u00012D[,\u000b+\"1\u001d\u0001M\u0007;\u001f!\u0001\u0001C\u0004\u000e\u0007\u0015\t\u0001r\u0002M\b!\u000e\u0001Qt\u0002\u0003\u0001\u0011#i1!B\u0001\t\u0012aE\u0001k!\u0001\u001e\u0010\u0011\u0001\u00012C\u0007\u0004\u000b\u0005A\u0019\u0002g\u0005Q\u0007\u0005\t3!B\u0001\t\u0007a\u0019\u0011kA\u0005\u0005\u000e%\tA\u0001A\u0007\u0002\u0011)i\u0011\u0001c\u0006\u000e\u0003!a\u0001"})
public final class JsCodeErrorReporter
implements ErrorReporter {
    public static final /* synthetic */ KClass $kotlinClass;
    private final JetExpression nodeToReport;
    private final String code;
    private final BindingTrace trace;

    static {
        $kotlinClass = Reflection.createKotlinClass(JsCodeErrorReporter.class);
    }

    @Override
    public void warning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(startPosition, "startPosition");
        Intrinsics.checkParameterIsNotNull(endPosition, "endPosition");
        DiagnosticFactory1<JetExpression, JsCallData> diagnosticFactory1 = ErrorsJs.JSCODE_WARNING;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, "ErrorsJs.JSCODE_WARNING");
        this.report(diagnosticFactory1, message, startPosition, endPosition);
    }

    @Override
    public void error(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkParameterIsNotNull(message, "message");
        Intrinsics.checkParameterIsNotNull(startPosition, "startPosition");
        Intrinsics.checkParameterIsNotNull(endPosition, "endPosition");
        DiagnosticFactory1<JetExpression, JsCallData> diagnosticFactory1 = ErrorsJs.JSCODE_ERROR;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, "ErrorsJs.JSCODE_ERROR");
        this.report(diagnosticFactory1, message, startPosition, endPosition);
        throw (Throwable)new AbortParsingException();
    }

    private final void report(DiagnosticFactory1<JetExpression, JsCallData> diagnosticFactory, String message, CodePosition startPosition, CodePosition endPosition) {
        JsCallData jsCallData;
        TextRange reportRange;
        if (JsCallCheckerKt.getIsConstantStringLiteral(this.nodeToReport)) {
            reportRange = new TextRange(this.getAbsoluteOffset(startPosition), this.getAbsoluteOffset(endPosition));
            jsCallData = new JsCallData(reportRange, message);
        } else {
            reportRange = this.nodeToReport.getTextRange();
            TextRange codeRange = new TextRange(JsCallCheckerKt.offsetOf(this.code, startPosition), JsCallCheckerKt.offsetOf(this.code, endPosition));
            TextRange textRange = reportRange;
            Intrinsics.checkExpressionValueIsNotNull(textRange, "reportRange");
            jsCallData = new JsCallDataWithCode(textRange, message, this.code, codeRange);
        }
        JsCallData data2 = jsCallData;
        ParametrizedDiagnostic<JetExpression> parametrizedDiagnostic = diagnosticFactory.on((JetExpression)((PsiElement)this.nodeToReport), data2);
        this.trace.report(parametrizedDiagnostic);
    }

    private final int getAbsoluteOffset(CodePosition $receiver) {
        int quotesLength = this.nodeToReport.getFirstChild().getTextLength();
        return this.nodeToReport.getTextOffset() + quotesLength + JsCallCheckerKt.offsetOf(this.code, $receiver);
    }

    public JsCodeErrorReporter(@NotNull JetExpression nodeToReport, @NotNull String code, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(nodeToReport, "nodeToReport");
        Intrinsics.checkParameterIsNotNull(code, "code");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.nodeToReport = nodeToReport;
        this.code = code;
        this.trace = trace;
    }
}

