/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.metadata.MetadataProperties;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.AliasingContext;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;

public final class FunctionTranslator
extends AbstractTranslator {
    @NotNull
    private TranslationContext functionBodyContext;
    @NotNull
    private final JetDeclarationWithBody functionDeclaration;
    @Nullable
    private JsName extensionFunctionReceiverName;
    @NotNull
    private final JsFunction functionObject;
    @NotNull
    private final FunctionDescriptor descriptor;

    @NotNull
    public static FunctionTranslator newInstance(@NotNull JetDeclarationWithBody function, @NotNull TranslationContext context) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "newInstance"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "newInstance"));
        }
        FunctionTranslator functionTranslator = new FunctionTranslator(function, context);
        if (functionTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "newInstance"));
        }
        return functionTranslator;
    }

    private FunctionTranslator(@NotNull JetDeclarationWithBody functionDeclaration, @NotNull TranslationContext context) {
        if (functionDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDeclaration", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "<init>"));
        }
        super(context);
        this.descriptor = BindingUtils.getFunctionDescriptor(context.bindingContext(), functionDeclaration);
        this.functionDeclaration = functionDeclaration;
        this.functionObject = this.context().getFunctionObject(this.descriptor);
        assert (this.functionObject.getParameters().isEmpty()) : ErrorReportingUtils.message(this.descriptor, "Function " + functionDeclaration.getText() + " processed for the second time.");
        this.functionBodyContext = this.getFunctionBodyContext();
    }

    @NotNull
    private TranslationContext getFunctionBodyContext() {
        AliasingContext aliasingContext;
        if (this.isExtensionFunction()) {
            ReceiverParameterDescriptor expectedReceiverDescriptor = this.descriptor.getExtensionReceiverParameter();
            assert (expectedReceiverDescriptor != null);
            this.extensionFunctionReceiverName = this.functionObject.getScope().declareName(Namer.getReceiverParameterName());
            aliasingContext = this.context().aliasingContext().inner(expectedReceiverDescriptor, this.extensionFunctionReceiverName.makeRef());
        } else {
            aliasingContext = null;
        }
        TranslationContext translationContext = this.context().newFunctionBody(this.functionObject, aliasingContext);
        if (translationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "getFunctionBodyContext"));
        }
        return translationContext;
    }

    @NotNull
    public JsPropertyInitializer translateAsEcma5PropertyDescriptor() {
        this.generateFunctionObject();
        JsPropertyInitializer jsPropertyInitializer = TranslationUtils.translateFunctionAsEcma5PropertyDescriptor(this.functionObject, this.descriptor, this.context());
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "translateAsEcma5PropertyDescriptor"));
        }
        return jsPropertyInitializer;
    }

    @NotNull
    public JsPropertyInitializer translateAsMethod() {
        JsName functionName = this.context().getNameForDescriptor(this.descriptor);
        this.generateFunctionObject();
        if (CallExpressionTranslator.shouldBeInlined(this.descriptor) && DescriptorUtilPackage.getIsEffectivelyPublicApi(this.descriptor)) {
            InlineMetadata metadata = InlineMetadata.compose(this.functionObject, this.descriptor);
            JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(functionName.makeRef(), metadata.getFunctionWithMetadata());
            if (jsPropertyInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "translateAsMethod"));
            }
            return jsPropertyInitializer;
        }
        JsPropertyInitializer jsPropertyInitializer = new JsPropertyInitializer(functionName.makeRef(), this.functionObject);
        if (jsPropertyInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "translateAsMethod"));
        }
        return jsPropertyInitializer;
    }

    private void generateFunctionObject() {
        JsAstUtils.setParameters(this.functionObject, this.translateParameters());
        this.translateBody();
    }

    private void translateBody() {
        if (!this.functionDeclaration.hasBody()) {
            assert (this.descriptor instanceof ConstructorDescriptor || this.descriptor.getModality().equals((Object)Modality.ABSTRACT));
            return;
        }
        this.functionObject.getBody().getStatements().addAll(FunctionBodyTranslator.translateFunctionBody(this.descriptor, this.functionDeclaration, this.functionBodyContext).getStatements());
    }

    @NotNull
    private List<JsParameter> translateParameters() {
        SmartList<JsParameter> jsParameters = new SmartList<JsParameter>();
        HashMap<DeclarationDescriptor, JsExpression> aliases = new HashMap<DeclarationDescriptor, JsExpression>();
        for (TypeParameterDescriptor type2 : this.descriptor.getTypeParameters()) {
            if (!type2.isReified()) continue;
            String suggestedName = Namer.isInstanceSuggestedName(type2);
            JsName paramName = this.functionObject.getScope().declareName(suggestedName);
            jsParameters.add(new JsParameter(paramName));
            aliases.put(type2, paramName.makeRef());
        }
        this.functionBodyContext = this.functionBodyContext.innerContextWithDescriptorsAliased(aliases);
        if (this.extensionFunctionReceiverName == null && this.descriptor.getValueParameters().isEmpty()) {
            SmartList<JsParameter> smartList = jsParameters;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "translateParameters"));
            }
            return smartList;
        }
        this.mayBeAddThisParameterForExtensionFunction(jsParameters);
        FunctionTranslator.addParameters(jsParameters, this.descriptor, this.context());
        SmartList<JsParameter> smartList = jsParameters;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "translateParameters"));
        }
        return smartList;
    }

    public static void addParameters(List<JsParameter> list, FunctionDescriptor descriptor2, TranslationContext context) {
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            JsParameter jsParameter = new JsParameter(context.getNameForDescriptor(valueParameter));
            MetadataProperties.setHasDefaultValue(jsParameter, DescriptorUtilPackage.hasDefaultValue(valueParameter));
            list.add(jsParameter);
        }
    }

    private void mayBeAddThisParameterForExtensionFunction(@NotNull List<JsParameter> jsParameters) {
        if (jsParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsParameters", "org/jetbrains/kotlin/js/translate/expression/FunctionTranslator", "mayBeAddThisParameterForExtensionFunction"));
        }
        if (this.isExtensionFunction()) {
            assert (this.extensionFunctionReceiverName != null);
            jsParameters.add(new JsParameter(this.extensionFunctionReceiverName));
        }
    }

    private boolean isExtensionFunction() {
        return DescriptorUtils.isExtension(this.descriptor) && !(this.functionDeclaration instanceof JetFunctionLiteralExpression);
    }
}

