/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsExpressionImpl;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsLiteral;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsStringLiteral;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.JetType;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\u001a\f)Y2)\u00197mC\ndWMU3gKJ,gnY3Ue\u0006t7\u000f\\1u_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0003UNT\u0011\u0002\u001e:b]Nd\u0017\r^3\u000b\u0013I,g-\u001a:f]\u000e,'bA!os*i\u0011n]\"p]N$(/^2u_JT!\u0002Z3tGJL\u0007\u000f^8s\u0015I\u0019\u0015\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:\u000b\u0017\u0011,7o\u0019:jaR|'o\u001d\u0006\b\u0005>|G.Z1o\u0015-I7/\u0012=uK:\u001c\u0018n\u001c8\u000b\u0011%\u001cX*Z7cKJTQ![:WCJT!\u0003\u0015:pa\u0016\u0014H/\u001f#fg\u000e\u0014\u0018\u000e\u001d;pe*a!j]#yaJ,7o]5p]*\u00191m\\7\u000b\r\u001d|wn\u001a7f\u0015\u0011!\u0017M\u001d;\u000b\u0011\r|W\u000e]5mKJTqAY1dW\u0016tGMC\u0002bgRT!C]3q_J$hj\u001c;TkB\u0004xN\u001d;fI*91m\u001c8uKb$(B\u0005+sC:\u001cH.\u0019;j_:\u001cuN\u001c;fqRT!\"\u001a=qe\u0016\u001c8/[8o\u0015yQU\r^\"bY2\f'\r\\3SK\u001a,'/\u001a8dK\u0016C\bO]3tg&|gNC\u0002qg&T!\u0005\u001e:b]Nd\u0017\r^3Bg6+WNY3s\rVt7\r^5p]J+g-\u001a:f]\u000e,'bD2mCN\u001cH)Z:de&\u0004Ho\u001c:\u000b\u001f\rc\u0017m]:EKN\u001c'/\u001b9u_JTq\u0003\u001e:b]Nd\u0017\r^3G_J\u001cuN\\:ueV\u001cGo\u001c:\u000b%\u0019+hn\u0019;j_:$Um]2sSB$xN\u001d\u0006\u001eiJ\fgn\u001d7bi\u00164uN]#yi\u0016t7/[8o\rVt7\r^5p]*iBO]1og2\fG/\u001a$pe\u0016CH/\u001a8tS>t\u0007K]8qKJ$\u0018P\u0003\u000bue\u0006t7\u000f\\1uK\u001a{'OR;oGRLwN\u001c\u0006\u001biJ\fgn\u001d7bi\u00164uN]'f[\n,'OR;oGRLwN\u001c\u0006\u001biJ\fgn\u001d7bi\u00164uN]'f[\n,'\u000f\u0015:pa\u0016\u0014H/\u001f\u0006\u0015iJ\fgn\u001d7bi\u00164uN\u001d)s_B,'\u000f^=\u000b9Q\u0014\u0018M\\:mCR,gi\u001c:U_BdUM^3m!J|\u0007/\u001a:usj\u000f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019Aq\u0001E\u0004\u0019\u0001)!\u0001B\u0001\t\f\u0015\u0019A\u0011\u0002\u0005\u0006\u0019\u0001)1\u0001b\u0002\t\r1\u0001QA\u0001C\u0005\u0011\u0015)1\u0001\"\u0003\t\u00111\u0001Q!\u0001\u0005\n\u000b\t!q\u0001c\u0005\u0006\u0005\u0011=\u0001BC\u0003\u0003\t!A)\"\u0002\u0002\u0005\u0012!YQA\u0001\u0003\n\u0011\t)!\u0001b\u0005\t\u0018\u0015\u0019AA\u0003E\t\u0019\u0001)!\u0001\u0002\u0006\t\u0012\u0015\u0011A\u0011\u0002\u0005\t\u000b\t!!\u0001#\u0007\u0006\u0007\u0011a\u0001\"\u0004\u0007\u0001\u000b\t!\u0011\u0001#\b\u0006\u0007\u0011i\u0001B\u0004\u0007\u0001\u000b\t!A\u0002C\u0007\u0006\u0005\u0011i\u0001BD\u0003\u0004\t\u0013A\u0001\u0003\u0004\u0001\u0006\u0005\u0011%\u0001\u0002E\u0003\u0004\t\u0013A\u0011\u0003\u0004\u0001\u0006\u0005\u0011%\u0001\"\u0005\u0003d\u00031\u0019\u0011dA\u0003\u0002\u0011\u0011AB!L\u000b\u0005\u0003a!Qt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\u000ba)\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0002M\u0006#\u000e)A\u0001B\u0005\u0002\t\u0003i\u0011\u0001\u0003\u0004.+\u0011\t\u0001TBO\b\t\u0001AI!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001\u0005\u001aQ!\u0001E\u00061\u0017\t6!\u0002C\u0007\u0013\u0005!\t!D\u0001\t\r5*B!\u0001\r\b;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001\"\u0002\r\u0006!\u000e\u0001\u0011eA\u0003\u0002\u0011\u0017AZ!U\u0002\u0006\t\u001dI\u0011\u0001\"\u0001\u000e\u0003!1Q&\u0006\u0003\u00021\u001fiz\u0001\u0002\u0001\t\n5\u0019Q!\u0001E\u00071\u001b\u00016\u0001A\u0011\u0004\u000b\u0005A)\u0002'\u0006R\u0007\u0015!y!C\u0001\t\u00175\t\u0001rCW \t\u0005AB\"h\u0004\u0005\u0001!eQbA\u0003\u0002\u00113AJ\u0002U\u0002\u0001;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u00012\u0004M\u000e!\u000e\u0005\u0011eA\u0003\u0002\u0011+A*\"U\u0002\b\t1I\u0011\u0001C\u0006\u000e\u0003!qQ\"\u0001E\u000f[\u007f!1\u0001'\u0002\u001e\u0010\u0011\u0001\u00012D\u0007\u0004\u000b\u0005AY\u0002g\u0007Q\u0007\u0001iz\u0001\u0002\u0001\t\u001a5\u0019Q!\u0001E\r13\u00016\u0011A\u0011\u0004\u000b\u0005A)\u0002'\u0006R\u0007\u001d!)!C\u0001\t\u00175\t\u0001RD\u0007\u0002\u00119i#\u0006B\u0001\u0019\u001fu=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001C\u0003\u0019\u000bA\u001b\u0001!h\u0004\u0005\u0001!}QbA\u0003\u0002\u0011=Ar\u0002UB\u0001;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\t\u0011eA\u0003\u0002\u0011+A*\"U\u0002\n\t=I\u0011\u0001C\u0006\u000e\u0003!1Q\"\u0001E\u0010\u001b\u0005Aa\"l\u0010\u0005\u0003a\u0005Rt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t!a\u0001\u0002k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005AI\u0002'\u0007Q\u0007\u0003\t3!B\u0001\t\u0016aU\u0011kA\u0004\u0005\"%\t\u0001bC\u0007\u0002\u0011Ci\u0011\u0001\u0003\b.@\u0011\t\u00014EO\b\t\u0001AI!D\u0002\u0006\u0003!\u0001\u0002\u0004\u0005)\u0004\u0001u=A\u0001\u0001E\r\u001b\r)\u0011\u0001#\u0007\u0019\u001aA\u001b\t!I\u0002\u0006\u0003!U\u0001TC)\u0004\u000f\u0011\r\u0012\"\u0001\u0005\f\u001b\u0005A\t#D\u0001\t\u001d5~B!\u0001\r\u0013;\u001f!\u0001\u0001#\u0003\u000e\u0007\u0015\t\u0001R\u0002M\u0007!\u000e\u0001Qt\u0002\u0003\u0001\u00113i1!B\u0001\t\u001aae\u0001k!\u0001\"\u0007\u0015\t\u0001R\u0003M\u000b#\u000e9AAE\u0005\u0002\u0011-i\u0011\u0001c\u0006\u000e\u0003!qQF\u000b\u0003\u00021Kiz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00111A\u00016\u0001AO\b\t\u0001AI\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0002u=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001c\u0007\u0019\u001cA\u001b\u0011!I\u0002\u0006\u0003!U\u0001TC)\u0004\u0013\u0011\u0015\u0012\"\u0001\u0005\f\u001b\u0005A\t#D\u0001\t\u001d5\t\u0001RDW \t\u0005A2#h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011AA\u0002\u0003U\u0002\u0001;\u001f!\u0001\u0001#\u0007\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\u0005\u0011eA\u0003\u0002\u0011+A*\"U\u0002\b\tMI\u0011\u0001C\u0006\u000e\u0003!\u0005R\"\u0001\u0005\u000f[\u007f!\u0011\u0001g\n\u001e\u0010\u0011\u0001\u0001\u0012B\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0001iz\u0001\u0002\u0001\t\u001a5\u0019Q!\u0001E\r13\u00016\u0011A\u0011\u0004\u000b\u0005A)\u0002'\u0006R\u0007\u001d!9#C\u0001\t\u00175\t\u0001rC\u0007\u0002\u00119i#\u0006B\u0001\u0019)u=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!h\u0004\u0005\u0001!eQbA\u0003\u0002\u00113AJ\u0002UB\u0001;\u001f!\u0001\u0001c\u0007\u000e\u0007\u0015\t\u00012\u0004M\u000e!\u000e\t\u0011eA\u0003\u0002\u0011+A*\"U\u0002\n\tQI\u0011\u0001C\u0006\u000e\u0003!]Q\"\u0001\u0005\u000f\u001b\u0005Ai\"l\u0010\u0005\u0003a%Rt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\u000ea5\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012D\u0007\u0004\u000b\u0005AI\u0002'\u0007Q\u0007\u0003\t3!B\u0001\t\u0016aU\u0011kA\u0004\u0005*%\t\u0001bC\u0007\u0002\u0011/i\u0011\u0001\u0003\b6\u0001\u0001"})
public final class CallableReferenceTranslator {
    public static final /* synthetic */ KClass $kotlinClass;
    public static final CallableReferenceTranslator INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(CallableReferenceTranslator.class);
        new CallableReferenceTranslator();
    }

    @NotNull
    public final JsExpression translate(@NotNull JetCallableReferenceExpression expression, @NotNull TranslationContext context) {
        JsExpression jsExpression;
        DeclarationDescriptor descriptor2;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DeclarationDescriptor declarationDescriptor = descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), expression.getCallableReference());
        if (declarationDescriptor instanceof PropertyDescriptor) {
            jsExpression = this.translateForProperty((PropertyDescriptor)descriptor2, context, expression);
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            jsExpression = this.translateForFunction((FunctionDescriptor)descriptor2, context, expression);
        } else {
            throw (Throwable)new IllegalArgumentException("Expected property or function: " + descriptor2 + ", expression=" + expression.getText());
        }
        return jsExpression;
    }

    private final JsExpression reportNotSupported(TranslationContext context, JetCallableReferenceExpression expression) {
        context.bindingTrace().report(ErrorsJs.REFERENCE_TO_BUILTIN_MEMBERS_NOT_SUPPORTED.on((JetElement)((PsiElement)expression), expression));
        JsExpression jsExpression = context.getEmptyExpression();
        Intrinsics.checkExpressionValueIsNotNull(jsExpression, "context.getEmptyExpression()");
        return jsExpression;
    }

    private final JsExpression translateForFunction(FunctionDescriptor descriptor2, TranslationContext context, JetCallableReferenceExpression expression) {
        JsExpression jsExpression;
        if (JsDescriptorUtils.isBuiltin(descriptor2)) {
            jsExpression = this.reportNotSupported(context, expression);
        } else if (this.isConstructor(descriptor2)) {
            jsExpression = this.translateForConstructor(descriptor2, context);
        } else if (this.isExtension(descriptor2)) {
            jsExpression = this.translateForExtensionFunction(descriptor2, context);
        } else if (this.isMember(descriptor2)) {
            jsExpression = this.translateForMemberFunction(descriptor2, context);
        } else {
            JsExpression jsExpression2 = ReferenceTranslator.translateAsFQReference(descriptor2, context);
            jsExpression = jsExpression2;
            Intrinsics.checkExpressionValueIsNotNull(jsExpression2, "ReferenceTranslator.tran\u2026ence(descriptor, context)");
        }
        return jsExpression;
    }

    private final JsExpression translateForProperty(PropertyDescriptor descriptor2, TranslationContext context, JetCallableReferenceExpression expression) {
        return JsDescriptorUtils.isBuiltin(descriptor2) ? this.reportNotSupported(context, expression) : (this.isExtension(descriptor2) ? this.translateForExtensionProperty(descriptor2, context) : (this.isMember(descriptor2) ? this.translateForMemberProperty(descriptor2, context) : this.translateForTopLevelProperty(descriptor2, context)));
    }

    private final boolean isConstructor(CallableDescriptor descriptor2) {
        return descriptor2 instanceof ConstructorDescriptor;
    }

    private final boolean isExtension(CallableDescriptor descriptor2) {
        return DescriptorUtils.isExtension(descriptor2);
    }

    private final boolean isMember(CallableDescriptor descriptor2) {
        return JsDescriptorUtils.getContainingDeclaration(descriptor2) instanceof ClassDescriptor;
    }

    private final JsExpression isVar(PropertyDescriptor descriptor2) {
        return descriptor2.isVar() ? JsLiteral.TRUE : JsLiteral.FALSE;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression translateForTopLevelProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        void value;
        DeclarationDescriptor packageDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor2);
        boolean bl = packageDescriptor instanceof PackageFragmentDescriptor;
        if (KotlinPackage.getASSERTIONS_ENABLED() && value == false) {
            String message = "Expected PackageFragmentDescriptor: " + packageDescriptor;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        JsNameRef jsPackageNameRef = context.getQualifiedReference(packageDescriptor);
        JsName jsPropertyName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context.namer().callableRefForTopLevelPropertyReference(), jsPackageNameRef, jsPropertyNameAsString, this.isVar(descriptor2));
    }

    private final JsExpression translateForMemberProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        JsName jsPropertyName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(jsPropertyName.toString());
        return new JsInvocation(context.namer().callableRefForMemberPropertyReference(), jsPropertyNameAsString, this.isVar(descriptor2));
    }

    private final JsExpression translateForExtensionProperty(PropertyDescriptor descriptor2, TranslationContext context) {
        PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
        if (propertyGetterDescriptor == null) {
            Intrinsics.throwNpe();
        }
        JsNameRef jsGetterNameRef = context.getQualifiedReference(propertyGetterDescriptor);
        Name propertyName = descriptor2.getName();
        JsStringLiteral jsPropertyNameAsString = context.program().getStringLiteral(propertyName.asString());
        ArrayList<JsExpressionImpl> argumentList2 = new ArrayList<JsExpressionImpl>(3);
        argumentList2.add(jsPropertyNameAsString);
        argumentList2.add(jsGetterNameRef);
        if (descriptor2.isVar()) {
            PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
            if (propertySetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            JsNameRef jsSetterNameRef = context.getQualifiedReference(propertySetterDescriptor);
            argumentList2.add(jsSetterNameRef);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            return this.translateForMemberProperty(descriptor2, context);
        }
        return new JsInvocation(context.namer().callableRefForExtensionPropertyReference(), (List<JsExpression>)argumentList2);
    }

    private final JsExpression translateForConstructor(FunctionDescriptor descriptor2, TranslationContext context) {
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor2, context);
        return new JsInvocation(context.namer().callableRefForConstructorReference(), jsFunctionRef);
    }

    private final JsExpression translateForExtensionFunction(FunctionDescriptor descriptor2, TranslationContext context) {
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        KotlinPackage.assert(receiverParameterDescriptor != null, "receiverParameter for extension should not be null");
        JsExpression jsFunctionRef = ReferenceTranslator.translateAsFQReference(descriptor2, context);
        if (Intrinsics.areEqual(descriptor2.getVisibility(), Visibilities.LOCAL)) {
            return new JsInvocation(context.namer().callableRefForLocalExtensionFunctionReference(), jsFunctionRef);
        }
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
            if (receiverParameterDescriptor2 == null) {
                Intrinsics.throwNpe();
            }
            JetType jetType = receiverParameterDescriptor2.getType();
            ClassDescriptor receiverClassDescriptor = DescriptorUtils.getClassDescriptorForType(jetType);
            CallableDescriptor callableDescriptor = descriptor2;
            ClassDescriptor classDescriptor = receiverClassDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "receiverClassDescriptor");
            return this.translateAsMemberFunctionReference(callableDescriptor, classDescriptor, context);
        }
        return new JsInvocation(context.namer().callableRefForExtensionFunctionReference(), jsFunctionRef);
    }

    private final JsExpression translateForMemberFunction(FunctionDescriptor descriptor2, TranslationContext context) {
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getContainingDeclaration(descriptor2);
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException("Expected ClassDescriptor: " + descriptor2);
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return this.translateAsMemberFunctionReference(descriptor2, classDescriptor2, context);
    }

    private final JsExpression translateAsMemberFunctionReference(CallableDescriptor descriptor2, ClassDescriptor classDescriptor, TranslationContext context) {
        JsNameRef jsClassNameRef = context.getQualifiedReference(classDescriptor);
        JsName funName = context.getNameForDescriptor(descriptor2);
        JsStringLiteral funNameAsString = context.program().getStringLiteral(funName.toString());
        return new JsInvocation(context.namer().callableRefForMemberFunctionReference(), jsClassNameRef, funNameAsString);
    }

    CallableReferenceTranslator() {
        INSTANCE$ = this;
    }
}

