/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetElementImplStub;
import org.jetbrains.kotlin.psi.JetFunctionTypeReceiver;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetTypeElement;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetFunctionType
extends JetElementImplStub<KotlinPlaceHolderStub<JetFunctionType>>
implements JetTypeElement {
    public static final JetToken RETURN_TYPE_SEPARATOR = JetTokens.ARROW;

    public JetFunctionType(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetFunctionType", "<init>"));
        }
        super(node);
    }

    public JetFunctionType(@NotNull KotlinPlaceHolderStub<JetFunctionType> stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetFunctionType", "<init>"));
        }
        super(stub, JetStubElementTypes.FUNCTION_TYPE);
    }

    @Override
    @NotNull
    public List<JetTypeReference> getTypeArgumentsAsTypes() {
        ArrayList<JetTypeReference> result2 = Lists.newArrayList();
        JetTypeReference receiverTypeRef = this.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            result2.add(receiverTypeRef);
        }
        for (JetParameter jetParameter : this.getParameters()) {
            result2.add(jetParameter.getTypeReference());
        }
        JetTypeReference returnTypeRef = this.getReturnTypeReference();
        if (returnTypeRef != null) {
            result2.add(returnTypeRef);
        }
        ArrayList<JetTypeReference> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFunctionType", "getTypeArgumentsAsTypes"));
        }
        return arrayList;
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetFunctionType", "accept"));
        }
        return visitor2.visitFunctionType(this, data2);
    }

    @Nullable
    public JetParameterList getParameterList() {
        return (JetParameterList)this.getStubOrPsiChild(JetStubElementTypes.VALUE_PARAMETER_LIST);
    }

    @NotNull
    public List<JetParameter> getParameters() {
        JetParameterList list = this.getParameterList();
        List<JetParameter> list2 = list != null ? list.getParameters() : Collections.emptyList();
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetFunctionType", "getParameters"));
        }
        return list2;
    }

    @Nullable
    public JetTypeReference getReceiverTypeReference() {
        JetFunctionTypeReceiver receiverDeclaration = (JetFunctionTypeReceiver)this.getStubOrPsiChild(JetStubElementTypes.FUNCTION_TYPE_RECEIVER);
        if (receiverDeclaration == null) {
            return null;
        }
        return receiverDeclaration.getTypeReference();
    }

    @Nullable
    public JetTypeReference getReturnTypeReference() {
        return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
    }
}

