/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds$$TImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"\b\f)qA+\u001f9f\u0005>,h\u000eZ:J[Bd'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u000fI,7o\u001c7wK*)1-\u00197mg*I\u0011N\u001c4fe\u0016t7-\u001a\u0006\u000b)f\u0004XMQ8v]\u0012\u001c(B\u0002\u001fj]&$hH\u0003\u0007usB,g+\u0019:jC\ndWMC\fUsB,\u0007+\u0019:b[\u0016$XM\u001d#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015I1\u0018M]5b]\u000e,wJ\u001a)pg&$\u0018n\u001c8\u000b\u0011Y\u000b'/[1oG\u0016TQ\u0001^=qKNTaAY8v]\u0012\u001c(\"C!se\u0006LH*[:u\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\u0006\u0005>,h\u000e\u001a\u0006\nO\u0016$(i\\;oINTq\u0001P:fi6zdHC\u0004C_>dW-\u00198\u000b\u000f%\u001ch)\u001b=fI*Qq-\u001a;Jg\u001aK\u00070\u001a3\u000b\u0015M,G/S:GSb,GM\u0003\u0007sKN,H\u000e\u001e,bYV,7O\u0003\u0006D_2dWm\u0019;j_:TqAS3u)f\u0004XMC\bhKR$\u0016\u0010]3WCJL\u0017M\u00197f\u0015\u00191\u0018\r\\;fg*Iq-\u001a;WC2,Xm\u001d\u0006\u0016O\u0016$h+\u0019:jC:\u001cWm\u00144Q_NLG/[8o\u0015!\tG\r\u001a\"pk:$'\"\u00022pk:$'\u0002B+oSRT\u0001\u0003V=qK\n{WO\u001c3tI\t{WO\u001c3\u000b\u001b\r|W\u000e];uKZ\u000bG.^3t\u0015\u00191\u0017\u000e\u001c;fe*I1m\u001c8eSRLwN\u001c\u0006\n\rVt7\r^5p]FR!cQ8ogR\u0014\u0018-\u001b8u!>\u001c\u0018\u000e^5p]*\u00112m\u001c8tiJ\f\u0017N\u001c;Q_NLG/[8o\u0015\rQg/\u001c\u0006\nMVt7\r^5p]NTABZ5mi\u0016\u0014(i\\;oINTAa[5oI*I!i\\;oI.Kg\u000e\u001a\u0006\u0004'\u0016$(\u0002\u0006+za\u0016\u0014u.\u001e8eg\u0012\u0012u.\u001e8e\u0017&tGMC\u0006feJ|'OV1mk\u0016\u001c(\"E'vi\u0006\u0014G.Z\"pY2,7\r^5p]*A1/\u001a;GSb,GMC\tuef\u0004vn]:jE2,\u0017I\\:xKJTa\u0002]8tg&\u0014G.Z!og^,'O!\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\r!)\u0001c\u0002\r\u0001\u0015\u0011A!\u0001E\u0006\u000b\r!A\u0001C\u0003\r\u0001\u0015\u0011A!\u0001\u0005\b\u000b\r!Q\u0001#\u0004\r\u0001\u0015\u0011A\u0001\u0002\u0005\u0006\u000b\t!Q\u0001#\u0004\u0006\u0003!EQA\u0001\u0003\b\u0011%)1\u0001b\u0004\t\u00111\u0001Qa\u0001C\u0004\u0011'a\u0001!\u0002\u0002\u0005\u0010!AQ!\u0001E\u0002\u000b\r!\u0019\u0002C\u0006\r\u0001\u0015\u0019A1\u0003E\u000e\u0019\u0001)1\u0001B\u0003\t\u001d1\u0001QA\u0001C\b\u00117)1\u0001b\u0005\t$1\u0001QA\u0001C\u0003\u0011I)1\u0001b\u0005\t)1\u0001QA\u0001C\u0003\u0011U)1\u0001b\u0007\t*1\u0001QA\u0001C\u0003\u0011\u0001)!\u0001b\u0005\t,\u0015\u0011Aa\u0004\u0005\u0017\u000b\t!y\u0002\u0003\u000b\u0006\u0007\u0011\u001d\u0001r\u0006\u0007\u0001\u000b\r!\u0019\u0002\u0003\r\r\u0001\u0015\u0011Aq\u0002\u0005\u0019\u000b\t!)\u0001#\r\u0006\u0007\u0011M\u00012\u0007\u0007\u0001\u000b\t!Q\u0001\u0003\b\u0005\u00071\u0019\u0011dA\u0003\u0002\u0011\u000fA:!L\u000b\u0005W\u0012Az!\t\u0005\u0006\u0003!A\u0011\u0002B\u0005\u0004\u000b\u0005A\t\u0002'\u0005\u0019\u0011U\u001b\u0001\"B\u0002\u0005\u0010%\t\u0001\"C\u0007\u0004\t)I\u0011\u0001C\u0005.@\u0011\u0019M\u0002g\u0006\u001e\u0010\u0011\u0001\u0001RC\u0007\u0004\u000b\u0005A!\u0002\u0007\u0006Q\u0007\u0001\t3!B\u0001\t\u0015aQ\u0001&I+\u0004\u001d\u0015\u0019AqC\u0005\u0002\t\u0003i1\u0001\u0002\u0007\n\u0003\u0011\u0005\u0011#\u0002C\r\u0013\u0005!\u0001!D\u0001\u0005\u00025\u0012B!1\u0007\u0019\u001b\u0005JQ!\u0001E\u000b\u0013\u0011I1!B\u0001\t\u0017aYA\u0012\u0001M\u000b+\u000e!Qa\u0001\u0003\u000e\u0013\u0005A9\"\f\t\u0005W\u0012AJ!I\u0002\u0006\u0003!%\u0001\u0014B+\u0004\u0011\u0015\u0019A\u0011B\u0005\u0002\u0011\u0019i1\u0001\"\b\n\u0003!1QF\u0005\u0003l\tay\u0011\u0005C\u0003\u0002\u0011+IA!C\u0002\u0006\u0003!Y\u0001d\u0003M\u000bI-*6\u0001B\u0007\u0004\t?I\u0011\u0001c\u0006.!\u0011YG\u0001\u0007\u0004\"\u0007\u0015\t\u00012\u0002M\u0006+\u000eAQa\u0001\u0003\u0007\u0013\u0005Ai!D\u0002\u0005!%\t\u0001RB\u0017\u0016\t\rA\n#h\u0004\u0005\u0001!\tRbA\u0003\u0002\u0011#A\n\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\u0007\u0019\u0019E\u001bQ\u0001\"\t\n\u0003\u0011\u0001Q\"\u0001E\r[?!\u0011\u0001'\n\"\u0011\u0015\t\u0001RC\u0005\u0005\u0013\r)\u0011\u0001C\u0006\u0019\u0017aU\u0011kA\u0002\u0005&%\t\u0001rC\u0017 \t\rA2#h\t\u0005\u0001!\u001dR\"D\u0003\u0002\u00115IA!C\u0002\u0006\u0003!q\u0001DD\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0006\u0019\u0015ai\u0001k\u0001\u0001\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000e)AaE\u0005\u0002\u0011;i\u0011\u0001\u0003\t.T\u0011\t\u0001TFO\r\t\u0001Ay!\u0004\u0005\u0006\u0003!U\u0011\u0002B\u0005\u0004\u000b\u0005A\t\u0002'\u0005\u0019\u0016A\u001b\u0001!h\u0004\u0005\u0001!9RbA\u0003\u0002\u0011CA\n\u0003UB\u0001C!)\u0011\u0001C\t\n\t%\u0019Q!\u0001\u0005\f1-A\u0012#U\u0002\b\t[I\u0011\u0001c\t\u000e\u0003!]Q\"\u0001\u0005\u0013[i\"\u0011\u0001'\f\u001e\u001a\u0011\u0001\u0001rB\u0007\t\u000b\u0005A)\"\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0003M\t1+\u00016\u0001AO\b\t\u0001Aq#D\u0002\u0006\u0003!\u0005\u0002\u0014\u0005)\u0004\u0002umA\u0001\u0001\u0005\u001a\u001b%)\u0011\u0001#\n\n\t%\u0019Q!\u0001\u0005\f1-a\t\u0001'\nQ\u0007\u0005\t\u0003\"B\u0001\t#%!\u0011bA\u0003\u0002\u0011-A2\u0002G\tR\u0007%!i#C\u0001\t$5\t\u0001rC\u0007\u0002\u0011Ii\u0011\u0001c\u0006.\u0016\u0011\u0019\u0001DG\u0011\u0004\u000b\u0005AA\u0002\u0007\u0007R\u0007\r!!$C\u0001\u0005\u00015.C!\u0001M\u001b;3!\u0001\u0001c\u0004\u000e\u0011\u0015\t\u0001RC\u0005\u0005\u0013\r)\u0011\u0001#\u0005\u0019\u0012aU\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001bG\u0007\u0005\u000b\u0005A1\u0002$\u0001\u0019\u0017A\u001b\t!I\u0002\u0006\u0003!Q\u0001DC)\u0004\u000f\u0011U\u0012\"\u0001C\u0001\u001b\u0005A9\"D\u0001\t'U\nS\u0001\t\u0003d\u0002a!Qt\u0002\u0003\u0001\u0011\u0013i1!B\u0001\t\na%\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0003\t3!B\u0001\t\u0007a\u0019\u0011kA\u0004\u0005\t%\tA\u0001A\u0007\u0002\u0011\u0019i\u0011\u0001#\u0004"})
public final class TypeBoundsImpl
implements TypeBounds {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final ArrayList<TypeBounds.Bound> bounds;
    private Collection<? extends JetType> resultValues;
    private boolean isFixed;
    @NotNull
    private final TypeParameterDescriptor typeVariable;
    @NotNull
    private final Variance varianceOfPosition;

    static {
        $kotlinClass = Reflection.createKotlinClass(TypeBoundsImpl.class);
    }

    @NotNull
    public ArrayList<TypeBounds.Bound> getBounds() {
        return this.bounds;
    }

    public final boolean getIsFixed() {
        return this.isFixed;
    }

    public final void setFixed() {
        this.isFixed = true;
    }

    public final void addBound(@NotNull TypeBounds.Bound bound) {
        Intrinsics.checkParameterIsNotNull(bound, "bound");
        this.resultValues = null;
        boolean value = Intrinsics.areEqual(bound.getTypeVariable(), this.getTypeVariable());
        if (KotlinPackage.getASSERTIONS_ENABLED() && !value) {
            String message = bound + " is added for incorrect type variable " + bound.getTypeVariable().getName() + ". Expected: " + this.getTypeVariable().getName();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ((ArrayList)this.getBounds()).add(bound);
    }

    private final Set<JetType> filterBounds(Collection<? extends TypeBounds.Bound> bounds, TypeBounds.BoundKind kind) {
        return this.filterBounds(bounds, kind, null);
    }

    private final Set<JetType> filterBounds(Collection<? extends TypeBounds.Bound> bounds, TypeBounds.BoundKind kind, Collection<JetType> errorValues) {
        LinkedHashSet<JetType> result2 = new LinkedHashSet<JetType>();
        for (TypeBounds.Bound bound : bounds) {
            if (!Intrinsics.areEqual((Object)bound.getKind(), (Object)kind)) continue;
            if (!ErrorUtils.containsErrorType(bound.getConstrainingType())) {
                result2.add(bound.getConstrainingType());
                continue;
            }
            Collection<JetType> collection = errorValues;
            Boolean bl = collection != null ? Boolean.valueOf(collection.add(bound.getConstrainingType())) : null;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeBoundsImpl filter(@NotNull Function1<? super ConstraintPosition, ? extends Boolean> condition) {
        void destination;
        void $receiver;
        void $receiver2;
        Intrinsics.checkParameterIsNotNull(condition, "condition");
        TypeBoundsImpl result2 = new TypeBoundsImpl(this.getTypeVariable(), this.getVarianceOfPosition());
        Iterable iterable = this.getBounds();
        Collection collection = result2.getBounds();
        void var4_5 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element : $receiver) {
            TypeBounds.Bound it2 = (TypeBounds.Bound)element;
            if (!condition.invoke(it2.getPosition()).booleanValue()) continue;
            destination.add(element);
        }
        List list = (List)destination;
        ((ArrayList)collection).addAll(list);
        return result2;
    }

    @Override
    @NotNull
    public Collection<JetType> getValues() {
        if (this.resultValues == null) {
            this.resultValues = this.computeValues();
        }
        Collection<JetType> collection = this.resultValues;
        if (collection == null) {
            Intrinsics.throwNpe();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<JetType> computeValues() {
        JetType superTypeOfAllLowerBounds;
        void numberLowerBounds;
        void generalLowerBounds;
        void $receiver;
        boolean hasStrongBound;
        Object it2;
        Object element3;
        List bounds;
        Object it3;
        LinkedHashSet values;
        block14: {
            boolean bl;
            Iterator destination;
            Iterable $receiver2;
            values = new LinkedHashSet();
            Iterable $receiver3 = this.getBounds();
            Iterable iterable = $receiver3;
            Collection collection = new ArrayList();
            for (Object element2 : $receiver2) {
                it3 = (TypeBounds.Bound)element2;
                if (!((TypeBounds.Bound)it3).getIsProper()) continue;
                destination.add(element2);
            }
            bounds = (List)((Object)destination);
            if (bounds.isEmpty()) {
                return KotlinPackage.listOf();
            }
            $receiver2 = bounds;
            for (Object element3 : $receiver2) {
                it2 = (TypeBounds.Bound)element3;
                if (!((TypeBounds.Bound)it2).getPosition().isStrong()) continue;
                bl = true;
                break block14;
            }
            bl = hasStrongBound = false;
        }
        if (!hasStrongBound) {
            return KotlinPackage.listOf();
        }
        Set<JetType> exactBounds = this.filterBounds(bounds, TypeBounds.BoundKind.EXACT_BOUND, values);
        JetType bestFit = FlexibleTypesKt.singleBestRepresentative((Collection<? extends JetType>)exactBounds);
        if (bestFit != null && this.tryPossibleAnswer(bounds, bestFit)) {
            return KotlinPackage.listOf(bestFit);
        }
        values.addAll(exactBounds);
        Iterable iterable = this.filterBounds(bounds, TypeBounds.BoundKind.LOWER_BOUND, values);
        ArrayList first = new ArrayList();
        ArrayList second = new ArrayList();
        for (Object element4 : $receiver) {
            JetType it4 = (JetType)element4;
            if (it4.getConstructor() instanceof IntegerValueTypeConstructor) {
                first.add(element4);
                continue;
            }
            second.add(element4);
        }
        it3 = new Pair(first, second);
        element3 = (List)((Pair)it3).component1();
        it2 = (List)((Pair)it3).component2();
        it3 = null;
        JetType superTypeOfLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection)generalLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfLowerBounds)) {
            JetType jetType = superTypeOfLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        CollectionsKt.addIfNotNull(values, superTypeOfLowerBounds);
        JetType superTypeOfNumberLowerBounds = TypeUtils.commonSupertypeForNumberTypes((Collection)numberLowerBounds);
        if (this.tryPossibleAnswer(bounds, superTypeOfNumberLowerBounds)) {
            JetType jetType = superTypeOfNumberLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        CollectionsKt.addIfNotNull(values, superTypeOfNumberLowerBounds);
        if (superTypeOfLowerBounds != null && superTypeOfNumberLowerBounds != null && this.tryPossibleAnswer(bounds, superTypeOfAllLowerBounds = CommonSupertypes.commonSupertypeForNonDenotableTypes((Collection<JetType>)KotlinPackage.listOf(superTypeOfLowerBounds, superTypeOfNumberLowerBounds)))) {
            JetType jetType = superTypeOfAllLowerBounds;
            if (jetType == null) {
                Intrinsics.throwNpe();
            }
            return KotlinPackage.setOf(jetType);
        }
        Set<JetType> upperBounds = this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND, values);
        JetType intersectionOfUpperBounds = new TypeIntersector(DescriptorUtilsKt.getBuiltIns(this.getTypeVariable())).intersect(JetTypeChecker.DEFAULT, upperBounds);
        if (!upperBounds.isEmpty() && intersectionOfUpperBounds != null && this.tryPossibleAnswer(bounds, intersectionOfUpperBounds)) {
            return KotlinPackage.setOf(intersectionOfUpperBounds);
        }
        values.addAll(this.filterBounds(bounds, TypeBounds.BoundKind.UPPER_BOUND));
        return values;
    }

    private final boolean tryPossibleAnswer(Collection<? extends TypeBounds.Bound> bounds, JetType possibleAnswer) {
        if (possibleAnswer == null) {
            return false;
        }
        if (!possibleAnswer.getConstructor().isDenotable() && !CapturedTypeConstructorKt.isCaptured(possibleAnswer)) {
            return false;
        }
        for (TypeBounds.Bound bound : bounds) {
            TypeBounds.BoundKind boundKind = bound.getKind();
            if (!(Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.LOWER_BOUND) ? !JetTypeChecker.DEFAULT.isSubtypeOf(bound.getConstrainingType(), possibleAnswer) : (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.UPPER_BOUND) ? !JetTypeChecker.DEFAULT.isSubtypeOf(possibleAnswer, bound.getConstrainingType()) : Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.EXACT_BOUND) && !JetTypeChecker.DEFAULT.equalTypes(bound.getConstrainingType(), possibleAnswer)))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable() {
        return this.typeVariable;
    }

    @Override
    @NotNull
    public Variance getVarianceOfPosition() {
        return this.varianceOfPosition;
    }

    public TypeBoundsImpl(@NotNull TypeParameterDescriptor typeVariable, @NotNull Variance varianceOfPosition) {
        Intrinsics.checkParameterIsNotNull(typeVariable, "typeVariable");
        Intrinsics.checkParameterIsNotNull((Object)varianceOfPosition, "varianceOfPosition");
        this.typeVariable = typeVariable;
        this.varianceOfPosition = varianceOfPosition;
        this.bounds = new ArrayList();
    }

    @Override
    @Nullable
    public JetType getValue() {
        return TypeBounds$$TImpl.getValue(this);
    }
}

