/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Lazy;
import kotlin.PropertyMetadata;
import kotlin.PropertyMetadataImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallableDescriptors;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionTaskHolder;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.collectors.CallableDescriptorCollector;
import org.jetbrains.kotlin.resolve.calls.tasks.collectors.CallableDescriptorCollectors;
import org.jetbrains.kotlin.resolve.calls.tasks.collectors.CallableDescriptorCollectorsKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.JetScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.JetScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"}\u001a)yA+Y:l!JLwN]5uSj,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u001d\u0011Xm]8mm\u0016TQaY1mYNTQ\u0001^1tWNT1!\u00118z\u0015\u0019a\u0014N\\5u})q1\u000f^8sC\u001e,W*\u00198bO\u0016\u0014(BD*u_J\fw-Z'b]\u0006<WM\u001d\u0006\bgR|'/Y4f\u0015A\u0019X.\u0019:u\u0007\u0006\u001cH/T1oC\u001e,'O\u0003\tT[\u0006\u0014HoQ1ti6\u000bg.Y4fe*Q1/\\1si\u000e\f7\u000f^:\u000b\u0003\u0011S!cQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe*YA-Z:de&\u0004Ho\u001c:t\u0015\u00051%bH1eI\u000e\u000bg\u000eZ5eCR,7OR8s\tft\u0017-\\5d%\u0016\u001cW-\u001b<fe*\u0001R\r\u001f9mS\u000eLGOU3dK&4XM\u001d\u0006\u0012%\u0016\u001cW-\u001b<fe^KG\u000f\u001b+za\u0016\u001c(\"E5na2L7-\u001b;SK\u000e,\u0017N^3sg*Q1i\u001c7mK\u000e$\u0018n\u001c8\u000b\u001bI+7-Z5wKJ4\u0016\r\\;f\u0015\u0019\u00198m\u001c9fg*I!/Z2fSZ,'o\u001d\u0006\u0002G*1B+Y:l!JLwN]5uSj,'oQ8oi\u0016DHO\u0003\u0006jg\u0016C\b\u000f\\5dSRTqAQ8pY\u0016\fgN\u0003\u0003V]&$(\"\t+bg.\u0004&/[8sSRL'0\u001a:%%\u0016\u001cW-\u001b<fe^KG\u000f\u001b+za\u0016\u001c(\u0002\u00026bm\u0006TA!\u001e;jY*1C+Y:l!JLwN]5uSj,'\u000f\n+bg.\u0004&/[8sSRL'0\u001a:D_:$X\r\u001f;\u000bA\u0005$GmQ1oI&$\u0017\r^3t\r>\u0014X\t\u001f9mS\u000eLGOU3dK&4XM\u001d\u0006\u0017C\u0012$7)\u00198eS\u0012\fG/Z:G_JLeN^8lK*Q\u0012\r\u001a3DC:$\u0017\u000eZ1uKN4uN\u001d(p%\u0016\u001cW-\u001b<fe*i\u0014\r\u001a3DC:$\u0017\u000eZ1uKN<\u0006.\u001a8J]Z|7.Z%t\u001b\u0016l'-\u001a:B]\u0012,\u0005\u0010^3og&|g\u000eV8FqBd\u0017nY5u%\u0016\u001cW-\u001b<fe*\u0001B-[:qCR\u001c\u0007NU3dK&4XM\u001d\u0006\u0012e\u0016\u001cW-\u001b<feB\u000b'/Y7fi\u0016\u0014(\u0002\u0004:fG\u0016Lg/\u001a:LS:$'\u0002F#ya2L7-\u001b;SK\u000e,\u0017N^3s\u0017&tGM\u0003\fbI\u0012,\u0005\u0010^3og&|gnQ1oI&$\u0017\r^3t\u0015q\tG\rZ'f[\n,'/\u0012=uK:\u001c\u0018n\u001c8DC:$\u0017\u000eZ1uKNT1dY1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\u000e{G\u000e\\3di>\u0014(bG\"bY2\f'\r\\3EKN\u001c'/\u001b9u_J\u001cu\u000e\u001c7fGR|'O\u0003\u0006d_2dWm\u0019;peNT!\"\u00193e\u001b\u0016l'-\u001a:t\u00155\u0019H/\u0019;jG6+WNY3sg*92m\\7qkR,\u0007K]5pe&$\u0018N_3e)\u0006\u001c8n\u001d\u0006\bG>tG/\u001a=u\u0015i\u0011\u0015m]5d\u0007\u0006dGNU3t_2,H/[8o\u0007>tG/\u001a=u\u0015\u0011q\u0017-\\3\u000b\t9\u000bW.\u001a\u0006\biJ\f7-\u001b8h\u0015=!&/Y2j]\u001e\u001cFO]1uK\u001eL(\u0002H2bY2\f'\r\\3EKN\u001c'/\u001b9u_J\u001cu\u000e\u001c7fGR|'o\u001d\u0006\u001d\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'oQ8mY\u0016\u001cGo\u001c:t\u0015\u0011a\u0015n\u001d;\u000b\u001dI+7o\u001c7vi&|g\u000eV1tW*)3m\\7qkR,\u0007K]5pe&$\u0018N_3e)\u0006\u001c8n\u001d$s_6\u001c\u0015M\u001c3jI\u0006$Xm\u001d\u0006\u000bG\u0006tG-\u001b3bi\u0016\u001c(b\u0005*fg>dW\u000f^5p]\u000e\u000bg\u000eZ5eCR,'BI2p[B,H/\u001a+bg.\u001chi\u001c:DY\u0006\u001c8o\u00142kK\u000e$(+Z2fSZ,'OC\trk\u0006d\u0017NZ5feJ+7-Z5wKJT\u0011#U;bY&4\u0017.\u001a:SK\u000e,\u0017N^3s\u0015Y!\u0018m]6Qe&|'/\u001b;ju\u0016\u00148i\u001c8uKb$(BF2p]Z,'\u000f^,ji\"LU\u000e\u001d7jK\u0012$\u0006.[:\u000b\u000bM\u001cw\u000e]3\u000b\u0011)+GoU2pa\u0016TAaY1mY*!1)\u00197m\u0015\r\u00018/\u001b\u0006$G>tg/\u001a:u/&$\b.S7qY&,G\r\u00165jg\u0006sGMT8SK\u000e,\u0017N^3s\u0015Q\u0019wN\u001c<feR<\u0016\u000e\u001e5SK\u000e,\u0017N^3sg*\tR\r\u001f;f]NLwN\u001c*fG\u0016Lg/\u001a:\u000b\rI,7/\u001e7u\u0015EiU\u000f^1cY\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0006\u0015Kb\u0004H.[2jiJ+7-Z5wKJ\\\u0015N\u001c3\u000b\u0015\r\u0014X-\u0019;f\u0017&tGM\u0003\u0003lS:$'\u0002F2sK\u0006$X\rT8pWV\u0004Hj\\2bi&|gN\u0003\u000bL_Rd\u0017N\u001c'p_.,\b\u000fT8dCRLwN\u001c\u0006\fS:\u001c'/Z7f]R\fGN\u0003\be_\u000e{W\u000e];uKR\u000b7o[:\u000b\u0011I,7-Z5wKJTab]3u\u00136\u0004H.[3e)\"L7OC\u0005dC:$\u0017\u000eZ1uK*q2\u000f\u001d7ji2+\u00070[2bY2LHj\\2bY\u0012+7o\u0019:jaR|'o\u001d\u0006\u000fC2dG)Z:de&\u0004Ho\u001c:t\u0015u\u0019wN\u001c;bS:,'o\u00144UQ\u0016\u001cUO\u001d:f]RdunY1mSRL(\"\u0006#fG2\f'/\u0019;j_:$Um]2sSB$xN\u001d\u0006\u0006Y>\u001c\u0017\r\u001c\u0006\t]>tGn\\2bY*!\u0002K]5pe&$\u0018\u0010\u0015:pm&$WM]%na2t;A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0003\t\tA1!B\u0002\u0005\u0006!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001b\u0002\t\b1\u0001QA\u0001\u0003\u0002\u0011\u0017)1\u0001\"\u0003\t\u000b1\u0001QA\u0001\u0003\u0003\u0011\u001d)1\u0001b\u0003\t\u000e1\u0001QA\u0001C\u0005\u0011\u0015)!\u0001b\u0003\t\u000e\u0015\u0011A!\u0001E\t\u000b\r!y\u0001\u0003\u0005\r\u0001\u0015\u0019Aa\u0001E\u000b\u0019\u0001)1\u0001b\u0002\t\u00181\u0001QA\u0001C\u0002\u00113)!\u0001b\u0005\t\u001b\u0015\u0019AA\u0003\u0005\r\u0019\u0001)1\u0001B\u0002\t\u001d1\u0001Qa\u0001C\u0004\u0011=a\u0001!B\u0002\u0005\b!}A\u0002A\u0003\u0003\t\u000bA\u0001#B\u0001\t\"\u0015\u0011A!\u0004\u0005\u0012\u000b\t!Y\u0002c\u0006\u0006\u0005\u0011\u0015\u00012E\u0003\u0004\t\u000bAY\u0003\u0004\u0001\u0006\u0005\u0011Q\u0001\u0002D\u0003\u0003\t\u000bAY#\u0002\u0002\u0005\u0006!ARa\u0001C\u0011\u0011_a\u0001!\u0002\u0002\u0005\"!=RA\u0001\u0003\u0003\u0011i)1\u0001\u0002\n\t61\u0001QA\u0001\u0003\u0002\u0011m)1\u0001B\n\t81\u0001Qa\u0001C\u0003\u0011sa\u0001!B\u0002\u0005\"!mB\u0002A\u0003\u0004\t\u000fAa\u0004\u0004\u0001\u0006\u0007\u0011\u0015\u0001R\b\u0007\u0001\u000b\t!Y\u0002\u0003\u0010\u0006\u0005\u0011\u0011\u0002RG\u0003\u0003\tMA9$\u0002\u0002\u0005\u0006!eRA\u0001C\u0011\u0011w)1\u0001\"\u0002\tA1\u0001Qa\u0001\u0003\u000b\u0011\u0007b\u0001!\u0002\u0002\u0005\u0015!\rSa\u0001C\n\u0011\u000fb\u0001!\u0002\u0002\u0005\u0003!)Sa\u0001C\u001b\u0011\u0013b\u0001!\u0002\u0002\u0005\u0014!\u001dSA\u0001C\u001b\u0011\u0013*1\u0001b\u0002\tP1\u0001QA\u0001\u0003\u0002\u0011+*1\u0001B\u000f\tU1\u0001QA\u0001\u0003\u001e\u0011)*!\u0001\"\u0002\tA\u0015\u0019Aq\u0002E/\u0019\u0001)!\u0001b\u0004\t^\u0011\u0019AbA\r\u0004\u000b\u0005AA\u0001\u0007\u0003\u001e\u0004AVa\"\f\u0007\u0005C\u0012Ab!I\u0002\u0006\u0003!1\u0001DB+\u0004\t\u0015\u0019AAB\u0005\u0002\u0011\u001diC\u0002B1\u00051\u0013\t3!B\u0001\t\u000ba)Qk\u0001\u0003\u0006\u0007\u0011%\u0011\"\u0001E\u0007[S\u0007A!A\t\u0007\t\u0001Ay!F\u0002\u0006\u0003!A\u0001\u0004C\t\b\t\u0003A\u0011\"\u0006\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011'iz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001E\t1#\u00016\u0001AO\r\t\u0001A1\"\u0004\u0005\u0006\u0003!I\u0011\u0002B\u0005\u0004\u000b\u0005A)\u0002'\u0006\u0019\u0013A\u001b\t!h\n\u0005\u0001!mQbD\u0003\u0002\u0011-IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001\r\f!\u000e\tQt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u0018a]\u0001ka\u0001\"\u0007\u0015\t\u0001\u0002\u0004\r\r#\u000eYA1C\u0005\u0002\t\u0001i\u0011\u0001#\u0007\u000e\u0003!qQ\"\u0001E\u000f\u001b\u0005!\t!,k\u0001\t\u0005\tb\u0001\u0002\u0001\t\u0010U\u0019Q!\u0001\u0005\t1!\tr\u0001\"\u0001\t\u0013U!QA\u0001C\u0001\u0011\u0001a\u0002\u0001\u0007\n\u001e\u0010\u0011\u0001\u0001BC\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001iJ\u0002\u0002\u0001\t\u00175AQ!\u0001\u0005\n\u0013\u0011I1!B\u0001\t\u0016aU\u0001$\u0003)\u0004\u0002u\u001dB\u0001\u0001E\u000e\u001b=)\u0011\u0001C\u0006\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002!C\u0003\n\t\u0015\u0011A\u0011\u0001E\u00019\u0003A2\u0002U\u0002\u0002;\u001f!\u0001\u0001#\b\u000e\u0007\u0015\t\u0001r\u0003M\f!\u000e\r\u0011eA\u0003\u0002\u00111AB\"U\u0002\f\tII\u0011\u0001\u0002\u0001\u000e\u0003!eQ\"\u0001\u0005\u000f\u001b\u0005Ai\"D\u0001\u0005\u00025VD!A\t\u0007\t\u0001Ay!F\u0002\u0006\u0003!A\u0001\u0004C\t\b\t\u0003A\u0011\"\u0006\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011Kiz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001E\t1#\u00016\u0001AO\u0014\t\u0001AY\"D\b\u0006\u0003!Y\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u0017A\u001b\t!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u000f\u0011\u0015\u0012\"\u0001\u0003\u0001\u001b\u0005AI\"D\u0001\t\u001e5~D!A\t\u0007\t\u0001Ay!F\u0002\u0006\u0003!A\u0001\u0004C\t\b\t\u0003A\u0011\"\u0006\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011MiJ\u0002\u0002\u0001\t\u00175AQ!\u0001\u0005\n\u0013\u0011I1!B\u0001\t\u0016aU\u0001$\u0003)\u0004\u0001u\u001dB\u0001\u0001E\u000e\u001b=)\u0011\u0001C\u0006\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002!C\u0003\n\t\u0015\u0011A\u0011\u0001E\u00019\u0003A2\u0002UB\u0001C\r)\u0011\u0001\u0003\u0007\u0019\u0019E\u001bq\u0001B\n\n\u0003\u0011\u0001Q\"\u0001\u0005\u000f\u001b\u0005Ai\"lh\u0001\t\u0005\tb\u0001\u0002\u0001\t\u0010U\u0019Q!\u0001\u0005\t1!\tr\u0001\"\u0001\t\u0013U!QA\u0001C\u0001\u0011\u0001a\u0002\u0001g\n\u001e\u0010\u0011\u0001\u0001\u0002F\u0007\u0004\u000b\u0005A)\u0002'\u0006Q\u0007\u0001iz\u0001\u0002\u0001\t*5\u0019Q!\u0001E\t1#\u00016\u0011AO\u0014\t\u0001AY\"D\b\u0006\u0003!Y\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u0017A\u001b\u0011!h\u0004\u0005\u0001!)RbA\u0003\u0002\u0011=Ar\u0002UB\u0002C\r)\u0011\u0001\u0003\u0007\u0019\u0019E\u001b1\u0002b\n\n\u0003\u0011\u0001Q\"\u0001E\u0010\u001b\u0005AI\"D\u0001\t\u001e5\t\u0001\u0002EWU\u0002\u0011\t\u0011C\u0002\u0003\u0001\u0011\u001f)2!B\u0001\t\u0011aA\u0011c\u0002C\u0001\u0011%)B!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001\r\u0017;\u001f!\u0001\u0001\u0003\u0006\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0001Q\u0014\u0004\u0003\u0001\u0011-i\u0001\"B\u0001\t\u0013%!\u0011bA\u0003\u0002\u0011+A*\u0002G\u0005Q\u0007\u0003i:\u0003\u0002\u0001\t\u001c5yQ!\u0001\u0005\f\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004A\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0002q\u0005\u0001d\u0003)\u0004\u0003u=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001c\u0006\u0019\u0018A\u001b\u0019!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u0017\u00111\u0012\"\u0001\u0003\u0001\u001b\u0005AI\"D\u0001\t\u001d5\t\u0001RD\u0007\u0002\t\u0003i\u0003\u001d\u0001\u0003\u0002#\u0019!\u0001\u0001c\u0004\u0016\u0007\u0015\t\u0001\u0002\u0003\r\t#\u001d!\t\u0001C\u0005\u0016\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001Aj#h\u0004\u0005\u0001!!RbA\u0003\u0002\u0011+A*\u0002U\u0002\u0001;\u001f!\u0001\u0001#\u000b\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0005Q4\u0004\u0003\u0001\u0011]i\u0011\"B\u0001\t#%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019#A\u001b\u0011!h\n\u0005\u0001!mQbD\u0003\u0002\u0011-IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001\r\f!\u000e\rQt\u0002\u0003\u0001\u0011Ui1!B\u0001\t\u001fay\u0001k\u0001\u0002\"\u0007\u0015\t\u0001\u0002\u0004\r\r#\u000eiAQF\u0005\u0002\t\u0001i\u0011\u0001c\b\u000e\u0003!eQ\"\u0001E\u0012\u001b\u0005Ai\"D\u0001\t!5~\r\u0001B\u0001\u0012\r\u0011\u0001\u0001rB\u000b\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0012\u000f\u0011\u0005\u0001\"C\u000b\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001aERt\u0002\u0003\u0001\u0011)i1!B\u0001\t\u0012aE\u0001k\u0001\u0001\u001e(\u0011\u0001\u00012D\u0007\u0010\u000b\u0005A1\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u00011-\u00016\u0011AO\b\t\u0001A\u0011$D\u0002\u0006\u0003!]\u0001t\u0003)\u0004\u0003u=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001c\u0006\u0019\u0018A\u001b\u0019!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u0017\u0011E\u0012\"\u0001\u0003\u0001\u001b\u0005AI\"D\u0001\t\u001e5\tA\u0011A\u0007\u0002\t\u0003i+\u001c\u0001\u0003\u0004#\u0019!\u0001\u0001c\u0004\u0016\u0007\u0015\t\u0001\u0002\u0003\r\t#\u001d!\t\u0001C\u0005\u0016\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\u001a$h\u0004\u0005\u0001!QRbA\u0003\u0002\u0011KA*\u0003U\u0002\u0001;\u001f!\u0001\u0001C\u000e\u000e\u0007\u0015\t\u0001r\u0005M\u0014!\u000e\u0005Qt\u0002\u0003\u0001\u0011qi1!B\u0001\t)a!\u0002kA\u0001\u001e\u001c\u0011\u0001\u0001\"H\u0007\n\u000b\u0005AI#C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001AJ\u0003UB\u0002CQ)\u0011\u0001C\u000b\n!%yQ!\u0001E\u0016\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004A\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0002q\u0005\u00014\u0006\r\u0016#\u000eYA1G\u0005\u0002\u0011Yi\u0011\u0001#\f\u000e\u0003!9R\"\u0001E\u0018\u001b\u0005A\u0001$Lk\u0001\t\r\tb\u0001\u0002\u0001\t\u0010U\u0019Q!\u0001\u0005\t1!\tr\u0001\"\u0001\t\u0013U!QA\u0001C\u0001\u0011\u0001a\u0002\u0001G\u0010\u001e\u0010\u0011\u0001\u0001BG\u0007\u0004\u000b\u0005A)\u0003'\nQ\u0007\u0001i*\u0003\u0002\u0001\t@5qQ!\u0001\u0005\n\u0013)I\u0011\"B\u0001\t2%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u00192aI\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001\u0002H\u0007\u0004\u000b\u0005AA\u0003\u0007\u000bQ\u0007\u0005\tC#B\u0001\t+%\u0001\u0012bD\u0003\u0002\u0011WIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001M\u00161U\t6!\u0003\u0003 \u0013\u0005Aa#D\u0001\t.5\t\u0001BD\u0007\u0002\u0011_i+\bB\u0001\u0012\r\u0011\u0001\u0001rB\u000b\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0012\u000f\u0011\u0005\u0001\"C\u000b\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001a\u0005St\u0002\u0003\u0001\u0011\u0005j1!B\u0001\t3aI\u0002k\u0001\u0001\u001e(\u0011\u0001\u0001BI\u0007\u0010\u000b\u0005A1\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u00011-\u00016\u0011A\u0011\u0004\u000b\u0005AA\u0002\u0007\u0007R\u0007\u001d!\t%C\u0001\u0005\u00015\t\u00012G\u0007\u0002\u0011;is\u001b\u0001\u0003\u0004#\u0019!\u0001\u0001c\u0004\u0016\u0007\u0015\t\u0001\u0002\u0003\r\t1\u000bjz\u0001\u0002\u0001\tG5\u0019Q!\u0001\u0005\u001b1i\u00016\u0001AO\b\t\u0001AI#D\u0002\u0006\u0003!U\u0001T\u0003)\u0004\u0002umA\u0001\u0001E\t\u001b%)\u0011\u0001C\u0005\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001G\u0005Q\u0007\u0005iz\u0001\u0002\u0001\t+5\u0019Q!\u0001\u0005\u00101=\u000161AO\b\t\u0001AA%D\u0002\u0006\u0003!Y\u0002d\u0007)\u0004\u0005\u0005rQ!\u0001\u0005\n\u0013)I\u0011\"B\u0001\t2%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u00192aI\u0011kA\u0007\u0005F%\t\u0001BD\u0007\u0002\u0011oi\u0011\u0001c\b\u000e\u0003!qQ\"\u0001\u0005\u0011\u001b\u0005AA$\fb\u0001\t\r\tb\u0001\u0002\u0001\t\u0010U\u0019Q!\u0001\u0005\t1!AZ%h\u0004\u0005\u0001!\u0019SbA\u0003\u0002\u0011iA\"\u0004U\u0002\u0001;7!\u0001\u0001#\u0005\u000e\u0013\u0015\t\u0001\"C\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001$\u0003)\u0004\u0002u=A\u0001\u0001\u0005%\u001b\r)\u0011\u0001C\u000e\u00197A\u001b\u0011!\t\b\u0006\u0003!I\u0011BC\u0005\n\u000b\u0005A\t$C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\n\u0004G\u0005R\u0007%!Y%C\u0001\t\u001d5\t\u0001rG\u0007\u0002\u00119i\u0011\u0001\u0003\u000f.D\u0004!\u0011!\u0005\u0004\u0005\u0001!=QcA\u0003\u0002\u0011!A\u0002\u0002\u0007\u0014\u001e\u001c\u0011\u0001\u0001\u0012C\u0007\n\u000b\u0005A\u0011\"C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\u0012\u0002U\u0002\u0001;\u001f!\u0001\u0001\u0003\u000b\u000e\u0007\u0015\t\u0001R\u0003M\u000b!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u001bj1!B\u0001\t\u0016aU\u0001kA\u0001\u001e&\u0011\u0001\u0001bJ\u0007\u000f\u000b\u0005AI$\u0003\u0006\n\u0013\u0015\t\u0001\u0012G\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001\u0014\u0007M\u001d!\u000e\rQt\u0002\u0003\u0001\u0011!j1!B\u0001\t\u001fay\u0001k\u0001\u0002\u001e\u0010\u0011\u0001\u0001\u0002J\u0007\u0004\u000b\u0005A1\u0004G\u000eQ\u0007\u000b\t3!B\u0001\t\u0019aa\u0011kA\b\u0005M%\tA\u0001A\u0007\u0002\u00119i\u0011\u0001c\b\u000e\u0003!}Q\"\u0001\u0005\u000f\u001b\u0005A\u0001#D\u0001\t95:\u000e\u0001B\u0001\u0012\r\u0011\u0001\u0001rB\u000b\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019MumA\u0001\u0001E\t\u001b%)\u0011\u0001C\u0005\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002\u0001G\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t)5\u0019Q!\u0001E\u000b1+\u00016\u0011AO\b\t\u0001Ai%D\u0002\u0006\u0003!U\u0001T\u0003)\u0004\u0003u=A\u0001\u0001\u0005)\u001b\r)\u0011\u0001C\b\u0019\u001fA\u001b\u0019!h\u0004\u0005\u0001!!SbA\u0003\u0002\u0011mA2\u0004U\u0002\u0003C9)\u0011\u0001C\u0005\n\u0015%IQ!\u0001E\u0019\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M\u00191%\t6!\u0004\u0003'\u0013\u0005Aa\"D\u0001\t\u001d5\t\u0001rD\u0007\u0002\u0011?i\u0011\u0001\u0003\t\u000e\u0003!aRv\b\u0003\u00021#jz\u0001\u0002\u0001\tS5\u0019Q!\u0001\u0005\u00101=\u00016\u0001AO\b\t\u0001Ai\"D\u0002\u0006\u0003!]\u0001t\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00101=\t6a\u0002C)\u0013\u0005A\u0001#D\u0001\t!5\tA\u0011A\u0017\u001a\t\u0005A\u001a&h\u0006\u0005\u0001!mQbB\u0003\u0002\u0011-I\u0011\u0001b\u0001\n\u0003\u0011\r\u0001d\u0003)\u0004\u0001\u0005\u001aQ!\u0001E\u001e1w\t6!\u0002C*\u0013\u0005Aa$D\u0001\t\u001e5VD!A\t\u0007\t\u0001Ay!F\u0002\u0006\u0003!A\u0001\u0004C\t\b\t\u0003A\u0011\"\u0006\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011-jz\u0001\u0002\u0001\tX5\u0019Q!\u0001E\u000b1+\u00016\u0001AO\u0014\t\u0001AY\"D\b\u0006\u0003!Y\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u0017A\u001b\t!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u000f\u0011Y\u0013\"\u0001\u0003\u0001\u001b\u0005Ay\"D\u0001\t\u001e5fC!A\t\u0007\t\u0001Ay!F\u0002\u0006\u0003!A\u0001\u0004\u0003\r-;\u001f!\u0001\u0001C\u0012\u000e\u0007\u0015\t\u0001B\u0007\r\u001b!\u000e\u0001Q4\u0004\u0003\u0001\u00113j\u0011\"B\u0001\t2%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u00192A\u001b\t!I\u0002\u0006\u0003!]\u0001tC)\u0004\u000f\u0011a\u0013\"\u0001C\u0001\u001b\u0005A9$D\u0001\t>5f\u000e\u0001B\u0002\u0012\r\u0011\u0001\u0001rB\u000b\u0004\u000b\u0005A\u0001\u0002\u0007\u0005\u0019[u\u0015B\u0001\u0001E.\u001b9)\u0011\u0001C\u0005\n\u0015%IQ!\u0001E\u0019\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M\u00191%\u00016\u0001AO\b\t\u0001Aa&D\u0002\u0006\u0003!y\u0002d\b)\u0004\u0002u\u0015B\u0001\u0001\u00050\u001b9)\u0011\u0001#\u000f\n\u0015%IQ!\u0001E\u0019\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M\u00191s\u00016!AO\u0013\t\u0001Ay&\u0004\b\u0006\u0003!e\u0012BC\u0005\n\u000b\u0005A\t$C\u0003\n\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001A\n\u0004'\u000fQ\u0007\u0007\t3!B\u0001\t\u0019aa\u0011kA\u0006\u0005[%\tA\u0001A\u0007\u0002\u00119i\u0011\u0001c\u0010\u000e\u0003!qQ\"\u0001\u0005\u000fk\u0005*\u0001\u0005Br\u00011\u0011iz\u0001\u0002\u0001\t\n5\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0001AO\b\t\u0001Aa!D\u0002\u0006\u0003!1\u0001D\u0002)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u00041\r\t6a\u0002\u0003\u0005\u0013\u0005!\u0001!D\u0001\t\u000e5\t\u0001b\u0002"})
public final class TaskPrioritizer {
    public static final /* synthetic */ KClass $kotlinClass;
    private final StorageManager storageManager;
    private final SmartCastManager smartCastManager;

    static {
        $kotlinClass = Reflection.createKotlinClass(TaskPrioritizer.class);
    }

    public final <D extends CallableDescriptor> void splitLexicallyLocalDescriptors(@NotNull Collection<? extends ResolutionCandidate<D>> allDescriptors2, @NotNull DeclarationDescriptor containerOfTheCurrentLocality, @NotNull Collection<ResolutionCandidate<D>> local, @NotNull Collection<ResolutionCandidate<D>> nonlocal) {
        Intrinsics.checkParameterIsNotNull(allDescriptors2, "allDescriptors");
        Intrinsics.checkParameterIsNotNull(containerOfTheCurrentLocality, "containerOfTheCurrentLocality");
        Intrinsics.checkParameterIsNotNull(local, "local");
        Intrinsics.checkParameterIsNotNull(nonlocal, "nonlocal");
        for (ResolutionCandidate<D> resolvedCall : allDescriptors2) {
            if (ExpressionTypingUtils.isLocal(containerOfTheCurrentLocality, (DeclarationDescriptor)resolvedCall.getDescriptor())) {
                local.add(resolvedCall);
                continue;
            }
            nonlocal.add(resolvedCall);
        }
    }

    @NotNull
    public final <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasks(@NotNull BasicCallResolutionContext context, @NotNull Name name, @NotNull TracingStrategy tracing, @NotNull CallableDescriptorCollectors<D> callableDescriptorCollectors) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        Intrinsics.checkParameterIsNotNull(callableDescriptorCollectors, "callableDescriptorCollectors");
        ReceiverValue explicitReceiver = context.call.getExplicitReceiver();
        ResolutionTaskHolder result2 = new ResolutionTaskHolder(this.storageManager, context, new PriorityProviderImpl(context), tracing);
        TaskPrioritizerContext taskPrioritizerContext = new TaskPrioritizerContext(name, result2, context, ScopeUtilsKt.asJetScope(context.scope), callableDescriptorCollectors);
        if (explicitReceiver instanceof QualifierReceiver) {
            ReceiverValue receiverValue = explicitReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "explicitReceiver");
            QualifierReceiver qualifierReceiver = (QualifierReceiver)receiverValue;
            ReceiverValue receiverValue2 = ReceiverValue.NO_RECEIVER;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "NO_RECEIVER");
            this.doComputeTasks(receiverValue2, taskPrioritizerContext.replaceScope(qualifierReceiver.getNestedClassesAndPackageMembersScope()));
            this.computeTasksForClassObjectReceiver(qualifierReceiver, taskPrioritizerContext);
        } else {
            ReceiverValue receiverValue = explicitReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "explicitReceiver");
            this.doComputeTasks(receiverValue, taskPrioritizerContext);
        }
        return result2.getTasks();
    }

    private final <D extends CallableDescriptor, F extends D> void computeTasksForClassObjectReceiver(QualifierReceiver qualifierReceiver, TaskPrioritizerContext<D, F> taskPrioritizerContext) {
        ReceiverValue classObjectReceiver = qualifierReceiver.getClassObjectReceiver();
        if (!classObjectReceiver.exists()) {
            return;
        }
        ClassifierDescriptor classifierDescriptor = qualifierReceiver.getClassifier();
        this.doComputeTasks(classObjectReceiver, taskPrioritizerContext.filterCollectors(new Function1<D, Boolean>(classifierDescriptor){
            final /* synthetic */ ClassifierDescriptor $classifierDescriptor;

            public final boolean invoke(@NotNull D it2) {
                Intrinsics.checkParameterIsNotNull(it2, "it");
                return this.$classifierDescriptor instanceof ClassDescriptor && ((ClassDescriptor)this.$classifierDescriptor).getCompanionObjectDescriptor() != null ? !(it2 instanceof ConstructorDescriptor) && !(it2 instanceof FakeCallableDescriptorForObject) : (this.$classifierDescriptor != null && DescriptorUtils.isEnumEntry(this.$classifierDescriptor) ? !(it2 instanceof FakeCallableDescriptorForObject) : true);
            }
            {
                this.$classifierDescriptor = classifierDescriptor;
                super(1);
            }
        }));
    }

    private final <D extends CallableDescriptor, F extends D> void doComputeTasks(ReceiverValue receiver, TaskPrioritizerContext<D, F> c) {
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        ReceiverWithTypes receiverWithTypes = new ReceiverWithTypes(receiver, c.getContext());
        boolean resolveInvoke = c.getContext().call.getDispatchReceiver().exists();
        if (resolveInvoke) {
            this.addCandidatesForInvoke(receiverWithTypes, c);
            return;
        }
        LinkedHashSet implicitReceivers = Sets.newLinkedHashSet((Iterable)JetScopeUtils.getImplicitReceiversHierarchyValues(c.getScope()));
        if (receiver.exists()) {
            Collection collection = implicitReceivers;
            Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
            this.addCandidatesForExplicitReceiver(receiverWithTypes, collection, c, true);
            this.addMembers(receiverWithTypes, c, true, true);
            return;
        }
        Collection collection = implicitReceivers;
        Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
        this.addCandidatesForNoReceiver(collection, c);
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForExplicitReceiver(ReceiverWithTypes explicitReceiver, Collection<? extends ReceiverValue> implicitReceivers, TaskPrioritizerContext<D, F> c, boolean isExplicit) {
        this.addMembers(explicitReceiver, c, false, isExplicit);
        if (DynamicTypesKt.isDynamic(explicitReceiver.getValue().getType())) {
            this.addCandidatesForDynamicReceiver(explicitReceiver, implicitReceivers, c, isExplicit);
        } else {
            this.addExtensionCandidates(explicitReceiver, implicitReceivers, c, isExplicit);
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addExtensionCandidates(ReceiverWithTypes explicitReceiver, Collection<? extends ReceiverValue> implicitReceivers, TaskPrioritizerContext<D, F> c, boolean isExplicit) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            for (ReceiverValue receiverValue : implicitReceivers) {
                this.addMemberExtensionCandidates(receiverValue, explicitReceiver, callableDescriptorCollector, c, this.createKind(ExplicitReceiverKind.EXTENSION_RECEIVER, isExplicit));
            }
            c.getResult().addCandidates(new Function0<Collection<? extends ResolutionCandidate<D>>>(this, c, explicitReceiver, callableDescriptorCollector, isExplicit){
                final /* synthetic */ TaskPrioritizer this$0;
                final /* synthetic */ TaskPrioritizerContext $c;
                final /* synthetic */ ReceiverWithTypes $explicitReceiver;
                final /* synthetic */ CallableDescriptorCollector $callableDescriptorCollector;
                final /* synthetic */ boolean $isExplicit;

                @NotNull
                public final Collection<ResolutionCandidate<D>> invoke() {
                    JetScope jetScope = this.$c.getScope();
                    ReceiverValue receiverValue = this.$explicitReceiver.getValue();
                    JetScope jetScope2 = this.$c.getScope();
                    Name name = this.$c.getName();
                    Collection<JetType> collection = this.$explicitReceiver.getTypes();
                    LookupLocation lookupLocation = TaskPrioritizer.access$createLookupLocation$1(this.this$0, this.$c);
                    BindingTrace bindingTrace = this.$c.getContext().trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                    Collection<D> collection2 = this.$callableDescriptorCollector.getExtensionsByName(jetScope2, name, collection, lookupLocation, bindingTrace);
                    ExplicitReceiverKind explicitReceiverKind = TaskPrioritizer.access$createKind$2(this.this$0, ExplicitReceiverKind.EXTENSION_RECEIVER, this.$isExplicit);
                    Call call = this.$c.getContext().call;
                    Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
                    return this.this$0.convertWithImpliedThis(jetScope, receiverValue, collection2, explicitReceiverKind, call);
                }
                {
                    this.this$0 = taskPrioritizer;
                    this.$c = taskPrioritizerContext;
                    this.$explicitReceiver = receiverWithTypes;
                    this.$callableDescriptorCollector = callableDescriptorCollector;
                    this.$isExplicit = bl;
                    super(0);
                }
            });
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addMembers(ReceiverWithTypes explicitReceiver, TaskPrioritizerContext<D, F> c, boolean staticMembers, boolean isExplicit) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            c.getResult().addCandidates(new Function0<ArrayList<ResolutionCandidate<D>>>(this, explicitReceiver, staticMembers, callableDescriptorCollector, c, isExplicit){
                final /* synthetic */ TaskPrioritizer this$0;
                final /* synthetic */ ReceiverWithTypes $explicitReceiver;
                final /* synthetic */ boolean $staticMembers;
                final /* synthetic */ CallableDescriptorCollector $callableDescriptorCollector;
                final /* synthetic */ TaskPrioritizerContext $c;
                final /* synthetic */ boolean $isExplicit;

                public final ArrayList<ResolutionCandidate<D>> invoke() {
                    ArrayList<ResolutionCandidate<D>> members = Lists.newArrayList();
                    for (JetType type2 : this.$explicitReceiver.getTypes()) {
                        Collection<D> collection;
                        if (this.$staticMembers) {
                            Name name = this.$c.getName();
                            LookupLocation lookupLocation = TaskPrioritizer.access$createLookupLocation$1(this.this$0, this.$c);
                            BindingTrace bindingTrace = this.$c.getContext().trace;
                            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                            collection = this.$callableDescriptorCollector.getStaticMembersByName(type2, name, lookupLocation, bindingTrace);
                        } else {
                            Name name = this.$c.getName();
                            LookupLocation lookupLocation = TaskPrioritizer.access$createLookupLocation$1(this.this$0, this.$c);
                            BindingTrace bindingTrace = this.$c.getContext().trace;
                            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                            collection = this.$callableDescriptorCollector.getMembersByName(type2, name, lookupLocation, bindingTrace);
                        }
                        Collection<D> membersForThisVariant = collection;
                        ReceiverValue receiverValue = this.$explicitReceiver.getValue();
                        ReceiverValue receiverValue2 = ReceiverValue.NO_RECEIVER;
                        Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "NO_RECEIVER");
                        Collection collection2 = members;
                        Intrinsics.checkExpressionValueIsNotNull(collection2, "members");
                        ExplicitReceiverKind explicitReceiverKind = TaskPrioritizer.access$createKind$2(this.this$0, ExplicitReceiverKind.DISPATCH_RECEIVER, this.$isExplicit);
                        Call call = this.$c.getContext().call;
                        Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
                        TaskPrioritizer.access$convertWithReceivers$3(this.this$0, membersForThisVariant, receiverValue, receiverValue2, collection2, explicitReceiverKind, call);
                    }
                    ArrayList<ResolutionCandidate<D>> arrayList = members;
                    Intrinsics.checkExpressionValueIsNotNull(arrayList, "members");
                    return arrayList;
                }
                {
                    this.this$0 = taskPrioritizer;
                    this.$explicitReceiver = receiverWithTypes;
                    this.$staticMembers = bl;
                    this.$callableDescriptorCollector = callableDescriptorCollector;
                    this.$c = taskPrioritizerContext;
                    this.$isExplicit = bl2;
                    super(0);
                }
            });
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForDynamicReceiver(ReceiverWithTypes explicitReceiver, Collection<? extends ReceiverValue> implicitReceivers, TaskPrioritizerContext<D, F> c, boolean isExplicit) {
        TaskPrioritizerContext<D, F> onlyDynamicReceivers = c.replaceCollectors(DynamicCallsKt.onlyDynamicReceivers(c.getCallableDescriptorCollectors()));
        this.addExtensionCandidates(explicitReceiver, implicitReceivers, onlyDynamicReceivers, isExplicit);
        c.getResult().addCandidates(new Function0<Collection<? extends ResolutionCandidate<D>>>(this, c, explicitReceiver, isExplicit){
            final /* synthetic */ TaskPrioritizer this$0;
            final /* synthetic */ TaskPrioritizerContext $c;
            final /* synthetic */ ReceiverWithTypes $explicitReceiver;
            final /* synthetic */ boolean $isExplicit;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<ResolutionCandidate<D>> invoke() {
                void destination;
                void $receiver;
                Call call = this.$c.getContext().call;
                Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
                JetScopeImpl dynamicScope = DynamicCallableDescriptors.createDynamicDescriptorScope(call, this.$c.getScope().getContainingDeclaration());
                Iterable $receiver2 = this.$c.getCallableDescriptorCollectors();
                Iterable iterable = $receiver2;
                Collection collection = new ArrayList<E>();
                for (T element : $receiver) {
                    CallableDescriptorCollector it2 = (CallableDescriptorCollector)element;
                    JetScope jetScope = dynamicScope;
                    Name name = this.$c.getName();
                    LookupLocation lookupLocation = TaskPrioritizer.access$createLookupLocation$1(this.this$0, this.$c);
                    BindingTrace bindingTrace = this.$c.getContext().trace;
                    Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                    Iterable list = it2.getNonExtensionsByName(jetScope, name, lookupLocation, bindingTrace);
                    KotlinPackage.addAll(destination, list);
                }
                List dynamicDescriptors = (List)destination;
                Collection collection2 = dynamicDescriptors;
                ReceiverValue receiverValue = this.$explicitReceiver.getValue();
                ReceiverValue receiverValue2 = ReceiverValue.NO_RECEIVER;
                Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "NO_RECEIVER");
                ExplicitReceiverKind explicitReceiverKind = TaskPrioritizer.access$createKind$2(this.this$0, ExplicitReceiverKind.DISPATCH_RECEIVER, this.$isExplicit);
                Call call2 = this.$c.getContext().call;
                Intrinsics.checkExpressionValueIsNotNull(call2, "c.context.call");
                return TaskPrioritizer.access$convertWithReceivers$4(this.this$0, collection2, receiverValue, receiverValue2, explicitReceiverKind, call2);
            }
            {
                this.this$0 = taskPrioritizer;
                this.$c = taskPrioritizerContext;
                this.$explicitReceiver = receiverWithTypes;
                this.$isExplicit = bl;
                super(0);
            }
        });
    }

    private final ExplicitReceiverKind createKind(ExplicitReceiverKind kind, boolean isExplicit) {
        if (isExplicit) {
            return kind;
        }
        return ExplicitReceiverKind.NO_EXPLICIT_RECEIVER;
    }

    private final <D extends CallableDescriptor, F extends D> void addMemberExtensionCandidates(ReceiverValue dispatchReceiver, ReceiverWithTypes receiverParameter, CallableDescriptorCollector<D> callableDescriptorCollector, TaskPrioritizerContext<D, F> c, ExplicitReceiverKind receiverKind) {
        c.getResult().addCandidates(new Function0<Collection<? extends ResolutionCandidate<D>>>(this, callableDescriptorCollector, dispatchReceiver, c, receiverParameter, receiverKind){
            final /* synthetic */ TaskPrioritizer this$0;
            final /* synthetic */ CallableDescriptorCollector $callableDescriptorCollector;
            final /* synthetic */ ReceiverValue $dispatchReceiver;
            final /* synthetic */ TaskPrioritizerContext $c;
            final /* synthetic */ ReceiverWithTypes $receiverParameter;
            final /* synthetic */ ExplicitReceiverKind $receiverKind;

            @NotNull
            public final Collection<ResolutionCandidate<D>> invoke() {
                JetScope jetScope = this.$dispatchReceiver.getType().getMemberScope();
                Intrinsics.checkExpressionValueIsNotNull(jetScope, "dispatchReceiver.type.memberScope");
                Name name = this.$c.getName();
                Collection<JetType> collection = this.$receiverParameter.getTypes();
                LookupLocation lookupLocation = TaskPrioritizer.access$createLookupLocation$1(this.this$0, this.$c);
                BindingTrace bindingTrace = this.$c.getContext().trace;
                Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
                Collection<D> memberExtensions = this.$callableDescriptorCollector.getExtensionsByName(jetScope, name, collection, lookupLocation, bindingTrace);
                ReceiverValue receiverValue = this.$receiverParameter.getValue();
                Call call = this.$c.getContext().call;
                Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
                return TaskPrioritizer.access$convertWithReceivers$4(this.this$0, memberExtensions, this.$dispatchReceiver, receiverValue, this.$receiverKind, call);
            }
            {
                this.this$0 = taskPrioritizer;
                this.$callableDescriptorCollector = callableDescriptorCollector;
                this.$dispatchReceiver = receiverValue;
                this.$c = taskPrioritizerContext;
                this.$receiverParameter = receiverWithTypes;
                this.$receiverKind = explicitReceiverKind;
                super(0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor, F extends D> void addCandidatesForNoReceiver(Collection<? extends ReceiverValue> implicitReceivers, TaskPrioritizerContext<D, F> c) {
        void destination;
        void $receiver;
        void $receiver2;
        ArrayList nonlocals;
        Collection<ResolutionCandidate<D>> members;
        ArrayList localsList = Lists.newArrayList();
        ArrayList nonlocalsList = Lists.newArrayList();
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            JetScope jetScope = c.getScope();
            JetScope jetScope2 = c.getScope();
            Name name = c.getName();
            LookupLocation lookupLocation = this.createLookupLocation(c);
            BindingTrace bindingTrace = c.getContext().trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.context.trace");
            Collection<D> collection = callableDescriptorCollector.getNonExtensionsByName(jetScope2, name, lookupLocation, bindingTrace);
            Call call = c.getContext().call;
            Intrinsics.checkExpressionValueIsNotNull(call, "c.context.call");
            members = this.convertWithImpliedThisAndNoReceiver(jetScope, collection, call);
            if (!KotlinPackage.isNotEmpty(members)) continue;
            nonlocals = Lists.newArrayList();
            ArrayList locals = Lists.newArrayList();
            DeclarationDescriptor declarationDescriptor = c.getScope().getContainingDeclaration();
            Collection collection2 = locals;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "locals");
            Collection collection3 = nonlocals;
            Intrinsics.checkExpressionValueIsNotNull(collection3, "nonlocals");
            this.splitLexicallyLocalDescriptors(members, declarationDescriptor, collection2, collection3);
            localsList.add(locals);
            nonlocalsList.add(nonlocals);
        }
        ResolutionTaskHolder<D, F> resolutionTaskHolder = c.getResult();
        List list = localsList;
        Intrinsics.checkExpressionValueIsNotNull(list, "localsList");
        resolutionTaskHolder.addCandidates(list);
        Iterable iterable = implicitReceivers;
        members = $receiver2;
        nonlocals = new ArrayList(KotlinPackage.collectionSizeOrDefault($receiver2, 10));
        for (Object item : $receiver) {
            void it2;
            ReceiverValue receiverValue = (ReceiverValue)item;
            void var12_12 = destination;
            ReceiverWithTypes receiverWithTypes = new ReceiverWithTypes((ReceiverValue)it2, c.getContext());
            var12_12.add(receiverWithTypes);
        }
        List implicitReceiversWithTypes = (List)destination;
        for (ReceiverWithTypes implicitReceiver : implicitReceiversWithTypes) {
            this.addCandidatesForExplicitReceiver(implicitReceiver, implicitReceivers, c, false);
        }
        ResolutionTaskHolder<D, F> resolutionTaskHolder2 = c.getResult();
        List list2 = nonlocalsList;
        Intrinsics.checkExpressionValueIsNotNull(list2, "nonlocalsList");
        resolutionTaskHolder2.addCandidates(list2);
        for (ReceiverWithTypes implicitReceiver : implicitReceiversWithTypes) {
            this.addMembers(implicitReceiver, c, true, false);
        }
    }

    private final KotlinLookupLocation createLookupLocation(TaskPrioritizerContext<?, ?> c) {
        JetElement jetElement = c.getContext().call.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull(jetElement, "c.context.call.callElement");
        return new KotlinLookupLocation(jetElement);
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesForInvoke(ReceiverWithTypes explicitReceiver, TaskPrioritizerContext<D, F> c) {
        List<ReceiverValue> implicitReceivers = JetScopeUtils.getImplicitReceiversHierarchyValues(c.getScope());
        ReceiverValue variableReceiver = c.getContext().call.getDispatchReceiver();
        KotlinPackage.assert(variableReceiver.exists(), "'Invoke' call hasn't got variable receiver");
        if (!explicitReceiver.getValue().exists()) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            ReceiverWithTypes receiverWithTypes = new ReceiverWithTypes(receiverValue, c.getContext());
            Collection collection = implicitReceivers;
            Intrinsics.checkExpressionValueIsNotNull(collection, "implicitReceivers");
            this.addCandidatesForExplicitReceiver(receiverWithTypes, collection, c, true);
        }
        if (explicitReceiver.getValue().exists()) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            this.addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(receiverValue, explicitReceiver, c, ExplicitReceiverKind.BOTH_RECEIVERS);
            return;
        }
        for (ReceiverValue implicitReceiver : implicitReceivers) {
            ReceiverValue receiverValue = variableReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue, "variableReceiver");
            ReceiverValue receiverValue2 = implicitReceiver;
            Intrinsics.checkExpressionValueIsNotNull(receiverValue2, "implicitReceiver");
            this.addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(receiverValue, new ReceiverWithTypes(receiverValue2, c.getContext()), c, ExplicitReceiverKind.DISPATCH_RECEIVER);
        }
    }

    private final <D extends CallableDescriptor, F extends D> void addCandidatesWhenInvokeIsMemberAndExtensionToExplicitReceiver(ReceiverValue dispatchReceiver, ReceiverWithTypes receiverParameter, TaskPrioritizerContext<D, F> c, ExplicitReceiverKind receiverKind) {
        for (CallableDescriptorCollector<D> callableDescriptorCollector : c.getCallableDescriptorCollectors()) {
            this.addMemberExtensionCandidates(dispatchReceiver, receiverParameter, callableDescriptorCollector, c, receiverKind);
        }
    }

    private final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithReceivers(Collection<? extends D> descriptors, ReceiverValue dispatchReceiver, ReceiverValue extensionReceiver2, ExplicitReceiverKind explicitReceiverKind, Call call) {
        ArrayList result2 = Lists.newArrayList();
        Collection collection = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection, "result");
        this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, collection, explicitReceiverKind, call);
        Collection collection2 = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection2, "result");
        return collection2;
    }

    private final <D extends CallableDescriptor> void convertWithReceivers(Collection<? extends D> descriptors, ReceiverValue dispatchReceiver, ReceiverValue extensionReceiver2, Collection<ResolutionCandidate<D>> result2, ExplicitReceiverKind explicitReceiverKind, Call call) {
        for (CallableDescriptor descriptor2 : descriptors) {
            ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(call, descriptor2);
            candidate.setDispatchReceiver(dispatchReceiver);
            candidate.setExtensionReceiver(extensionReceiver2);
            candidate.setExplicitReceiverKind(explicitReceiverKind);
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = candidate;
            Intrinsics.checkExpressionValueIsNotNull(resolutionCandidate, "candidate");
            result2.add(resolutionCandidate);
        }
    }

    @NotNull
    public final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThisAndNoReceiver(@NotNull JetScope scope2, @NotNull Collection<? extends D> descriptors, @NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        Intrinsics.checkParameterIsNotNull(call, "call");
        ReceiverValue receiverValue = ReceiverValue.NO_RECEIVER;
        Intrinsics.checkExpressionValueIsNotNull(receiverValue, "NO_RECEIVER");
        return this.convertWithImpliedThis(scope2, receiverValue, descriptors, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, call);
    }

    @NotNull
    public final <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> convertWithImpliedThis(@NotNull JetScope scope2, @NotNull ReceiverValue receiverParameter, @NotNull Collection<? extends D> descriptors, @NotNull ExplicitReceiverKind receiverKind, @NotNull Call call) {
        Intrinsics.checkParameterIsNotNull(scope2, "scope");
        Intrinsics.checkParameterIsNotNull(receiverParameter, "receiverParameter");
        Intrinsics.checkParameterIsNotNull(descriptors, "descriptors");
        Intrinsics.checkParameterIsNotNull((Object)receiverKind, "receiverKind");
        Intrinsics.checkParameterIsNotNull(call, "call");
        ArrayList<ResolutionCandidate<CallableDescriptor>> result2 = Lists.newArrayList();
        for (CallableDescriptor descriptor2 : descriptors) {
            ResolutionCandidate<CallableDescriptor> candidate = ResolutionCandidate.create(call, descriptor2);
            candidate.setExtensionReceiver(receiverParameter);
            candidate.setExplicitReceiverKind(receiverKind);
            ResolutionCandidate<CallableDescriptor> resolutionCandidate = candidate;
            Intrinsics.checkExpressionValueIsNotNull(resolutionCandidate, "candidate");
            if (!this.setImpliedThis(scope2, resolutionCandidate)) continue;
            result2.add(candidate);
        }
        Collection collection = result2;
        Intrinsics.checkExpressionValueIsNotNull(collection, "result");
        return collection;
    }

    private final <D extends CallableDescriptor> boolean setImpliedThis(JetScope scope2, ResolutionCandidate<D> candidate) {
        ReceiverParameterDescriptor dispatchReceiver = candidate.getDescriptor().getDispatchReceiverParameter();
        if (dispatchReceiver == null) {
            return true;
        }
        List<ReceiverParameterDescriptor> receivers = scope2.getImplicitReceiversHierarchy();
        for (ReceiverParameterDescriptor receiver : receivers) {
            if (!JetTypeChecker.DEFAULT.isSubtypeOf(receiver.getType(), dispatchReceiver.getType())) continue;
            candidate.setDispatchReceiver(dispatchReceiver.getValue());
            return true;
        }
        return false;
    }

    @NotNull
    public final <D extends CallableDescriptor, F extends D> List<ResolutionTask<D, F>> computePrioritizedTasksFromCandidates(@NotNull BasicCallResolutionContext context, @NotNull Collection<? extends ResolutionCandidate<D>> candidates, @NotNull TracingStrategy tracing) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(candidates, "candidates");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        ResolutionTaskHolder result2 = new ResolutionTaskHolder(this.storageManager, context, new PriorityProviderImpl(context), tracing);
        result2.addCandidates(new Function0<Collection<? extends ResolutionCandidate<D>>>(candidates){
            final /* synthetic */ Collection $candidates;

            @NotNull
            public final Collection<ResolutionCandidate<D>> invoke() {
                return this.$candidates;
            }
            {
                this.$candidates = collection;
                super(0);
            }
        });
        return result2.getTasks();
    }

    public TaskPrioritizer(@NotNull StorageManager storageManager, @NotNull SmartCastManager smartCastManager) {
        Intrinsics.checkParameterIsNotNull(storageManager, "storageManager");
        Intrinsics.checkParameterIsNotNull(smartCastManager, "smartCastManager");
        this.storageManager = storageManager;
        this.smartCastManager = smartCastManager;
    }

    @NotNull
    public static final /* synthetic */ SmartCastManager access$getSmartCastManager$0(TaskPrioritizer $this) {
        return $this.smartCastManager;
    }

    @NotNull
    public static final /* synthetic */ KotlinLookupLocation access$createLookupLocation$1(TaskPrioritizer $this, @NotNull TaskPrioritizerContext<?, ?> c) {
        return $this.createLookupLocation(c);
    }

    @NotNull
    public static final /* synthetic */ ExplicitReceiverKind access$createKind$2(TaskPrioritizer $this, @NotNull ExplicitReceiverKind kind, boolean isExplicit) {
        return $this.createKind(kind, isExplicit);
    }

    public static final /* synthetic */ <D extends CallableDescriptor> void access$convertWithReceivers$3(TaskPrioritizer $this, @NotNull Collection<? extends D> descriptors, @NotNull ReceiverValue dispatchReceiver, @NotNull ReceiverValue extensionReceiver2, @NotNull Collection<ResolutionCandidate<D>> result2, @NotNull ExplicitReceiverKind explicitReceiverKind, @NotNull Call call) {
        $this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, result2, explicitReceiverKind, call);
    }

    @NotNull
    public static final /* synthetic */ <D extends CallableDescriptor> Collection<ResolutionCandidate<D>> access$convertWithReceivers$4(TaskPrioritizer $this, @NotNull Collection<? extends D> descriptors, @NotNull ReceiverValue dispatchReceiver, @NotNull ReceiverValue extensionReceiver2, @NotNull ExplicitReceiverKind explicitReceiverKind, @NotNull Call call) {
        return $this.convertWithReceivers(descriptors, dispatchReceiver, extensionReceiver2, explicitReceiverKind, call);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"x\u0004)\t\"+Z2fSZ,'oV5uQRK\b/Z:\u000b\u001fQ\u000b7o\u001b)sS>\u0014\u0018\u000e^5{KJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\u0015\u0019\u0017\r\u001c7t\u0015\u0015!\u0018m]6t\u0015\r\te.\u001f\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000bY\fG.^3\u000b\u001bI+7-Z5wKJ4\u0016\r\\;f\u0015\u0019\u00198m\u001c9fg*I!/Z2fSZ,'o\u001d\u0006\bG>tG/\u001a=u\u0015E\u0011Vm]8mkRLwN\\\"p]R,\u0007\u0010\u001e\u0006\u0006if\u0004Xm\u001d\u0006\u000b\u0007>dG.Z2uS>t'b\u0002&fiRK\b/\u001a\u0006\u000fif\u0004Xm\u001d\u0013eK2,w-\u0019;f\u0015\u0011a\u0015M_=\u000b\u0011\u001d,G\u000fV=qKNTAA[1wC*!Q\u000f^5m\u0015!9W\r\u001e,bYV,g4\u0001\u0006\u0003!\tQA\u0001\u0003\u0001\u0011\u0007)!\u0001\"\u0001\t\u0005\u0015\u0011A!\u0001E\u0003\u000b\t!\u0019\u0001C\u0002\u0006\u0005\u0011\u0011\u0001rA\u0003\u0004\t\u000bA\t\u0001\u0004\u0001\u0006\u0007\u0011\u0019\u0001\u0002\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\t!!A\u0002A\u0003\u0003\t\u0007Aa!\u0002\u0002\u0005\u000b!5Qa\u0001C\u0006\u0011\u0017a\u0001!\u0002\u0002\u0005\u0005!9Qa\u0001C\u0007\u0011\u001fa\u0001!\u0002\u0002\u0005\u0006!\u0005QA\u0001C\u0006\u0011\u0017)!\u0001\"\u0004\t\u0010\u0015\u0019A\u0001\u0002E\t\u0019\u0001)!\u0001B\u0001\t\u0011\u0015\u0019A1\u0003\u0005\n\u0019\u0001)!\u0001\u0002\u0003\t\u0015\u0015\t\u0001bC\u0003\u0003\t-A9\"\u0002\u0002\u0005\u0018!EA!\u0011\u0002\r\be\u0019Q!\u0001E\u00051\u0013ic\u0002B1\u00051\u001d\tS!B\u0001\t\u000f%\tA1\u0001\r\b+\u000e!Qa\u0001\u0003\b\u0013\u0005A\t\"\f\f\u0005G\u0012A\u0002\"\t\u0005\u0006\u0003!I\u0011\u0002B\u0005\u0004\u000b\u0005A!\u0002\u0007\u0006\u0019\u0013\u0011\u001aSk\u0001\u0005\u0006\u0007\u0011M\u0011\"\u0001E\u000b\u001b\r!)\"C\u0001\t\u00195\u0002Ba\u0019\u0003\u0019\u000b\u0005\u001aQ!\u0001\u0005\u00071\u0019)6\u0001C\u0003\u0004\t\u0015I\u0011\u0001\u0003\u0005\u000e\u0007\u0011a\u0011\"\u0001\u0005\tk\u0015*A\u0005Br\u00011\u0013iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001\u0005\u00071\u0019\u00016\u0011AO\n\t\u0001Aq!D\u0003\u0006\u0003!9\u0011\"\u0001C\u00021\u001d\u00016!A\u0011\u0004\u000b\u0005A9\u0001g\u0002R\u0007%!I!C\u0001\u0005\u00015\t\u0001rB\u0007\u0002\u0011!i\u0011\u0001#\u0005"})
    private final class ReceiverWithTypes {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Lazy<? extends List<JetType>> types$delegate;
        @NotNull
        private final ReceiverValue value;
        private final ResolutionContext<?> context;
        private static final /* synthetic */ PropertyMetadata[] $propertyMetadata;

        static {
            $kotlinClass = Reflection.createKotlinClass(ReceiverWithTypes.class);
            $propertyMetadata = new PropertyMetadata[]{new PropertyMetadataImpl("types")};
        }

        @NotNull
        public final Collection<JetType> getTypes() {
            return KotlinPackage.get(this.types$delegate, this, $propertyMetadata[0]);
        }

        @NotNull
        public final ReceiverValue getValue() {
            return this.value;
        }

        public ReceiverWithTypes(@NotNull ReceiverValue value, @NotNull ResolutionContext<?> context) {
            Intrinsics.checkParameterIsNotNull(value, "value");
            Intrinsics.checkParameterIsNotNull(context, "context");
            this.value = value;
            this.context = context;
            this.types$delegate = KotlinPackage.lazy((Function0)new Function0<List<JetType>>(this){
                final /* synthetic */ ReceiverWithTypes this$0;

                @NotNull
                public final List<JetType> invoke() {
                    return TaskPrioritizer.access$getSmartCastManager$0(this.this$0.TaskPrioritizer.this).getSmartCastVariants(this.this$0.getValue(), ReceiverWithTypes.access$getContext$0(this.this$0));
                }
                {
                    this.this$0 = receiverWithTypes;
                    super(0);
                }
            });
        }

        @NotNull
        public static final /* synthetic */ ResolutionContext<?> access$getContext$0(ReceiverWithTypes $this) {
            return $this.context;
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"Q\u0006)!\u0002K]5pe&$\u0018\u0010\u0015:pm&$WM]%na2Tq\u0002V1tWB\u0013\u0018n\u001c:ji&TXM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*9!/Z:pYZ,'\"B2bY2\u001c(\"\u0002;bg.\u001c(\"\u0001#\u000b%\r\u000bG\u000e\\1cY\u0016$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148O\u0003\tQe&|'/\u001b;z!J|g/\u001b3fe*!\"+Z:pYV$\u0018n\u001c8UCN\\\u0007j\u001c7eKJT1CU3t_2,H/[8o\u0007\u0006tG-\u001b3bi\u0016Ta\u0001P5oSRt$bB2p]R,\u0007\u0010\u001e\u0006\u001b\u0005\u0006\u001c\u0018nY\"bY2\u0014Vm]8mkRLwN\\\"p]R,\u0007\u0010\u001e\u0006\u000fO\u0016$X*\u0019=Qe&|'/\u001b;z\u0015\rIe\u000e\u001e\u0006\fO\u0016$\bK]5pe&$\u0018PC\u0005dC:$\u0017\u000eZ1uK*Q\u0002.Y:J[Bd\u0017nY5u\tft\u0017-\\5d%\u0016\u001cW-\u001b<fe*9!i\\8mK\u0006t'\"D5t'ftG\u000f[3tSj,GMC\u0005jgZK7/\u001b2mK\u001a\r!B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0003\t\u0007A1!\u0002\u0002\u0005\u0005!\u001dQa\u0001C\u0003\u0011\u0003a\u0001!B\u0002\u0005\u0007!\u0001A\u0002A\u0003\u0003\t\u0005AQ!B\u0002\u0005\t!%A\u0002A\u0003\u0004\t\u000bAa\u0001\u0004\u0001\u0006\u0007\u0011)\u00012\u0002\u0007\u0001\u000b\r!)\u0001#\u0004\r\u0001\u0015\u0011AA\u0001E\b\u000b\r!i\u0001\u0003\u0005\r\u0001\u0015\u0011AQ\u0002\u0005\t\u000b\u0005A!!B\u0002\u0005\u0011!IA\u0002A\u0003\u0003\t\u000bAi!B\u0002\u0005\u0011!YA\u0002\u0001\u0003\u0002\u0019\u000f)b\u0001\u0002\u0001\t\tU\u0019Q!\u0001E\u00051\u0013Ib\"B\u0001\t\f%Q\u0011\"C\u0003\u0002\u0011\u0019IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011\u0019AZ!\f\u0007\u0005C\u0012Az!I\u0002\u0006\u0003!9\u0001dB+\u0004\t\u0015\u0019AqB\u0005\u0002\u0011\u001fi+\u0002B\u0006\u0019\u0012\u0005\u001aQ!\u0001E\t1#\t6a\u0001C\t\u0013\u0005!)!L\u000e\u0005\u0017aMQ4\u0004\u0003\u0001\u0011)i\u0011\"B\u0001\t\r%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\rA\u001b\u0001!I\u0002\u0006\u0003!E\u0001\u0014C)\u0004\u000b\u0011M\u0011\"\u0001C\u0003\u001b\u0005A\u0011\"L\u000e\u0005\u0007aUQ4\u0004\u0003\u0001\u0011)i\u0011\"B\u0001\t\r%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\rA\u001b\u0001!I\u0002\u0006\u0003!M\u00014C)\u0004\u000b\u0011U\u0011\"\u0001C\u0001\u001b\u0005A\u0011\"L\u000e\u0005\u0003a]Q4\u0004\u0003\u0001\u0011)i\u0011\"B\u0001\t\r%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\rA\u001b\u0001!I\u0002\u0006\u0003!M\u00014C)\u0004\u000b\u0011]\u0011\"\u0001C\u0001\u001b\u0005A\u0011\"\f\u000f\u0005\u0003aaQT\u0004\u0003\u0001\u0011)i!\"B\u0001\t\r%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\r\u0002a1\u0001k\u0001\u0001\"\u0007\u0015\t\u00012\u0003M\n#\u000e)A\u0001D\u0005\u0002\t\u0003i\u0011\u0001C\u00056H\u0015\u0015Ca9\u0001\u0012\r\u0011\u0001\u0001\u0002B\u000b\u0004\u000b\u0005AI\u0001'\u0003\u0019\u000fu=A\u0001\u0001E\b\u001b\r)\u0011\u0001C\u0004\u0019\u000fA\u001b\u0001!I\u0005\u0006\u0003!\u001d\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001a\u001d\u0011kA\u0003\u0005\u000f%\tA\u0001A\u0007\u0002\u0011\u001f\u0001"})
    private static final class PriorityProviderImpl<D extends CallableDescriptor>
    implements ResolutionTaskHolder.PriorityProvider<ResolutionCandidate<D>> {
        public static final /* synthetic */ KClass $kotlinClass;
        private final BasicCallResolutionContext context;

        static {
            $kotlinClass = Reflection.createKotlinClass(PriorityProviderImpl.class);
        }

        @Override
        public int getPriority(@NotNull ResolutionCandidate<D> candidate) {
            Intrinsics.checkParameterIsNotNull(candidate, "candidate");
            return this.hasImplicitDynamicReceiver(candidate) ? 0 : (this.isVisible(candidate) ? 2 : 0) + (this.isSynthesized(candidate) ? 0 : 1);
        }

        @Override
        public int getMaxPriority() {
            return 3;
        }

        private final boolean isVisible(ResolutionCandidate<D> candidate) {
            if (candidate == null) {
                return false;
            }
            D candidateDescriptor = candidate.getDescriptor();
            if (ErrorUtils.isError((DeclarationDescriptor)candidateDescriptor)) {
                return true;
            }
            ReceiverValue receiverValue = ExpressionTypingUtils.normalizeReceiverValueForVisibility(candidate.getDispatchReceiver(), this.context.trace.getBindingContext());
            return Visibilities.isVisible(receiverValue, (DeclarationDescriptorWithVisibility)candidateDescriptor, this.context.scope.getOwnerDescriptor());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSynthesized(ResolutionCandidate<D> candidate) {
            D descriptor2 = candidate.getDescriptor();
            if (!(descriptor2 instanceof CallableMemberDescriptor)) return false;
            CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)descriptor2;
            Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "descriptor");
            if (!CallResolverUtilKt.isOrOverridesSynthesized(callableMemberDescriptor)) return false;
            return true;
        }

        public final boolean hasImplicitDynamicReceiver(@NotNull ResolutionCandidate<D> candidate) {
            Intrinsics.checkParameterIsNotNull(candidate, "candidate");
            return (!candidate.getExplicitReceiverKind().isDispatchReceiver() || !candidate.getCall().getExplicitReceiver().exists()) && DynamicCallsKt.isDynamic((DeclarationDescriptor)candidate.getDescriptor());
        }

        public PriorityProviderImpl(@NotNull BasicCallResolutionContext context) {
            Intrinsics.checkParameterIsNotNull(context, "context");
            this.context = context;
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"(\n)1B+Y:l!JLwN]5uSj,'oQ8oi\u0016DHOC\bUCN\\\u0007K]5pe&$\u0018N_3s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\u0006i\u0006\u001c8n\u001d\u0006\u0002\t*\u00112)\u00197mC\ndW\rR3tGJL\u0007\u000f^8s\u0015-!Wm]2sSB$xN]:\u000b\u0003\u0019S1!\u00118z\u0015\u0019a\u0014N\\5u})!a.Y7f\u0015\u0011q\u0015-\\3\u000b\rI,7/\u001e7u\u0015Q\u0011Vm]8mkRLwN\u001c+bg.Du\u000e\u001c3fe*91m\u001c8uKb$(B\u0007\"bg&\u001c7)\u00197m%\u0016\u001cx\u000e\\;uS>t7i\u001c8uKb$(\"B:d_B,'\u0002\u0003&fiN\u001bw\u000e]3\u000b\rM\u001cw\u000e]3t\u0015q\u0019\u0017\r\u001c7bE2,G)Z:de&\u0004Ho\u001c:D_2dWm\u0019;peNTAdQ1mY\u0006\u0014G.\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\u000e{G\u000e\\3di>\u00148O\u0003\u0006d_2dWm\u0019;peNTqdZ3u\u0007\u0006dG.\u00192mK\u0012+7o\u0019:jaR|'oQ8mY\u0016\u001cGo\u001c:t\u0015)9W\r^\"p]R,\u0007\u0010\u001e\u0006\bO\u0016$h*Y7f\u0015%9W\r\u001e*fgVdGO\u0003\u0005hKR\u001c6m\u001c9f\u0015A1\u0017\u000e\u001c;fe\u000e{G\u000e\\3di>\u00148O\u0003\u0004gS2$XM\u001d\u0006\n\rVt7\r^5p]FRqAQ8pY\u0016\fgN\u0003\u0014UCN\\\u0007K]5pe&$\u0018N_3sIQ\u000b7o\u001b)sS>\u0014\u0018\u000e^5{KJ\u001cuN\u001c;fqRT1A\u001b<n\u0015%1WO\\2uS>t7OC\tsKBd\u0017mY3D_2dWm\u0019;peNTQB\\3x\u0007>dG.Z2u_J\u001c(\u0002\u0004:fa2\f7-Z*d_B,'\u0002\u00038foN\u001bw\u000e]3S\u0004)\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015QA\u0001C\u0002\u0011\r)!\u0001\u0002\u0002\t\b\u0015\u0019AQ\u0001E\u0001\u0019\u0001)1\u0001B\u0002\t\u00011\u0001QA\u0001\u0003\u0002\u0011\u0015)1\u0001\u0002\u0003\t\n1\u0001Q!\u0001\u0005\u0003\u000b\r!Q\u0001\u0003\u0004\r\u0001\u0015\u0011A!\u0001\u0005\b\u000b\r!a\u0001c\u0004\r\u0001\u0015\u0019AQ\u0001E\t\u0019\u0001)!\u0001\u0002\u0002\t\u0013\u0015\u0019Aq\u0002E\n\u0019\u0001)!\u0001b\u0001\t\u0017\u0015\u0019A\u0011\u0003E\u000b\u0019\u0001)!\u0001\"\u0002\t\u001a\u0015\u0019A1\u0003\u0005\r\u0019\u0001)!\u0001\u0002\u0004\t\u0010\u0015\u0011AQ\u0001E\t\u000b\t!y\u0001c\u0005\u0006\u0005\u0011E\u0001RC\u0003\u0003\t'AA\"B\u0002\u0005\u000b!\u0005B\u0002A\u0003\u0004\t\u0015A\u0011\u0003\u0004\u0001\u0006\u0005\u0011\u0015\u00012E\u0003\u0003\t\u0015A!#\u0002\u0002\u0005\u001e!\u0015RA\u0001\u0003\u0010\u0011C!\u0011\u0001d\u0002\u0016\r\u0011\u0001\u0001\u0002B\u000b\u0004\u000b\u0005AI\u0001'\u0003\u0016\u000f\u0011\u0005\u00012B\u000b\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001e\u0019Q!\u0001E\u00061\u0017ic\u0003B2\u00051/\t\u0013\"B\u0001\t\u0015%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\u0015U\u001b\u0001\"B\u0002\u0005\u0018%\t\u0001\u0012D\u0007\u0004\t5I\u0011\u0001#\u0007.!\u0011\u0019G\u0001G\u0005\"\u0007\u0015\t\u0001\u0002\u0003\r\t+\u000eAQa\u0001\u0003\n\u0013\u0005A9\"D\u0002\u0005\u001c%\t\u0001rC\u0017\u0011\t\r$\u0001dB\u0011\u0004\u000b\u0005Ai\u0001'\u0004V\u0007!)1\u0001B\u0004\n\u0003!UQb\u0001\u0003\u000f\u0013\u0005A)\"\f\u000f\u0005G\u0012A\u0002\"I\b\u0006\u0003!9\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\u000fU\u001b\u0001\"B\u0002\u0005\u0011%\t\u0001bC\u0007\u0004\t;I\u0011\u0001C\u0006.!\u0011\u0019G\u0001\u0007\u0006\"\u0007\u0015\t\u0001\"\u0003\r\n+\u000eAQa\u0001\u0003\u000b\u0013\u0005AA\"D\u0002\u0005\u001f%\t\u0001\u0002D\u0017-\t\rAz\"(\n\u0005\u0001!\u0001RBD\u0003\u0002\u00115IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001\u0013\u0011I1!B\u0001\t\u001cam\u0001$\u0004)\u0004\u0001\u0005zQ!\u0001E\u0004\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004A\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0002q\u0005\u0001tA)\u0004\u000b\u0011}\u0011\"\u0001\u0005\u000f\u001b\u0005Ay\"L\u0014\u0005\u0007a\u0019R4\u0004\u0003\u0001\u0011Oi\u0011\"B\u0001\t\u0015%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\u0015A\u001b\u0001!I\b\u0006\u0003!\u001d\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001%)\u0011\u0002B\u0003\u0003\t\u0003A\t\u0001(\u0001\u0019\bE\u001bQ\u0001B\n\n\u0003!qQ\"\u0001E\r[\u0005\"1\u0001\u0007\u000b\u001e\u0010\u0011\u0001\u0001\u0012F\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0001\ts\"B\u0001\t\b%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\n\u000b%!QA\u0001C\u0001\u0011\u0003a\n\u0001g\u0002R\u0007\u0015!A#C\u0001\t\u001d5\t\u0001\u0002D\u001bo\u0002\u0015e\u000f\u0001Br\u0001#\u0019!\u0001\u0001\u0003\u0003\u0016\u0007\u0015\t\u0001\u0012\u0002M\u0005#\u001d!\t\u0001c\u0003\u0016\t\u0015\u0011A\u0011\u0001\u0005\u00019\u0001Aj!h\u0004\u0005\u0001!9QbA\u0003\u0002\u0011\u001bAj\u0001U\u0002\u0001;O!\u0001\u0001\u0003\u0005\u000e\u001f\u0015\t\u0001bB\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002a9\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0005iz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001\u0005\n1%\u000161AO\u000e\t\u0001A9\"D\u0005\u0006\u0003!Q\u0011\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001aQ\u0001k\u0001\u0002\"\u001f\u0015\t\u0001rA\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0011\"B\u0005\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002a\u001d\u0011kA\u0007\u0005\u000e%\tA\u0001A\u0007\u0002\u0011+i\u0011\u0001C\u0006\u000e\u0003!]Q\"\u0001\u0005\r\u001b\u0005AI\u0002"})
    private static final class TaskPrioritizerContext<D extends CallableDescriptor, F extends D> {
        public static final /* synthetic */ KClass $kotlinClass;
        @NotNull
        private final Name name;
        @NotNull
        private final ResolutionTaskHolder<D, F> result;
        @NotNull
        private final BasicCallResolutionContext context;
        @NotNull
        private final JetScope scope;
        @NotNull
        private final CallableDescriptorCollectors<D> callableDescriptorCollectors;

        static {
            $kotlinClass = Reflection.createKotlinClass(TaskPrioritizerContext.class);
        }

        @NotNull
        public final TaskPrioritizerContext<D, F> replaceScope(@NotNull JetScope newScope) {
            Intrinsics.checkParameterIsNotNull(newScope, "newScope");
            return new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, newScope, this.callableDescriptorCollectors);
        }

        @NotNull
        public final TaskPrioritizerContext<D, F> replaceCollectors(@NotNull CallableDescriptorCollectors<D> newCollectors) {
            Intrinsics.checkParameterIsNotNull(newCollectors, "newCollectors");
            return new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, this.scope, newCollectors);
        }

        @NotNull
        public final TaskPrioritizerContext<D, F> filterCollectors(@NotNull Function1<? super D, ? extends Boolean> filter) {
            Intrinsics.checkParameterIsNotNull(filter, "filter");
            return new TaskPrioritizerContext<D, F>(this.name, this.result, this.context, this.scope, CallableDescriptorCollectorsKt.filtered(this.callableDescriptorCollectors, filter));
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @NotNull
        public final ResolutionTaskHolder<D, F> getResult() {
            return this.result;
        }

        @NotNull
        public final BasicCallResolutionContext getContext() {
            return this.context;
        }

        @NotNull
        public final JetScope getScope() {
            return this.scope;
        }

        @NotNull
        public final CallableDescriptorCollectors<D> getCallableDescriptorCollectors() {
            return this.callableDescriptorCollectors;
        }

        public TaskPrioritizerContext(@NotNull Name name, @NotNull ResolutionTaskHolder<D, F> result2, @NotNull BasicCallResolutionContext context, @NotNull JetScope scope2, @NotNull CallableDescriptorCollectors<D> callableDescriptorCollectors) {
            Intrinsics.checkParameterIsNotNull(name, "name");
            Intrinsics.checkParameterIsNotNull(result2, "result");
            Intrinsics.checkParameterIsNotNull(context, "context");
            Intrinsics.checkParameterIsNotNull(scope2, "scope");
            Intrinsics.checkParameterIsNotNull(callableDescriptorCollectors, "callableDescriptorCollectors");
            this.name = name;
            this.result = result2;
            this.context = context;
            this.scope = scope2;
            this.callableDescriptorCollectors = callableDescriptorCollectors;
        }
    }
}

