/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.io.InputStream;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializedResourcePaths;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataProvider;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;

@KotlinClass(version={0, 25, 0}, abiVersion=25, kind=KotlinClass.Kind.CLASS, data={"e\u0006)q\"+Z:pkJ\u001cW\rT8bI&twm\u00117bgN$\u0015\r^1GS:$WM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*i1/\u001a:jC2L'0\u0019;j_:Tq\u0002Z3tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0010\u00072\f7o\u001d#bi\u00064\u0015N\u001c3fe*1A(\u001b8jizRq\u0003]1dW\u0006<WM\u0012:bO6,g\u000e\u001e)s_ZLG-\u001a:\u000b/A\u000b7m[1hK\u001a\u0013\u0018mZ7f]R\u0004&o\u001c<jI\u0016\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTqc]3sS\u0006d\u0017N_3e%\u0016\u001cx.\u001e:dKB\u000bG\u000f[:\u000b/M+'/[1mSj,GMU3t_V\u00148-\u001a)bi\"\u001c(\u0002\u00047pC\u0012\u0014Vm]8ve\u000e,'\"\u0003$v]\u000e$\u0018n\u001c82\u0015\u0019\u0019FO]5oO*Y\u0011J\u001c9viN#(/Z1n\u0015\u0011Q\u0017M^1\u000b\u0005%|'b\u00016w[*Ia-\u001e8di&|gn\u001d\u0006\u000eM&tGm\u00117bgN$\u0015\r^1\u000b\u000f\rd\u0017m]:JI*91\t\\1tg&#'\u0002\u00028b[\u0016T\u0011c\u00117bgN$\u0015\r^1Qe>4\u0018\u000eZ3sQ\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0002\u0005\u0005!\u0019A\u0002A\u0003\u0003\t\u0005AQ!B\u0002\u0005\b!%A\u0002A\u0003\u0004\t\u0007Aa\u0001\u0004\u0001\u0006\u0003!\rQa\u0001\u0003\u0006\u0011\u001da\u0001!B\u0002\u0005\u000b!=A\u0002A\u0003\u0002\u0011#)!\u0001\"\u0004\t\u0013\u0015\u0019Aa\u0002\u0005\t\u0019\u0001)!\u0001b\u0002\t\n\u0015\u0011A1\u0001\u0005\u0007\u000b\t!Q\u0001c\u0005\u0006\u0005\u0011I\u0001BC\u0003\u0003\t'Aq!\u0002\u0002\u0005\u0003!aQa\u0001C\u000b\u0011/a\u0001!B\u0002\u0005\u0005!eA\u0002A\u0003\u0003\t\tAI\"\u0002\u0002\u0005\u0016!]Aa\u0003G\u00033\r)\u0011\u0001C\u0002\u0019\u00075:B!\u0019\u0003\u0019\u000e\u0005rQ!\u0001E\u0006\u0013\u0011I1!B\u0001\t\ra1\u0011\"B\u0005\u0005\u000b\u0005Ay\u0001$\u0001\u0019\u0010a-Qk\u0001\u0003\u0006\u0007\u00115\u0011\"\u0001\u0005\u000b[1!\u0011\r\u0002\r\u0005C\r)\u0011\u0001\u0003\u0003\u0019\tU\u001bA!B\u0002\u0005\t%\t\u0001\u0002C\u0017\r\t\u0005$\u00014B\u0011\u0004\u000b\u0005AI\u0001'\u0003V\u0007\u0011)1\u0001b\u0003\n\u0003!EQF\u0006\u0003\f1+iz\u0001\u0002\u0001\t\u00175\u0019Q!\u0001\u0005\f1-\u00016\u0001A\u0011\u0005\u000b\u0005A9\u0002$\u0001\u0019\u0018E\u001bQ\u0001\"\u0006\n\u0003!aQ\"\u0001E\rk[*Y\u0007Br\u00011\u000fiz\u0001\u0002\u0001\t\t5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001AO\b\t\u0001AY!D\u0002\u0006\u0003!%\u0001\u0014\u0002)\u0004\u0002u\u0015B\u0001\u0001E\u0007\u001b9)\u0011\u0001c\u0003\n\t%\u0019Q!\u0001\u0005\u00071\u0019IQ!\u0003\u0003\u0006\u0003!=A\u0012\u0001M\b1\u0017\u00016!A\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007%!9!C\u0001\u0005\u00015\t\u0001\u0002C\u0007\u0002\u0011#i\u0011\u0001\u0003\u0006"})
public class ResourceLoadingClassDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final PackageFragmentProvider packageFragmentProvider;
    private final SerializedResourcePaths serializedResourcePaths;
    private final Function1<? super String, ? extends InputStream> loadResource;

    static {
        $kotlinClass = Reflection.createKotlinClass(ResourceLoadingClassDataFinder.class);
    }

    @Override
    @Nullable
    public ClassDataProvider findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.getPackageFqName()");
        PackageFragmentDescriptor packageFragmentDescriptor = KotlinPackage.singleOrNull(this.packageFragmentProvider.getPackageFragments(fqName2));
        if (!(packageFragmentDescriptor instanceof DeserializedPackageFragment)) {
            packageFragmentDescriptor = null;
        }
        DeserializedPackageFragment deserializedPackageFragment = (DeserializedPackageFragment)packageFragmentDescriptor;
        if (deserializedPackageFragment == null) {
            return null;
        }
        DeserializedPackageFragment packageFragment = deserializedPackageFragment;
        InputStream inputStream = this.loadResource.invoke(this.serializedResourcePaths.getClassMetadataPath(classId));
        if (inputStream == null) {
            return null;
        }
        InputStream stream = inputStream;
        ClassData classData = new ClassData(packageFragment.getNameResolver(), ProtoBuf.Class.parseFrom(stream, this.serializedResourcePaths.getExtensionRegistry()));
        return new ClassDataProvider(classData, null, 2, null);
    }

    public ResourceLoadingClassDataFinder(@NotNull PackageFragmentProvider packageFragmentProvider, @NotNull SerializedResourcePaths serializedResourcePaths, @NotNull Function1<? super String, ? extends InputStream> loadResource) {
        Intrinsics.checkParameterIsNotNull(packageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkParameterIsNotNull(serializedResourcePaths, "serializedResourcePaths");
        Intrinsics.checkParameterIsNotNull(loadResource, "loadResource");
        this.packageFragmentProvider = packageFragmentProvider;
        this.serializedResourcePaths = serializedResourcePaths;
        this.loadResource = loadResource;
    }
}

