/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.CharBuffer;

class NativeString
implements CharSequence,
Comparable {
    private Pointer pointer;
    private String encoding;

    public NativeString(String string, boolean wide) {
        this(string, wide ? "--WIDE-STRING--" : Native.getDefaultStringEncoding());
    }

    public NativeString(String string, String encoding) {
        if (string == null) {
            throw new NullPointerException("String must not be null");
        }
        this.encoding = encoding;
        if (this.encoding == "--WIDE-STRING--") {
            int len = (string.length() + 1) * Native.WCHAR_SIZE;
            this.pointer = new Memory(len);
            this.pointer.setWideString(0L, string);
        } else {
            byte[] data2 = Native.getBytes(string, encoding);
            this.pointer = new Memory(data2.length + 1);
            this.pointer.write(0L, data2, 0, data2.length);
            this.pointer.setByte(data2.length, (byte)0);
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof CharSequence) {
            return this.compareTo(other) == 0;
        }
        return false;
    }

    @Override
    public String toString() {
        boolean wide = this.encoding == "--WIDE-STRING--";
        String s = wide ? "const wchar_t*" : "const char*";
        s = s + "(" + (wide ? this.pointer.getWideString(0L) : this.pointer.getString(0L, this.encoding)) + ")";
        return s;
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    @Override
    public char charAt(int index2) {
        return this.toString().charAt(index2);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return CharBuffer.wrap(this.toString()).subSequence(start, end);
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        return this.toString().compareTo(other.toString());
    }
}

