/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.IndexedValue;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.Deserialization;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedType;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FlexibleTypeCapabilitiesDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.LocalClassResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeConstructorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeConstructorKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializerKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionBase;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    public static final /* synthetic */ KClass $kotlinClass;
    private final Function1<? super Integer, ? extends ClassDescriptor> classDescriptors;
    private final NotNullLazyValue<Map<Integer, ? extends TypeParameterDescriptor>> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final List<? extends ProtoBuf.TypeParameter> typeParameterProtos;
    private final String debugName;

    static {
        $kotlinClass = Reflection.createKotlinClass(TypeDeserializer.class);
    }

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.toReadOnlyList(((Map)this.typeParameterDescriptors.invoke()).values());
    }

    @NotNull
    public final JetType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(additionalAnnotations, "additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            FlexibleTypeCapabilitiesDeserializer flexibleTypeCapabilitiesDeserializer = this.c.getComponents().getFlexibleTypeCapabilitiesDeserializer();
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull(string, "id");
            FlexibleTypeCapabilities capabilities = flexibleTypeCapabilitiesDeserializer.capabilitiesById(string);
            if (capabilities == null) {
                JetType jetType = ErrorUtils.createErrorType(new DeserializedType(this.c, proto, null, 4, null) + ": Capabilities not found for id " + id);
                Intrinsics.checkExpressionValueIsNotNull(jetType, "ErrorUtils.createErrorTy\u2026es not found for id $id\")");
                return jetType;
            }
            JetType jetType = new DeserializedType(this.c, proto, null, 4, null);
            ProtoBuf.Type type2 = proto.getFlexibleUpperBound();
            Intrinsics.checkExpressionValueIsNotNull(type2, "proto.getFlexibleUpperBound()");
            return DelegatingFlexibleType.Companion.create(jetType, new DeserializedType(this.c, type2, null, 4, null), capabilities);
        }
        return new DeserializedType(this.c, proto, additionalAnnotations);
    }

    @NotNull
    public static /* synthetic */ JetType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n) {
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type2, annotations2);
    }

    @NotNull
    public final TypeConstructor typeConstructor(@NotNull ProtoBuf.Type proto) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        TypeConstructorData typeConstructorData = TypeDeserializerKt.getTypeConstructorData(proto);
        int id = typeConstructorData.getId();
        TypeConstructor typeConstructor2 = this.typeConstructor(typeConstructorData);
        if (typeConstructor2 == null) {
            TypeConstructor typeConstructor3 = ErrorUtils.createErrorType(Intrinsics.areEqual((Object)typeConstructorData.getKind(), (Object)TypeConstructorKind.CLASS) ? this.c.getNameResolver().getClassId(id).asSingleFqName().asString() : "Unknown type parameter " + id).getConstructor();
            typeConstructor2 = typeConstructor3;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "ErrorUtils.createErrorTy\u2026id\"\n        ).constructor");
        }
        return typeConstructor2;
    }

    private final TypeConstructor typeConstructor(TypeConstructorData data2) {
        TypeConstructor typeConstructor2;
        switch (TypeDeserializer$WhenMappings.$EnumSwitchMapping$0[data2.getKind().ordinal()]) {
            case 1: {
                ClassDescriptor classDescriptor = this.classDescriptors.invoke((Integer)data2.getId());
                if (classDescriptor != null) {
                    typeConstructor2 = classDescriptor.getTypeConstructor();
                    break;
                }
                typeConstructor2 = null;
                break;
            }
            case 2: {
                typeConstructor2 = this.typeParameterTypeConstructor(data2.getId());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return typeConstructor2;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Annotated annotated = (TypeParameterDescriptor)((Map)this.typeParameterDescriptors.invoke()).get(typeParameterId);
        if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            annotated = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return annotated;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassResolver localClassResolver = this.c.getComponents().getLocalClassResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull(classId, "id");
            return localClassResolver.resolveLocalClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull(classId, "id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    @NotNull
    public final TypeProjection typeArgument(@Nullable TypeParameterDescriptor parameter, @NotNull ProtoBuf.Type.Argument typeArgumentProto) {
        TypeProjectionBase typeProjectionBase;
        Intrinsics.checkParameterIsNotNull(typeArgumentProto, "typeArgumentProto");
        if (Intrinsics.areEqual(typeArgumentProto.getProjection(), ProtoBuf.Type.Argument.Projection.STAR)) {
            if (parameter == null) {
                JetType jetType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(jetType, "c.components.moduleDescr\u2026tIns.getNullableAnyType()");
                typeProjectionBase = new TypeBasedStarProjectionImpl(jetType);
            } else {
                typeProjectionBase = new StarProjectionImpl(parameter);
            }
        } else {
            ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
            Intrinsics.checkExpressionValueIsNotNull(projection, "typeArgumentProto.getProjection()");
            Variance variance = Deserialization.variance(projection);
            ProtoBuf.Type type2 = typeArgumentProto.getType();
            Intrinsics.checkExpressionValueIsNotNull(type2, "typeArgumentProto.getType()");
            typeProjectionBase = new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type2, null, 2));
        }
        return typeProjectionBase;
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<? extends ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        this.c = c;
        this.parent = parent;
        this.typeParameterProtos = typeParameterProtos;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor$0(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeParameterDescriptors = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<Integer, ? extends TypeParameterDescriptor>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @NotNull
            public final Map<Integer, TypeParameterDescriptor> invoke() {
                Map map2;
                if (TypeDeserializer.access$getTypeParameterProtos$1(this.this$0).isEmpty()) {
                    map2 = MapsKt.mapOf();
                } else {
                    LinkedHashMap<K, V> result2 = new LinkedHashMap<K, V>();
                    for (IndexedValue<T> indexedValue : CollectionsKt.withIndex((Iterable)TypeDeserializer.access$getTypeParameterProtos$1(this.this$0))) {
                        int index2 = indexedValue.component1();
                        ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                        MapsKt.set(result2, proto.getId(), new DeserializedTypeParameterDescriptor(TypeDeserializer.access$getC$2(this.this$0), proto, index2));
                    }
                    map2 = result2;
                }
                return map2;
            }
            {
                this.this$0 = typeDeserializer;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor$0(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @NotNull
    public static final /* synthetic */ List<ProtoBuf.TypeParameter> access$getTypeParameterProtos$1(TypeDeserializer $this) {
        return $this.typeParameterProtos;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$2(TypeDeserializer $this) {
        return $this.c;
    }
}

