/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.load.kotlin.DeserializationComponentsForJava;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.ChainedScope;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.PackageData;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.ErrorReporter;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

public final class DeserializedDescriptorResolver {
    private final ErrorReporter errorReporter;
    private DeserializationComponents components;
    public static final Set<KotlinClassHeader.Kind> KOTLIN_CLASS = KotlinPackage.setOf(KotlinClassHeader.Kind.CLASS);
    public static final Set<KotlinClassHeader.Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = KotlinPackage.setOf(KotlinClassHeader.Kind.FILE_FACADE, KotlinClassHeader.Kind.MULTIFILE_CLASS_PART);
    public static final Set<KotlinClassHeader.Kind> KOTLIN_PACKAGE_FACADE = KotlinPackage.setOf(KotlinClassHeader.Kind.PACKAGE_FACADE);

    public DeserializedDescriptorResolver(@NotNull ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorReporter", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "<init>"));
        }
        this.errorReporter = errorReporter;
    }

    @Inject
    public void setComponents(@NotNull DeserializationComponentsForJava context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "setComponents"));
        }
        this.components = context.getComponents();
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "resolveClass"));
        }
        String[] data2 = this.readData(kotlinClass, KOTLIN_CLASS);
        if (data2 != null) {
            ClassData classData = JvmProtoBufUtil.readClassDataFrom(data2);
            KotlinJvmBinarySourceElement sourceElement = new KotlinJvmBinarySourceElement(kotlinClass);
            return this.components.getClassDeserializer().deserializeClass(kotlinClass.getClassId(), new ClassDataWithSource(classData, sourceElement));
        }
        return null;
    }

    @Nullable
    public JetScope createKotlinPackagePartScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull KotlinJvmBinaryClass kotlinClass) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackagePartScope"));
        }
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackagePartScope"));
        }
        String[] data2 = this.readData(kotlinClass, KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART);
        if (data2 != null) {
            PackageData packageData = JvmProtoBufUtil.readPackageDataFrom(data2);
            return new DeserializedPackageMemberScope(descriptor2, packageData.getPackageProto(), packageData.getNameResolver(), this.components, (Function0<? extends Collection<? extends Name>>)new Function0<Collection<Name>>(){

                @Override
                public Collection<Name> invoke() {
                    return Collections.emptyList();
                }
            });
        }
        return null;
    }

    @NotNull
    public JetScope createKotlinPackageScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull List<KotlinJvmBinaryClass> packageParts) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        if (packageParts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageParts", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        ArrayList<JetScope> list = new ArrayList<JetScope>();
        for (KotlinJvmBinaryClass callable : packageParts) {
            JetScope scope2 = this.createKotlinPackagePartScope(descriptor2, callable);
            if (scope2 == null) continue;
            list.add(scope2);
        }
        if (list.isEmpty()) {
            JetScope.Empty empty = JetScope.Empty.INSTANCE$;
            if (empty == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
            }
            return empty;
        }
        ChainedScope chainedScope = new ChainedScope(descriptor2, "Member scope for union of package parts data", list.toArray(new JetScope[list.size()]));
        if (chainedScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "createKotlinPackageScope"));
        }
        return chainedScope;
    }

    @Nullable
    public String[] readData(@NotNull KotlinJvmBinaryClass kotlinClass, @NotNull Set<KotlinClassHeader.Kind> expectedKinds) {
        if (kotlinClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinClass", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        if (expectedKinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedKinds", "org/jetbrains/kotlin/load/kotlin/DeserializedDescriptorResolver", "readData"));
        }
        KotlinClassHeader header = kotlinClass.getClassHeader();
        if (!header.getIsCompatibleAbiVersion()) {
            this.errorReporter.reportIncompatibleAbiVersion(kotlinClass.getClassId(), kotlinClass.getLocation(), header.getVersion());
        } else if (expectedKinds.contains((Object)header.getKind())) {
            return header.getAnnotationData();
        }
        return null;
    }
}

