/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.impl.com.google.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.serialization.SerializedResourcePaths;
import kotlin.reflect.jvm.internal.impl.serialization.builtins.BuiltInsProtoBuf;
import org.jetbrains.annotations.NotNull;

public final class BuiltInsSerializedResourcePaths
extends SerializedResourcePaths {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final ExtensionRegistryLite extensionRegistry;
    private static final String CLASS_METADATA_FILE_EXTENSION = "kotlin_class";
    private static final String PACKAGE_FILE_EXTENSION = "kotlin_package";
    private static final String STRING_TABLE_FILE_EXTENSION = "kotlin_string_table";
    public static final BuiltInsSerializedResourcePaths INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(BuiltInsSerializedResourcePaths.class);
        new BuiltInsSerializedResourcePaths();
    }

    @Override
    @NotNull
    public ExtensionRegistryLite getExtensionRegistry() {
        return extensionRegistry;
    }

    @Override
    @NotNull
    public String getClassMetadataPath(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        StringBuilder stringBuilder = new StringBuilder();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "classId.getPackageFqName()");
        return stringBuilder.append(this.packageFqNameToPath(fqName2)).append("/").append(classId.getRelativeClassName().asString()).append(".").append(CLASS_METADATA_FILE_EXTENSION).toString();
    }

    @Override
    @NotNull
    public String getPackageFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + PACKAGE_FILE_EXTENSION;
    }

    @Override
    @NotNull
    public String getStringTableFilePath(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        return this.packageFqNameToPath(fqName2) + "/" + this.shortName(fqName2) + "." + STRING_TABLE_FILE_EXTENSION;
    }

    private final String packageFqNameToPath(FqName fqName2) {
        return StringsKt.replace$default(fqName2.asString(), '.', '/', false, 4);
    }

    private final String shortName(FqName fqName2) {
        String string;
        if (fqName2.isRoot()) {
            string = "default-package";
        } else {
            String string2 = fqName2.shortName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "fqName.shortName().asString()");
        }
        return string;
    }

    BuiltInsSerializedResourcePaths() {
        INSTANCE$ = this;
        ExtensionRegistryLite extensionRegistryLite = ExtensionRegistryLite.newInstance();
        Intrinsics.checkExpressionValueIsNotNull(extensionRegistryLite, "ExtensionRegistryLite.newInstance()");
        extensionRegistry = extensionRegistryLite;
        BuiltInsProtoBuf.registerAllExtensions(this.getExtensionRegistry());
        CLASS_METADATA_FILE_EXTENSION = CLASS_METADATA_FILE_EXTENSION;
        PACKAGE_FILE_EXTENSION = PACKAGE_FILE_EXTENSION;
        STRING_TABLE_FILE_EXTENSION = STRING_TABLE_FILE_EXTENSION;
    }
}

