/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.checker;

import java.util.ArrayDeque;
import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.types.JetType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SubtypePathNode;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedureCallbacks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UtilsKt {
    @Nullable
    public static final JetType findCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkParameterIsNotNull(subtype, "subtype");
        Intrinsics.checkParameterIsNotNull(supertype, "supertype");
        Intrinsics.checkParameterIsNotNull(typeCheckingProcedureCallbacks, "typeCheckingProcedureCallbacks");
        ArrayDeque<SubtypePathNode> queue = new ArrayDeque<SubtypePathNode>();
        queue.add(new SubtypePathNode(subtype, null));
        TypeConstructor supertypeConstructor = supertype.getConstructor();
        while (!queue.isEmpty()) {
            SubtypePathNode lastPathNode = (SubtypePathNode)queue.poll();
            JetType currentSubtype = lastPathNode.getType();
            TypeConstructor constructor = currentSubtype.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(constructor, supertypeConstructor)) {
                JetType substituted = currentSubtype;
                boolean isAnyMarkedNullable = currentSubtype.isMarkedNullable();
                for (SubtypePathNode currentPathNode = lastPathNode.getPrevious(); currentPathNode != null; currentPathNode = currentPathNode.getPrevious()) {
                    Intrinsics.checkExpressionValueIsNotNull(TypeSubstitutor.create(currentPathNode.getType()).safeSubstitute(substituted, Variance.INVARIANT), "TypeSubstitutor.create(c\u2026uted, Variance.INVARIANT)");
                    isAnyMarkedNullable = isAnyMarkedNullable || currentPathNode.getType().isMarkedNullable();
                }
                return TypeUtils.makeNullableAsSpecified(substituted, isAnyMarkedNullable);
            }
            Iterator<JetType> iterator2 = constructor.getSupertypes().iterator();
            while (iterator2.hasNext()) {
                JetType immediateSupertype;
                JetType jetType = immediateSupertype = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(jetType, "immediateSupertype");
                queue.add(new SubtypePathNode(jetType, lastPathNode));
            }
        }
        return null;
    }
}

