/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocElementImpl;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"2\u0006)91\nR8d)\u0006<'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\t-$wn\u0019\u0006\u0004aNL'\u0002B5na2Tqb\u0013#pG\u0016cW-\\3oi&k\u0007\u000f\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\t9|G-\u001a\u0006\b\u0003N#fj\u001c3f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*!A.\u00198h\u0015!Ygn\\<o)\u0006<'\u0002D&E_\u000e\\en\\<o)\u0006<'B\u00029beN,'OC\u0006hKR\\en\\<o)\u0006<'\u0002F2iS2$'/\u001a8BMR,'\u000fV1h\u001d\u0006lWM\u0003\u0003MSN$(\u0002\u00026bm\u0006TA!\u001e;jY*Qq-\u001a;D_:$XM\u001c;\u000b\rM#(/\u001b8h\u0015\u001d9W\r\u001e(b[\u0016TabZ3u'V\u0014'.Z2u\u0019&t7N\u0003\u0005L\t>\u001cG*\u001b8l\u001599W\r^*vE*,7\r\u001e(b[\u0016T!\u0002[1t'V\u0014'.Z2u\u0015=\u0019wN\u001c;f]R\u001c\u0005.\u001b7ee\u0016t'b\u0002\"p_2,\u0017M\u001cV\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0011AA\u0001\u0005\u0004\u000b\r!)\u0001\u0003\u0001\r\u0001\u0015\u0019AQ\u0001E\u0004\u0019\u0001)\u0011\u0001c\u0003\u0006\u0005\u0011!\u0001BB\u0003\u0003\t\u0013Ai!B\u0002\u0005\u000b!)A\u0002A\u0003\u0003\t\u0015AQ!\u0002\u0002\u0005\u0004!AQa\u0001C\u0007\u0011\u001fa\u0001!\u0002\u0002\u0005\u000e!=Q!\u0001E\u0002\u000b\r!\u0001\u0002c\u0005\r\u0001\u0015\t\u0001BC\u0003\u0003\t%A)\"\u0002\u0002\u0005\u0014!MQa\u0001\u0003\t\u0011/a\u0001!\u0002\u0002\u0005\u0013!5QA\u0001\u0003\f\u0011/)1\u0001\"\u0002\t\u001b1\u0001QA\u0001C\u0003\u00115)1\u0001\u0002\u0005\t\u001f1\u0001Aa\u0003\u0007\u00043\r)\u0011\u0001c\u0002\u0019\b5rAa\u0019\u0003\u0019\u000f\u0005\"Q!\u0001\u0005\b\u0019\u0003Ar\u0001J\u0012V\u0007\u0011i1\u0001\"\u0005\n\u0003!=Qv\u0004\u0003\u00021%\t\u0003\"B\u0001\t\u0012%!\u0011bA\u0003\u0002\u0011\u0017AZ\u0001'\u0005R\u0007\r!\u0011\"C\u0001\t\u00155VAa\u0003\r\fC\r)\u0011\u0001#\u0006\u0019\u0016E\u001b1\u0001B\u0006\n\u0003!]Qv\u0003\u0003\f11\tC!B\u0001\t\u00161\u0005\u0001TC)\u0004\u0007\u0011a\u0011\"\u0001E\f[/!1\u0001'\u0007\"\t\u0015\t\u0001\u0002\u0004G\u000111\t6a\u0001C\r\u0013\u0005AI\"l\u0006\u0005\u0017am\u0011\u0005B\u0003\u0002\u0011+a\t\u0001'\u0006R\u0007\r!Y\"C\u0001\t\u00185RB!\u0001\r\u000f;3!\u0001\u0001#\b\u000e\u0011\u0015\t\u0001\u0012C\u0005\u0005\u0013\r)\u0011\u0001c\u0003\u0019\faE\u0001k\u0001\u0001\"\u0007\u0015\t\u0001\"\u0004\r\u000e#\u000e)AAD\u0005\u0002\t\u0003i\u0011\u0001\u0003\u00066.\u0015-Ba9\u0001\u0019\tu=A\u0001\u0001E\u0005\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0001!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u000b\u0011!\u0011\"\u0001\u0003\u0001\u001b\u0005Aa\u0001"})
public class KDocTag
extends KDocElementImpl {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KDocTag.class);
    }

    @Override
    @Nullable
    public String getName() {
        Object tagName = this.findChildByType(KDocTokens.TAG_NAME);
        if (tagName != null) {
            return StringsKt.substring(tagName.getText(), 1);
        }
        return null;
    }

    @Nullable
    public String getSubjectName() {
        KDocLink kDocLink = this.getSubjectLink();
        return kDocLink != null ? kDocLink.getLinkText() : null;
    }

    @Nullable
    public final KDocLink getSubjectLink() {
        List<ASTNode> children = this.childrenAfterTagName();
        if (this.hasSubject(children)) {
            ASTNode aSTNode = CollectionsKt.firstOrNull(children);
            PsiElement psiElement = aSTNode != null ? aSTNode.getPsi() : null;
            if (!(psiElement instanceof KDocLink)) {
                psiElement = null;
            }
            return (KDocLink)psiElement;
        }
        return null;
    }

    @Nullable
    public final KDocKnownTag getKnownTag() {
        return this.getName() != null ? KDocKnownTag.findByTagName(this.getName()) : (KDocKnownTag)null;
    }

    private final boolean hasSubject(List<? extends ASTNode> contentChildren) {
        KDocKnownTag kDocKnownTag = this.getKnownTag();
        if (kDocKnownTag != null ? kDocKnownTag.isReferenceRequired() : false) {
            ASTNode aSTNode = CollectionsKt.firstOrNull(contentChildren);
            return Intrinsics.areEqual(aSTNode != null ? aSTNode.getElementType() : null, KDocTokens.MARKDOWN_LINK);
        }
        return false;
    }

    private final List<ASTNode> childrenAfterTagName() {
        ASTNode it2;
        Object item;
        Object $receiver = this.getNode().getChildren(null);
        boolean yielding = false;
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < ((Object[])$receiver).length; ++i) {
            item = $receiver[i];
            if (yielding) {
                list.add(item);
                continue;
            }
            it2 = (ASTNode)item;
            if (Intrinsics.areEqual(it2.getElementType(), KDocTokens.TAG_NAME)) continue;
            list.add(item);
            yielding = true;
        }
        $receiver = list;
        yielding = false;
        list = new ArrayList();
        Iterator iterator2 = $receiver.iterator();
        while (iterator2.hasNext()) {
            item = iterator2.next();
            if (yielding) {
                list.add(item);
                continue;
            }
            it2 = (ASTNode)item;
            if (Intrinsics.areEqual(it2.getElementType(), TokenType.WHITE_SPACE)) continue;
            list.add(item);
            yielding = true;
        }
        return list;
    }

    @NotNull
    public String getContent() {
        StringBuilder builder = new StringBuilder();
        boolean contentStarted = false;
        boolean afterAsterisk = false;
        List<ASTNode> children = this.childrenAfterTagName();
        if (this.hasSubject(children)) {
            children = CollectionsKt.drop((Iterable)children, 1);
        }
        for (ASTNode node : children) {
            IElementType type2 = node.getElementType();
            if (KDocTokens.CONTENT_TOKENS.contains(type2)) {
                String string;
                if (!contentStarted || afterAsterisk) {
                    string = StringsKt.trimStart(node.getText());
                } else {
                    String string2 = node.getText();
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "node.text");
                }
                builder.append(string);
                contentStarted = true;
                afterAsterisk = false;
            }
            if (Intrinsics.areEqual(type2, KDocTokens.LEADING_ASTERISK)) {
                afterAsterisk = true;
            }
            if (Intrinsics.areEqual(type2, TokenType.WHITE_SPACE) && contentStarted) {
                builder.append(StringsKt.repeat("\n", StringUtil.countNewLines(node.getText())));
            }
            if (!Intrinsics.areEqual(type2, KDocElementTypes.KDOC_TAG)) continue;
            break;
        }
        return StringsKt.trimEnd(builder.toString(), ' ', '\t');
    }

    public KDocTag(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        super(node);
    }
}

