/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preprocessor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.idea.JetFileType;
import org.jetbrains.kotlin.preprocessor.CollectModificationsVisitor;
import org.jetbrains.kotlin.preprocessor.Conditional;
import org.jetbrains.kotlin.preprocessor.ConditionalKt;
import org.jetbrains.kotlin.preprocessor.Evaluator;
import org.jetbrains.kotlin.preprocessor.Logger;
import org.jetbrains.kotlin.preprocessor.Modification;
import org.jetbrains.kotlin.preprocessor.ModificationsKt;
import org.jetbrains.kotlin.preprocessor.Preprocessor;
import org.jetbrains.kotlin.preprocessor.PreprocessorKt;
import org.jetbrains.kotlin.preprocessor.Profile;
import org.jetbrains.kotlin.preprocessor.SystemOutLogger;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiFactory;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"0\n)a\u0001K]3qe>\u001cWm]:pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0007qe\u0016\u0004(o\\2fgN|'OC\u0002B]fTa\u0001P5oSRt$B\u00027pO\u001e,'O\u0003\u0004M_\u001e<WM\u001d\u0006\tM&dW\rV=qK*Y!*\u001a;GS2,G+\u001f9f\u0015\u0011IG-Z1\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'bC4fi\u001aKG.\u001a+za\u0016TQB[3u!NLg)Y2u_JL(\"\u0004&fiB\u001b\u0018NR1di>\u0014\u0018PC\u0002qg&T\u0001cZ3u\u0015\u0016$\bk]5GC\u000e$xN]=\u000b\u0013\u001d,G\u000fT8hO\u0016\u0014(b\b9s_\u000e,7o\u001d#je\u0016\u001cGo\u001c:z\u001bVdG/[#wC2,\u0018\r^8sg*Q1o\\;sG\u0016\u0014vn\u001c;\u000b\t\u0019KG.\u001a\u0006\u0005U\u00064\u0018M\u0003\u0002j_*\u0011B/\u0019:hKR\u0014V\r\\1uSZ,'k\\8u\u0015!\u0001(o\u001c4jY\u0016\u001c(\u0002\u0002'jgRTq\u0001\u0015:pM&dWM\u0003\u0003V]&$(\u0002B;uS2Tq\u0004\u001d:pG\u0016\u001c8\u000fR5sK\u000e$xN]=TS:<G.Z#wC2,\u0018\r^8s\u0015)!\u0018M]4fiJ{w\u000e\u001e\u0006\nKZ\fG.^1u_JT\u0011\"\u0012<bYV\fGo\u001c:\u000b5A\u0014xnY3tg\u001aKG.Z'vYRLWI^1mk\u0006$xN]:\u000b\u0015M|WO]2f\r&dWM\u0003\u0006fm\u0006dW/\u0019;peNTACR5mKB\u0013xnY3tg&twMU3tk2$(B\u00079s_\u000e,7o\u001d$jY\u0016\u001c\u0016N\\4mK\u00163\u0018\r\\;bi>\u0014(\"\t)sKB\u0014xnY3tg>\u0014HER5mKB\u0013xnY3tg&twMU3tk2$(B\u00049s_\u000e,7o]*pkJ\u001cWm\u001d\u0006\baJ|g-\u001b7f}\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0002\u0011\u0007)1\u0001\"\u0002\t\u00061\u0001Qa\u0001C\u0002\u0011\u0011a\u0001!\u0002\u0002\u0005\u0004!!QA\u0001\u0003\u0002\u0011\u0017)1\u0001\"\u0003\t\u000b1\u0001QA\u0001C\u0005\u0011\u0015)!\u0001B\u0001\t\u0011\u0015\u0019AA\u0002E\b\u0019\u0001)!\u0001\u0002\u0004\t\u0010\u0015\t\u0001bC\u0003\u0003\t\u001fA9\"B\u0002\u0005\u0011!UA\u0002A\u0003\u0004\t\u000bAQ\u0002\u0004\u0001\u0006\u0007\u0011\r\u00012\u0004\u0007\u0001\u000b\r!)\u0001\u0003\b\r\u0001\u0015\u0011A\u0001\u0003E\u000b\u000b\t!y\u0001#\b\u0006\u0005\u0011Y\u0001\"D\u0003\u0004\t\u0007A\t\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001\u0012E\u0003\u0004\t\tA)\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001rE\u0003\u0003\t\u0007AY\u0002B\u0002\r\u0005e\u0019Q!\u0001\u0005\u00041\ri\nQE\u0017\u0017\t\r$\u0001\u0014B\u0011\n\u000b\u0005AQ\u0001\u0005\u0004\u0016\t\u0015\t\u0001\"\u0002G\u00011\u0015AR!V\u0002\t\u000b\r!I!C\u0001\t\f5\u0019AQB\u0005\u0002\u0011\u0017i\u0003\u0003B2\u00051\u001d\t3!B\u0001\t\u000ea5Qk\u0001\u0005\u0006\u0007\u00119\u0011\"\u0001\u0005\b\u001b\r!\t\"C\u0001\t\u000f5\u0002Ba\u0019\u0003\u0019\b\u0005\u001aQ!\u0001E\u00041\u000f)6\u0001C\u0003\u0004\t\u000fI\u0011\u0001\u0003\u0003\u000e\u0007\u0011I\u0011\"\u0001\u0005\u0005[=\"\u0011\u0001g\u0005\u001e\u0010\u0011\u0001\u0001BC\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001iz\u0001\u0002\u0001\t\u00195\u0019Q!\u0001E\t1#\u00016\u0011AO\r\t\u0001AI\"\u0004\u0005\u0006\u0003!I\u0011\u0002B\u0005\u0004\u000b\u0005A\u0019\u0002g\u0005\u0019\u0013A\u001b\u0011!I\u0002\u0006\u0003!Q\u0001DC)\u0004\u0013\u0011M\u0011\"\u0001\u0003\u0001\u001b\u0005A)\"D\u0001\t\u00165\t\u0001rC\u0017+\t\u0005Ar\"h\u0004\u0005\u0001!QQbA\u0003\u0002\u0011#A\n\u0002U\u0002\u0001;\u001f!\u0001\u0001c\b\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0005Qt\u0002\u0003\u0001\u0011Ai1!B\u0001\t\u0019aa\u0001kA\u0001\"\u0007\u0015\t\u0001B\u0003\r\u000b#\u000eIAaD\u0005\u0002\t\u0001i\u0011\u0001#\u0006\u000e\u0003!UQ\"\u0001E\r['\"\u0011\u0001G\t\u001e\u0010\u0011\u0001\u00012E\u0007\u0004\u000b\u0005A\t\u0002'\u0005Q\u0007\u0001iJ\u0002\u0002\u0001\t%5AQ!\u0001\u0005\n\u0013\u0011I1!B\u0001\t\u0019aa\u0001$\u0003)\u0004\u0002\u0005BQ!\u0001\u0005\n\u0013\u0011I1!B\u0001\t\u001bai\u0001$C)\u0004\u000f\u0011\t\u0012\"\u0001E\f\u001b\u0005A)\"D\u0001\t\u00185~B!\u0001\r\u0014;\u001f!\u0001\u0001c\t\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0001Qt\u0002\u0003\u0001\u0011Ai1!B\u0001\t\u0019aa\u0001k!\u0001\"\u0007\u0015\t\u0001\"\u0004\r\u000e#\u000e9AaE\u0005\u0002\u00117i\u0011\u0001#\u0006\u000e\u0003!eQv\b\u0003\u00041Qiz\u0001\u0002\u0001\t\u00155\u0019Q!\u0001E\t1#\u00016\u0001AO\b\t\u0001AI#D\u0002\u0006\u0003!M\u00014\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\u000b1)\t6a\u0002\u0003\u0015\u0013\u0005!\u0001!D\u0001\t\u00165\t\u0001BD[\u0017\u000bW!1\u001d\u0001\r\u0004;\u001f!\u0011\u0001c\u0002\u000e\u0007\u0015\t\u0001r\u0001M\u0004!\u000e\u0001\u0011eA\u0003\u0002\u0011\tA\"!U\u0002\u0006\t\rI\u0011\u0001\u0002\u0001\u000e\u0003!!\u0001"})
public final class Preprocessor {
    public static final /* synthetic */ KClass $kotlinClass;
    private final JetFileType fileType;
    @NotNull
    private final JetPsiFactory jetPsiFactory;
    @NotNull
    private final Logger logger;

    static {
        $kotlinClass = Reflection.createKotlinClass(Preprocessor.class);
    }

    public final JetFileType getFileType() {
        return this.fileType;
    }

    @NotNull
    public final JetPsiFactory getJetPsiFactory() {
        return this.jetPsiFactory;
    }

    public final void processSources(@NotNull File sourceRoot, @NotNull Profile profile) {
        Intrinsics.checkParameterIsNotNull(sourceRoot, "sourceRoot");
        Intrinsics.checkParameterIsNotNull(profile, "profile");
        this.processDirectorySingleEvaluator(sourceRoot, profile.getTargetRoot(), profile.getEvaluator());
    }

    private final FileProcessingResult processFileSingleEvaluator(File sourceFile, Evaluator evaluator) {
        if (Intrinsics.areEqual(FilesKt.getExtension(sourceFile), this.fileType.getDefaultExtension()) ^ true) {
            return FileProcessingResult.Copy.INSTANCE$;
        }
        String sourceText = PreprocessorKt.convertLineSeparators(FilesKt.readText$default(sourceFile, null, 1));
        String string = sourceFile.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "sourceFile.name");
        JetFile psiFile = this.jetPsiFactory.createFile(string, sourceText);
        List<Conditional> fileAnnotations = ConditionalKt.parseConditionalAnnotations(psiFile);
        if (!((Boolean)evaluator.invoke(fileAnnotations)).booleanValue()) {
            return FileProcessingResult.Skip.INSTANCE$;
        }
        CollectModificationsVisitor visitor2 = new CollectModificationsVisitor(CollectionsKt.listOf(evaluator));
        psiFile.accept(visitor2);
        List list = (List)CollectionsKt.single((Iterable)visitor2.getElementModifications().values());
        return CollectionsKt.isNotEmpty(list) ? (FileProcessingResult)new FileProcessingResult.Modify(sourceText, list) : (FileProcessingResult)FileProcessingResult.Copy.INSTANCE$;
    }

    /*
     * WARNING - void declaration
     */
    private final void processDirectorySingleEvaluator(File sourceRoot, File targetRoot, Evaluator evaluator) {
        void sourceDirectories;
        String resultText;
        void sourceFiles;
        void $receiver;
        Object[] objectArray = sourceRoot.listFiles();
        ArrayList<void> first = new ArrayList<void>();
        ArrayList<void> second = new ArrayList<void>();
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void element = $receiver[i];
            File it2 = (File)element;
            if (!it2.isDirectory()) {
                first.add(element);
                continue;
            }
            second.add(element);
        }
        Pair pair = new Pair(first, second);
        List list = pair.component1();
        List list2 = pair.component2();
        pair = null;
        HashSet<File> processedFiles = SetsKt.hashSetOf(new File[0]);
        Iterator iterator2 = sourceFiles.iterator();
        while (iterator2.hasNext()) {
            File sourceFile;
            File file = sourceFile = (File)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull(file, "sourceFile");
            FileProcessingResult result2 = this.processFileSingleEvaluator(file, evaluator);
            this.logger.debug(result2 + ": " + sourceFile);
            if (result2 instanceof FileProcessingResult.Skip) continue;
            File targetFile2 = PreprocessorKt.makeRelativeTo(sourceFile, sourceRoot, targetRoot);
            CollectionsKt.plusAssign((Collection)processedFiles, targetFile2);
            if (targetFile2.exists() && targetFile2.isDirectory()) {
                FilesKt.deleteRecursively(targetFile2);
            }
            if (result2 instanceof FileProcessingResult.Copy) {
                FileUtil.copy(sourceFile, targetFile2);
                continue;
            }
            if (!(result2 instanceof FileProcessingResult.Modify)) continue;
            resultText = ((FileProcessingResult.Modify)result2).getModifiedText();
            if (targetFile2.exists() && PreprocessorKt.isTextEqualTo(targetFile2, resultText)) continue;
            this.logger.info("Rewriting modified " + targetFile2);
            FilesKt.writeText$default(targetFile2, resultText, null, 2);
        }
        for (File sourceDir : sourceDirectories) {
            File targetDir = PreprocessorKt.makeRelativeTo(sourceDir, sourceRoot, targetRoot);
            if (targetDir.exists() && !targetDir.isDirectory()) {
                targetDir.delete();
            }
            PreprocessorKt.mkdirsOrFail(targetDir);
            File file = sourceDir;
            Intrinsics.checkExpressionValueIsNotNull(file, "sourceDir");
            this.processDirectorySingleEvaluator(file, targetDir, evaluator);
            CollectionsKt.plusAssign((Collection)processedFiles, targetDir);
        }
        File[] fileArray = targetRoot.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            Object var16_19;
            HashSet<File> hashSet;
            File targetFile;
            block9: {
                Object v2;
                void $receiver2;
                void $receiver3;
                targetFile = fileArray[i];
                Iterable targetFile2 = processedFiles;
                hashSet = processedFiles;
                resultText = $receiver3;
                for (Object element : $receiver2) {
                    File it3 = (File)element;
                    if (!FileUtil.filesEqual(it3, targetFile)) continue;
                    v2 = element;
                    break block9;
                }
                v2 = var16_19 = null;
            }
            if (hashSet.remove(var16_19)) continue;
            this.logger.info("Deleting skipped " + targetFile);
            FilesKt.deleteRecursively(targetFile);
        }
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public Preprocessor(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull(logger, "logger");
        this.logger = logger;
        this.fileType = JetFileType.INSTANCE;
        CompilerConfiguration configuration = new CompilerConfiguration();
        KotlinCoreEnvironment environment2 = KotlinCoreEnvironment.Companion.createForProduction(environment.1.INSTANCE$, configuration, CollectionsKt.emptyList());
        Project project = environment2.getProject();
        this.jetPsiFactory = new JetPsiFactory(project);
    }

    public /* synthetic */ Preprocessor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = SystemOutLogger.INSTANCE$;
        }
        this(logger);
    }

    public Preprocessor() {
        this(null, 1, null);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"#\u0004)!b)\u001b7f!J|7-Z:tS:<'+Z:vYRTA\u0002\u0015:faJ|7-Z:t_JT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\raJ,\u0007O]8dKN\u001cxN\u001d\u0006\u0004\u0003:L(B\u0002\u001fj]&$hH\u0003\u0005u_N#(/\u001b8h\u0015\u0019\u0019FO]5oO*92n\u001c;mS:t#N^7/!2\fGOZ8s[RK\b/\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'\u0002B\"pafTa!T8eS\u001aL(\u0002B*lSBT%B\u0001\t\u0003\u0015\u0011A\u0001\u0001E\u0002\u000b\t!\t\u0001\u0003\u0002\u0006\u0005\u0011\t\u0001RA\u0003\u0004\t\u0007A\t\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0002\u0001\u0007\u0001\u000b\u0005A!!B\u0002\u0005\u0007!\u0019A\u0002A\u0003\u0004\t\rAI\u0001\u0004\u0001\u0006\u0003!-QA\u0001C\u0005\u0011\u0019)!\u0001B\u0003\t\n\u0011YBRA\r\u0004\u000b\u0005A9\u0001g\u0002\u001e\u0004\u001b9y!,\t\u0005\u0017a!\u0011%C\u0003\u0002\u0011\u0011\u0001R!\u0006\u0003\u0006\u0003!!A\u0012\u0001\r\u00051\u0011\t6a\u0001\u0003\u0005\u0013\u0005AY!\u000e\u0007\u0006\u0017\u0011\t\u000f\u0001g\u0002\"\u0007\u0015\t\u0001R\u0001M\u0003#\u000e\u0019AqA\u0005\u0002\t\u0001\u0001"})
    public static abstract class FileProcessingResult {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(FileProcessingResult.class);
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }

        private FileProcessingResult() {
        }

        public /* synthetic */ FileProcessingResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"Q\u0015\u0011\u00196.\u001b9\u000b)\u0019KG.\u001a)s_\u000e,7o]5oOJ+7/\u001e7u\u00151\u0001&/\u001a9s_\u000e,7o]8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002\u00049sKB\u0014xnY3tg>\u0014hF\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0011\u0001C\u0002\u0006\u0007\u0011\r\u0001\"\u0001\u0007\u0001\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001!1-\u0001\u0007\u00043\r)\u0011\u0001#\u0002\u0019\u0006U\u0002\u0001"})
        public static final class Skip
        extends FileProcessingResult {
            public static final /* synthetic */ KClass $kotlinClass;
            public static final Skip INSTANCE$;

            static {
                $kotlinClass = Reflection.createKotlinClass(Skip.class);
                new Skip();
            }

            Skip() {
                super(null);
                INSTANCE$ = this;
            }
        }

        @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"Q\u0015\u0011\u0019u\u000e]=\u000b)\u0019KG.\u001a)s_\u000e,7o]5oOJ+7/\u001e7u\u00151\u0001&/\u001a9s_\u000e,7o]8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002\u00049sKB\u0014xnY3tg>\u0014hF\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0011\u0001C\u0002\u0006\u0007\u0011\r\u0001\"\u0001\u0007\u0001\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001!1-\u0001\u0007\u00043\r)\u0011\u0001#\u0002\u0019\u0006U\u0002\u0001"})
        public static final class Copy
        extends FileProcessingResult {
            public static final /* synthetic */ KClass $kotlinClass;
            public static final Copy INSTANCE$;

            static {
                $kotlinClass = Reflection.createKotlinClass(Copy.class);
                new Copy();
            }

            Copy() {
                super(null);
                INSTANCE$ = this;
            }
        }

        @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"`\u0004)1Qj\u001c3jMfTACR5mKB\u0013xnY3tg&twMU3tk2$(\u0002\u0004)sKB\u0014xnY3tg>\u0014(bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0007W>$H.\u001b8\u000b\u0019A\u0014X\r\u001d:pG\u0016\u001c8o\u001c:\u000b\rqJg.\u001b;?\u0015)\u0019x.\u001e:dKR+\u0007\u0010\u001e\u0006\u0007'R\u0014\u0018N\\4\u000b\u001b5|G-\u001b4jG\u0006$\u0018n\u001c8t\u0015\u0011a\u0015n\u001d;\u000b\u00195{G-\u001b4jG\u0006$\u0018n\u001c8\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twM\u0003\u0003vi&d'\u0002E4fi6{G-\u001b4jG\u0006$\u0018n\u001c8t\u001559W\r^*pkJ\u001cW\rV3yi*yq-\u001a;N_\u0012Lg-[3e)\u0016DHO\u0003\u0005u_N#(/\u001b8hM*\u0011\u0001c\u0001\u0006\u0005\u0011\u0001\u0001BA\u0003\u0003\t\u0003A)!\u0002\u0002\u0005\u0003!\u0019Qa\u0001C\u0002\u0011\u0005a\u0001!B\u0002\u0005\u0005!\u0005A\u0002A\u0003\u0004\t\u000bA\u0001\u0001\u0004\u0001\u0006\u0003!\u0015Qa\u0001C\u0004\u0011\u0013a\u0001!B\u0002\u0005\b!-A\u0002A\u0003\u0004\t\u0007Aa\u0001\u0004\u0001\u0006\u0003!5QA\u0001C\u0006\u0011\u001d)!\u0001\u0002\u0004\t\n\u0015\u0011A1\u0002E\b\u000b\t!q\u0001c\u0003\u0005\u00071\u0019\u0011dA\u0003\u0002\u0011\u000bA*!L\u000b\u0005G\u0012AR!\t\u0005\u0006\u0003!%\u0011\u0002B\u0005\u0004\u000b\u0005AQ\u0001G\u0003\u0019\nU\u001b\u0001\"B\u0002\u0005\u000b%\t\u0001rB\u0007\u0004\t!I\u0011\u0001c\u0004.!\u0011\u0019G\u0001\u0007\u0003\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005+\u000eAQa\u0001\u0003\u0005\u0013\u0005Ai!D\u0002\u0005\u0012%\t\u0001RBW\u000b\t\rA\u0012\"I\u0002\u0006\u0003!!\u0001\u0004B)\u0004\u0007\u0011I\u0011\"\u0001E\u0007[+!1\u0002g\u0005\"\u0007\u0015\t\u0001\u0002\u0002\r\u0005#\u000e\u0019A1C\u0005\u0002\u0011\u001b)d%B\u0013\u0005G\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001;3!\u0001\u0001C\u0003\u000e\u0011\u0015\t\u0001\u0012B\u0005\u0005\u0013\r)\u0011\u0001C\u0003\u0019\u000ba%\u0001k!\u0001\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000e9AqA\u0005\u0002\t\u0001i\u0011\u0001#\u0004\u000e\u0003!=\u0001"})
        public static final class Modify
        extends FileProcessingResult {
            public static final /* synthetic */ KClass $kotlinClass;
            @NotNull
            private final String sourceText;
            @NotNull
            private final List<? extends Modification> modifications;

            static {
                $kotlinClass = Reflection.createKotlinClass(Modify.class);
            }

            @NotNull
            public final String getModifiedText() {
                return ModificationsKt.applyTo(this.modifications, this.sourceText);
            }

            @Override
            @NotNull
            public String toString() {
                return "Modify(" + this.modifications.size() + ")";
            }

            @NotNull
            public final String getSourceText() {
                return this.sourceText;
            }

            @NotNull
            public final List<Modification> getModifications() {
                return this.modifications;
            }

            public Modify(@NotNull String sourceText, @NotNull List<? extends Modification> modifications) {
                Intrinsics.checkParameterIsNotNull(sourceText, "sourceText");
                Intrinsics.checkParameterIsNotNull(modifications, "modifications");
                super(null);
                this.sourceText = sourceText;
                this.modifications = modifications;
            }
        }
    }
}

