/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetLanguage;
import org.jetbrains.kotlin.parsing.JetParser;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetFileStubBuilder;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;

public class JetFileElementType
extends IStubFileElementType<KotlinFileStub> {
    public static final int STUB_VERSION = 59;

    public JetFileElementType() {
        super("kotlin.FILE", JetLanguage.INSTANCE);
    }

    protected JetFileElementType(@NonNls String debugName) {
        super(debugName, JetLanguage.INSTANCE);
    }

    @Override
    public StubBuilder getBuilder() {
        return new JetFileStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 59;
    }

    @Override
    @NotNull
    public String getExternalId() {
        if ("kotlin.FILE" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "getExternalId"));
        }
        return "kotlin.FILE";
    }

    @Override
    public void serialize(@NotNull KotlinFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "serialize"));
        }
        StubIndexService.getInstance().serializeFileStub(stub, dataStream);
    }

    @Override
    @NotNull
    public KotlinFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "deserialize"));
        }
        KotlinFileStub kotlinFileStub = StubIndexService.getInstance().deserializeFileStub(dataStream);
        if (kotlinFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "deserialize"));
        }
        return kotlinFileStub;
    }

    @Override
    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "doParseContents"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "doParseContents"));
        }
        Project project = psi.getProject();
        Language languageForParser = this.getLanguageForParser(psi);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, null, languageForParser, chameleon.getChars());
        JetParser parser = (JetParser)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(languageForParser)).createParser(project);
        return parser.parse(this, builder, psi.getContainingFile()).getFirstChildNode();
    }

    @Override
    public void indexStub(@NotNull KotlinFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/psi/stubs/elements/JetFileElementType", "indexStub"));
        }
        StubIndexService.getInstance().indexFile(stub, sink);
    }
}

