/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.tree.IElementType;
import java.math.BigInteger;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.evaluate.BinaryOperationKey;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt$WhenMappings;
import org.jetbrains.kotlin.resolve.constants.evaluate.UnaryOperationKey;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u001e\u0010)\u0019\u0011IT-\u000b\u001f\r{W\u000e]5mKRKW.\u001a+za\u0016T1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015%\u0019wN\\:uC:$8O\u0003\u0005fm\u0006dW/\u0019;f\u0015\r\te.\u001f\u0006\u0007O\u0016$\u0018IT-\u000b;\r{gn\u001d;b]R,\u0005\u0010\u001d:fgNLwN\\#wC2,\u0018\r^8s\u0017RTqAQ(P\u0019\u0016\u000beJC\u0004C_>dW-\u00198\u000b\u0015\u001d,GOQ(P\u0019\u0016\u000beJ\u0003\u0003C3R+%\u0002\u0002\"zi\u0016TqaZ3u\u0005f#VI\u0003\u0003D\u0011\u0006\u0013&\u0002B\"iCJTqaZ3u\u0007\"\u000b%K\u0003\u0004E\u001fV\u0013E*\u0012\u0006\u0007\t>,(\r\\3\u000b\u0013\u001d,G\u000fR(V\u00052+%\"\u0002$M\u001f\u0006#&\"\u0002$m_\u0006$(\u0002C4fi\u001acu*\u0011+\u000b\u0007%sEKC\u0002J]RTaaZ3u\u0013:#&\u0002\u0002'P\u001d\u001eSA\u0001T8oO*9q-\u001a;M\u001f:;%\"B*I\u001fJ#&\"B*i_J$(\u0002C4fiNCuJ\u0015+\u000b\rM#&+\u0013(H\u0015\u0019\u0019FO]5oO*Iq-\u001a;T)JKej\u0012\u0006\u0002\u0003*\t!IC\bcS:\f'/_(qKJ\fG/[8o\u0015\u0005\t'\"\u00012\u000b\u0019\u0019,hn\u0019;j_:t\u0015-\\3\u000b\u0013=\u0004XM]1uS>t'\"\u0003$v]\u000e$\u0018n\u001c83\u0015\u001d\u0019\u0007.Z2lKJT!BQ5h\u0013:$XmZ3s\u0015\u0011Q\u0017M^1\u000b\t5\fG\u000f\u001b\u0006\u0005!\u0006L'O\u0003\nCS:\f'/_(qKJ\fG/[8o\u0017\u0016L(\u0002\u00027b]\u001eT1A\u001b<n\u0015%1WO\\2uS>t7OC\u0013de\u0016\fG/Z\"p[BLG.\u001a+j[\u0016\u001cuN\\:uC:$hi\u001c:D_6\u0004\u0018M]3U_*1!/Z:vYRT!c\u001c9fe\u0006$\u0018n\u001c8SK\u001a,'/\u001a8dK*i!*\u001a;FqB\u0014Xm]:j_:T1\u0001]:j\u0015\u001d1\u0017m\u0019;pefTAcQ8ogR\fg\u000e\u001e,bYV,g)Y2u_JL(\"D\"p]N$\u0018M\u001c;WC2,XM\u0003\u0004PE*,7\r\u001e\u0006#GJ,\u0017\r^3D_6\u0004\u0018\u000e\\3US6,7i\u001c8ti\u0006tGOR8s\u000bF,\u0018\r\\:\u000b%\u001d,GoQ8na&dW\rV5nKRK\b/\u001a\u0006\u0002G*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(\"G4fiJ+7-Z5wKJ,\u0005\u0010\u001d:fgNLwN\u001c+za\u0016TAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2TQaY1mYNTQ!\\8eK2TQ\u0002[1t\u0019>twmU;gM&D(\u0002\u0002;fqRTQ\"[:J]R,w-\u001a:UsB,'\"\u0002<bYV,'\u0002\u00049beN,'i\\8mK\u0006t'b\u00039beN,Gi\\;cY\u0016T!\u0002]1sg\u00164En\\1u\u0015Q\u0001\u0018M]:f\r2|\u0017\r^5oO2KG/\u001a:bY*I\u0001/\u0019:tK2{gn\u001a\u0006\u000fk:\f'/_(qKJ\fG/[8o\u0015%1UO\\2uS>t\u0017GC\tV]\u0006\u0014\u0018p\u00149fe\u0006$\u0018n\u001c8LKft.A\u0003\u0002\u0011\u0005)!\u0001\u0002\u0001\t\u0004\u0015\u0011A\u0011\u0001\u0005\u0003\u000b\t!\u0011\u0001#\u0002\u0006\u0005\u0011\r\u0001bA\u0003\u0003\t\tA9!B\u0002\u0005\u0006!\u0005A\u0002A\u0003\u0002\u0011\t)1\u0001b\u0002\t\t1\u0001QA\u0001C\u0003\u0011\u0003)1\u0001b\u0002\t\r1\u0001Qa\u0001C\u0004\u0011\u001fa\u0001!B\u0002\u0005\b!IA\u0002A\u0003\u0004\t\u000fA)\u0002\u0004\u0001\u0006\u0007\u0011\u001d\u0001\u0002\u0004\u0007\u0001\u000b\r!9\u0001c\u0007\r\u0001\u0015\u0019Aq\u0001\u0005\u0010\u0019\u0001)1\u0001b\u0002\t\"1\u0001Qa\u0001C\u0004\u0011Ia\u0001!B\u0002\u0005\b!5B\u0002A\u0003\u0002\u0011a)!\u0001\u0002\u0006\t2\u0015\u0019AQ\u0003E\u0018\u0019\u0001)1\u0001b\u0002\t31\u0001Qa\u0001C\u0003\u0011ga\u0001!\u0002\u0002\u0005\b!IRA\u0001\u0003\u000b\u0011i)!\u0001B\u0007\t%\u0015\u0011Aq\u0001E\u001b\u000b\t!a\u0002C\u000e\u0006\u0005\u0011u\u0001RF\u0003\u0003\t\u0005AY$B\u0002\u0005 !iB\u0002A\u0003\u0004\t\tAi\u0004\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\b\u0007\u0001\u000b\t!!\u0001C\u0010\u0006\u0005\u0011i\u0001rH\u0003\u0003\t?AQ$\u0002\u0002\u0005\u0005!uRA\u0001\u0003\u0002\u0011\t*1\u0001b\n\tD1\u0001QA\u0001C\u0014\u0011\u0007*!\u0001b\u0001\tI\u0015\u0011A!\u0006E%\u000b\r!Y\u0003c\u0012\r\u0001\u0015\u0011A1\u0006E$\u000b\t!Q\u0002#\u0006\u0006\u0005\u0011i\u0001\u0002D\u0003\u0003\t5Aq\"B\u0002\u0005\b!QC\u0002A\u0003\u0004\t\u000bA)\u0006\u0004\u0001\u0006\u0005\u0011u\u0001BKC\u0017\t\u0001$\u0001\u0004A\u0011\t\u000b\u0005A1!\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0002\r\u00051\r)6\u0001C\u0003\u0004\t\u0001I\u0011\u0001#\u0003\u000e\u0007\u0011%\u0011\"\u0001E\u00051\u000e)QQ\u0006\u0003a\ta-\u0011\u0005C\u0003\u0002\u0011\rIA!C\u0002\u0006\u0003!)\u0001$\u0002\r\u0004+\u000eAQa\u0001C\u0006\u0013\u0005AI!D\u0002\u0005\u000e%\t\u0001\u0012\u0002-\u0004\u000b\u00155B\u0001\u0019\u0003\u0019\u000f\u0005BQ!\u0001\u0005\u0004\u0013\u0011I1!B\u0001\t\fa-\u0001dA+\u0004\u0011\u0015\u0019AaB\u0005\u0002\u0011\u0013i1\u0001\u0002\u0005\n\u0003!%\u0001lA\u0003\u0006.\u0011\u0001G\u0001'\u0005\"\u0011\u0015\t\u0001bA\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0004\u0019\ra\u0019Qk\u0001\u0005\u0006\u0007\u0011E\u0011\"\u0001E\u0005\u001b\r!\u0019\"C\u0001\t\na\u001bQ!\"\f\u0005A\u0012A\"\"\t\u0005\u0006\u0003!\u0019\u0011\u0002B\u0005\u0004\u000b\u0005Ai\u0001'\u0004\u0019\u0007U\u001b\u0001\"B\u0002\u0005\u0015%\t\u0001\u0012B\u0007\u0004\t-I\u0011\u0001#\u0003Y\u0007\u0015)i\u0003\u00021\u00051/\t\u0003\"B\u0001\t\u0007%!\u0011bA\u0003\u0002\u0011\u001dAr\u0001G\u0002V\u0007!)1\u0001b\u0006\n\u0003!%Qb\u0001C\r\u0013\u0005AI\u0001W\u0002\u0006\u000b[!\u0001\r\u0002\r\u000eC!)\u0011\u0001C\u0002\n\t%\u0019Q!\u0001E\b1\u001fA2!V\u0002\t\u000b\r!Q\"C\u0001\t\n5\u0019AAD\u0005\u0002\u0011\u0013A6!BC\u0017\t\u0001$\u0001TD\u0011\t\u000b\u0005A1!\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0003\r\t1\r)6\u0001C\u0003\u0004\t;I\u0011\u0001#\u0003\u000e\u0007\u0011}\u0011\"\u0001E\u00051\u000e)QQ\u0006\u0003a\ta\u0001\u0012\u0005C\u0003\u0002\u0011\rIA!C\u0002\u0006\u0003!E\u0001\u0014\u0003\r\u0004+\u000eAQa\u0001\u0003\u0011\u0013\u0005AI!D\u0002\u0005#%\t\u0001\u0012\u0002-\u0004\u000b\u00155B\u0001\u0019\u0003\u0019$\u0005BQ!\u0001\u0005\u0004\u0013\u0011I1!B\u0001\t\u0013aI\u0001dA+\u0004\u0011\u0015\u0019A1E\u0005\u0002\u0011\u0013i1\u0001\"\n\n\u0003!%\u0001lA\u0003\u0006{\u0006!\t!E\u0004\u0005\u0001!\u0019R\u0003B\u0003\u0002\u0011\u0011a\t\u0001\u0007\u0003\u0012\u000f\u0011\u0005\u0001rE\u000b\u0005\u000b\u0005AA\u0001$\u0001\u0019\ta!R4\u0004\u0003\u0001\u0011Si\u0011\"B\u0001\t\u0007%)\u0011\u0002B\u0003\u0003\t\u0003A\u0001\u0001\b\u0001\u0019\u0007A\u001b\u0001!h\u0007\u0005\u0001!)R\"C\u0003\u0002\u0011\rIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u00011\r\u00016\u0011AO\b\t\u0001AY#D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0003uEB\u0001\u0001\u0005\u0017\u001bQ)\u0011\u0001c\u0005\n\u000b%!QA\u0001C\u0001\u0011\u0001a\u0002!C\u0003\n\t\u0015\u0011A\u0011\u0001E\u00019\u0003IA!C\u0002\u0006\u0003!!\u0001\u0004\u0002M\n!\u000e\rQT\u0006\u0003\u0001\u0011]i!#B\u0001\t\u0014%!\u0011bA\u0003\u0002\u0011-A2\"\u0003\u0003\n\u0007\u0015\t\u0001b\u0003\r\f\u0013\u0011I1!B\u0001\t\u0017aY\u00014\u0003)\u0004\u0005\u0005\u001a\r!B\u0001\t\u0018%\u0001\u0012bD\u0003\u0002\u00111IQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001\r\r\u00139JQ&B\u0001\t\u0018%)\u0012\u0002F\u0003\u0002\u0011'IQ!\u0003\u0003\u0006\u0003!!A\u0012\u0001\r\u0005\u0013\u0015IA!B\u0001\t\t1\u0005\u0001\u0004B\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0003\u0019\taM\u0011bE\u0005\u0013\u000b\u0005A\u0019\"\u0003\u0003\n\u0007\u0015\t\u0001b\u0003\r\f\u0013\u0011I1!B\u0001\t\u0017aY\u0011\u0002B\u0005\u0004\u000b\u0005A1\u0002G\u0006\u0019\u0014a]\u0001tC)\u0004\u001b\u0011!\u0012\"\u0001E\r\u001b\u0005AI!D\u0001\t\n5\t\u00012D\u0007\u0002\u0011=i\u0011\u0001C\bY\u0007\u0015)y\u0006B\u0001\u00198uEA\u0001\u0001\u0005\u001d\u001b\u0011)\u0011\u0001\u0003\u0003\r\u0002a!\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\u0012H\u0007\u0004\u000b\u0005A\u0001\u0003\u0007\tQ\u0007\u0003iz\u0001\u0002\u0001\t=5\u0019Q!\u0001E\u00111C\u00016!A\u0011\u0007\u000b\u0005A\u0011#C\u0001\u0005\u00041\u0005\u0001$E)\u0004\u0013\u0011]\u0012\"\u0001E\u0012\u001b\u0005A!#D\u0001\t&5\t\u0001b\u0005-\u0004\u000b\u0015}C!\u0001\r!;#!\u0001\u0001\u0003\u000f\u000e\t\u0015\t\u0001\u0002\u0002G\u00011\u0011\u00016\u0001AO\b\t\u0001AI$D\u0002\u0006\u0003!\u0001\u0002\u0004\u0005)\u0004\u0002u=A\u0001\u0001\u0005\u001f\u001b\r)\u0011\u0001#\t\u0019\"A\u001b\u0011!\t\u0004\u0006\u0003!\t\u0012\"\u0001C\u0002\u0019\u0003A\u0012#U\u0002\n\t\u0001J\u0011\u0001c\t\u000e\u0003!\u0011R\"\u0001E\u0013\u001b\u0005A1\u0003W\u0002\u0006\u000bw!\u0011\u0001'\u0011\u001e\u0010\u0011\u0001\u0001\"I\u0007\u0004\u000b\u0005AA\u0003\u0007\u000bQ\u0007\u0001\t#\"B\u0001\t\u0007%)A\u0011A\u0005\u0004\u000b\u0005AA\u0001\u0007\u0003\r\u0002a\u0019\u0011kA\u0003\u0005B%\t\u0001\u0012B\u0007\u0002\u0011SA6!BC\u001a\t\u0005A*%h\u0005\u0005\u0001!\u0019S\"B\u0003\u0002\u0011YI\u0011\u0001b\u0001\u0019-A\u001b\u0001!\t\u0003\u0006\u0003!!B\u0012\u0001\r\u0015#\u000e)AQI\u0005\u0002\u0011Si\u0011\u0001#\fY\u0007\u0015)i\u0003B\u0001\u0019Ku=A\u0001\u0001E&\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b\u0001!I\u0002\u0006\u0003!)\u0001$B)\u0004\u000b\u0011)\u0013\"\u0001C\u0001\u001b\u0005AY\u0002W\u0002\u0006\u000b_!1\u0001\u0007\u0014\u001e\u0012\u0011\u0001\u0001RJ\u0007\u0005\u000b\u0005AA\u0001$\u0001\u0019\tA\u001b\u0001!I\u0002\u0006\u0003!)\u0001$B)\u0004\u000b\u00111\u0013\"\u0001C\u0001\u001b\u0005A!\u0003W\u0002\u0006\u000b[!\u0011\u0001G\u0014\u001e\u0010\u0011\u0001\u00012J\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0001\t3!B\u0001\t\u000ba)\u0011kA\u0003\u0005O%\tA\u0011A\u0007\u0002\u00117A6!BC\u0018\t\u0005Az%h\u0004\u0005\u0001!-SbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0001C\u0011)\u0011\u0001#\u0004\r\u0002a5\u0011kA\u0003\u0005P%\t\u0001bF\u0007\u0002\u00117A6!BC\u0018\t\u0005A\u0002&h\u0004\u0005\u0001!-SbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0001C\u0011)\u0011\u0001C\u0004\r\u0002a9\u0011kA\u0003\u0005Q%\t\u0001rF\u0007\u0002\u00117A6!BC\u0018\t\u0005A\n&h\u0004\u0005\u0001!-SbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0001C\u0011)\u0011\u0001\u0003\u0003\r\u0002a!\u0011kA\u0003\u0005R%\t\u0001BE\u0007\u0002\u00117A6!BC\u0018\t\rA\u0012&h\u0004\u0005\u0001!-SbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0001C\u0011)\u0011\u0001\u0003\u0005\r\u0002aA\u0011kA\u0003\u0005S%\t\u0001\u0002G\u0007\u0002\u00117A6!B\u0003I\u0003\u0011\u0005\u0011c\u0002\u0003\u0001\u0011M)B!B\u0001\t\t1\u0005\u0001\u0004\u0002M*;7!\u0001\u0001#\u000b\u000e\u0013\u0015\t\u0001bA\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001d\u0001)\u0004\u0001u=A\u0001\u0001E\u0016\u001b\r)\u0011\u0001C\u0005\u0019\u0013A\u001b\t!(\n\u0005\u0001!1RBD\u0003\u0002\u0011cIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u0001\u0013\u0011I1!B\u0001\t\ta!\u0001\u0014\u0007)\u0004\u0003u\rB\u0001\u0001\u0005\u0018\u001b5)\u0011\u0001#\r\n\t%\u0019Q!\u0001\u0005\t1!IA!C\u0002\u0006\u0003!A\u0001\u0004\u0003M\u0019!\u000e\r\u0011EM\u0003\u0002\u0011/I!\"C\u0005\u0006\u0003!I\u0012\"B\u0005\u0005\u000b\t!\t\u0001\u0003\u0001\u001d\u0001aI\u0012bI\u0005#\u000b\u0005A9\"C\b\n\u001d\u0015\t\u0001\u0012G\u0005\u0006\u0013\u0011)\u0011\u0001\u0003\u0003\r\u0002a!\u0011\u0002B\u0005\u0004\u000b\u0005AA\u0001\u0007\u0003\u00192%q\u0011\"D\u0003\u0002\u0011cIA!C\u0002\u0006\u0003!A\u0001\u0004C\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011aE\u0002t\u0003M\f#\u000eYA1K\u0005\u0002\u00113i\u0011\u0001#\u0003\u000e\u0003!mQ\"\u0001E\u001a\u001b\u0005A\u0019\u0004W\u0002\u0006"})
public final class ConstantExpressionEvaluatorKt {
    @NotNull
    static final CompileTimeType<Byte> BYTE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Short> SHORT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Integer> INT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Long> LONG = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Double> DOUBLE = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Float> FLOAT = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Character> CHAR = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Boolean> BOOLEAN = new CompileTimeType();
    @NotNull
    static final CompileTimeType<String> STRING = new CompileTimeType();
    @NotNull
    static final CompileTimeType<Object> ANY = new CompileTimeType();

    public static final boolean hasLongSuffix(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        return StringsKt.endsWith$default(text, 'l', false, 2) || StringsKt.endsWith$default(text, 'L', false, 2);
    }

    @Nullable
    public static final Long parseLong(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            Function1<String, String> substringLongSuffix$ = new Function1<String, String>(text){
                final /* synthetic */ String $text;

                @NotNull
                public final String invoke(@NotNull String s) {
                    Intrinsics.checkParameterIsNotNull(s, "s");
                    return ConstantExpressionEvaluatorKt.hasLongSuffix(this.$text) ? StringsKt.substring(s, 0, s.length() - 1) : s;
                }
                {
                    this.$text = string;
                    super(1);
                }
            };
            Function2<String, Integer, Long> parseLong$ = new Function2<String, Integer, Long>(substringLongSuffix$){
                final /* synthetic */ parseLong.1 $substringLongSuffix;

                public final long invoke(@NotNull String text, int radix) {
                    Intrinsics.checkParameterIsNotNull(text, "text");
                    return Long.parseLong(this.$substringLongSuffix.invoke(text), radix);
                }
                {
                    this.$substringLongSuffix = var1_1;
                    super(2);
                }
            };
            return StringsKt.startsWith$default(text, "0x", false, 2) || StringsKt.startsWith$default(text, "0X", false, 2) ? parseLong$.invoke(StringsKt.substring(text, 2), 16) : (StringsKt.startsWith$default(text, "0b", false, 2) || StringsKt.startsWith$default(text, "0B", false, 2) ? parseLong$.invoke(StringsKt.substring(text, 2), 2) : parseLong$.invoke(text, 10));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Object parseFloatingLiteral(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        if (StringsKt.endsWith$default(StringsKt.toLowerCase(text), 'f', false, 2)) {
            return ConstantExpressionEvaluatorKt.parseFloat(text);
        }
        return ConstantExpressionEvaluatorKt.parseDouble(text);
    }

    @Nullable
    public static final Double parseDouble(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static final Float parseFloat(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static final boolean parseBoolean(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull(text, "text");
        if ("true".equals(text)) {
            return true;
        }
        if ("false".equals(text)) {
            return false;
        }
        throw (Throwable)new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    @Nullable
    public static final ConstantValue<?> createCompileTimeConstantForEquals(@Nullable Object result2, @NotNull JetExpression operationReference, @NotNull ConstantValueFactory factory) {
        Intrinsics.checkParameterIsNotNull(operationReference, "operationReference");
        Intrinsics.checkParameterIsNotNull(factory, "factory");
        if (result2 instanceof Boolean) {
            boolean bl;
            PreconditionsKt.assert(operationReference instanceof JetSimpleNameExpression, "This method should be called only for equals operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetSimpleNameExpression");
            }
            IElementType operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.EQEQ)) {
                bl = (Boolean)result2;
            } else if (Intrinsics.areEqual(iElementType, JetTokens.EXCLEQ)) {
                bl = !((Boolean)result2).booleanValue();
            } else if (Intrinsics.areEqual(iElementType, JetTokens.IDENTIFIER)) {
                PreconditionsKt.assert(Intrinsics.areEqual(((JetSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorConventions.EQUALS), "This method should be called only for equals operations");
                bl = (Boolean)result2;
            } else {
                throw (Throwable)new IllegalStateException("Unknown equals operation token: " + operationToken + " " + ((JetSimpleNameExpression)operationReference).getText());
            }
            boolean value = bl;
            return factory.createBooleanValue(value);
        }
        return null;
    }

    @Nullable
    public static final ConstantValue<?> createCompileTimeConstantForCompareTo(@Nullable Object result2, @NotNull JetExpression operationReference, @NotNull ConstantValueFactory factory) {
        Intrinsics.checkParameterIsNotNull(operationReference, "operationReference");
        Intrinsics.checkParameterIsNotNull(factory, "factory");
        if (result2 instanceof Integer) {
            BooleanValue booleanValue;
            PreconditionsKt.assert(operationReference instanceof JetSimpleNameExpression, "This method should be called only for compareTo operations");
            JetExpression jetExpression = operationReference;
            if (jetExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetSimpleNameExpression");
            }
            IElementType operationToken = ((JetSimpleNameExpression)jetExpression).getReferencedNameElementType();
            IElementType iElementType = operationToken;
            if (Intrinsics.areEqual(iElementType, JetTokens.LT)) {
                booleanValue = factory.createBooleanValue(((Number)result2).intValue() < 0);
            } else if (Intrinsics.areEqual(iElementType, JetTokens.LTEQ)) {
                booleanValue = factory.createBooleanValue(((Number)result2).intValue() <= 0);
            } else if (Intrinsics.areEqual(iElementType, JetTokens.GT)) {
                booleanValue = factory.createBooleanValue(((Number)result2).intValue() > 0);
            } else if (Intrinsics.areEqual(iElementType, JetTokens.GTEQ)) {
                booleanValue = factory.createBooleanValue(((Number)result2).intValue() >= 0);
            } else {
                if (Intrinsics.areEqual(iElementType, JetTokens.IDENTIFIER)) {
                    PreconditionsKt.assert(Intrinsics.areEqual(((JetSimpleNameExpression)operationReference).getReferencedNameAsName(), OperatorConventions.COMPARE_TO), "This method should be called only for compareTo operations");
                    return factory.createIntValue(((Number)result2).intValue());
                }
                throw (Throwable)new IllegalStateException("Unknown compareTo operation token: " + operationToken);
            }
            return booleanValue;
        }
        return null;
    }

    public static final boolean isIntegerType(@Nullable Object value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
    }

    @Nullable
    public static final JetType getReceiverExpressionType(@NotNull ResolvedCall<?> resolvedCall) {
        JetType jetType;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        switch (ConstantExpressionEvaluatorKt$WhenMappings.$EnumSwitchMapping$0[resolvedCall.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                jetType = resolvedCall.getDispatchReceiver().getType();
                break;
            }
            case 2: {
                jetType = resolvedCall.getExtensionReceiver().getType();
                break;
            }
            case 3: {
                jetType = null;
                break;
            }
            case 4: {
                jetType = null;
                break;
            }
            default: {
                jetType = null;
            }
        }
        return jetType;
    }

    @Nullable
    public static final CompileTimeType<? extends Object> getCompileTimeType(@NotNull JetType c) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        KotlinBuiltIns builtIns = KotlinBuiltIns.getInstance();
        JetType jetType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual(jetType, builtIns.getIntType()) ? INT : (Intrinsics.areEqual(jetType, builtIns.getByteType()) ? BYTE : (Intrinsics.areEqual(jetType, builtIns.getShortType()) ? SHORT : (Intrinsics.areEqual(jetType, builtIns.getLongType()) ? LONG : (Intrinsics.areEqual(jetType, builtIns.getDoubleType()) ? DOUBLE : (Intrinsics.areEqual(jetType, builtIns.getFloatType()) ? FLOAT : (Intrinsics.areEqual(jetType, builtIns.getCharType()) ? CHAR : (Intrinsics.areEqual(jetType, builtIns.getBooleanType()) ? BOOLEAN : (Intrinsics.areEqual(jetType, builtIns.getStringType()) ? STRING : (Intrinsics.areEqual(jetType, builtIns.getAnyType()) ? ANY : (CompileTimeType)null)))))))));
    }

    @NotNull
    public static final CompileTimeType<Byte> getBYTE() {
        return BYTE;
    }

    @NotNull
    public static final CompileTimeType<Short> getSHORT() {
        return SHORT;
    }

    @NotNull
    public static final CompileTimeType<Integer> getINT() {
        return INT;
    }

    @NotNull
    public static final CompileTimeType<Long> getLONG() {
        return LONG;
    }

    @NotNull
    public static final CompileTimeType<Double> getDOUBLE() {
        return DOUBLE;
    }

    @NotNull
    public static final CompileTimeType<Float> getFLOAT() {
        return FLOAT;
    }

    @NotNull
    public static final CompileTimeType<Character> getCHAR() {
        return CHAR;
    }

    @NotNull
    public static final CompileTimeType<Boolean> getBOOLEAN() {
        return BOOLEAN;
    }

    @NotNull
    public static final CompileTimeType<String> getSTRING() {
        return STRING;
    }

    @NotNull
    public static final CompileTimeType<Object> getANY() {
        return ANY;
    }

    @NotNull
    public static final <A, B> Pair<BinaryOperationKey<A, B>, Pair<? extends Function2<? super Object, ? super Object, ? extends Object>, ? extends Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>> binaryOperation(@NotNull CompileTimeType<A> a, @NotNull CompileTimeType<B> b, @NotNull String functionName, @NotNull Function2<? super A, ? super B, ? extends Object> operation, @NotNull Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger> checker) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        return TuplesKt.to(new BinaryOperationKey<A, B>(a, b, functionName), new Pair<Function2<? super A, ? super B, ? extends Object>, Function2<? super BigInteger, ? super BigInteger, ? extends BigInteger>>(operation, checker));
    }

    @NotNull
    public static final <A> Pair<UnaryOperationKey<A>, Pair<? extends Function1<? super Object, ? extends Object>, ? extends Function1<? super Long, ? extends Long>>> unaryOperation(@NotNull CompileTimeType<A> a, @NotNull String functionName, @NotNull Function1<? super A, ? extends Object> operation, @NotNull Function1<? super Long, ? extends Long> checker) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(functionName, "functionName");
        Intrinsics.checkParameterIsNotNull(operation, "operation");
        Intrinsics.checkParameterIsNotNull(checker, "checker");
        return TuplesKt.to(new UnaryOperationKey<A>(a, functionName), new Pair<Function1<? super A, ? extends Object>, Function1<? super Long, ? extends Long>>(operation, checker));
    }
}

