/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.JetTypeImpl;
import org.jetbrains.kotlin.types.TypeProjectionImpl;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"c\u0004)Y\"*\u0019<b\u00072\f7o](o\u0007>l\u0007/\u00198j_:\u001c\u0005.Z2lKJT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\be\u0016\u001cx\u000e\u001c<f\u0015\rQg/\u001c\u0006\u0006G\u0006dGn\u001d\u0006\tG\",7m[3sg*Y1)\u00197m\u0007\",7m[3s\u0015\u0019a\u0014N\\5u})\taI\u0003\nDC2d\u0017M\u00197f\t\u0016\u001c8M]5qi>\u0014(b\u00033fg\u000e\u0014\u0018\u000e\u001d;peNTQa\u00195fG.TAB]3t_24X\rZ\"bY2TABU3t_24X\rZ\"bY2TQ!\\8eK2TqaY8oi\u0016DHO\u0003\u000eCCNL7mQ1mYJ+7o\u001c7vi&|gnQ8oi\u0016DHO\u0003\u0003V]&$h1\u0001\u0006\u0003!\u0005QA\u0001\u0003\u0001\u0011\u0005)!\u0001\"\u0001\t\u0004\u0015\u0011A!\u0001\u0005\u0003\u000b\t!\u0019\u0001#\u0002\u0006\u0005\u0011\u0011\u0001bA\u0003\u0003\t\u000bA9!B\u0002\u0005\u0007!\u0001A\u0002A\u0003\u0003\t\u0007A1!\u0002\u0002\u0005\t!\u001dQa\u0001C\u0005\u0011\u0011a\u0001!\u0002\u0002\u0005\u0003!1Qa\u0001C\u0006\u0011\u0017a\u0001!\u0002\u0002\u0005\t!AQa\u0001C\u0007\u0011\u001fa\u0001!\u0002\u0002\u0005\t!EQa\u0001C\b\u0011%a\u0001!B\u0001\t\u0004\u0015\u0019A\u0011\u0003E\n\u0019\u0001)!\u0001\"\u0004\t\u0010\u0015\u0011Aq\u0002\u0005\n\t\ra9!G\u0002\u0006\u0003!)\u0001$BW-\t-\tb\u0001\u0002\u0001\t\u000bU\u0019Q!\u0001\u0005\u00071\u0019Aj!h\u0007\u0005\u0001!9Q\"C\u0003\u0002\u0011\u001dIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0002\u0001\u000f\u00011\u001d\u00016\u0001AO\b\t\u0001A\t\"D\u0002\u0006\u0003!A\u0001\u0004\u0003)\u0004\u0002\u0005\u001aQ!\u0001\u0005\n1%\t6a\u0002C\u0007\u0013\u0005!\u0001!D\u0001\t\u00145\t\u0001BC\u001b\r\u000b-!1\u001d\u0001M\u0005C\r)\u0011\u0001c\u0002\u0019\bE\u001b1\u0001\"\u0003\n\u0003\u0011\u0001\u0001"})
public final class JavaClassOnCompanionChecker
implements CallChecker {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(JavaClassOnCompanionChecker.class);
    }

    @Override
    public <F extends CallableDescriptor> void check(@NotNull ResolvedCall<F> resolvedCall, @NotNull BasicCallResolutionContext context) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(context, "context");
        F descriptor2 = resolvedCall.getResultingDescriptor();
        if (!(descriptor2 instanceof PropertyDescriptor) || Intrinsics.areEqual(((PropertyDescriptor)descriptor2).getName().asString(), "javaClass") ^ true) {
            return;
        }
        DeclarationDescriptor container = ((PropertyDescriptor)descriptor2).getContainingDeclaration();
        if (!(container instanceof PackageFragmentDescriptor) || Intrinsics.areEqual(((PackageFragmentDescriptor)container).getFqName().asString(), "kotlin") ^ true) {
            return;
        }
        JetType actualType = ((PropertyDescriptor)descriptor2).getType();
        Object object = CollectionsKt.singleOrNull(actualType.getArguments());
        if (!((object != null && (object = object.getType()) != null && (object = object.getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor companionObject = classDescriptor;
        if (companionObject.isCompanionObject()) {
            DeclarationDescriptor declarationDescriptor = companionObject.getContainingDeclaration();
            if (declarationDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor;
            ClassifierDescriptor classifierDescriptor2 = actualType.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor2;
            if (classDescriptor2 == null) {
                return;
            }
            ClassDescriptor javaLangClass = classDescriptor2;
            JetTypeImpl expectedType = JetTypeImpl.Companion.create(Annotations.Companion.getEMPTY(), javaLangClass, actualType.isMarkedNullable(), CollectionsKt.listOf(new TypeProjectionImpl(containingClass.getDefaultType())));
            context.trace.report(ErrorsJvm.JAVA_CLASS_ON_COMPANION.on((JetElement)((PsiElement)resolvedCall.getCall().getCallElement()), actualType, expectedType));
        }
    }
}

