/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentMostlySingularMultiMap;
import com.intellij.util.containers.ConcurrentSoftHashMap;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.WeakKeyWeakValueHashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseExternalAnnotationsManager
extends ExternalAnnotationsManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.BaseExternalAnnotationsManager");
    @NotNull
    private static final List<PsiFile> NULL_LIST = new ArrayList<PsiFile>(0);
    @NotNull
    private final ConcurrentMap<String, List<PsiFile>> myExternalAnnotations = new ConcurrentSoftValueHashMap<String, List<PsiFile>>(10, 0.75f, 2);
    protected final PsiManager myPsiManager;
    private static final List<AnnotationData> NO_DATA = new ArrayList<AnnotationData>(1);
    private final ConcurrentMostlySingularMultiMap<PsiModifierListOwner, AnnotationData> cache = new ConcurrentMostlySingularMultiMap();
    private final CharTableImpl charTable = new CharTableImpl();
    private final Map<AnnotationData, AnnotationData> annotationDataCache = new WeakKeyWeakValueHashMap<AnnotationData, AnnotationData>();
    private final ConcurrentMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>> annotationFileToDataAndModStamp = new ConcurrentSoftHashMap<PsiFile, Pair<MostlySingularMultiMap<String, AnnotationData>, Long>>();
    private static final JavaParserUtil.ParserWrapper ANNOTATION = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotation(builder);
        }
    };

    public BaseExternalAnnotationsManager(PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    @Nullable
    protected static String getExternalName(@NotNull PsiModifierListOwner listOwner, boolean showParamName) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.getExternalName must not be null");
        }
        return PsiFormatUtil.getExternalName(listOwner, showParamName, Integer.MAX_VALUE);
    }

    @Nullable
    private static String getFQN(@NotNull String packageName, @NotNull PsiFile psiFile) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.getFQN must not be null");
        }
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.getFQN must not be null");
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return StringUtil.getQualifiedName(packageName, virtualFile.getNameWithoutExtension());
    }

    @Nullable
    protected static String getNormalizedExternalName(@NotNull PsiModifierListOwner owner) {
        int idx;
        PsiMethod method;
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.getNormalizedExternalName must not be null");
        }
        String externalName = BaseExternalAnnotationsManager.getExternalName(owner, true);
        if (externalName == null) {
            return null;
        }
        if (owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && (method = PsiTreeUtil.getParentOfType((PsiElement)owner, PsiMethod.class)) != null) {
            externalName = externalName.substring(0, externalName.lastIndexOf(32) + 1) + method.getParameterList().getParameterIndex((PsiParameter)owner);
        }
        if ((idx = externalName.indexOf(40)) == -1) {
            return externalName;
        }
        StringBuilder buf = new StringBuilder(externalName.length());
        int rightIdx = externalName.indexOf(41);
        String[] params = externalName.substring(idx + 1, rightIdx).split(",");
        buf.append(externalName, 0, idx + 1);
        for (String param : params) {
            int spaceIdx = (param = param.trim()).indexOf(32);
            if (spaceIdx > -1) {
                buf.append(param, 0, spaceIdx);
            } else {
                buf.append(param);
            }
            buf.append(", ");
        }
        if (StringUtil.endsWith(buf, ", ")) {
            buf.delete(buf.length() - ", ".length(), buf.length());
        }
        buf.append(externalName, rightIdx, externalName.length());
        return buf.toString();
    }

    protected abstract boolean hasAnyAnnotationsRoots();

    @Override
    @Nullable
    public PsiAnnotation findExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.findExternalAnnotation must not be null");
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.findExternalAnnotation must not be null");
        }
        List<AnnotationData> list = this.collectExternalAnnotations(listOwner);
        AnnotationData data = BaseExternalAnnotationsManager.findByFQN(list, annotationFQN);
        return data == null ? null : data.getAnnotation(this);
    }

    @Override
    public boolean isExternalAnnotationWritable(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.isExternalAnnotationWritable must not be null");
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.isExternalAnnotationWritable must not be null");
        }
        List<AnnotationData> map = this.doCollect(listOwner, true);
        return BaseExternalAnnotationsManager.findByFQN(map, annotationFQN) != null;
    }

    private static AnnotationData findByFQN(@NotNull List<AnnotationData> map, final @NotNull String annotationFQN) {
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.findByFQN must not be null");
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.findByFQN must not be null");
        }
        return ContainerUtil.find(map, new Condition<AnnotationData>(){

            @Override
            public boolean value(AnnotationData data) {
                return data.annotationClassFqName.equals(annotationFQN);
            }
        });
    }

    @Override
    @Nullable
    public PsiAnnotation[] findExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.findExternalAnnotations must not be null");
        }
        List<AnnotationData> result = this.collectExternalAnnotations(listOwner);
        return result.isEmpty() ? null : ContainerUtil.map2Array(result, PsiAnnotation.EMPTY_ARRAY, new Function<AnnotationData, PsiAnnotation>(){

            @Override
            public PsiAnnotation fun(AnnotationData data) {
                return data.getAnnotation(BaseExternalAnnotationsManager.this);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<AnnotationData> collectExternalAnnotations(@NotNull PsiModifierListOwner listOwner) {
        List<AnnotationData> computed;
        List<AnnotationData> cached;
        List<AnnotationData> list;
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.collectExternalAnnotations must not be null");
        }
        if (!this.hasAnyAnnotationsRoots()) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.collectExternalAnnotations must not return null");
            return list;
        }
        do {
            if ((cached = (List<AnnotationData>)this.cache.get(listOwner)) != NO_DATA && cached.isEmpty()) continue;
            list = cached;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.collectExternalAnnotations must not return null");
            return list;
        } while (!this.cache.replace(listOwner, (Collection<AnnotationData>)cached, computed = this.doCollect(listOwner, false)));
        cached = computed;
        list = cached;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.collectExternalAnnotations must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private AnnotationData internAnnotationData(@NotNull AnnotationData data) {
        if (data == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.internAnnotationData must not be null");
        }
        Map<AnnotationData, AnnotationData> map = this.annotationDataCache;
        // MONITORENTER : map
        AnnotationData interned = this.annotationDataCache.get(data);
        if (interned == null) {
            this.annotationDataCache.put(data, data);
            interned = data;
        }
        AnnotationData annotationData = interned;
        // MONITOREXIT : map
        if (annotationData != null) return annotationData;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.internAnnotationData must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private MostlySingularMultiMap<String, AnnotationData> getDataFromFile(@NotNull PsiFile file) {
        MostlySingularMultiMap mostlySingularMultiMap;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.getDataFromFile must not be null");
        }
        Pair cached = (Pair)this.annotationFileToDataAndModStamp.get(file);
        long fileModificationStamp = file.getModificationStamp();
        if (cached != null && (Long)cached.getSecond() == fileModificationStamp) {
            mostlySingularMultiMap = (MostlySingularMultiMap)cached.getFirst();
            if (mostlySingularMultiMap == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.getDataFromFile must not return null");
            return mostlySingularMultiMap;
        }
        DataParsingSaxHandler handler = new DataParsingSaxHandler(file);
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(new InputSource(new StringReader(BaseExternalAnnotationsManager.escapeAttributes(file.getText()))), (DefaultHandler)handler);
        }
        catch (IOException e) {
            LOG.error(e);
        }
        catch (ParserConfigurationException e) {
            LOG.error(e);
        }
        catch (SAXException e) {
            LOG.error(e);
        }
        Pair<MostlySingularMultiMap<String, AnnotationData>, Long> pair = Pair.create(handler.getResult(), file.getModificationStamp());
        this.annotationFileToDataAndModStamp.put(file, pair);
        mostlySingularMultiMap = (MostlySingularMultiMap)pair.first;
        if (mostlySingularMultiMap != null) return mostlySingularMultiMap;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.getDataFromFile must not return null");
    }

    protected void duplicateError(@NotNull PsiFile file, @NotNull String externalName, @NotNull String text) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.duplicateError must not be null");
        }
        if (externalName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.duplicateError must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.duplicateError must not be null");
        }
        LOG.error(text + "; for signature: '" + externalName + "' in the file " + file.getVirtualFile().getPresentableUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private String intern(@NotNull String annotationFQN) {
        if (annotationFQN == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.intern must not be null");
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        String string = ((Object)this.charTable.doIntern(annotationFQN)).toString();
        // MONITOREXIT : charTableImpl
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.intern must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private List<AnnotationData> doCollect(@NotNull PsiModifierListOwner listOwner, boolean onlyWritable) {
        List<AnnotationData> list;
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.doCollect must not be null");
        }
        List<PsiFile> files = this.findExternalAnnotationsFiles(listOwner);
        if (files == null) {
            list = NO_DATA;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.doCollect must not return null");
            return list;
        }
        SmartList<AnnotationData> result = new SmartList<AnnotationData>();
        String externalName = BaseExternalAnnotationsManager.getExternalName(listOwner, false);
        if (externalName == null) {
            list = NO_DATA;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.doCollect must not return null");
            return list;
        }
        String oldExternalName = BaseExternalAnnotationsManager.getNormalizedExternalName(listOwner);
        for (PsiFile file : files) {
            if (!file.isValid() || onlyWritable && !file.isWritable()) continue;
            MostlySingularMultiMap<String, AnnotationData> fileData = this.getDataFromFile(file);
            this.addAnnotations(result, externalName, file, fileData);
            if (oldExternalName == null || externalName.equals(oldExternalName)) continue;
            this.addAnnotations(result, oldExternalName, file, fileData);
        }
        if (result.isEmpty()) {
            list = NO_DATA;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.doCollect must not return null");
            return list;
        }
        result.trimToSize();
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.doCollect must not return null");
    }

    private void addAnnotations(@NotNull List<AnnotationData> result, @NotNull String externalName, @NotNull PsiFile file, @NotNull MostlySingularMultiMap<String, AnnotationData> fileData) {
        if (result == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.addAnnotations must not be null");
        }
        if (externalName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.addAnnotations must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.addAnnotations must not be null");
        }
        if (fileData == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.addAnnotations must not be null");
        }
        Iterable<AnnotationData> data = fileData.get(externalName);
        for (AnnotationData ad : data) {
            if (result.contains(ad)) {
                if (!Comparing.equal(ad.virtualFile, file.getVirtualFile())) continue;
                this.duplicateError(file, externalName, "Duplicate signature");
                continue;
            }
            result.add(ad);
        }
    }

    @Override
    @Nullable
    public List<PsiFile> findExternalAnnotationsFiles(@NotNull PsiModifierListOwner listOwner) {
        SmartList<PsiFile> result;
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.findExternalAnnotationsFiles must not be null");
        }
        PsiFile containingFile = listOwner.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        String packageName = javaFile.getPackageName();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        String fqn = BaseExternalAnnotationsManager.getFQN(packageName, containingFile);
        if (fqn == null) {
            return null;
        }
        List files = (List)this.myExternalAnnotations.get(fqn);
        if (files == NULL_LIST) {
            return null;
        }
        if (files != null) {
            boolean allValid = true;
            for (PsiFile file : files) {
                allValid &= file.isValid();
            }
            if (allValid) {
                return files;
            }
        }
        if (virtualFile == null) {
            return null;
        }
        THashSet<PsiFile> possibleAnnotationsXmls = new THashSet<PsiFile>();
        for (VirtualFile root : this.getExternalAnnotationsRoots(virtualFile)) {
            PsiFile psiFile;
            VirtualFile ext = root.findFileByRelativePath(packageName.replace('.', '/') + "/" + "annotations.xml");
            if (ext == null || (psiFile = this.myPsiManager.findFile(ext)) == null) continue;
            possibleAnnotationsXmls.add(psiFile);
        }
        if (possibleAnnotationsXmls.isEmpty()) {
            this.myExternalAnnotations.put(fqn, NULL_LIST);
            result = null;
        } else {
            result = new SmartList<PsiFile>(possibleAnnotationsXmls);
            Collections.sort(result, new Comparator<PsiFile>(){

                @Override
                public int compare(PsiFile f1, PsiFile f2) {
                    boolean w2;
                    boolean w1 = f1.isWritable();
                    if (w1 == (w2 = f2.isWritable())) {
                        return 0;
                    }
                    return w1 ? -1 : 1;
                }
            });
            this.myExternalAnnotations.put(fqn, result);
        }
        return result;
    }

    @NotNull
    protected abstract List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile var1);

    protected void dropCache() {
        this.myExternalAnnotations.clear();
        this.annotationFileToDataAndModStamp.clear();
        this.cache.clear();
    }

    @NotNull
    private static String escapeAttributes(@NotNull String invalidXml) {
        if (invalidXml == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.escapeAttributes must not be null");
        }
        StringBuilder buf = new StringBuilder(invalidXml.length());
        boolean inAttribute = false;
        for (int i = 0; i < invalidXml.length(); ++i) {
            char c = invalidXml.charAt(i);
            if (inAttribute && c == '<') {
                buf.append("&lt;");
                continue;
            }
            if (inAttribute && c == '>') {
                buf.append("&gt;");
                continue;
            }
            if (c == '\"' || c == '\'') {
                buf.append('\"');
                inAttribute = !inAttribute;
                continue;
            }
            buf.append(c);
        }
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.escapeAttributes must not return null");
        }
        return string;
    }

    @Override
    public void annotateExternally(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, @NotNull PsiFile fromFile, @Nullable PsiNameValuePair[] value) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.annotateExternally must not be null");
        }
        if (annotationFQName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.annotateExternally must not be null");
        }
        if (fromFile == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.annotateExternally must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean deannotate(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.deannotate must not be null");
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.deannotate must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean editExternalAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, @Nullable PsiNameValuePair[] value) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.editExternalAnnotation must not be null");
        }
        if (annotationFQN == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.editExternalAnnotation must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ExternalAnnotationsManager.AnnotationPlace chooseAnnotationsPlace(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.chooseAnnotationsPlace must not be null");
        }
        throw new UnsupportedOperationException();
    }

    protected void cacheExternalAnnotations(@NotNull String packageName, @NotNull PsiFile fromFile, @NotNull List<PsiFile> annotationFiles) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.cacheExternalAnnotations must not be null");
        }
        if (fromFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.cacheExternalAnnotations must not be null");
        }
        if (annotationFiles == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.cacheExternalAnnotations must not be null");
        }
        String fqn = BaseExternalAnnotationsManager.getFQN(packageName, fromFile);
        if (fqn != null) {
            this.myExternalAnnotations.put(fqn, annotationFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private PsiAnnotation createAnnotationFromText(@NotNull String text) throws IncorrectOperationException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager.createAnnotationFromText must not be null");
        }
        CharTableImpl charTableImpl = this.charTable;
        // MONITORENTER : charTableImpl
        DummyHolder holder = DummyHolderFactory.createHolder(this.myPsiManager, new JavaDummyElement(text, ANNOTATION, LanguageLevel.HIGHEST), null, this.charTable);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotation)) {
            throw new IncorrectOperationException("Incorrect annotation \"" + text + "\".");
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)element;
        // MONITOREXIT : charTableImpl
        if (psiAnnotation != null) return psiAnnotation;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager.createAnnotationFromText must not return null");
    }

    private class DataParsingSaxHandler
    extends DefaultHandler {
        private final MostlySingularMultiMap<String, AnnotationData> data = new MostlySingularMultiMap();
        private final PsiFile file;
        private String externalName = null;
        private String annotationFQN = null;
        private StringBuilder arguments = null;

        private DataParsingSaxHandler(PsiFile file) {
            this.file = file;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("item".equals(qName)) {
                this.externalName = attributes.getValue("name");
            } else if ("annotation".equals(qName)) {
                this.annotationFQN = attributes.getValue("name");
                this.arguments = new StringBuilder();
            } else if ("val".equals(qName)) {
                String name;
                if (this.arguments.length() != 0) {
                    this.arguments.append(",");
                }
                if ((name = attributes.getValue("name")) != null) {
                    this.arguments.append(name);
                    this.arguments.append("=");
                }
                this.arguments.append(attributes.getValue("val"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("item".equals(qName)) {
                this.externalName = null;
            } else if ("annotation".equals(qName) && this.externalName != null && this.annotationFQN != null) {
                String argumentsString = this.arguments.length() == 0 ? "" : BaseExternalAnnotationsManager.this.intern(this.arguments.toString());
                for (AnnotationData existingData : this.data.get(this.externalName)) {
                    if (!existingData.annotationClassFqName.equals(this.annotationFQN)) continue;
                    BaseExternalAnnotationsManager.this.duplicateError(this.file, this.externalName, "Duplicate annotation '" + this.annotationFQN + "' ");
                }
                AnnotationData annData = BaseExternalAnnotationsManager.this.internAnnotationData(new AnnotationData(this.annotationFQN, argumentsString, this.file.getVirtualFile()));
                this.data.add(this.externalName, annData);
                this.annotationFQN = null;
                this.arguments = null;
            }
        }

        public MostlySingularMultiMap<String, AnnotationData> getResult() {
            if (this.data.isEmpty()) {
                return MostlySingularMultiMap.emptyMap();
            }
            this.data.compact();
            return this.data;
        }
    }

    private static class AnnotationData {
        @NotNull
        private final String annotationClassFqName;
        @NotNull
        private final String annotationParameters;
        private final VirtualFile virtualFile;
        private PsiAnnotation annotation;

        private AnnotationData(@NotNull String annotationClassFqName, @NotNull String annotationParameters, VirtualFile virtualFile) {
            if (annotationClassFqName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData.<init> must not be null");
            }
            if (annotationParameters == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData.<init> must not be null");
            }
            this.annotationClassFqName = annotationClassFqName;
            this.annotationParameters = annotationParameters;
            this.virtualFile = virtualFile;
        }

        @NotNull
        private PsiAnnotation getAnnotation(@NotNull BaseExternalAnnotationsManager context) {
            if (context == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData.getAnnotation must not be null");
            }
            PsiAnnotation a = this.annotation;
            if (a == null) {
                this.annotation = a = context.createAnnotationFromText("@" + this.annotationClassFqName + (this.annotationParameters.isEmpty() ? "" : "(" + this.annotationParameters + ")"));
            }
            PsiAnnotation psiAnnotation = a;
            if (psiAnnotation == null) {
                throw new IllegalStateException("@NotNull method com/intellij/codeInsight/BaseExternalAnnotationsManager$AnnotationData.getAnnotation must not return null");
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnnotationData data = (AnnotationData)o;
            return this.annotationClassFqName.equals(data.annotationClassFqName) && this.annotationParameters.equals(data.annotationParameters);
        }

        public int hashCode() {
            int result = this.annotationClassFqName.hashCode();
            result = 31 * result + this.annotationParameters.hashCode();
            return result;
        }
    }
}

