/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.PsiCoreCommentImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NotNull;

public class CoreASTFactory
extends ASTFactory
implements DefaultASTFactory {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LazyParseableElement createLazy(ILazyParseableElementType type, CharSequence text) {
        LazyParseableElement lazyParseableElement;
        if (type instanceof IFileElementType) {
            lazyParseableElement = new FileElement(type, text);
            if (lazyParseableElement == null) throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createLazy must not return null");
            return lazyParseableElement;
        }
        lazyParseableElement = new LazyParseableElement(type, text);
        if (lazyParseableElement != null) return lazyParseableElement;
        throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createLazy must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CompositeElement createComposite(IElementType type) {
        CompositeElement compositeElement;
        if (type instanceof IFileElementType) {
            compositeElement = new FileElement(type, null);
            if (compositeElement == null) throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createComposite must not return null");
            return compositeElement;
        }
        compositeElement = new CompositeElement(type);
        if (compositeElement != null) return compositeElement;
        throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createComposite must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public LeafElement createLeaf(IElementType type, CharSequence text) {
        LeafElement leafElement;
        Language lang = type.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null && parserDefinition.getCommentTokens().contains(type)) {
            leafElement = this.createComment(type, text);
            if (leafElement == null) throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createLeaf must not return null");
            return leafElement;
        }
        leafElement = new LeafPsiElement(type, text);
        if (leafElement != null) return leafElement;
        throw new IllegalStateException("@NotNull method com/intellij/core/CoreASTFactory.createLeaf must not return null");
    }

    @Override
    public LeafElement createComment(IElementType type, CharSequence text) {
        return new PsiCoreCommentImpl(type, text);
    }
}

