/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.openapi.extensions.EPAvailabilityListenerExtension;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAvailabilityListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LogProvider;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.AreaPicoContainerImpl;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.UndefinedPluginDescriptor;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;

public class ExtensionsAreaImpl
implements ExtensionsArea {
    private final LogProvider myLogger;
    private static final Map<String, String> ourDefaultEPs = new HashMap<String, String>();
    private final AreaPicoContainerImpl myPicoContainer;
    private final Throwable myCreationTrace;
    private final Map<String, ExtensionPointImpl> myExtensionPoints;
    private final Map<String, Throwable> myEPTraces;
    private final MultiMap<String, ExtensionPointAvailabilityListener> myAvailabilityListeners;
    private final List<Runnable> mySuspendedListenerActions;
    private boolean myAvailabilityNotificationsActive;
    private final AreaInstance myAreaInstance;
    private final String myAreaClass;
    private final Map<Element, ExtensionComponentAdapter> myExtensionElement2extension;

    public ExtensionsAreaImpl(String areaClass, AreaInstance areaInstance, PicoContainer parentPicoContainer, @NotNull LogProvider logger) {
        if (logger == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.<init> must not be null");
        }
        this.myExtensionPoints = new ConcurrentHashMap<String, ExtensionPointImpl>();
        this.myEPTraces = null;
        this.myAvailabilityListeners = new MultiMap();
        this.mySuspendedListenerActions = new ArrayList<Runnable>();
        this.myAvailabilityNotificationsActive = true;
        this.myExtensionElement2extension = new HashMap<Element, ExtensionComponentAdapter>();
        this.myCreationTrace = null;
        this.myAreaClass = areaClass;
        this.myAreaInstance = areaInstance;
        this.myPicoContainer = new AreaPicoContainerImpl(parentPicoContainer, areaInstance);
        this.myLogger = logger;
        this.initialize();
    }

    public final void notifyAreaReplaced() {
        for (ExtensionPointImpl point : this.myExtensionPoints.values()) {
            point.notifyAreaReplaced(this);
        }
    }

    @Override
    @NotNull
    public AreaPicoContainer getPicoContainer() {
        AreaPicoContainerImpl areaPicoContainerImpl = this.myPicoContainer;
        if (areaPicoContainerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.getPicoContainer must not return null");
        }
        return areaPicoContainerImpl;
    }

    MutablePicoContainer getMutablePicoContainer() {
        return this.myPicoContainer;
    }

    @Override
    public String getAreaClass() {
        return this.myAreaClass;
    }

    private void initialize() {
        for (Map.Entry<String, String> entry : ourDefaultEPs.entrySet()) {
            String epName = entry.getKey();
            this.registerExtensionPoint(epName, entry.getValue());
        }
        ((ExtensionPointImpl)this.getExtensionPoint("com.intellij.openapi.extensions.epAvailabilityListener")).addExtensionPointListener(new ExtensionPointListener(){

            public void extensionRemoved(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1.extensionRemoved must not be null");
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                Collection listeners = ExtensionsAreaImpl.this.myAvailabilityListeners.get(epListenerExtension.getExtensionPointName());
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)iterator.next();
                    if (!listener.getClass().getName().equals(epListenerExtension.getListenerClass())) continue;
                    iterator.remove();
                    return;
                }
                ExtensionsAreaImpl.this.myLogger.warn("Failed to find EP availability listener: " + epListenerExtension.getListenerClass());
            }

            public void extensionAdded(@NotNull Object extension, PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl$1.extensionAdded must not be null");
                }
                EPAvailabilityListenerExtension epListenerExtension = (EPAvailabilityListenerExtension)extension;
                try {
                    String epName = epListenerExtension.getExtensionPointName();
                    ExtensionPointAvailabilityListener listener = (ExtensionPointAvailabilityListener)ExtensionsAreaImpl.this.instantiate(epListenerExtension.loadListenerClass());
                    ExtensionsAreaImpl.this.addAvailabilityListener(epName, listener);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private Object instantiate(Class clazz) {
        ConstructorInjectionComponentAdapter adapter = new ConstructorInjectionComponentAdapter(Integer.toString(System.identityHashCode(new Object())), clazz);
        return adapter.getComponentInstance(this.getPicoContainer());
    }

    public void addAvailabilityListener(@NotNull String extensionPointName, @NotNull ExtensionPointAvailabilityListener listener) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.addAvailabilityListener must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.addAvailabilityListener must not be null");
        }
        this.myAvailabilityListeners.putValue(extensionPointName, listener);
        if (this.hasExtensionPoint(extensionPointName)) {
            this.notifyAvailableListener(listener, this.myExtensionPoints.get(extensionPointName));
        }
    }

    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, ExtensionPoint.Kind.INTERFACE);
    }

    @Override
    public void registerExtensionPoint(@NotNull @NonNls String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        if (kind == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        this.registerExtensionPoint(extensionPointName, extensionPointBeanClass, new UndefinedPluginDescriptor(), kind);
    }

    private void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull PluginDescriptor descriptor, @NotNull ExtensionPoint.Kind kind) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        if (extensionPointBeanClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        if (kind == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        if (this.hasExtensionPoint(extensionPointName)) {
            throw new RuntimeException("Duplicate registration for EP: " + extensionPointName);
        }
        this.registerExtensionPoint(new ExtensionPointImpl(extensionPointName, extensionPointBeanClass, kind, this, this.myAreaInstance, this.myLogger, descriptor));
    }

    public void registerExtensionPoint(@NotNull ExtensionPointImpl extensionPoint) {
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.registerExtensionPoint must not be null");
        }
        String name = extensionPoint.getName();
        this.myExtensionPoints.put(name, extensionPoint);
        this.notifyEPRegistered(extensionPoint);
    }

    private void notifyEPRegistered(ExtensionPoint extensionPoint) {
        Collection<ExtensionPointAvailabilityListener> listeners = this.myAvailabilityListeners.get(extensionPoint.getName());
        for (ExtensionPointAvailabilityListener listener : listeners) {
            this.notifyAvailableListener(listener, extensionPoint);
        }
    }

    private void notifyAvailableListener(final ExtensionPointAvailabilityListener listener, final ExtensionPoint extensionPoint) {
        this.queueNotificationAction(new Runnable(){

            @Override
            public void run() {
                listener.extensionPointRegistered(extensionPoint);
            }
        });
    }

    private void queueNotificationAction(Runnable action) {
        if (this.myAvailabilityNotificationsActive) {
            action.run();
        } else {
            this.mySuspendedListenerActions.add(action);
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.getExtensionPoint must not be null");
        }
        ExtensionPointImpl extensionPoint = this.myExtensionPoints.get(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in area " + this.myAreaInstance);
        }
        ExtensionPointImpl extensionPointImpl = extensionPoint;
        if (extensionPointImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.getExtensionPoint must not return null");
        }
        return extensionPointImpl;
    }

    @Override
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.getExtensionPoint must not be null");
        }
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        if (extensionPointName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.hasExtensionPoint must not be null");
        }
        return this.myExtensionPoints.containsKey(extensionPointName);
    }

    @NotNull
    public MutablePicoContainer[] getPluginContainers() {
        MutablePicoContainer[] mutablePicoContainerArray = new MutablePicoContainer[]{};
        if (mutablePicoContainerArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/extensions/impl/ExtensionsAreaImpl.getPluginContainers must not return null");
        }
        return mutablePicoContainerArray;
    }

    static {
        ourDefaultEPs.put("com.intellij.openapi.extensions.epAvailabilityListener", EPAvailabilityListenerExtension.class.getName());
    }
}

