/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;

public class JDOMUtil {
    private static final ThreadLocal<SoftReference<SAXBuilder>> ourSaxBuilder = new ThreadLocal();
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    @NotNull
    public static Object[] getChildNodesWithAttrs(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.getChildNodesWithAttrs must not be null");
        }
        ArrayList<Cloneable> result = new ArrayList<Cloneable>();
        result.addAll(e.getContent());
        result.addAll(e.getAttributes());
        Object[] objectArray = ArrayUtil.toObjectArray(result);
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getChildNodesWithAttrs must not return null");
        }
        return objectArray;
    }

    @NotNull
    public static Content[] getContent(@NotNull Element m) {
        if (m == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.getContent must not be null");
        }
        List<Content> list = m.getContent();
        Content[] contentArray = list.toArray(new Content[list.size()]);
        if (contentArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.getContent must not return null");
        }
        return contentArray;
    }

    @NotNull
    public static String concatTextNodesValues(@NotNull Object[] nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/util/JDOMUtil.concatTextNodesValues must not be null");
        }
        StringBuilder result = new StringBuilder();
        for (Object node : nodes) {
            result.append(((Content)node).getValue());
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/util/JDOMUtil.concatTextNodesValues must not return null");
        }
        return string;
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    private static class EmptyTextFilter
    implements Filter {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            if (obj instanceof Text) {
                Text t = (Text)obj;
                return !CharArrayUtil.containsOnlyWhiteSpaces(t.getText());
            }
            return true;
        }
    }
}

