/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InitialPatternCondition<T> {
    private final Class<T> myAcceptedClass;

    protected InitialPatternCondition(@NotNull Class<T> aAcceptedClass) {
        if (aAcceptedClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/InitialPatternCondition.<init> must not be null");
        }
        this.myAcceptedClass = aAcceptedClass;
    }

    @NotNull
    public Class<T> getAcceptedClass() {
        Class<T> clazz = this.myAcceptedClass;
        if (clazz == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/InitialPatternCondition.getAcceptedClass must not return null");
        }
        return clazz;
    }

    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        return this.myAcceptedClass.isInstance(o);
    }

    @NonNls
    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    public void append(@NonNls @NotNull StringBuilder builder, String indent) {
        if (builder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/InitialPatternCondition.append must not be null");
        }
        builder.append("instanceOf(").append(this.myAcceptedClass.getSimpleName()).append(")");
    }
}

