/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeImpl
extends PsiDiamondType {
    private final PsiManager myManager;
    private final PsiTypeElement myTypeElement;
    private static final Logger LOG = Logger.getInstance("#" + PsiDiamondTypeImpl.class.getName());

    public PsiDiamondTypeImpl(PsiManager manager, PsiTypeElement psiTypeElement) {
        super(PsiAnnotation.EMPTY_ARRAY);
        this.myManager = manager;
        this.myTypeElement = psiTypeElement;
    }

    @Override
    public String getPresentableText() {
        return "";
    }

    @Override
    public String getCanonicalText() {
        return "";
    }

    @Override
    public String getInternalCanonicalText() {
        return "Diamond Type";
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public boolean equalsToText(@NonNls String text) {
        return text != null && text.isEmpty();
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiDiamondTypeImpl.accept must not be null");
        }
        return visitor.visitDiamondType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return GlobalSearchScope.allScope(this.myManager.getProject());
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{PsiDiamondTypeImpl.getJavaLangObject(this.myManager, this.getResolveScope())};
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiDiamondTypeImpl.getSuperTypes must not return null");
        }
        return psiTypeArray;
    }

    @Override
    public PsiDiamondType.DiamondInferenceResult resolveInferredTypes() {
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType((PsiElement)this.myTypeElement, PsiNewExpression.class);
        if (newExpression == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression) {
        return PsiDiamondTypeImpl.resolveInferredTypes(newExpression, newExpression);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypes(PsiNewExpression newExpression, PsiElement context) {
        PsiElement resolve;
        PsiAnonymousClass anonymousClass = newExpression.getAnonymousClass();
        if (anonymousClass != null && (resolve = anonymousClass.getBaseClassReference().resolve()) instanceof PsiClass) {
            return PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT;
        }
        PsiReferenceParameterList referenceParameterList = PsiTreeUtil.getChildOfType(newExpression, PsiReferenceParameterList.class);
        if (referenceParameterList != null && referenceParameterList.getTypeParameterElements().length > 0) {
            return PsiDiamondType.DiamondInferenceResult.EXPLICIT_CONSTRUCTOR_TYPE_ARGS;
        }
        return PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, context);
    }

    public static PsiDiamondType.DiamondInferenceResult resolveInferredTypesNoCheck(final PsiNewExpression newExpression, final PsiElement context) {
        final PsiClass psiClass = PsiDiamondTypeImpl.findClass(newExpression);
        if (psiClass == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        final Ref staticFactoryRef = new Ref();
        PsiSubstitutor inferredSubstitutor = ourDiamondGuard.doPreventingRecursion(newExpression, false, new Computable<PsiSubstitutor>(){

            @Override
            public PsiSubstitutor compute() {
                PsiTypeParameter[] params;
                PsiMethod constructor = PsiDiamondTypeImpl.findConstructor(psiClass, newExpression);
                PsiMethod staticFactory = PsiDiamondTypeImpl.generateStaticFactory(constructor, psiClass, params = PsiDiamondTypeImpl.getAllTypeParams(constructor, psiClass));
                if (staticFactory == null) {
                    return null;
                }
                staticFactoryRef.set(staticFactory);
                return PsiDiamondTypeImpl.inferTypeParametersForStaticFactory(staticFactory, newExpression, context);
            }
        });
        if (inferredSubstitutor == null) {
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiMethod staticFactory = (PsiMethod)staticFactoryRef.get();
        if (staticFactory == null) {
            LOG.error(inferredSubstitutor);
            return PsiDiamondType.DiamondInferenceResult.NULL_RESULT;
        }
        PsiTypeParameter[] parameters = staticFactory.getTypeParameters();
        PsiTypeParameter[] classParameters = psiClass.getTypeParameters();
        PsiJavaCodeReferenceElement classOrAnonymousClassReference = newExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(classOrAnonymousClassReference != null);
        PsiDiamondType.DiamondInferenceResult result = new PsiDiamondType.DiamondInferenceResult(classOrAnonymousClassReference.getReferenceName() + "<>", newExpression.getProject());
        block0: for (PsiTypeParameter parameter : parameters) {
            for (PsiTypeParameter classParameter : classParameters) {
                if (!Comparing.strEqual(classParameter.getName(), parameter.getName())) continue;
                result.addInferredType(inferredSubstitutor.substitute(parameter));
                continue block0;
            }
        }
        return result;
    }

    @Nullable
    private static PsiMethod findConstructor(PsiClass containingClass, PsiNewExpression newExpression) {
        PsiExpressionList argumentList = newExpression.getArgumentList();
        Project project = newExpression.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        JavaResolveResult result = resolveHelper.resolveConstructor(facade.getElementFactory().createType(containingClass), argumentList, argumentList);
        return (PsiMethod)result.getElement();
    }

    @Nullable
    private static PsiClass findClass(PsiNewExpression newExpression) {
        PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
        if (classReference != null) {
            String text = classReference.getReferenceName();
            if (text != null) {
                PsiClass aClass;
                Project project = newExpression.getProject();
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                PsiResolveHelper resolveHelper = facade.getResolveHelper();
                PsiExpression newExpressionQualifier = newExpression.getQualifier();
                PsiElement qualifierElement = classReference.getQualifier();
                String qualifier = qualifierElement != null ? qualifierElement.getText() : "";
                String qualifiedName = StringUtil.getQualifiedName(qualifier, text);
                if (newExpressionQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly(newExpressionQualifier.getType())) != null) {
                    return aClass.findInnerClassByName(qualifiedName, false);
                }
                return resolveHelper.resolveReferencedClass(qualifiedName, newExpression);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiMethod generateStaticFactory(@Nullable PsiMethod constructor, PsiClass containingClass, PsiTypeParameter[] params) {
        StringBuilder buf = new StringBuilder();
        buf.append("public static ");
        buf.append("<");
        buf.append(StringUtil.join(params, new Function<PsiTypeParameter, String>(){

            @Override
            public String fun(PsiTypeParameter psiTypeParameter) {
                String extendsList = psiTypeParameter.getLanguage().isKindOf(JavaLanguage.INSTANCE) ? psiTypeParameter.getExtendsList().getText() : null;
                return psiTypeParameter.getName() + (StringUtil.isEmpty(extendsList) ? "" : " " + extendsList);
            }
        }, ", "));
        buf.append(">");
        String qualifiedName = containingClass.getQualifiedName();
        buf.append(qualifiedName != null ? qualifiedName : containingClass.getName());
        PsiTypeParameter[] parameters = containingClass.getTypeParameters();
        buf.append("<");
        buf.append(StringUtil.join(parameters, new Function<PsiTypeParameter, String>(){

            @Override
            public String fun(PsiTypeParameter psiTypeParameter) {
                return psiTypeParameter.getName();
            }
        }, ", "));
        buf.append("> ");
        String staticFactoryName = "staticFactory";
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance(containingClass.getProject());
        staticFactoryName = styleManager.suggestUniqueVariableName(staticFactoryName, (PsiElement)containingClass, false);
        buf.append(staticFactoryName);
        if (constructor == null) {
            buf.append("()");
        } else {
            buf.append("(").append(StringUtil.join(constructor.getParameterList().getParameters(), new Function<PsiParameter, String>(){
                int myIdx = 0;

                @Override
                public String fun(PsiParameter psiParameter) {
                    return psiParameter.getType().getCanonicalText() + " p" + this.myIdx++;
                }
            }, ",")).append(")");
        }
        buf.append("{}");
        return JavaPsiFacade.getElementFactory(containingClass.getProject()).createMethodFromText(buf.toString(), constructor != null ? constructor : containingClass);
    }

    private static PsiTypeParameter[] getAllTypeParams(PsiTypeParameterListOwner listOwner, PsiClass containingClass) {
        LinkedHashSet params = new LinkedHashSet();
        if (listOwner != null) {
            Collections.addAll(params, listOwner.getTypeParameters());
        }
        Collections.addAll(params, containingClass.getTypeParameters());
        return params.toArray(new PsiTypeParameter[params.size()]);
    }

    private static PsiSubstitutor inferTypeParametersForStaticFactory(@NotNull PsiMethod staticFactoryMethod, PsiNewExpression expression, PsiElement parent) {
        if (staticFactoryMethod == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiDiamondTypeImpl.inferTypeParametersForStaticFactory must not be null");
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance(staticFactoryMethod.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiParameter[] parameters = staticFactoryMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = expression.getArgumentList();
        PsiExpression[] expressions = argumentList.getExpressions();
        return resolveHelper.inferTypeArguments(staticFactoryMethod.getTypeParameters(), parameters, expressions, PsiSubstitutor.EMPTY, parent, DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public static boolean hasDefaultConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] constructors;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiDiamondTypeImpl.hasDefaultConstructor must not be null");
        }
        for (PsiMethod method : constructors = psiClass.getConstructors()) {
            if (method.getParameterList().getParametersCount() != 0) continue;
            return true;
        }
        return constructors.length == 0;
    }

    public static boolean haveConstructorsGenericsParameters(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiDiamondTypeImpl.haveConstructorsGenericsParameters must not be null");
        }
        for (final PsiMethod method : psiClass.getConstructors()) {
            for (PsiParameter parameter : method.getParameterList().getParameters()) {
                PsiType type = parameter.getType();
                Boolean accept = type.accept(new PsiTypeVisitor<Boolean>(){

                    @Override
                    public Boolean visitArrayType(PsiArrayType arrayType) {
                        return arrayType.getComponentType().accept(this);
                    }

                    @Override
                    public Boolean visitClassType(PsiClassType classType) {
                        for (PsiType psiType : classType.getParameters()) {
                            Boolean typaParamFound;
                            if (psiType == null || (typaParamFound = psiType.accept(this)) == null || !typaParamFound.booleanValue()) continue;
                            return true;
                        }
                        PsiClass aClass = PsiUtil.resolveClassInType(classType);
                        return aClass instanceof PsiTypeParameter && ((PsiTypeParameter)aClass).getOwner() == method;
                    }

                    @Override
                    public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                        PsiType bound = wildcardType.getBound();
                        if (bound == null) {
                            return false;
                        }
                        return bound.accept(this);
                    }
                });
                if (accept == null || !accept.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }
}

