/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.file.exclude.ProjectFileExclusionManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.ContentBasedFileSubstitutor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.PsiLargeFileImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionCache;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleRootFileViewProvider
extends UserDataHolderBase
implements FileViewProvider {
    private static final Key<Boolean> OUR_NO_SIZE_LIMIT_KEY = Key.create("no.size.limit");
    private static final Logger LOG = Logger.getInstance("#" + SingleRootFileViewProvider.class.getCanonicalName());
    @NotNull
    private final PsiManager myManager;
    @NotNull
    private final VirtualFile myVirtualFile;
    private final boolean myEventSystemEnabled;
    private final boolean myPhysical;
    private final AtomicReference<PsiFile> myPsiFile;
    private volatile Content myContent;
    private volatile SoftReference<Document> myDocument;
    @NotNull
    private final Language myBaseLanguage;
    private final ProjectFileExclusionManager myExclusionManager;

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        this(manager, file, true);
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        this(manager, virtualFile, physical, SingleRootFileViewProvider.calcBaseLanguage(virtualFile, manager.getProject()));
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean physical, @NotNull Language language) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.<init> must not be null");
        }
        this.myPsiFile = new AtomicReference();
        this.myManager = manager;
        this.myVirtualFile = virtualFile;
        this.myEventSystemEnabled = physical;
        this.myBaseLanguage = language;
        this.setContent(new VirtualFileContent());
        this.myPhysical = this.isEventSystemEnabled() && !(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem);
        this.myExclusionManager = ProjectFileExclusionManager.SERVICE.getInstance(manager.getProject());
    }

    @Override
    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getBaseLanguage must not return null");
        }
        return language;
    }

    private static Language calcBaseLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        ContentBasedFileSubstitutor[] processors;
        Language language;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.calcBaseLanguage must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.calcBaseLanguage must not be null");
        }
        if (file instanceof LightVirtualFile && (language = ((LightVirtualFile)file).getLanguage()) != null) {
            return language;
        }
        FileType fileType = file.getFileType();
        if (fileType == UnknownFileType.INSTANCE) {
            fileType = FileTypeRegistry.getInstance().detectFileTypeFromContent(file);
        }
        if (fileType.isBinary()) {
            return Language.ANY;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file)) {
            return PlainTextLanguage.INSTANCE;
        }
        if (fileType instanceof LanguageFileType) {
            return LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), file, project);
        }
        for (ContentBasedFileSubstitutor processor : processors = Extensions.getExtensions(ContentBasedFileSubstitutor.EP_NAME)) {
            Language language2 = processor.obtainLanguageForFile(file);
            if (language2 == null) continue;
            return language2;
        }
        return PlainTextLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set = Collections.singleton(this.getBaseLanguage());
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getLanguages must not return null");
        }
        return set;
    }

    @Override
    @Nullable
    public final PsiFile getPsi(@NotNull Language target) {
        VirtualFile virtualFile;
        FileManager fileManager;
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.getPsi must not be null");
        }
        if (!this.isPhysical() && (fileManager = ((PsiManagerEx)this.myManager).getFileManager()).findCachedViewProvider(virtualFile = this.getVirtualFile()) == null) {
            fileManager.setViewProvider(virtualFile, this);
        }
        return this.getPsiInner(target);
    }

    @Override
    @NotNull
    public List<PsiFile> getAllFiles() {
        List<PsiFile> list = ContainerUtil.createMaybeSingletonList(this.getPsi(this.getBaseLanguage()));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getAllFiles must not return null");
        }
        return list;
    }

    @Nullable
    protected PsiFile getPsiInner(@NotNull Language target) {
        boolean set;
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.getPsiInner must not be null");
        }
        if (target != this.getBaseLanguage()) {
            return null;
        }
        PsiFile psiFile = this.myPsiFile.get();
        if (psiFile == null && !(set = this.myPsiFile.compareAndSet(null, psiFile = this.createFile()))) {
            psiFile = this.myPsiFile.get();
        }
        return psiFile;
    }

    @Override
    public void beforeContentsSynchronized() {
        this.unsetPsiContent();
    }

    @Override
    public void contentsSynchronized() {
        this.unsetPsiContent();
    }

    private void unsetPsiContent() {
        if (!(this.myContent instanceof PsiFileContent)) {
            return;
        }
        Document cachedDocument = this.getCachedDocument();
        this.setContent(cachedDocument == null ? new VirtualFileContent() : new DocumentContent());
    }

    public void beforeDocumentChanged(@Nullable PsiFile psiCause) {
        PsiFile psiFile;
        PsiFile psiFile2 = psiFile = psiCause != null ? psiCause : this.getPsi(this.getBaseLanguage());
        if (psiFile instanceof PsiFileImpl) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, psiCause == null ? this.getModificationStamp() : LocalTimeCounter.currentTime()));
        }
    }

    @Override
    public void rootChanged(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.rootChanged must not be null");
        }
        if (psiFile instanceof PsiFileImpl && ((PsiFileImpl)psiFile).isContentsLoaded()) {
            this.setContent(new PsiFileContent((PsiFileImpl)psiFile, LocalTimeCounter.currentTime()));
        }
    }

    @Override
    public boolean isEventSystemEnabled() {
        return this.myEventSystemEnabled;
    }

    @Override
    public boolean isPhysical() {
        return this.myPhysical;
    }

    @Override
    public long getModificationStamp() {
        return this.getContent().getModificationStamp();
    }

    @Override
    public boolean supportsIncrementalReparse(@NotNull Language rootLanguage) {
        if (rootLanguage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.supportsIncrementalReparse must not be null");
        }
        return true;
    }

    public PsiFile getCachedPsi(Language target) {
        return this.myPsiFile.get();
    }

    public FileElement[] getKnownTreeRoots() {
        PsiFile psiFile = this.myPsiFile.get();
        if (psiFile == null || !(psiFile instanceof PsiFileImpl)) {
            return new FileElement[0];
        }
        if (((PsiFileImpl)psiFile).getTreeElement() == null) {
            return new FileElement[0];
        }
        return new FileElement[]{(FileElement)psiFile.getNode()};
    }

    private PsiFile createFile() {
        try {
            VirtualFile vFile = this.getVirtualFile();
            if (vFile.isDirectory()) {
                return null;
            }
            if (this.isIgnored()) {
                return null;
            }
            Project project = this.myManager.getProject();
            if (this.isPhysical()) {
                FileIndexFacade indexFacade;
                VirtualFile parent = vFile.getParent();
                if (parent == null) {
                    return null;
                }
                PsiDirectory psiDir = this.getManager().findDirectory(parent);
                if (psiDir == null && !(indexFacade = FileIndexFacade.getInstance(project)).isInLibrarySource(vFile) && !indexFacade.isInLibraryClasses(vFile)) {
                    return null;
                }
            }
            FileType fileType = vFile.getFileType();
            return this.createFile(project, vFile, fileType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    protected boolean isIgnored() {
        VirtualFile file = this.getVirtualFile();
        if (file instanceof LightVirtualFile) {
            return false;
        }
        if (this.myExclusionManager != null && this.myExclusionManager.isExcluded(file)) {
            return true;
        }
        return FileTypeRegistry.getInstance().isFileIgnored(file);
    }

    @Nullable
    protected PsiFile createFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileType fileType) {
        PsiFile psiFile;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.createFile must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.createFile must not be null");
        }
        if (fileType == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.createFile must not be null");
        }
        if (fileType.isBinary() || file.is(VFileProperty.SPECIAL)) {
            return new PsiBinaryFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        if (!SingleRootFileViewProvider.isTooLargeForIntelligence(file) && (psiFile = this.createFile(this.getBaseLanguage())) != null) {
            return psiFile;
        }
        if (SingleRootFileViewProvider.isTooLargeForContentLoading(file)) {
            return new PsiLargeFileImpl((PsiManagerImpl)this.getManager(), this);
        }
        return new PsiPlainTextFileImpl(this);
    }

    @Deprecated
    public static boolean isTooLarge(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.isTooLarge must not be null");
        }
        return SingleRootFileViewProvider.isTooLargeForIntelligence(vFile);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.isTooLargeForIntelligence must not be null");
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.getMaxIntellisenseFileSize());
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.isTooLargeForContentLoading must not be null");
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD);
    }

    private static boolean checkFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.checkFileSizeLimit must not be null");
        }
        return !Boolean.TRUE.equals(vFile.getUserData(OUR_NO_SIZE_LIMIT_KEY));
    }

    public static void doNotCheckFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.doNotCheckFileSizeLimit must not be null");
        }
        vFile.putUserData(OUR_NO_SIZE_LIMIT_KEY, Boolean.TRUE);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile, long contentSize) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.isTooLargeForIntelligence must not be null");
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return contentSize > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    private static boolean fileSizeIsGreaterThan(@NotNull VirtualFile vFile, long maxBytes) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.fileSizeIsGreaterThan must not be null");
        }
        if (vFile instanceof LightVirtualFile) {
            int lengthInChars = ((LightVirtualFile)vFile).getContent().length();
            if ((long)lengthInChars < maxBytes / 2L) {
                return false;
            }
            if ((long)lengthInChars > maxBytes) {
                return true;
            }
        }
        return vFile.getLength() > maxBytes;
    }

    @Nullable
    protected PsiFile createFile(@NotNull Language lang) {
        if (lang == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.createFile must not be null");
        }
        if (lang != this.getBaseLanguage()) {
            return null;
        }
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createFile(this);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getManager must not return null");
        }
        return psiManager;
    }

    @Override
    @NotNull
    public CharSequence getContents() {
        CharSequence charSequence = this.getContent().getText();
        if (charSequence == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getContents must not return null");
        }
        return charSequence;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getVirtualFile must not return null");
        }
        return virtualFile;
    }

    @Nullable
    private Document getCachedDocument() {
        Document document;
        Document document2 = document = this.myDocument != null ? this.myDocument.get() : null;
        if (document != null) {
            return document;
        }
        return FileDocumentManager.getInstance().getCachedDocument(this.getVirtualFile());
    }

    @Override
    public Document getDocument() {
        Document document;
        Document document2 = document = this.myDocument != null ? this.myDocument.get() : null;
        if (document == null) {
            document = FileDocumentManager.getInstance().getDocument(this.getVirtualFile());
            this.myDocument = new SoftReference<Document>(document);
        }
        if (document != null && this.getContent() instanceof VirtualFileContent) {
            this.setContent(new DocumentContent());
        }
        return document;
    }

    @Override
    public FileViewProvider clone() {
        VirtualFile origFile = this.getVirtualFile();
        LightVirtualFile copy = new LightVirtualFile(origFile.getName(), origFile.getFileType(), this.getContents(), origFile.getCharset(), this.getModificationStamp());
        copy.setOriginalFile(origFile);
        copy.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
        copy.setCharset(origFile.getCharset());
        return this.createCopy(copy);
    }

    @Override
    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.createCopy must not be null");
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.getManager(), copy, false, this.myBaseLanguage);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.createCopy must not return null");
        }
        return singleRootFileViewProvider;
    }

    @Override
    public PsiReference findReferenceAt(int offset) {
        PsiFileImpl psiFile = (PsiFileImpl)this.getPsi(this.getBaseLanguage());
        return SingleRootFileViewProvider.findReferenceAt(psiFile, offset);
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.findElementAt must not be null");
        }
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? SingleRootFileViewProvider.findElementAt(psiFile, offset) : null;
    }

    @Override
    @Nullable
    public PsiReference findReferenceAt(int offset, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.findReferenceAt must not be null");
        }
        PsiFile psiFile = this.getPsi(language);
        return psiFile != null ? SingleRootFileViewProvider.findReferenceAt(psiFile, offset) : null;
    }

    @Nullable
    private static PsiReference findReferenceAt(@Nullable PsiFile psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findReferenceAt(offsetInElement);
        }
        return null;
    }

    @Override
    public PsiElement findElementAt(int offset) {
        return SingleRootFileViewProvider.findElementAt(this.getPsi(this.getBaseLanguage()), offset);
    }

    @Override
    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/SingleRootFileViewProvider.findElementAt must not be null");
        }
        if (!ReflectionCache.isAssignable(lang, this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    @Nullable
    protected static PsiElement findElementAt(@Nullable PsiElement psiFile, int offset) {
        if (psiFile == null) {
            return null;
        }
        int offsetInElement = offset;
        for (PsiElement child = psiFile.getFirstChild(); child != null; child = child.getNextSibling()) {
            int length = child.getTextLength();
            if (length <= offsetInElement) {
                offsetInElement -= length;
                continue;
            }
            return child.findElementAt(offsetInElement);
        }
        return null;
    }

    public void forceCachedPsi(PsiFile psiFile) {
        this.myPsiFile.set(psiFile);
        ((PsiManagerEx)this.myManager).getFileManager().setViewProvider(this.getVirtualFile(), this);
    }

    private Content getContent() {
        return this.myContent;
    }

    private void setContent(Content content) {
        this.myContent = content;
    }

    @NonNls
    public String toString() {
        return this.getClass().getSimpleName() + "{myVirtualFile=" + this.myVirtualFile + ", content=" + this.getContent() + '}';
    }

    @Override
    @NotNull
    public PsiFile getStubBindingRoot() {
        PsiFile psi = this.getPsi(this.getBaseLanguage());
        assert (psi != null);
        PsiFile psiFile = psi;
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider.getStubBindingRoot must not return null");
        }
        return psiFile;
    }

    private class PsiFileContent
    implements Content {
        private final PsiFileImpl myFile;
        private volatile String myContent = null;
        private final long myModificationStamp;
        private final List<FileElement> myFileElementHardRefs = new SmartList<FileElement>();

        private PsiFileContent(PsiFileImpl file, long modificationStamp) {
            this.myFile = file;
            this.myModificationStamp = modificationStamp;
            for (PsiFile aFile : SingleRootFileViewProvider.this.getAllFiles()) {
                if (!(aFile instanceof PsiFileImpl)) continue;
                this.myFileElementHardRefs.add(((PsiFileImpl)aFile).calcTreeElement());
            }
        }

        @Override
        public CharSequence getText() {
            String content = this.myContent;
            if (content == null) {
                this.myContent = content = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

                    @Override
                    public String compute() {
                        return PsiFileContent.this.myFile.calcTreeElement().getText();
                    }
                });
            }
            return content;
        }

        @Override
        public long getModificationStamp() {
            return this.myModificationStamp;
        }
    }

    private class DocumentContent
    implements Content {
        private DocumentContent() {
        }

        @NonNls
        public String toString() {
            Document document = SingleRootFileViewProvider.this.getDocument();
            return "DocumentContent{size=" + (document == null ? null : Integer.valueOf(document.getTextLength())) + "}";
        }

        @Override
        @NotNull
        public CharSequence getText() {
            Document document = SingleRootFileViewProvider.this.getDocument();
            assert (document != null);
            CharSequence charSequence = document.getCharsSequence();
            if (charSequence == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/SingleRootFileViewProvider$DocumentContent.getText must not return null");
            }
            return charSequence;
        }

        @Override
        public long getModificationStamp() {
            Document document;
            Document document2 = document = SingleRootFileViewProvider.this.myDocument == null ? null : (Document)SingleRootFileViewProvider.this.myDocument.get();
            if (document != null) {
                return document.getModificationStamp();
            }
            return SingleRootFileViewProvider.this.myVirtualFile.getModificationStamp();
        }
    }

    private class VirtualFileContent
    implements Content {
        private VirtualFileContent() {
        }

        @Override
        public CharSequence getText() {
            VirtualFile virtualFile = SingleRootFileViewProvider.this.getVirtualFile();
            if (virtualFile instanceof LightVirtualFile) {
                Document doc = SingleRootFileViewProvider.this.getCachedDocument();
                if (doc != null) {
                    return doc.getCharsSequence();
                }
                return ((LightVirtualFile)virtualFile).getContent();
            }
            Document document = SingleRootFileViewProvider.this.getDocument();
            if (document == null) {
                return LoadTextUtil.loadText(virtualFile);
            }
            return document.getCharsSequence();
        }

        @Override
        public long getModificationStamp() {
            return SingleRootFileViewProvider.this.getVirtualFile().getModificationStamp();
        }

        @NonNls
        public String toString() {
            return "VirtualFileContent{size=" + SingleRootFileViewProvider.this.getVirtualFile().getLength() + "}";
        }
    }

    private static interface Content {
        public CharSequence getText();

        public long getModificationStamp();
    }
}

