/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import org.jetbrains.annotations.Nullable;

public class LocalsControlFlowPolicy
implements ControlFlowPolicy {
    private final PsiElement myCodeFragment;

    public LocalsControlFlowPolicy(PsiElement codeFragment) {
        this.myCodeFragment = codeFragment;
    }

    @Override
    public PsiVariable getUsedVariable(PsiReferenceExpression refExpr) {
        if (refExpr.isQualified()) {
            return null;
        }
        PsiElement refElement = refExpr.resolve();
        return refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter ? this.checkCodeFragment(refElement) : null;
    }

    @Nullable
    private PsiVariable checkCodeFragment(PsiElement refElement) {
        PsiElement codeFragment = ControlFlowUtil.findCodeFragment(refElement);
        if (refElement instanceof PsiParameter) {
            PsiElement declarationScope = ((PsiParameter)refElement).getDeclarationScope();
            if (declarationScope instanceof PsiMethod) {
                codeFragment = ((PsiMethod)declarationScope).getBody();
            } else if (declarationScope instanceof PsiLambdaExpression) {
                codeFragment = ((PsiLambdaExpression)declarationScope).getBody();
            }
        }
        if (codeFragment == null) {
            return null;
        }
        if (this.myCodeFragment.getContainingFile() == codeFragment.getContainingFile() && !this.myCodeFragment.equals(codeFragment)) {
            return null;
        }
        return (PsiVariable)refElement;
    }

    @Override
    public boolean isParameterAccepted(PsiParameter psiParameter) {
        return this.checkCodeFragment(psiParameter) != null;
    }

    @Override
    public boolean isLocalVariableAccepted(PsiLocalVariable psiVariable) {
        return this.checkCodeFragment(psiVariable) != null;
    }
}

