/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.containers.ConcurrentWeakValueHashMap;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class EmptyFileManager
implements FileManager {
    private final PsiManagerImpl myManager;
    private final ConcurrentWeakValueHashMap<VirtualFile, FileViewProvider> myVFileToViewProviderMap = new ConcurrentWeakValueHashMap();

    EmptyFileManager(PsiManagerImpl manager) {
        this.myManager = manager;
    }

    @Override
    public void dispose() {
    }

    @Override
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.findFile must not be null");
        }
        return null;
    }

    @Override
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.findDirectory must not be null");
        }
        return null;
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.reloadFromDisk must not be null");
        }
    }

    @Override
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.getCachedPsiFile must not be null");
        }
        return null;
    }

    @Override
    public void cleanupForNextTest() {
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.findViewProvider must not be null");
        }
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file);
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.findCachedViewProvider must not be null");
        }
        return (FileViewProvider)this.myVFileToViewProviderMap.get(file);
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean physical) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.createFileViewProvider must not be null");
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, file, physical);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/EmptyFileManager.createFileViewProvider must not return null");
        }
        return singleRootFileViewProvider;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider singleRootFileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/EmptyFileManager.setViewProvider must not be null");
        }
        if (!(virtualFile instanceof VirtualFileWindow)) {
            if (singleRootFileViewProvider == null) {
                this.myVFileToViewProviderMap.remove(virtualFile);
            } else {
                this.myVFileToViewProviderMap.put((Object)virtualFile, (Object)singleRootFileViewProvider);
            }
        }
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        List<PsiFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/EmptyFileManager.getAllCachedFiles must not return null");
        }
        return list;
    }
}

