/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.OrFilter;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.ElementClassFilter;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.FilterScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.RowIcon;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiClassImplUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiClassImplUtil");
    private static final Key<ParameterizedCachedValue<MembersMap, PsiClass>> MAP_IN_CLASS_KEY = Key.create("MAP_KEY");
    private static final Function<ClassIconRequest, Icon> FULL_ICON_EVALUATOR = new NullableFunction<ClassIconRequest, Icon>(){

        @Override
        public Icon fun(ClassIconRequest r) {
            if (!r.psiClass.isValid() || r.psiClass.getProject().isDisposed()) {
                return null;
            }
            boolean isLocked = (r.flags & 2) != 0 && !r.psiClass.isWritable();
            Icon symbolIcon = r.symbolIcon != null ? r.symbolIcon : ElementPresentationUtil.getClassIconOfKind(r.psiClass, ElementPresentationUtil.getClassKind(r.psiClass));
            RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(symbolIcon, r.psiClass, isLocked);
            return ElementPresentationUtil.addVisibilityIcon(r.psiClass, r.flags, baseIcon);
        }
    };

    private PsiClassImplUtil() {
    }

    public static void cacheEverything(PsiClass aClass) {
        PsiClassImplUtil.getValues(aClass).getValue(aClass);
    }

    @NotNull
    public static PsiField[] getAllFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAllFields must not be null");
        }
        List<PsiField> map = PsiClassImplUtil.getAllByMap(aClass, MemberType.FIELD);
        PsiField[] psiFieldArray = map.toArray(new PsiField[map.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllFields must not return null");
        }
        return psiFieldArray;
    }

    @NotNull
    public static PsiMethod[] getAllMethods(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAllMethods must not be null");
        }
        List<PsiMethod> methods = PsiClassImplUtil.getAllByMap(aClass, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiClass[] getAllInnerClasses(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAllInnerClasses must not be null");
        }
        List<PsiClass> classes = PsiClassImplUtil.getAllByMap(aClass, MemberType.CLASS);
        PsiClass[] psiClassArray = classes.toArray(new PsiClass[classes.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Nullable
    public static PsiField findFieldByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findFieldByName must not be null");
        }
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.FIELD);
        return byMap.isEmpty() ? null : (PsiField)byMap.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findMethodsByName must not be null");
        }
        List<PsiMember> methods = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.METHOD);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiMethod findMethodBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findMethodBySignature must not be null");
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findMethodBySignature must not be null");
        }
        List<PsiMethod> result = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, true);
        return result.isEmpty() ? null : result.get(0);
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not be null");
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not be null");
        }
        List<PsiMethod> methods = PsiClassImplUtil.findMethodsBySignature(aClass, patternMethod, checkBases, false);
        PsiMethod[] psiMethodArray = methods.toArray(new PsiMethod[methods.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiMethod> findMethodsBySignature(@NotNull PsiClass aClass, @NotNull PsiMethod patternMethod, boolean checkBases, boolean stopOnFirst) {
        List<PsiMethod> list;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not be null");
        }
        if (patternMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not be null");
        }
        PsiMethod[] methodsByName = aClass.findMethodsByName(patternMethod.getName(), checkBases);
        if (methodsByName.length == 0) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
            return list;
        }
        SmartList<PsiMethod> methods = new SmartList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : methodsByName) {
            PsiClass superClass = method.getContainingClass();
            PsiSubstitutor substitutor = checkBases && !aClass.equals(superClass) ? TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY) : PsiSubstitutor.EMPTY;
            MethodSignature signature = method.getSignature(substitutor);
            if (!signature.equals(patternSignature)) continue;
            methods.add(method);
            if (stopOnFirst) break;
        }
        if ((list = methods) != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsBySignature must not return null");
    }

    @Nullable
    public static PsiClass findInnerByName(@NotNull PsiClass aClass, String name, boolean checkBases) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findInnerByName must not be null");
        }
        List<PsiMember> byMap = PsiClassImplUtil.findByMap(aClass, name, checkBases, MemberType.CLASS);
        return byMap.isEmpty() ? null : (PsiClass)byMap.get(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static List<PsiMember> findByMap(@NotNull PsiClass aClass, String name, boolean checkBases, @NotNull MemberType type) {
        List<PsiMember> list;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findByMap must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findByMap must not be null");
        }
        if (name == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
            return list;
        }
        if (checkBases) {
            Map<String, List<Pair<PsiMember, PsiSubstitutor>>> allMethodsMap = PsiClassImplUtil.getMap(aClass, type);
            List<Pair<PsiMember, PsiSubstitutor>> list2 = allMethodsMap.get(name);
            if (list2 == null) {
                list = Collections.emptyList();
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
                return list;
            } else {
                ArrayList<PsiMember> ret = new ArrayList<PsiMember>(list2.size());
                for (Pair<PsiMember, PsiSubstitutor> info : list2) {
                    ret.add(info.getFirst());
                }
                list = ret;
                if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
                return list;
            }
        }
        PsiMember[] members = null;
        switch (type) {
            case METHOD: {
                members = aClass.getMethods();
                break;
            }
            case CLASS: {
                members = aClass.getInnerClasses();
                break;
            }
            case FIELD: {
                members = aClass.getFields();
                break;
            }
        }
        ArrayList<PsiMember> list3 = new ArrayList<PsiMember>();
        for (PsiMember member : members) {
            if (!name.equals(member.getName())) continue;
            list3.add(member);
        }
        list = list3;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findByMap must not return null");
    }

    @NotNull
    public static <T extends PsiMember> List<Pair<T, PsiSubstitutor>> getAllWithSubstitutorsByMap(@NotNull PsiClass aClass, @NotNull MemberType type) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAllWithSubstitutorsByMap must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAllWithSubstitutorsByMap must not be null");
        }
        Map<String, List<Pair<PsiMember, PsiSubstitutor>>> allMap = PsiClassImplUtil.getMap(aClass, type);
        List<Pair<T, PsiSubstitutor>> list = allMap.get("Intellij-IDEA-ALL");
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllWithSubstitutorsByMap must not return null");
        }
        return list;
    }

    @NotNull
    private static <T extends PsiMember> List<T> getAllByMap(@NotNull PsiClass aClass, @NotNull MemberType type) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAllByMap must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAllByMap must not be null");
        }
        List<Pair<T, PsiSubstitutor>> pairs = PsiClassImplUtil.getAllWithSubstitutorsByMap(aClass, type);
        ArrayList<PsiMember> ret = new ArrayList<PsiMember>(pairs.size());
        for (int i = 0; i < pairs.size(); ++i) {
            Pair<T, PsiSubstitutor> pair = pairs.get(i);
            PsiMember t = (PsiMember)pair.getFirst();
            LOG.assertTrue(t != null, aClass);
            ret.add(t);
        }
        ArrayList<PsiMember> arrayList = ret;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAllByMap must not return null");
        }
        return arrayList;
    }

    @NotNull
    private static MembersMap buildAllMaps(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.buildAllMaps must not be null");
        }
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> classes = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> fields = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        final ArrayList<Pair<PsiMember, PsiSubstitutor>> methods = new ArrayList<Pair<PsiMember, PsiSubstitutor>>();
        FilterScopeProcessor<MethodCandidateInfo> processor = new FilterScopeProcessor<MethodCandidateInfo>((ElementFilter)new OrFilter(ElementClassFilter.METHOD, ElementClassFilter.FIELD, ElementClassFilter.CLASS)){

            @Override
            protected void add(PsiElement element, PsiSubstitutor substitutor) {
                if (element instanceof PsiMethod) {
                    methods.add(Pair.create((PsiMember)element, substitutor));
                } else if (element instanceof PsiField) {
                    fields.add(Pair.create((PsiMember)element, substitutor));
                } else if (element instanceof PsiClass) {
                    classes.add(Pair.create((PsiMember)element, substitutor));
                }
            }
        };
        PsiClassImplUtil.processDeclarationsInClassNotCached(psiClass, processor, ResolveState.initial(), null, null, psiClass, false, PsiUtil.getLanguageLevel(psiClass));
        MembersMap result = new MembersMap(MemberType.class);
        result.put(MemberType.CLASS, PsiClassImplUtil.generateMapByList(classes));
        result.put(MemberType.METHOD, PsiClassImplUtil.generateMapByList(methods));
        result.put(MemberType.FIELD, PsiClassImplUtil.generateMapByList(fields));
        MembersMap membersMap = result;
        if (membersMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.buildAllMaps must not return null");
        }
        return membersMap;
    }

    @NotNull
    private static Map<String, List<Pair<PsiMember, PsiSubstitutor>>> generateMapByList(@NotNull List<Pair<PsiMember, PsiSubstitutor>> list) {
        if (list == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.generateMapByList must not be null");
        }
        THashMap<String, List<Pair<PsiMember, PsiSubstitutor>>> map = new THashMap<String, List<Pair<PsiMember, PsiSubstitutor>>>();
        map.put("Intellij-IDEA-ALL", list);
        for (Pair<PsiMember, PsiSubstitutor> info : list) {
            PsiMember element = info.getFirst();
            String currentName = element.getName();
            ArrayList<Pair<PsiMember, PsiSubstitutor>> listByName = (ArrayList<Pair<PsiMember, PsiSubstitutor>>)map.get(currentName);
            if (listByName == null) {
                listByName = new ArrayList<Pair<PsiMember, PsiSubstitutor>>(1);
                map.put(currentName, listByName);
            }
            listByName.add(info);
        }
        THashMap<String, List<Pair<PsiMember, PsiSubstitutor>>> tHashMap = map;
        if (tHashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.generateMapByList must not return null");
        }
        return tHashMap;
    }

    private static Map<String, List<Pair<PsiMember, PsiSubstitutor>>> getMap(@NotNull PsiClass aClass, @NotNull MemberType type) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getMap must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getMap must not be null");
        }
        ParameterizedCachedValue<MembersMap, PsiClass> value = PsiClassImplUtil.getValues(aClass);
        return (Map)value.getValue(aClass).get((Object)type);
    }

    @NotNull
    private static ParameterizedCachedValue<MembersMap, PsiClass> getValues(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getValues must not be null");
        }
        ParameterizedCachedValue<MembersMap, PsiClass> value = aClass.getUserData(MAP_IN_CLASS_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager(aClass.getProject()).createParameterizedCachedValue(ByNameCachedValueProvider.INSTANCE, false);
            if (aClass.isPhysical()) {
                value = ((UserDataHolderEx)((Object)aClass)).putUserDataIfAbsent(MAP_IN_CLASS_KEY, value);
            }
        }
        ParameterizedCachedValue<MembersMap, PsiClass> parameterizedCachedValue = value;
        if (parameterizedCachedValue == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getValues must not return null");
        }
        return parameterizedCachedValue;
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getClassIcon must not be null");
        }
        return PsiClassImplUtil.getClassIcon(flags, aClass, null);
    }

    public static Icon getClassIcon(int flags, @NotNull PsiClass aClass, @Nullable Icon symbolIcon) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getClassIcon must not be null");
        }
        Icon base = Iconable.LastComputedIcon.get(aClass, flags);
        if (base == null) {
            if (symbolIcon == null) {
                symbolIcon = ElementPresentationUtil.getClassIconOfKind(aClass, ElementPresentationUtil.getBasicClassKind(aClass));
            }
            RowIcon baseIcon = ElementBase.createLayeredIcon(aClass, symbolIcon, 0);
            base = ElementPresentationUtil.addVisibilityIcon(aClass, flags, baseIcon);
        }
        return IconDeferrer.getInstance().defer(base, new ClassIconRequest(aClass, flags, symbolIcon), FULL_ICON_EVALUATOR);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static SearchScope getClassUseScope(@NotNull PsiClass aClass) {
        PsiDirectory psiDirectory;
        SearchScope searchScope;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getClassUseScope must not be null");
        }
        if (aClass instanceof PsiAnonymousClass) {
            searchScope = new LocalSearchScope(aClass);
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getClassUseScope must not return null");
            return searchScope;
        }
        GlobalSearchScope maximalUseScope = ResolveScopeManager.getElementUseScope(aClass);
        PsiFile file = aClass.getContainingFile();
        if (PsiImplUtil.isInServerPage(file)) {
            searchScope = maximalUseScope;
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getClassUseScope must not return null");
            return searchScope;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (aClass.hasModifierProperty("public") || aClass.hasModifierProperty("protected")) {
            searchScope = containingClass == null ? maximalUseScope : containingClass.getUseScope();
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getClassUseScope must not return null");
            return searchScope;
        }
        if (aClass.hasModifierProperty("private") || aClass instanceof PsiTypeParameter) {
            PsiClass topClass = PsiUtil.getTopLevelClass(aClass);
            searchScope = new LocalSearchScope(topClass == null ? aClass.getContainingFile() : topClass);
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getClassUseScope must not return null");
            return searchScope;
        }
        PsiPackage aPackage = null;
        if (file instanceof PsiJavaFile) {
            aPackage = JavaPsiFacade.getInstance(aClass.getProject()).findPackage(((PsiJavaFile)file).getPackageName());
        }
        if (aPackage == null && (psiDirectory = file.getContainingDirectory()) != null) {
            aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory);
        }
        if (aPackage != null) {
            GlobalSearchScope globalSearchScope = PackageScope.packageScope(aPackage, false);
            SearchScope searchScope2 = ((SearchScope)globalSearchScope).intersectWith(maximalUseScope);
            searchScope = searchScope2;
            if (searchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getClassUseScope must not return null");
            return searchScope;
        }
        searchScope = new LocalSearchScope(file);
        if (searchScope != null) return searchScope;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getClassUseScope must not return null");
    }

    public static boolean isMainOrPremainMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.isMainOrPremainMethod must not be null");
        }
        if (!PsiType.VOID.equals(method.getReturnType())) {
            return false;
        }
        String name = method.getName();
        if (!"main".equals(name) && !"premain".equals(name)) {
            return false;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(method.getProject()).getElementFactory();
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        try {
            MethodSignature main = PsiClassImplUtil.createSignatureFromText(factory, "void main(String[] args);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, main)) {
                return true;
            }
            MethodSignature premain = PsiClassImplUtil.createSignatureFromText(factory, "void premain(String args, java.lang.instrument.Instrumentation i);");
            if (MethodSignatureUtil.areSignaturesEqual(signature, premain)) {
                return true;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return false;
    }

    @NotNull
    private static MethodSignature createSignatureFromText(@NotNull PsiElementFactory factory, @NotNull String text) {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.createSignatureFromText must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.createSignatureFromText must not be null");
        }
        MethodSignature methodSignature = factory.createMethodFromText(text, null).getSignature(PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.createSignatureFromText must not return null");
        }
        return methodSignature;
    }

    public static boolean processDeclarationsInClass(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, boolean isRaw) {
        NameHint nameHint;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClass must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClass must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClass must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClass must not be null");
        }
        if (last instanceof PsiTypeParameterList || last instanceof PsiModifierList) {
            return true;
        }
        if (visited != null && visited.contains(aClass)) {
            return true;
        }
        PsiSubstitutor substitutor = state.get(PsiSubstitutor.KEY);
        isRaw = isRaw || PsiUtil.isRawSubstitutor(aClass, substitutor);
        ParameterizedCachedValue<MembersMap, PsiClass> cache = PsiClassImplUtil.getValues(aClass);
        boolean upToDate = cache.hasUpToDateValue();
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(place);
        if (upToDate && (nameHint = processor.getHint(NameHint.KEY)) != null) {
            String name = nameHint.getName(state);
            return PsiClassImplUtil.processCachedMembersByName(aClass, processor, state, visited, last, place, isRaw, substitutor, cache.getValue(aClass), name, languageLevel);
        }
        return PsiClassImplUtil.processDeclarationsInClassNotCached(aClass, processor, state, visited, last, place, isRaw, languageLevel);
    }

    private static boolean processCachedMembersByName(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, boolean isRaw, @NotNull PsiSubstitutor substitutor, @NotNull MembersMap value, String name, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor finalSubstitutor;
        PsiClass containingClass;
        boolean resolved;
        List list;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processCachedMembersByName must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processCachedMembersByName must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processCachedMembersByName must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processCachedMembersByName must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 7 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processCachedMembersByName must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 8 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processCachedMembersByName must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 10 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processCachedMembersByName must not be null");
        }
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            PsiField fieldByName = aClass.findFieldByName(name, false);
            if (fieldByName != null) {
                processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                if (!processor.execute(fieldByName, state)) {
                    return false;
                }
            } else {
                Map allFieldsMap = (Map)value.get((Object)MemberType.FIELD);
                list = (List)allFieldsMap.get(name);
                if (list != null) {
                    resolved = false;
                    for (Pair candidate : list) {
                        PsiMember candidateField = (PsiMember)candidate.getFirst();
                        containingClass = candidateField.getContainingClass();
                        if (containingClass == null) {
                            LOG.error("No class for field " + candidateField.getName() + " of " + candidateField.getClass());
                            continue;
                        }
                        finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, factory, languageLevel);
                        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                        if (processor.execute(candidateField, state.put(PsiSubstitutor.KEY, finalSubstitutor))) continue;
                        resolved = true;
                    }
                    if (resolved) {
                        return false;
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            if (last != null && last.getContext() == aClass) {
                if (last instanceof PsiClass && !processor.execute(last, state)) {
                    return false;
                }
                PsiTypeParameterList list2 = aClass.getTypeParameterList();
                if (list2 != null && !list2.processDeclarations(processor, state, last, place)) {
                    return false;
                }
            }
            if (!(last instanceof PsiReferenceList)) {
                PsiClass classByName = aClass.findInnerClassByName(name, false);
                if (classByName != null) {
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                    if (!processor.execute(classByName, state)) {
                        return false;
                    }
                } else {
                    Map allClassesMap = (Map)value.get((Object)MemberType.CLASS);
                    list = (List)allClassesMap.get(name);
                    if (list != null) {
                        resolved = false;
                        for (Pair candidate : list) {
                            PsiMember inner = (PsiMember)candidate.getFirst();
                            containingClass = inner.getContainingClass();
                            if (containingClass == null) continue;
                            finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(containingClass, (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, factory, languageLevel);
                            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass);
                            if (processor.execute(inner, state.put(PsiSubstitutor.KEY, finalSubstitutor))) continue;
                            resolved = true;
                        }
                        if (resolved) {
                            return false;
                        }
                    }
                }
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            MethodResolverProcessor methodResolverProcessor;
            if (processor instanceof MethodResolverProcessor && (methodResolverProcessor = (MethodResolverProcessor)processor).isConstructor()) {
                PsiMethod[] constructors = aClass.getConstructors();
                methodResolverProcessor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
                for (PsiMethod constructor : constructors) {
                    if (methodResolverProcessor.execute(constructor, state)) continue;
                    return false;
                }
                return true;
            }
            Map allMethodsMap = (Map)value.get((Object)MemberType.METHOD);
            List list3 = (List)allMethodsMap.get(name);
            if (list3 != null) {
                boolean resolved2 = false;
                for (Pair candidate : list3) {
                    ProgressIndicatorProvider.checkCanceled();
                    PsiMethod candidateMethod = (PsiMethod)candidate.getFirst();
                    if (processor instanceof MethodResolverProcessor && candidateMethod.isConstructor() != ((MethodResolverProcessor)processor).isConstructor()) continue;
                    PsiClass containingClass2 = candidateMethod.getContainingClass();
                    if (visited != null && visited.contains(candidateMethod.getContainingClass())) continue;
                    PsiSubstitutor finalSubstitutor2 = PsiClassImplUtil.obtainFinalSubstitutor(containingClass2, (PsiSubstitutor)candidate.getSecond(), aClass, substitutor, factory, languageLevel);
                    finalSubstitutor2 = PsiClassImplUtil.checkRaw(isRaw, factory, candidateMethod, finalSubstitutor2);
                    processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, containingClass2);
                    if (processor.execute(candidateMethod, state.put(PsiSubstitutor.KEY, finalSubstitutor2))) continue;
                    resolved2 = true;
                }
                if (resolved2) {
                    return false;
                }
                if (visited != null) {
                    for (Pair aList : list3) {
                        visited.add(((PsiMember)aList.getFirst()).getContainingClass());
                    }
                }
            }
        }
        return true;
    }

    private static PsiSubstitutor checkRaw(boolean isRaw, @NotNull PsiElementFactory factory, @NotNull PsiMethod candidateMethod, @NotNull PsiSubstitutor substitutor) {
        if (factory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.checkRaw must not be null");
        }
        if (candidateMethod == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.checkRaw must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.checkRaw must not be null");
        }
        if (isRaw && !candidateMethod.hasModifierProperty("static")) {
            PsiTypeParameter[] methodTypeParameters = candidateMethod.getTypeParameters();
            substitutor = factory.createRawSubstitutor(substitutor, methodTypeParameters);
        }
        return substitutor;
    }

    public static PsiSubstitutor obtainFinalSubstitutor(@NotNull PsiClass candidateClass, @NotNull PsiSubstitutor candidateSubstitutor, @NotNull PsiClass aClass, @NotNull PsiSubstitutor substitutor, @NotNull PsiElementFactory elementFactory, @NotNull LanguageLevel languageLevel) {
        if (candidateClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.obtainFinalSubstitutor must not be null");
        }
        if (candidateSubstitutor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.obtainFinalSubstitutor must not be null");
        }
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.obtainFinalSubstitutor must not be null");
        }
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.obtainFinalSubstitutor must not be null");
        }
        if (elementFactory == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.obtainFinalSubstitutor must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.obtainFinalSubstitutor must not be null");
        }
        if (PsiUtil.isRawSubstitutor(aClass, substitutor)) {
            return elementFactory.createRawSubstitutor(candidateClass).putAll(substitutor);
        }
        PsiClassType containingType = elementFactory.createType(candidateClass, candidateSubstitutor, languageLevel);
        PsiType type = substitutor.substitute(containingType);
        if (!(type instanceof PsiClassType)) {
            return candidateSubstitutor;
        }
        return ((PsiClassType)type).resolveGenerics().getSubstitutor();
    }

    private static boolean processDeclarationsInClassNotCached(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, boolean isRaw, @NotNull LanguageLevel languageLevel) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClassNotCached must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClassNotCached must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClassNotCached must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClassNotCached must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 7 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processDeclarationsInClassNotCached must not be null");
        }
        if (visited == null) {
            visited = new THashSet<PsiClass>();
        }
        if (!visited.add(aClass)) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, aClass);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor.getHint(NameHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.FIELD)) {
            if (nameHint != null) {
                PsiField fieldByName = aClass.findFieldByName(nameHint.getName(state), false);
                if (fieldByName != null && !processor.execute(fieldByName, state)) {
                    return false;
                }
            } else {
                PsiField[] fields;
                for (PsiField field : fields = aClass.getFields()) {
                    if (processor.execute(field, state)) continue;
                    return false;
                }
            }
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.METHOD)) {
            PsiMethod[] methods;
            PsiSubstitutor baseSubstitutor = state.get(PsiSubstitutor.KEY);
            for (PsiMethod method : methods = nameHint != null ? aClass.findMethodsByName(nameHint.getName(state), false) : aClass.getMethods()) {
                ResolveState methodState;
                PsiSubstitutor finalSubstitutor = PsiClassImplUtil.checkRaw(isRaw, factory, method, baseSubstitutor);
                ResolveState resolveState = methodState = finalSubstitutor == baseSubstitutor ? state : state.put(PsiSubstitutor.KEY, finalSubstitutor);
                if (processor.execute(method, methodState)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            PsiTypeParameterList list;
            if (last != null && last.getContext() == aClass && (list = aClass.getTypeParameterList()) != null && !list.processDeclarations(processor, ResolveState.initial(), last, place)) {
                return false;
            }
            if (!(last instanceof PsiReferenceList) && !(last instanceof PsiModifierList)) {
                if (nameHint != null) {
                    PsiClass inner = aClass.findInnerClassByName(nameHint.getName(state), false);
                    if (inner != null && !processor.execute(inner, state)) {
                        return false;
                    }
                } else {
                    PsiClass[] inners;
                    for (PsiClass inner : inners = aClass.getInnerClasses()) {
                        if (processor.execute(inner, state)) continue;
                        return false;
                    }
                }
            }
        }
        return last instanceof PsiReferenceList || PsiClassImplUtil.processSuperTypes(aClass, processor, visited, last, place, state, isRaw, factory, languageLevel);
    }

    private static boolean processSuperTypes(@NotNull PsiClass aClass, @NotNull PsiScopeProcessor processor, @Nullable Set<PsiClass> visited, PsiElement last, @NotNull PsiElement place, @NotNull ResolveState state, boolean isRaw, @NotNull PsiElementFactory factory, @NotNull LanguageLevel languageLevel) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processSuperTypes must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processSuperTypes must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processSuperTypes must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processSuperTypes must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 7 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processSuperTypes must not be null");
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException("Argument 8 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.processSuperTypes must not be null");
        }
        boolean resolved = false;
        for (PsiClassType superType : aClass.getSuperTypes()) {
            PsiSubstitutor finalSubstitutor;
            PsiClassType.ClassResolveResult superTypeResolveResult = superType.resolveGenerics();
            PsiClass superClass = superTypeResolveResult.getElement();
            if (superClass == null || PsiClassImplUtil.processDeclarationsInClass(superClass, processor, state.put(PsiSubstitutor.KEY, finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor(superClass, superTypeResolveResult.getSubstitutor(), aClass, state.get(PsiSubstitutor.KEY), factory, languageLevel)), visited, last, place, isRaw)) continue;
            resolved = true;
        }
        return !resolved;
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getSuperClass must not be null");
        }
        PsiManager manager = psiClass.getManager();
        GlobalSearchScope resolveScope = psiClass.getResolveScope();
        JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
        if (psiClass.isInterface()) {
            return facade.findClass("java.lang.Object", resolveScope);
        }
        if (psiClass.isEnum()) {
            return facade.findClass("java.lang.Enum", resolveScope);
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass == null || baseClass.isInterface()) {
                return facade.findClass("java.lang.Object", resolveScope);
            }
            return baseClass;
        }
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return null;
        }
        PsiClassType[] referenceElements = psiClass.getExtendsListTypes();
        if (referenceElements.length == 0) {
            return facade.findClass("java.lang.Object", resolveScope);
        }
        PsiClass psiResoved = referenceElements[0].resolve();
        return psiResoved == null ? facade.findClass("java.lang.Object", resolveScope) : psiResoved;
    }

    @NotNull
    public static PsiClass[] getSupers(@NotNull PsiClass psiClass) {
        PsiClass[] supers;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getSupers must not be null");
        }
        for (PsiClass aSuper : supers = PsiClassImplUtil.getSupersInner(psiClass)) {
            LOG.assertTrue(aSuper != null);
        }
        if (supers == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupers must not return null");
        }
        return supers;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiClass[] getSupersInner(@NotNull PsiClass psiClass) {
        PsiClass[] psiClassArray;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not be null");
        }
        PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        if (psiClass.isInterface()) {
            psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), true);
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not return null");
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray2;
            PsiAnonymousClass psiAnonymousClass = (PsiAnonymousClass)psiClass;
            PsiClassType baseClassReference = psiAnonymousClass.getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null) {
                if (baseClass.isInterface()) {
                    PsiClass[] psiClassArray3;
                    PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
                    if (objectClass != null) {
                        PsiClass[] psiClassArray4 = new PsiClass[2];
                        psiClassArray4[0] = objectClass;
                        psiClassArray3 = psiClassArray4;
                        psiClassArray4[1] = baseClass;
                    } else {
                        PsiClass[] psiClassArray5 = new PsiClass[1];
                        psiClassArray3 = psiClassArray5;
                        psiClassArray5[0] = baseClass;
                    }
                    psiClassArray = psiClassArray3;
                    if (psiClassArray3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not return null");
                    return psiClassArray;
                } else {
                    psiClassArray = new PsiClass[]{baseClass};
                    if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not return null");
                    return psiClassArray;
                }
            }
            PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
            if (objectClass != null) {
                PsiClass[] psiClassArray6 = new PsiClass[1];
                psiClassArray2 = psiClassArray6;
                psiClassArray6[0] = objectClass;
            } else {
                psiClassArray2 = psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not return null");
            return psiClassArray;
        }
        if (psiClass instanceof PsiTypeParameter) {
            if (extendsListTypes.length == 0) {
                PsiClass[] psiClassArray7;
                PsiClass objectClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Object", psiClass.getResolveScope());
                if (objectClass != null) {
                    PsiClass[] psiClassArray8 = new PsiClass[1];
                    psiClassArray7 = psiClassArray8;
                    psiClassArray8[0] = objectClass;
                } else {
                    psiClassArray7 = psiClassArray = PsiClass.EMPTY_ARRAY;
                }
                if (psiClassArray7 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not return null");
                return psiClassArray;
            } else {
                psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
                if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not return null");
                return psiClassArray;
            }
        }
        PsiClass[] interfaces = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        PsiClass superClass = PsiClassImplUtil.getSuperClass(psiClass);
        if (superClass == null) {
            psiClassArray = interfaces;
            if (interfaces == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not return null");
            return psiClassArray;
        }
        PsiClass[] types = new PsiClass[interfaces.length + 1];
        types[0] = superClass;
        System.arraycopy(interfaces, 0, types, 1, interfaces.length);
        psiClassArray = types;
        if (types != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSupersInner must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClassType[] getSuperTypes(@NotNull PsiClass psiClass) {
        PsiClassType[] psiClassTypeArray;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not be null");
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClassType objectType;
            PsiClassType baseClassType = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (!(baseClass == null || !baseClass.isInterface() ? (psiClassTypeArray = new PsiClassType[]{baseClassType}) != null : (psiClassTypeArray = new PsiClassType[]{objectType = PsiType.getJavaLangObject(psiClass.getManager(), psiClass.getResolveScope()), baseClassType}) != null)) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
            return psiClassTypeArray;
        }
        PsiClassType[] extendsTypes = psiClass.getExtendsListTypes();
        PsiClassType[] implementsTypes = psiClass.getImplementsListTypes();
        boolean hasExtends = extendsTypes.length != 0;
        int extendsListLength = extendsTypes.length + (hasExtends ? 0 : 1);
        PsiClassType[] result = new PsiClassType[extendsListLength + implementsTypes.length];
        System.arraycopy(extendsTypes, 0, result, 0, extendsTypes.length);
        if (!hasExtends) {
            PsiClassType objectType;
            if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
                psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
                if (PsiClassType.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
                return psiClassTypeArray;
            }
            PsiManager manager = psiClass.getManager();
            result[0] = objectType = PsiType.getJavaLangObject(manager, psiClass.getResolveScope());
        }
        System.arraycopy(implementsTypes, 0, result, extendsListLength, implementsTypes.length);
        for (int i = 0; i < result.length; ++i) {
            PsiClassType type = result[i];
            result[i] = (PsiClassType)PsiUtil.captureToplevelWildcards(type, psiClass);
        }
        psiClassTypeArray = result;
        if (result != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getSuperTypes must not return null");
    }

    @NotNull
    private static PsiClassType getAnnotationSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory) {
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAnnotationSuperType must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getAnnotationSuperType must not be null");
        }
        PsiClassType psiClassType = factory.createTypeByFQClassName("java.lang.annotation.Annotation", psiClass.getResolveScope());
        if (psiClassType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getAnnotationSuperType must not return null");
        }
        return psiClassType;
    }

    private static PsiClassType getEnumSuperType(@NotNull PsiClass psiClass, @NotNull PsiElementFactory factory) {
        PsiClassType superType;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getEnumSuperType must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getEnumSuperType must not be null");
        }
        PsiManager manager = psiClass.getManager();
        PsiClass enumClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Enum", psiClass.getResolveScope());
        if (enumClass == null) {
            try {
                superType = (PsiClassType)factory.createTypeFromText("java.lang.Enum", null);
            }
            catch (IncorrectOperationException e) {
                superType = null;
            }
        } else {
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], factory.createType(psiClass));
            }
            superType = new PsiImmediateClassType(enumClass, substitutor);
        }
        return superType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiTypeParameter typeParameter) {
        PsiClass[] psiClassArray;
        if (typeParameter == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getInterfaces must not be null");
        }
        PsiClassType[] referencedTypes = typeParameter.getExtendsListTypes();
        if (referencedTypes.length == 0) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
            if (PsiClass.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getInterfaces must not return null");
            return psiClassArray;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(referencedTypes.length);
        for (PsiClassType referencedType : referencedTypes) {
            PsiClass psiClass = referencedType.resolve();
            if (psiClass == null || !psiClass.isInterface()) continue;
            result.add(psiClass);
        }
        psiClassArray = result.toArray(new PsiClass[result.size()]);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getInterfaces must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClass[] getInterfaces(@NotNull PsiClass psiClass) {
        PsiClass[] psiClassArray;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getInterfaces must not be null");
        }
        if (psiClass.isInterface()) {
            PsiClassType[] extendsListTypes = psiClass.getExtendsListTypes();
            psiClassArray = PsiClassImplUtil.resolveClassReferenceList(extendsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
            if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getInterfaces must not return null");
            return psiClassArray;
        }
        if (psiClass instanceof PsiAnonymousClass) {
            PsiClass[] psiClassArray2;
            PsiClassType baseClassReference = ((PsiAnonymousClass)psiClass).getBaseClassType();
            PsiClass baseClass = baseClassReference.resolve();
            if (baseClass != null && baseClass.isInterface()) {
                PsiClass[] psiClassArray3 = new PsiClass[1];
                psiClassArray2 = psiClassArray3;
                psiClassArray3[0] = baseClass;
            } else {
                psiClassArray2 = psiClassArray = PsiClass.EMPTY_ARRAY;
            }
            if (psiClassArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getInterfaces must not return null");
            return psiClassArray;
        }
        PsiClassType[] implementsListTypes = psiClass.getImplementsListTypes();
        psiClassArray = PsiClassImplUtil.resolveClassReferenceList(implementsListTypes, psiClass.getManager(), psiClass.getResolveScope(), false);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getInterfaces must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiClass[] resolveClassReferenceList(@NotNull PsiClassType[] listOfTypes, @NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope, boolean includeObject) {
        PsiClass[] psiClassArray;
        if (listOfTypes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.resolveClassReferenceList must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.resolveClassReferenceList must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.resolveClassReferenceList must not be null");
        }
        PsiClass objectClass = JavaPsiFacade.getInstance(manager.getProject()).findClass("java.lang.Object", resolveScope);
        if (objectClass == null) {
            includeObject = false;
        }
        if (listOfTypes.length == 0) {
            if (includeObject) {
                psiClassArray = new PsiClass[]{objectClass};
                if (psiClassArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.resolveClassReferenceList must not return null");
                return psiClassArray;
            } else {
                psiClassArray = PsiClass.EMPTY_ARRAY;
                if (PsiClass.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.resolveClassReferenceList must not return null");
                return psiClassArray;
            }
        }
        int referenceCount = listOfTypes.length;
        if (includeObject) {
            ++referenceCount;
        }
        PsiClass[] resolved = new PsiClass[referenceCount];
        int resolvedCount = 0;
        if (includeObject) {
            resolved[resolvedCount++] = objectClass;
        }
        for (PsiClassType reference : listOfTypes) {
            PsiClass refResolved = reference.resolve();
            if (refResolved == null) continue;
            resolved[resolvedCount++] = refResolved;
        }
        if (resolvedCount < referenceCount) {
            PsiClass[] shorter = new PsiClass[resolvedCount];
            System.arraycopy(resolved, 0, shorter, 0, resolvedCount);
            resolved = shorter;
        }
        psiClassArray = resolved;
        if (resolved != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.resolveClassReferenceList must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(@NotNull PsiClass psiClass, String name, boolean checkBases) {
        List<Object> list;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName must not be null");
        }
        if (!checkBases) {
            PsiMethod[] methodsByName = psiClass.findMethodsByName(name, false);
            ArrayList<Pair<PsiMethod, PsiSubstitutor>> ret = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>(methodsByName.length);
            for (PsiMethod method : methodsByName) {
                ret.add(new Pair<PsiMethod, PsiSubstitutor>(method, PsiSubstitutor.EMPTY));
            }
            list = ret;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName must not return null");
            return list;
        }
        Map<String, List<Pair<PsiMember, PsiSubstitutor>>> map = PsiClassImplUtil.getMap(psiClass, MemberType.METHOD);
        List<Pair<PsiMember, PsiSubstitutor>> list2 = map.get(name);
        list = list2 == null ? Collections.emptyList() : Collections.unmodifiableList(list2);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClassType[] getExtendsListTypes(@NotNull PsiClass psiClass) {
        PsiClassType[] psiClassTypeArray;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getExtendsListTypes must not be null");
        }
        if (psiClass.isEnum()) {
            PsiClassType[] psiClassTypeArray2;
            PsiClassType enumSuperType = PsiClassImplUtil.getEnumSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory());
            if (enumSuperType == null) {
                psiClassTypeArray2 = PsiClassType.EMPTY_ARRAY;
            } else {
                PsiClassType[] psiClassTypeArray3 = new PsiClassType[1];
                psiClassTypeArray2 = psiClassTypeArray3;
                psiClassTypeArray3[0] = enumSuperType;
            }
            psiClassTypeArray = psiClassTypeArray2;
            if (psiClassTypeArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getExtendsListTypes must not return null");
            return psiClassTypeArray;
        }
        if (psiClass.isAnnotationType()) {
            psiClassTypeArray = new PsiClassType[]{PsiClassImplUtil.getAnnotationSuperType(psiClass, JavaPsiFacade.getInstance(psiClass.getProject()).getElementFactory())};
            if (psiClassTypeArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getExtendsListTypes must not return null");
            return psiClassTypeArray;
        }
        PsiReferenceList extendsList = psiClass.getExtendsList();
        if (extendsList != null) {
            psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getExtendsListTypes must not return null");
            return psiClassTypeArray;
        }
        psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
        if (PsiClassType.EMPTY_ARRAY != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getExtendsListTypes must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiClassType[] getImplementsListTypes(@NotNull PsiClass psiClass) {
        PsiClassType[] psiClassTypeArray;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getImplementsListTypes must not be null");
        }
        PsiReferenceList extendsList = psiClass.getImplementsList();
        if (extendsList != null) {
            psiClassTypeArray = extendsList.getReferencedTypes();
            if (psiClassTypeArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getImplementsListTypes must not return null");
            return psiClassTypeArray;
        }
        psiClassTypeArray = PsiClassType.EMPTY_ARRAY;
        if (PsiClassType.EMPTY_ARRAY != null) return psiClassTypeArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.getImplementsListTypes must not return null");
    }

    public static boolean isClassEquivalentTo(@NotNull PsiClass aClass, PsiElement another) {
        PsiFile original2;
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.isClassEquivalentTo must not be null");
        }
        if (aClass == another) {
            return true;
        }
        if (!(another instanceof PsiClass)) {
            return false;
        }
        String name1 = aClass.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiClass)another).getName();
        if (name2 == null) {
            return false;
        }
        if (name1.hashCode() != name2.hashCode()) {
            return false;
        }
        if (!name1.equals(name2)) {
            return false;
        }
        String qName1 = aClass.getQualifiedName();
        String qName2 = ((PsiClass)another).getQualifiedName();
        if (qName1 == null || qName2 == null) {
            if (qName1 != qName2) {
                return false;
            }
            if (aClass instanceof PsiTypeParameter && another instanceof PsiTypeParameter) {
                PsiTypeParameter p1 = (PsiTypeParameter)aClass;
                PsiTypeParameter p2 = (PsiTypeParameter)another;
                return p1.getIndex() == p2.getIndex() && aClass.getManager().areElementsEquivalent(p1.getOwner(), p2.getOwner());
            }
            return false;
        }
        if (qName1.hashCode() != qName2.hashCode() || !qName1.equals(qName2)) {
            return false;
        }
        if (PsiClassImplUtil.originalElement(aClass).equals(PsiClassImplUtil.originalElement((PsiClass)another))) {
            return true;
        }
        PsiFile file1 = aClass.getContainingFile().getOriginalFile();
        PsiFile file2 = another.getContainingFile().getOriginalFile();
        PsiFile original1 = file1.getUserData(PsiFileFactory.ORIGINAL_FILE);
        if (original1 == (original2 = file2.getUserData(PsiFileFactory.ORIGINAL_FILE)) && original1 != null || original1 == file2 || original2 == file1 || file1 == file2) {
            return PsiClassImplUtil.compareClassSeqNumber(aClass, (PsiClass)another);
        }
        FileIndexFacade fileIndex = ServiceManager.getService(file1.getProject(), FileIndexFacade.class);
        VirtualFile vfile1 = file1.getViewProvider().getVirtualFile();
        VirtualFile vfile2 = file2.getViewProvider().getVirtualFile();
        boolean lib1 = fileIndex.isInLibraryClasses(vfile1);
        boolean lib2 = fileIndex.isInLibraryClasses(vfile2);
        return !(!fileIndex.isInSource(vfile1) && !lib1 || !fileIndex.isInSource(vfile2) && !lib2);
    }

    private static boolean compareClassSeqNumber(@NotNull PsiClass aClass, @NotNull PsiClass another) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareClassSeqNumber must not be null");
        }
        if (another == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareClassSeqNumber must not be null");
        }
        int index1 = PsiClassImplUtil.getSeqNumber(aClass);
        if (index1 == -1) {
            return true;
        }
        int index2 = PsiClassImplUtil.getSeqNumber(another);
        return index1 == index2;
    }

    private static int getSeqNumber(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.getSeqNumber must not be null");
        }
        PsiElement parent = aClass.getParent();
        if (parent == null) {
            return -1;
        }
        int seqNo = 0;
        for (PsiElement child : parent.getChildren()) {
            if (child == aClass) {
                return seqNo;
            }
            if (!(child instanceof PsiClass) || !Comparing.strEqual(aClass.getName(), ((PsiClass)child).getName())) continue;
            ++seqNo;
        }
        return -1;
    }

    @NotNull
    private static PsiElement originalElement(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.originalElement must not be null");
        }
        PsiElement originalElement = aClass.getOriginalElement();
        PsiCompiledElement compiled = originalElement.getUserData(ClsElementImpl.COMPILED_ELEMENT);
        PsiElement psiElement = compiled != null ? compiled : originalElement;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/PsiClassImplUtil.originalElement must not return null");
        }
        return psiElement;
    }

    public static boolean isFieldEquivalentTo(@NotNull PsiField field, PsiElement another) {
        if (field == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.isFieldEquivalentTo must not be null");
        }
        if (!(another instanceof PsiField)) {
            return false;
        }
        String name1 = field.getName();
        if (name1 == null) {
            return false;
        }
        if (!another.isValid()) {
            return false;
        }
        String name2 = ((PsiField)another).getName();
        if (!name1.equals(name2)) {
            return false;
        }
        PsiClass aClass1 = field.getContainingClass();
        PsiClass aClass2 = ((PsiField)another).getContainingClass();
        return aClass1 != null && aClass2 != null && field.getManager().areElementsEquivalent(aClass1, aClass2);
    }

    public static boolean isMethodEquivalentTo(@NotNull PsiMethod method1, PsiElement another) {
        PsiParameter[] parameters2;
        if (method1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.isMethodEquivalentTo must not be null");
        }
        if (method1 == another) {
            return true;
        }
        if (!(another instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)another;
        if (!another.isValid()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        PsiClass aClass1 = method1.getContainingClass();
        PsiClass aClass2 = method2.getContainingClass();
        PsiManager manager = method1.getManager();
        if (aClass1 == null || aClass2 == null || !manager.areElementsEquivalent(aClass1, aClass2)) {
            return false;
        }
        PsiParameter[] parameters1 = method1.getParameterList().getParameters();
        if (parameters1.length != (parameters2 = method2.getParameterList().getParameters()).length) {
            return false;
        }
        for (int i = 0; i < parameters1.length; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (PsiClassImplUtil.compareParamTypes(manager, type1, type2 = parameter2.getType(), new HashSet<String>())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareParamTypes(@NotNull PsiManager manager, @NotNull PsiType type1, @NotNull PsiType type2, Set<String> visited) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type1 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type2 == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil.compareParamTypes must not be null");
        }
        if (type1 instanceof PsiArrayType) {
            PsiType componentType2;
            PsiType componentType1;
            return type2 instanceof PsiArrayType && PsiClassImplUtil.compareParamTypes(manager, componentType1 = ((PsiArrayType)type1).getComponentType(), componentType2 = ((PsiArrayType)type2).getComponentType(), visited);
        }
        if (!(type1 instanceof PsiClassType) || !(type2 instanceof PsiClassType)) {
            return type1.equals(type2);
        }
        PsiClass class1 = ((PsiClassType)type1).resolve();
        PsiClass class2 = ((PsiClassType)type2).resolve();
        visited.add(type1.getCanonicalText());
        visited.add(type2.getCanonicalText());
        if (class1 instanceof PsiTypeParameter && class2 instanceof PsiTypeParameter) {
            PsiClassType[] eTypes2;
            if (!Comparing.equal(class1.getName(), class2.getName()) || ((PsiTypeParameter)class1).getIndex() != ((PsiTypeParameter)class2).getIndex()) {
                return false;
            }
            PsiClassType[] eTypes1 = class1.getExtendsListTypes();
            if (eTypes1.length != (eTypes2 = class2.getExtendsListTypes()).length) {
                return false;
            }
            for (int i = 0; i < eTypes1.length; ++i) {
                PsiClassType eType1 = eTypes1[i];
                PsiClassType eType2 = eTypes2[i];
                if (visited.contains(eType1.getCanonicalText()) || visited.contains(eType2.getCanonicalText())) {
                    return false;
                }
                if (PsiClassImplUtil.compareParamTypes(manager, eType1, eType2, visited)) continue;
                return false;
            }
            return true;
        }
        return manager.areElementsEquivalent(class1, class2);
    }

    private static class ByNameCachedValueProvider
    implements ParameterizedCachedValueProvider<MembersMap, PsiClass> {
        private static final ByNameCachedValueProvider INSTANCE = new ByNameCachedValueProvider();

        private ByNameCachedValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<MembersMap> compute(@NotNull PsiClass myClass) {
            if (myClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil$ByNameCachedValueProvider.compute must not be null");
            }
            MembersMap map = PsiClassImplUtil.buildAllMaps(myClass);
            return new CachedValueProvider.Result<MembersMap>(map, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        }
    }

    private static class MembersMap
    extends EnumMap<MemberType, Map<String, List<Pair<PsiMember, PsiSubstitutor>>>> {
        public MembersMap(@NotNull Class<MemberType> keyType) {
            if (keyType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil$MembersMap.<init> must not be null");
            }
            super(keyType);
        }
    }

    private static class ClassIconRequest {
        @NotNull
        private final PsiClass psiClass;
        private final int flags;
        private final Icon symbolIcon;

        private ClassIconRequest(@NotNull PsiClass psiClass, int flags, Icon symbolIcon) {
            if (psiClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiClassImplUtil$ClassIconRequest.<init> must not be null");
            }
            this.psiClass = psiClass;
            this.flags = flags;
            this.symbolIcon = symbolIcon;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassIconRequest)) {
                return false;
            }
            ClassIconRequest that = (ClassIconRequest)o;
            return this.flags == that.flags && this.psiClass.equals(that.psiClass);
        }

        public int hashCode() {
            int result = this.psiClass.hashCode();
            result = 31 * result + this.flags;
            return result;
        }
    }

    public static enum MemberType {
        CLASS,
        FIELD,
        METHOD;

    }
}

