/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import org.jetbrains.annotations.NotNull;

public abstract class PsiTreeChangePreprocessorBase
implements PsiTreeChangePreprocessor {
    private final PsiModificationTrackerImpl myModificationTracker;

    public PsiTreeChangePreprocessorBase(PsiManagerImpl psiManager) {
        this.myModificationTracker = (PsiModificationTrackerImpl)psiManager.getModificationTracker();
        psiManager.addTreeChangePreprocessor(this);
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/PsiTreeChangePreprocessorBase.treeChanged must not be null");
        }
        boolean changedInsideCodeBlock = false;
        switch (event.getCode()) {
            case BEFORE_CHILDREN_CHANGE: {
                if (event.getParent() instanceof PsiFile) {
                    changedInsideCodeBlock = true;
                    break;
                }
            }
            case CHILDREN_CHANGED: {
                if (event.isGenericChildrenChange()) {
                    return;
                }
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_REMOVAL: 
            case CHILD_ADDED: 
            case CHILD_REMOVED: {
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_PROPERTY_CHANGE: 
            case PROPERTY_CHANGED: {
                changedInsideCodeBlock = false;
                break;
            }
            case BEFORE_CHILD_REPLACEMENT: 
            case CHILD_REPLACED: {
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_MOVEMENT: 
            case CHILD_MOVED: {
                boolean bl = changedInsideCodeBlock = this.isInsideCodeBlock(event.getOldParent()) && this.isInsideCodeBlock(event.getNewParent());
            }
        }
        if (!changedInsideCodeBlock) {
            this.myModificationTracker.incOutOfCodeBlockModificationCounter();
        }
    }

    protected abstract boolean isInsideCodeBlock(PsiElement var1);
}

