/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import com.intellij.psi.impl.compiled.ClsBinaryExpressionImpl;
import com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaTokenImpl;
import com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.JavaDummyElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.impl.compiled.ClsParsingUtil");
    private static final JavaParserUtil.ParserWrapper ANNOTATION_VALUE = new JavaParserUtil.ParserWrapper(){

        @Override
        public void parse(PsiBuilder builder) {
            JavaParser.INSTANCE.getDeclarationParser().parseAnnotationValue(builder);
        }
    };

    private ClsParsingUtil() {
    }

    public static PsiExpression createExpressionFromText(String exprText, PsiManager manager, ClsElementImpl parent) {
        PsiExpression expr;
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
        PsiJavaFile dummyJavaFile = ((PsiJavaParserFacadeImpl)parserFacade).getDummyJavaFile();
        try {
            expr = parserFacade.createExpressionFromText(exprText, dummyJavaFile);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
        return ClsParsingUtil.psiToClsExpression(expr, parent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotationMemberValue createMemberValueFromText(String text, PsiManager manager, ClsElementImpl parent) {
        PsiAnnotationMemberValue psiAnnotationMemberValue;
        PsiElementFactory factory = JavaPsiFacade.getInstance(manager.getProject()).getElementFactory();
        PsiJavaFile context = ((PsiJavaParserFacadeImpl)((Object)factory)).getDummyJavaFile();
        LanguageLevel level = PsiUtil.getLanguageLevel(parent);
        DummyHolder holder = DummyHolderFactory.createHolder(manager, new JavaDummyElement(text, ANNOTATION_VALUE, level), (PsiElement)context);
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(holder.getTreeElement().getFirstChildNode());
        if (!(element instanceof PsiAnnotationMemberValue)) {
            LOG.error("Could not parse initializer:'" + text + "'");
            psiAnnotationMemberValue = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.createMemberValueFromText must not return null");
        } else {
            psiAnnotationMemberValue = ClsParsingUtil.getMemberValue(element, parent);
            if (psiAnnotationMemberValue == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.createMemberValueFromText must not return null");
            return psiAnnotationMemberValue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotationMemberValue getMemberValue(PsiElement element, ClsElementImpl parent) {
        PsiAnnotationMemberValue psiAnnotationMemberValue;
        if (element instanceof PsiExpression) {
            PsiExpression psiExpression = ClsParsingUtil.psiToClsExpression((PsiExpression)element, parent);
            psiAnnotationMemberValue = psiExpression;
            if (psiExpression != null) return psiAnnotationMemberValue;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.getMemberValue must not return null");
        }
        if (element instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent, clsInitializers);
            int i = 0;
            while (true) {
                if (i >= initializers.length) {
                    ClsArrayInitializerMemberValueImpl clsArrayInitializerMemberValueImpl = arrayValue;
                    psiAnnotationMemberValue = clsArrayInitializerMemberValueImpl;
                    if (clsArrayInitializerMemberValueImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.getMemberValue must not return null");
                    return psiAnnotationMemberValue;
                }
                clsInitializers[i] = ClsParsingUtil.getMemberValue(initializers[i], arrayValue);
                ++i;
            }
        }
        if (!(element instanceof PsiAnnotation)) {
            LOG.error("Unexpected source element for annotation member value: " + element);
            psiAnnotationMemberValue = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.getMemberValue must not return null");
        }
        final PsiAnnotation psiAnnotation = (PsiAnnotation)element;
        PsiJavaCodeReferenceElement referenceElement = psiAnnotation.getNameReferenceElement();
        assert (referenceElement != null) : psiAnnotation;
        final String canonicalText = referenceElement.getText();
        ClsAnnotationValueImpl clsAnnotationValueImpl = new ClsAnnotationValueImpl(parent){

            @Override
            protected ClsJavaCodeReferenceElementImpl createReference() {
                return new ClsJavaCodeReferenceElementImpl(this, canonicalText);
            }

            @Override
            protected ClsAnnotationParameterListImpl createParameterList() {
                PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                return new ClsAnnotationParameterListImpl(this, psiAttributes);
            }

            @Override
            public PsiAnnotationOwner getOwner() {
                return (PsiAnnotationOwner)((Object)this.getParent());
            }
        };
        psiAnnotationMemberValue = clsAnnotationValueImpl;
        if (clsAnnotationValueImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.getMemberValue must not return null");
        return psiAnnotationMemberValue;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static PsiExpression psiToClsExpression(PsiExpression expr, @Nullable ClsElementImpl parent) {
        ClsElementImpl clsElementImpl;
        if (expr instanceof PsiLiteralExpression) {
            ClsLiteralExpressionImpl clsLiteralExpressionImpl = new ClsLiteralExpressionImpl(parent, expr.getText(), expr.getType(), ((PsiLiteralExpression)expr).getValue());
            clsElementImpl = clsLiteralExpressionImpl;
            if (clsLiteralExpressionImpl != null) return clsElementImpl;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpr = (PsiPrefixExpression)expr;
            ClsJavaTokenImpl operation = new ClsJavaTokenImpl(null, prefixExpr.getOperationTokenType(), prefixExpr.getOperationSign().getText());
            ClsLiteralExpressionImpl literal = (ClsLiteralExpressionImpl)ClsParsingUtil.psiToClsExpression(prefixExpr.getOperand(), null);
            ClsPrefixExpressionImpl clsPrefixExpressionImpl = new ClsPrefixExpressionImpl(parent, operation, literal);
            clsElementImpl = clsPrefixExpressionImpl;
            if (clsPrefixExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
            return clsElementImpl;
        }
        if (expr instanceof PsiClassObjectAccessExpression) {
            String canonicalClassText = ((PsiClassObjectAccessExpression)expr).getOperand().getType().getCanonicalText();
            ClsClassObjectAccessExpressionImpl clsClassObjectAccessExpressionImpl = new ClsClassObjectAccessExpressionImpl(parent, canonicalClassText);
            clsElementImpl = clsClassObjectAccessExpressionImpl;
            if (clsClassObjectAccessExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
            return clsElementImpl;
        }
        if (expr instanceof PsiReferenceExpression) {
            ClsReferenceExpressionImpl clsReferenceExpressionImpl = new ClsReferenceExpressionImpl(parent, (PsiReferenceExpression)expr);
            clsElementImpl = clsReferenceExpressionImpl;
            if (clsReferenceExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
            return clsElementImpl;
        }
        if (expr instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpr = (PsiBinaryExpression)expr;
            PsiExpression lOperand = ClsParsingUtil.psiToClsExpression(binaryExpr.getLOperand(), null);
            ClsJavaTokenImpl operation = new ClsJavaTokenImpl(null, binaryExpr.getOperationTokenType(), binaryExpr.getOperationSign().getText());
            PsiExpression rOperand = ClsParsingUtil.psiToClsExpression(binaryExpr.getROperand(), null);
            if (lOperand instanceof ClsLiteralExpressionImpl) {
                ClsBinaryExpressionImpl clsBinaryExpressionImpl = new ClsBinaryExpressionImpl(parent, (ClsLiteralExpressionImpl)lOperand, operation, (ClsLiteralExpressionImpl)rOperand);
                clsElementImpl = clsBinaryExpressionImpl;
                if (clsBinaryExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
                return clsElementImpl;
            }
            if (lOperand instanceof ClsPrefixExpressionImpl) {
                ClsBinaryExpressionImpl clsBinaryExpressionImpl = new ClsBinaryExpressionImpl(parent, (ClsPrefixExpressionImpl)lOperand, operation, (ClsLiteralExpressionImpl)rOperand);
                clsElementImpl = clsBinaryExpressionImpl;
                if (clsBinaryExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
                return clsElementImpl;
            }
        } else {
            PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance(expr.getProject()).getConstantEvaluationHelper();
            Object value = evaluator.computeConstantExpression(expr);
            if (value != null) {
                ClsLiteralExpressionImpl clsLiteralExpressionImpl = new ClsLiteralExpressionImpl(parent, expr.getText(), expr.getType(), value);
                clsElementImpl = clsLiteralExpressionImpl;
                if (clsLiteralExpressionImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
                return clsElementImpl;
            }
        }
        LOG.error("Unable to compute expression value: " + expr);
        clsElementImpl = null;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParsingUtil.psiToClsExpression must not return null");
    }

    public static boolean isJavaIdentifier(@NotNull String identifier, @NotNull LanguageLevel level) {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParsingUtil.isJavaIdentifier must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParsingUtil.isJavaIdentifier must not be null");
        }
        return StringUtil.isJavaIdentifier(identifier) && !JavaLexer.isKeyword(identifier, level);
    }
}

