/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.AnnotationElement;
import com.intellij.psi.impl.source.tree.java.PsiAnnotationImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaAnnotationElementType
extends JavaStubElementType<PsiAnnotationStub, PsiAnnotation> {
    public JavaAnnotationElementType() {
        super("ANNOTATION");
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        AnnotationElement annotationElement = new AnnotationElement();
        if (annotationElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.createCompositeNode must not return null");
        }
        return annotationElement;
    }

    @Override
    public PsiAnnotation createPsi(@NotNull PsiAnnotationStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createAnnotation(stub);
    }

    @Override
    public PsiAnnotation createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.createPsi must not be null");
        }
        return new PsiAnnotationImpl(node);
    }

    @Override
    public PsiAnnotationStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String text = LightTreeUtil.toFilteredString(tree, node, null);
        return new PsiAnnotationStubImpl(parentStub, text);
    }

    @Override
    public void serialize(@NotNull PsiAnnotationStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.serialize must not be null");
        }
        if (dataStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.serialize must not be null");
        }
        dataStream.writeUTFFast(stub.getText());
    }

    @Override
    @NotNull
    public PsiAnnotationStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.deserialize must not be null");
        }
        PsiAnnotationStubImpl psiAnnotationStubImpl = new PsiAnnotationStubImpl(parentStub, dataStream.readUTFFast());
        if (psiAnnotationStubImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.deserialize must not return null");
        }
        return psiAnnotationStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiAnnotationStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.indexStub must not be null");
        }
        if (sink == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaAnnotationElementType.indexStub must not be null");
        }
        String shortName = JavaAnnotationElementType.getReferenceShortName(stub.getText());
        if (!StringUtil.isEmptyOrSpaces(shortName)) {
            sink.occurrence(JavaStubIndexKeys.ANNOTATIONS, shortName);
        }
    }

    private static String getReferenceShortName(String annotationText) {
        int index = annotationText.indexOf(40);
        if (index >= 0) {
            annotationText = annotationText.substring(0, index);
        }
        return PsiNameHelper.getShortClassName(annotationText);
    }
}

