/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.source.PsiAnonymousClassImpl;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiEnumConstantInitializerImpl;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.AnonymousClassElement;
import com.intellij.psi.impl.source.tree.java.EnumConstantInitializerElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaClassElementType
extends JavaStubElementType<PsiClassStub, PsiClass> {
    public JavaClassElementType(@NotNull @NonNls String id) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.<init> must not be null");
        }
        super(id);
    }

    @Override
    public PsiClass createPsi(@NotNull PsiClassStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createClass(stub);
    }

    @Override
    public PsiClass createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.createPsi must not be null");
        }
        if (node instanceof EnumConstantInitializerElement) {
            return new PsiEnumConstantInitializerImpl(node);
        }
        if (node instanceof AnonymousClassElement) {
            return new PsiAnonymousClassImpl(node);
        }
        return new PsiClassImpl(node);
    }

    @Override
    public PsiClassStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        LighterASTNode parent;
        boolean isDeprecatedByComment = false;
        boolean isInterface = false;
        boolean isEnum = false;
        boolean isEnumConst = false;
        boolean isAnonymous = false;
        boolean isAnnotation = false;
        boolean isInQualifiedNew = false;
        boolean hasDeprecatedAnnotation = false;
        String qualifiedName = null;
        String name = null;
        String baseRef = null;
        if (node.getTokenType() == JavaElementType.ANONYMOUS_CLASS) {
            isAnonymous = true;
        } else if (node.getTokenType() == JavaElementType.ENUM_CONSTANT_INITIALIZER) {
            isEnumConst = true;
            isAnonymous = true;
            baseRef = ((PsiClassStub)parentStub.getParentStub()).getName();
        }
        for (LighterASTNode child : tree.getChildren(node)) {
            IElementType type = child.getTokenType();
            if (type == JavaDocElementType.DOC_COMMENT) {
                isDeprecatedByComment = RecordUtil.isDeprecatedByDocComment(tree, child);
                continue;
            }
            if (type == JavaElementType.MODIFIER_LIST) {
                hasDeprecatedAnnotation = RecordUtil.isDeprecatedByAnnotation(tree, child);
                continue;
            }
            if (type == JavaTokenType.AT) {
                isAnnotation = true;
                continue;
            }
            if (type == JavaTokenType.INTERFACE_KEYWORD) {
                isInterface = true;
                continue;
            }
            if (type == JavaTokenType.ENUM_KEYWORD) {
                isEnum = true;
                continue;
            }
            if (!isAnonymous && type == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (!isAnonymous || isEnumConst || type != JavaElementType.JAVA_CODE_REFERENCE) continue;
            baseRef = LightTreeUtil.toFilteredString(tree, child, null);
        }
        if (name != null) {
            if (parentStub instanceof PsiJavaFileStub) {
                String pkg = ((PsiJavaFileStub)parentStub).getPackageName();
                qualifiedName = pkg.length() > 0 ? pkg + '.' + name : name;
            } else if (parentStub instanceof PsiClassStub) {
                String parentFqn = ((PsiClassStub)parentStub).getQualifiedName();
                String string = qualifiedName = parentFqn != null ? parentFqn + '.' + name : null;
            }
        }
        if (isAnonymous && (parent = tree.getParent(node)) != null && parent.getTokenType() == JavaElementType.NEW_EXPRESSION) {
            isInQualifiedNew = LightTreeUtil.firstChildOfType(tree, parent, JavaTokenType.DOT) != null;
        }
        byte flags = PsiClassStubImpl.packFlags(isDeprecatedByComment, isInterface, isEnum, isEnumConst, isAnonymous, isAnnotation, isInQualifiedNew, hasDeprecatedAnnotation);
        JavaClassElementType type = JavaClassElementType.typeForClass(isAnonymous, isEnumConst);
        return new PsiClassStubImpl(type, parentStub, qualifiedName, name, baseRef, flags);
    }

    public static JavaClassElementType typeForClass(boolean anonymous, boolean enumConst) {
        return enumConst ? JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER : (anonymous ? JavaStubElementTypes.ANONYMOUS_CLASS : JavaStubElementTypes.CLASS);
    }

    @Override
    public void serialize(@NotNull PsiClassStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.serialize must not be null");
        }
        if (dataStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.serialize must not be null");
        }
        dataStream.writeByte(((PsiClassStubImpl)stub).getFlags());
        if (!stub.isAnonymous()) {
            dataStream.writeName(stub.getName());
            dataStream.writeName(stub.getQualifiedName());
            dataStream.writeByte(stub.getLanguageLevel().ordinal());
            dataStream.writeName(stub.getSourceFileName());
        } else {
            dataStream.writeName(stub.getBaseClassReferenceText());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiClassStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        PsiClassStubImpl psiClassStubImpl;
        if (dataStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.deserialize must not be null");
        }
        byte flags = dataStream.readByte();
        boolean isAnonymous = PsiClassStubImpl.isAnonymous(flags);
        boolean isEnumConst = PsiClassStubImpl.isEnumConstInitializer(flags);
        JavaClassElementType type = JavaClassElementType.typeForClass(isAnonymous, isEnumConst);
        if (!isAnonymous) {
            StringRef name = dataStream.readName();
            StringRef qname = dataStream.readName();
            byte languageLevelId = dataStream.readByte();
            StringRef sourceFileName = dataStream.readName();
            PsiClassStubImpl classStub = new PsiClassStubImpl(type, parentStub, qname, name, null, flags);
            classStub.setLanguageLevel(LanguageLevel.values()[languageLevelId]);
            classStub.setSourceFileName(sourceFileName);
            psiClassStubImpl = classStub;
            if (psiClassStubImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/JavaClassElementType.deserialize must not return null");
            return psiClassStubImpl;
        }
        StringRef baseRef = dataStream.readName();
        psiClassStubImpl = new PsiClassStubImpl(type, parentStub, null, null, baseRef, flags);
        if (psiClassStubImpl != null) return psiClassStubImpl;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/JavaClassElementType.deserialize must not return null");
    }

    @Override
    public void indexStub(@NotNull PsiClassStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.indexStub must not be null");
        }
        if (sink == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaClassElementType.indexStub must not be null");
        }
        boolean isAnonymous = stub.isAnonymous();
        if (isAnonymous) {
            String baseRef = stub.getBaseClassReferenceText();
            if (baseRef != null) {
                sink.occurrence(JavaStubIndexKeys.ANONYMOUS_BASEREF, PsiNameHelper.getShortClassName(baseRef));
            }
        } else {
            String fqn;
            String shortName = stub.getName();
            if (shortName != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_SHORT_NAMES, shortName);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(JavaStubIndexKeys.CLASS_FQN, fqn.hashCode());
            }
        }
    }

    @Override
    public String getId(PsiClassStub stub) {
        String name = stub.getName();
        return name != null ? name : super.getId(stub);
    }
}

