/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementType;
import com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import com.intellij.psi.impl.java.stubs.impl.PsiNameValuePairStubImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaNameValuePairType
extends JavaStubElementType<PsiNameValuePairStub, PsiNameValuePair> {
    protected JavaNameValuePairType() {
        super("NAME_VALUE_PAIR", true);
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaNameValuePairType.createPsi must not be null");
        }
        return new PsiNameValuePairImpl(node);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        NameValuePairElement nameValuePairElement = new NameValuePairElement();
        if (nameValuePairElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/JavaNameValuePairType.createCompositeNode must not return null");
        }
        return nameValuePairElement;
    }

    @Override
    public PsiNameValuePairStub createStub(LighterAST tree, LighterASTNode node, StubElement parentStub) {
        String name = null;
        String value = null;
        List<LighterASTNode> children = tree.getChildren(node);
        for (LighterASTNode child : children) {
            if (child.getTokenType() == JavaTokenType.IDENTIFIER) {
                name = RecordUtil.intern(tree.getCharTable(), child);
                continue;
            }
            if (child.getTokenType() != JavaElementType.LITERAL_EXPRESSION) continue;
            value = RecordUtil.intern(tree.getCharTable(), tree.getChildren(child).get(0));
            value = StringUtil.stripQuotesAroundValue(value);
        }
        return new PsiNameValuePairStubImpl(parentStub, StringRef.fromString(name), StringRef.fromString(value));
    }

    @Override
    public PsiNameValuePair createPsi(@NotNull PsiNameValuePairStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaNameValuePairType.createPsi must not be null");
        }
        return this.getPsiFactory(stub).createNameValuePair(stub);
    }

    @Override
    public void serialize(@NotNull PsiNameValuePairStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaNameValuePairType.serialize must not be null");
        }
        if (dataStream == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaNameValuePairType.serialize must not be null");
        }
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getValue());
    }

    @Override
    @NotNull
    public PsiNameValuePairStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaNameValuePairType.deserialize must not be null");
        }
        StringRef name = dataStream.readName();
        PsiNameValuePairStubImpl psiNameValuePairStubImpl = new PsiNameValuePairStubImpl(parentStub, name, dataStream.readName());
        if (psiNameValuePairStubImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/java/stubs/JavaNameValuePairType.deserialize must not return null");
        }
        return psiNameValuePairStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiNameValuePairStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaNameValuePairType.indexStub must not be null");
        }
        if (sink == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/java/stubs/JavaNameValuePairType.indexStub must not be null");
        }
    }
}

