/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightReferenceParameterList;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightClassReference
extends LightElement
implements PsiJavaCodeReferenceElement {
    private final String myText;
    private final String myClassName;
    private final PsiElement myContext;
    private final GlobalSearchScope myResolveScope;
    private final PsiClass myRefClass;
    private final PsiSubstitutor mySubstitutor;
    private LightReferenceParameterList myParameterList;

    private LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull @NonNls String className, PsiSubstitutor substitutor, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myText = text;
        this.myClassName = className;
        this.myResolveScope = resolveScope;
        this.myContext = null;
        this.myRefClass = null;
        this.mySubstitutor = substitutor;
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull @NonNls String className, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        this(manager, text, className, null, resolveScope);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull @NonNls String className, PsiSubstitutor substitutor, PsiElement context) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myText = text;
        this.myClassName = className;
        this.mySubstitutor = substitutor;
        this.myContext = context;
        this.myResolveScope = null;
        this.myRefClass = null;
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull PsiClass refClass) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (refClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        this(manager, text, refClass, null);
    }

    public LightClassReference(@NotNull PsiManager manager, @NotNull @NonNls String text, @NotNull PsiClass refClass, PsiSubstitutor substitutor) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        if (refClass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.<init> must not be null");
        }
        super(manager, JavaLanguage.INSTANCE);
        this.myText = text;
        this.myRefClass = refClass;
        this.myResolveScope = null;
        this.myClassName = null;
        this.myContext = null;
        this.mySubstitutor = substitutor;
    }

    @Override
    public PsiElement resolve() {
        if (this.myClassName != null) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
            if (this.myContext != null) {
                return facade.getResolveHelper().resolveReferencedClass(this.myClassName, this.myContext);
            }
            return facade.findClass(this.myClassName, this.myResolveScope);
        }
        return this.myRefClass;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult javaResolveResult;
        PsiElement resolved = this.resolve();
        if (resolved == null) {
            javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.advancedResolve must not return null");
            return javaResolveResult;
        }
        PsiSubstitutor substitutor = this.mySubstitutor;
        if (substitutor == null) {
            substitutor = resolved instanceof PsiClass ? JavaPsiFacade.getInstance(this.myManager.getProject()).getElementFactory().createRawSubstitutor((PsiClass)resolved) : PsiSubstitutor.EMPTY;
        }
        if ((javaResolveResult = new CandidateInfo(resolved, substitutor)) != null) return javaResolveResult;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.advancedResolve must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public JavaResolveResult[] multiResolve(boolean incompleteCode) {
        JavaResolveResult[] javaResolveResultArray;
        JavaResolveResult result = this.advancedResolve(incompleteCode);
        if (result != JavaResolveResult.EMPTY) {
            javaResolveResultArray = new JavaResolveResult[]{result};
            if (javaResolveResultArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.multiResolve must not return null");
            return javaResolveResultArray;
        }
        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
        if (JavaResolveResult.EMPTY_ARRAY != null) return javaResolveResultArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.multiResolve must not return null");
    }

    @Override
    public void processVariants(PsiScopeProcessor processor) {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public PsiReferenceParameterList getParameterList() {
        if (this.myParameterList == null) {
            this.myParameterList = new LightReferenceParameterList(this.myManager, PsiTypeElement.EMPTY_ARRAY);
        }
        return this.myParameterList;
    }

    @Override
    public String getQualifiedName() {
        if (this.myClassName != null) {
            PsiClass psiClass;
            if (this.myContext != null && (psiClass = (PsiClass)this.resolve()) != null) {
                return psiClass.getQualifiedName();
            }
            return this.myClassName;
        }
        return this.myRefClass.getQualifiedName();
    }

    @Override
    public String getReferenceName() {
        if (this.myClassName != null) {
            return PsiNameHelper.getShortClassName(this.myClassName);
        }
        if (this.myRefClass instanceof PsiAnonymousClass) {
            return ((PsiAnonymousClass)this.myRefClass).getBaseClassReference().getReferenceName();
        }
        return this.myRefClass.getName();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiReference getReference() {
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getCanonicalText() {
        String string;
        String name = this.getQualifiedName();
        if (name == null) {
            string = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.getCanonicalText must not return null");
        } else {
            PsiType[] types = this.getTypeParameters();
            if (types.length == 0) {
                string = name;
                if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.getCanonicalText must not return null");
                return string;
            } else {
                StringBuffer buf = new StringBuffer();
                buf.append(name);
                buf.append('<');
                for (int i = 0; i < types.length; ++i) {
                    if (i > 0) {
                        buf.append(',');
                    }
                    buf.append(types[i].getCanonicalText());
                }
                buf.append('>');
                string = buf.toString();
                if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.getCanonicalText must not return null");
                return string;
            }
        }
    }

    @Override
    public PsiElement copy() {
        if (this.myClassName != null) {
            if (this.myContext != null) {
                return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myContext);
            }
            return new LightClassReference(this.myManager, this.myText, this.myClassName, this.mySubstitutor, this.myResolveScope);
        }
        return new LightClassReference(this.myManager, this.myText, this.myRefClass, this.mySubstitutor);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.bindToElement must not be null");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/light/LightClassReference.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "LightClassReference:" + this.myText;
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return element instanceof PsiClass && this.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        throw new RuntimeException("Variants are not available for light references");
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Override
    public PsiElement getElement() {
        return this;
    }

    @Override
    public boolean isValid() {
        return this.myRefClass == null || this.myRefClass.isValid();
    }

    @Override
    @NotNull
    public PsiType[] getTypeParameters() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/light/LightClassReference.getTypeParameters must not return null");
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public PsiElement getQualifier() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }
}

