/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartTypePointerManagerImpl
extends SmartTypePointerManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.smartPointers.SmartTypePointerManagerImpl");
    private static final SmartTypePointer NULL_POINTER = new SmartTypePointer(){

        @Override
        public PsiType getType() {
            return null;
        }
    };
    private final SmartPointerManager myPsiPointerManager;
    private final Project myProject;

    public SmartTypePointerManagerImpl(SmartPointerManager psiPointerManager, Project project) {
        this.myPsiPointerManager = psiPointerManager;
        this.myProject = project;
    }

    @Override
    @NotNull
    public SmartTypePointer createSmartTypePointer(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl.createSmartTypePointer must not be null");
        }
        SmartTypePointer pointer = type.accept(new SmartTypeCreatingVisitor());
        SmartTypePointer smartTypePointer = pointer != null ? pointer : NULL_POINTER;
        if (smartTypePointer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl.createSmartTypePointer must not return null");
        }
        return smartTypePointer;
    }

    private class SmartTypeCreatingVisitor
    extends PsiTypeVisitor<SmartTypePointer> {
        private SmartTypeCreatingVisitor() {
        }

        @Override
        public SmartTypePointer visitPrimitiveType(PsiPrimitiveType primitiveType) {
            return new SimpleTypePointer(primitiveType);
        }

        @Override
        public SmartTypePointer visitArrayType(PsiArrayType arrayType) {
            SmartTypePointer componentTypePointer = arrayType.getComponentType().accept(this);
            return componentTypePointer != null ? new ArrayTypePointer(arrayType, componentTypePointer) : null;
        }

        @Override
        public SmartTypePointer visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            SmartTypePointer boundPointer = bound == null ? null : bound.accept(this);
            return new WildcardTypePointer(wildcardType, boundPointer);
        }

        @Override
        public SmartTypePointer visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                if (classType instanceof PsiClassReferenceType) {
                    return new ClassReferenceTypePointer((PsiClassReferenceType)classType);
                }
                return new SimpleTypePointer(classType);
            }
            if (classType instanceof PsiClassReferenceType) {
                classType = ((PsiClassReferenceType)classType).createImmediateCopy();
            }
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            HashMap<SmartPsiElementPointer, SmartTypePointer> map = new HashMap<SmartPsiElementPointer, SmartTypePointer>();
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass)) {
                PsiType substitutionResult = substitutor.substitute(typeParameter);
                if (substitutionResult == null) continue;
                SmartPsiElementPointer<PsiTypeParameter> pointer = SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(typeParameter);
                map.put(pointer, substitutionResult.accept(this));
            }
            return new ClassTypePointer(classType, SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(aClass), map);
        }

        @Override
        public SmartTypePointer visitDisjunctionType(PsiDisjunctionType disjunctionType) {
            return new DisjunctionTypePointer(disjunctionType);
        }
    }

    private class DisjunctionTypePointer
    extends TypePointerBase<PsiDisjunctionType> {
        private final List<SmartTypePointer> myPointers;

        private DisjunctionTypePointer(@NotNull PsiDisjunctionType type) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$DisjunctionTypePointer.<init> must not be null");
            }
            super(type);
            this.myPointers = ContainerUtil.map(type.getDisjunctions(), new Function<PsiType, SmartTypePointer>(){

                @Override
                public SmartTypePointer fun(PsiType psiType) {
                    return SmartTypePointerManagerImpl.this.createSmartTypePointer(psiType);
                }
            });
        }

        @Override
        protected PsiDisjunctionType calcType() {
            List<PsiType> types = ContainerUtil.map(this.myPointers, new NullableFunction<SmartTypePointer, PsiType>(){

                @Override
                public PsiType fun(SmartTypePointer typePointer) {
                    return typePointer.getType();
                }
            });
            return new PsiDisjunctionType(types, PsiManager.getInstance(SmartTypePointerManagerImpl.this.myProject));
        }
    }

    private class ClassReferenceTypePointer
    extends TypePointerBase<PsiClassReferenceType> {
        private final SmartPsiElementPointer mySmartPsiElementPointer;
        private final String myReferenceText;

        ClassReferenceTypePointer(@NotNull PsiClassReferenceType type) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassReferenceTypePointer.<init> must not be null");
            }
            super(type);
            PsiJavaCodeReferenceElement reference = type.getReference();
            this.mySmartPsiElementPointer = SmartTypePointerManagerImpl.this.myPsiPointerManager.createSmartPsiElementPointer(reference);
            this.myReferenceText = reference.getText();
        }

        @Override
        protected PsiClassReferenceType calcType() {
            PsiClassReferenceType myType = null;
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.mySmartPsiElementPointer.getElement();
            PsiElementFactory factory = JavaPsiFacade.getInstance(SmartTypePointerManagerImpl.this.myProject).getElementFactory();
            if (referenceElement != null) {
                myType = (PsiClassReferenceType)factory.createType(referenceElement);
            } else {
                try {
                    myType = (PsiClassReferenceType)factory.createTypeFromText(this.myReferenceText, null);
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            return myType;
        }
    }

    private static abstract class TypePointerBase<T extends PsiType>
    implements SmartTypePointer {
        private Reference<T> myTypeRef;

        TypePointerBase(@NotNull T type) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$TypePointerBase.<init> must not be null");
            }
            this.myTypeRef = new SoftReference<T>(type);
        }

        public T getType() {
            PsiType myType;
            Reference<T> typeRef = this.myTypeRef;
            PsiType psiType = myType = typeRef == null ? null : (PsiType)typeRef.get();
            if (myType != null && myType.isValid()) {
                return (T)myType;
            }
            myType = this.calcType();
            this.myTypeRef = myType == null ? null : new SoftReference<PsiType>(myType);
            return (T)myType;
        }

        @Nullable
        protected abstract T calcType();
    }

    private static class ClassTypePointer
    extends TypePointerBase<PsiClassType> {
        private final SmartPsiElementPointer myClass;
        private final Map<SmartPsiElementPointer, SmartTypePointer> myMap;

        public ClassTypePointer(@NotNull PsiClassType type, @NotNull SmartPsiElementPointer aClass, @NotNull Map<SmartPsiElementPointer, SmartTypePointer> map) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassTypePointer.<init> must not be null");
            }
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassTypePointer.<init> must not be null");
            }
            if (map == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ClassTypePointer.<init> must not be null");
            }
            super(type);
            this.myClass = aClass;
            this.myMap = map;
        }

        @Override
        protected PsiClassType calcType() {
            Object classElement = this.myClass.getElement();
            if (!(classElement instanceof PsiClass)) {
                return null;
            }
            HashMap<PsiTypeParameter, PsiType> resurrected = new HashMap<PsiTypeParameter, PsiType>();
            Set<Map.Entry<SmartPsiElementPointer, SmartTypePointer>> set = this.myMap.entrySet();
            for (Map.Entry<SmartPsiElementPointer, SmartTypePointer> entry : set) {
                Object element = entry.getKey().getElement();
                if (!(element instanceof PsiTypeParameter)) continue;
                SmartTypePointer typePointer = entry.getValue();
                resurrected.put((PsiTypeParameter)element, typePointer == null ? null : typePointer.getType());
            }
            for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiClass)classElement)) {
                if (resurrected.containsKey(typeParameter)) continue;
                resurrected.put(typeParameter, null);
            }
            PsiSubstitutor resurrectedSubstitutor = PsiSubstitutorImpl.createSubstitutor(resurrected);
            return new PsiImmediateClassType((PsiClass)classElement, resurrectedSubstitutor);
        }
    }

    private static class WildcardTypePointer
    extends TypePointerBase<PsiWildcardType> {
        private final PsiManager myManager;
        private final SmartTypePointer myBoundPointer;
        private final boolean myIsExtending;

        public WildcardTypePointer(@NotNull PsiWildcardType type, @Nullable SmartTypePointer boundPointer) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$WildcardTypePointer.<init> must not be null");
            }
            super(type);
            this.myManager = type.getManager();
            this.myBoundPointer = boundPointer;
            this.myIsExtending = type.isExtends();
        }

        @Override
        protected PsiWildcardType calcType() {
            if (this.myBoundPointer == null) {
                return PsiWildcardType.createUnbounded(this.myManager);
            }
            PsiType type = this.myBoundPointer.getType();
            assert (type != null) : this.myBoundPointer;
            if (this.myIsExtending) {
                return PsiWildcardType.createExtends(this.myManager, type);
            }
            return PsiWildcardType.createSuper(this.myManager, type);
        }
    }

    private static class ArrayTypePointer
    extends TypePointerBase<PsiArrayType> {
        private final SmartTypePointer myComponentTypePointer;

        public ArrayTypePointer(@NotNull PsiArrayType type, @NotNull SmartTypePointer componentTypePointer) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ArrayTypePointer.<init> must not be null");
            }
            if (componentTypePointer == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$ArrayTypePointer.<init> must not be null");
            }
            super(type);
            this.myComponentTypePointer = componentTypePointer;
        }

        @Override
        @Nullable
        protected PsiArrayType calcType() {
            PsiType type = this.myComponentTypePointer.getType();
            return type == null ? null : new PsiArrayType(type);
        }
    }

    private static class SimpleTypePointer
    implements SmartTypePointer {
        private final PsiType myType;

        private SimpleTypePointer(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/smartPointers/SmartTypePointerManagerImpl$SimpleTypePointer.<init> must not be null");
            }
            this.myType = type;
        }

        @Override
        public PsiType getType() {
            return this.myType;
        }
    }
}

