/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldImpl
extends JavaStubPsiElement<PsiFieldStub>
implements Queryable,
PsiField,
PsiVariableEx {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiFieldImpl");
    private volatile SoftReference<PsiType> myCachedType = null;
    private volatile Object myCachedInitializerValue = null;

    public PsiFieldImpl(PsiFieldStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.FIELD);
    }

    protected PsiFieldImpl(PsiFieldStub stub, IStubElementType type) {
        super(stub, type);
    }

    public PsiFieldImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    private void dropCached() {
        this.myCachedInitializerValue = null;
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiFieldImpl clone = (PsiFieldImpl)super.clone();
        clone.dropCached();
        return clone;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getNode must not return null");
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getNameIdentifier must not return null");
        }
        return psiIdentifier;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getName() {
        String string;
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            string = stub.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getName must not return null");
            return string;
        }
        string = this.getNameIdentifier().getText();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getName must not return null");
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.setName must not be null");
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    public PsiType getTypeNoResolve() {
        return this.getType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType;
        PsiType type;
        PsiType psiType2;
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub == null) {
            this.myCachedType = null;
            PsiType psiType3 = JavaSharedImplUtil.getType(this.getTypeElement(), this.getNameIdentifier());
            psiType2 = psiType3;
            if (psiType3 == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getType must not return null");
            return psiType2;
        }
        SoftReference<PsiType> cachedType = this.myCachedType;
        if (cachedType != null && (type = (PsiType)cachedType.get()) != null) {
            PsiType psiType4 = type;
            psiType2 = psiType4;
            if (psiType4 != null) return psiType2;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getType must not return null");
        }
        String typeText = TypeInfo.createTypeText(stub.getType(true));
        try {
            PsiType type2 = JavaPsiFacade.getInstance(this.getProject()).getParserFacade().createTypeFromText(typeText, this);
            this.myCachedType = new SoftReference<PsiType>(type2);
            psiType = type2;
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            psiType2 = null;
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getType must not return null");
        }
        psiType2 = psiType;
        if (psiType == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getType must not return null");
        return psiType2;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField != this) {
            return firstField.getTypeElement();
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList;
        PsiModifierList selfModifierList = this.getSelfModifierList();
        if (selfModifierList != null) {
            psiModifierList = selfModifierList;
            if (psiModifierList == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getModifierList must not return null");
            return psiModifierList;
        }
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField == this) {
            if (!this.isValid()) {
                throw new PsiInvalidElementAccessException(this);
            }
            PsiField lastResort = this.findFirstFieldByTree();
            if (lastResort == this) {
                throw new IllegalStateException("Missing modifier list for sequence of fields: '" + this.getText() + "'");
            }
            firstField = lastResort;
        }
        if ((psiModifierList = firstField.getModifierList()) != null) return psiModifierList;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getModifierList must not return null");
    }

    @Nullable
    private PsiModifierList getSelfModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    private PsiField findFirstFieldInDeclaration() {
        if (this.getSelfModifierList() != null) {
            return this;
        }
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            List<StubElement> siblings = stub.getParentStub().getChildrenStubs();
            int idx = siblings.indexOf(stub);
            assert (idx >= 0);
            for (int i = idx - 1; i >= 0 && siblings.get(i) instanceof PsiFieldStub; --i) {
                PsiFieldStub prevField = (PsiFieldStub)siblings.get(i);
                PsiFieldImpl prevFieldPsi = (PsiFieldImpl)prevField.getPsi();
                if (prevFieldPsi.getSelfModifierList() == null) continue;
                return prevFieldPsi;
            }
        }
        return this.findFirstFieldByTree();
    }

    private PsiField findFirstFieldByTree() {
        CompositeElement treeElement = this.getNode();
        ASTNode modifierList = treeElement.findChildByRole(8);
        if (modifierList == null) {
            ASTNode prevField;
            for (prevField = treeElement.getTreePrev(); prevField != null && prevField.getElementType() != JavaElementType.FIELD; prevField = prevField.getTreePrev()) {
            }
            if (prevField == null) {
                return this;
            }
            return ((PsiFieldImpl)SourceTreeToPsiMap.treeElementToPsi(prevField)).findFirstFieldInDeclaration();
        }
        return this;
    }

    @Override
    public PsiExpression getInitializer() {
        return (PsiExpression)this.getNode().findChildByRoleAsPsiElement(21);
    }

    @Override
    public boolean hasInitializer() {
        if (this.getStub() != null) {
            return this.getInitializerText() != null;
        }
        return this.getInitializer() != null;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Nullable
    private Object _computeConstantValue(Set<PsiVariable> visitedVars) {
        PsiExpression initializer;
        Object cachedInitializerValue = this.myCachedInitializerValue;
        if (cachedInitializerValue != null && !(cachedInitializerValue instanceof PsiExpression)) {
            return cachedInitializerValue;
        }
        PsiType type = this.getType();
        if (!(type instanceof PsiPrimitiveType) && !type.equalsToText("java.lang.String")) {
            return null;
        }
        if (cachedInitializerValue != null) {
            initializer = (PsiExpression)cachedInitializerValue;
        } else {
            PsiFieldStub stub = (PsiFieldStub)this.getStub();
            if (stub == null) {
                initializer = this.getInitializer();
                if (initializer == null) {
                    return null;
                }
            } else {
                String initializerText = stub.getInitializerText();
                if (initializerText == null) {
                    return null;
                }
                if (";INITIALIZER_NOT_STORED;".equals(initializerText)) {
                    return null;
                }
                if (";INITIALIZER_TOO_LONG;".equals(initializerText)) {
                    this.getNode();
                    return this.computeConstantValue(visitedVars);
                }
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
                initializer = parserFacade.createExpressionFromText(initializerText, this);
            }
        }
        Object result = PsiConstantEvaluationHelperImpl.computeCastTo(initializer, type, visitedVars);
        this.myCachedInitializerValue = initializer instanceof PsiLiteralExpression ? result : initializer;
        return result;
    }

    @Override
    public Object computeConstantValue() {
        Object cachedInitializerValue = this.myCachedInitializerValue;
        if (cachedInitializerValue != null && !(cachedInitializerValue instanceof PsiExpression)) {
            return cachedInitializerValue;
        }
        return this.computeConstantValue(new HashSet<PsiVariable>(2));
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        return JavaResolveCache.getInstance(this.getProject()).computeConstantValueWithCaching(this, OurConstValueComputer.INSTANCE, visitedVars);
    }

    @Nullable
    private String getInitializerText() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.getInitializerText();
        }
        throw new RuntimeException("Shall not be called when in stubless mode");
    }

    @Override
    public boolean isDeprecated() {
        PsiFieldStub stub = (PsiFieldStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation(this);
        }
        return PsiImplUtil.isDeprecatedByDocTag(this) || PsiImplUtil.isDeprecatedByAnnotation(this);
    }

    @Override
    public PsiDocComment getDocComment() {
        CompositeElement treeElement = this.getNode();
        if (this.getTypeElement() != null) {
            PsiElement element = treeElement.findChildByRoleAsPsiElement(7);
            return element instanceof PsiDocComment ? (PsiDocComment)element : null;
        }
        ASTNode prevField = treeElement.getTreePrev();
        while (prevField.getElementType() != JavaElementType.FIELD) {
            prevField = prevField.getTreePrev();
        }
        return ((PsiField)SourceTreeToPsiMap.treeElementToPsi(prevField)).getDocComment();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        ASTNode nextField;
        ASTNode comma;
        CheckUtil.checkWritable(this);
        PsiTypeElement type = this.getTypeElement();
        PsiModifierList modifierList = this.getModifierList();
        ASTNode field = SourceTreeToPsiMap.psiElementToTree(type.getParent());
        while ((comma = PsiImplUtil.skipWhitespaceAndComments(field.getTreeNext())) != null && comma.getElementType() == JavaTokenType.COMMA && (nextField = PsiImplUtil.skipWhitespaceAndComments(comma.getTreeNext())) != null && nextField.getElementType() == JavaElementType.FIELD) {
            LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, null, this.getManager());
            CodeEditUtil.addChild(field, semicolon, null);
            CodeEditUtil.removeChild(comma.getTreeParent(), comma);
            PsiElement typeClone = type.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(typeClone), nextField.getFirstChildNode());
            PsiElement modifierListClone = modifierList.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(modifierListClone), nextField.getFirstChildNode());
            field = nextField;
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitField(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiClass originalClass = (PsiClass)this.getContainingClass().getOriginalElement();
        PsiField originalField = originalClass.findFieldByName(this.getName(), false);
        return originalField != null ? originalField : this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiFieldImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiFieldImpl.putInfo must not be null");
        }
        info.put("fieldName", this.getName());
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    private static class OurConstValueComputer
    implements JavaResolveCache.ConstValueComputer {
        private static final OurConstValueComputer INSTANCE = new OurConstValueComputer();

        private OurConstValueComputer() {
        }

        @Override
        public Object execute(PsiVariable variable, Set<PsiVariable> visitedVars) {
            return ((PsiFieldImpl)variable)._computeConstantValue(visitedVars);
        }
    }
}

