/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.ConstraintType;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.PsiResolveHelperImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProcessCandidateParameterTypeInferencePolicy
extends DefaultParameterTypeInferencePolicy {
    public static final ProcessCandidateParameterTypeInferencePolicy INSTANCE = new ProcessCandidateParameterTypeInferencePolicy();

    @Override
    public Pair<PsiType, ConstraintType> inferTypeConstraintFromCallContext(PsiExpression innerMethodCall, PsiExpressionList expressionList, PsiCallExpression contextCall, PsiTypeParameter typeParameter) {
        PsiExpression[] expressions = expressionList.getExpressions();
        PsiElement parent = innerMethodCall;
        while (parent.getParent() instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        int i = ArrayUtil.find(expressions, parent);
        if (i < 0) {
            return null;
        }
        PsiMethod owner = (PsiMethod)typeParameter.getOwner();
        if (owner == null) {
            return null;
        }
        try {
            JavaResolveResult[] results = this.getResults(contextCall, i);
            PsiType innerReturnType = owner.getReturnType();
            for (JavaResolveResult result : results) {
                PsiSubstitutor substitutor;
                Pair<PsiType, ConstraintType> constraint;
                if (result == null || (constraint = ProcessCandidateParameterTypeInferencePolicy.inferConstraint(typeParameter, innerMethodCall, i, innerReturnType, result, substitutor = this.getSubstitutor(contextCall, expressions, i, result))) == null) continue;
                return constraint;
            }
        }
        catch (MethodProcessorSetupFailedException ev) {
            return null;
        }
        return null;
    }

    protected PsiSubstitutor getSubstitutor(PsiCallExpression contextCall, PsiExpression[] expressions, int i, JavaResolveResult result) {
        if (result instanceof MethodCandidateInfo) {
            List<PsiExpression> leftArgs = this.getExpressions(expressions, i);
            return ((MethodCandidateInfo)result).inferSubstitutorFromArgs(this, leftArgs.toArray(new PsiExpression[leftArgs.size()]));
        }
        return result.getSubstitutor();
    }

    protected List<PsiExpression> getExpressions(PsiExpression[] expressions, int i) {
        return Arrays.asList(expressions).subList(0, i);
    }

    protected static Pair<PsiType, ConstraintType> inferConstraint(PsiTypeParameter typeParameter, PsiExpression innerMethodCall, int parameterIdx, PsiType innerReturnType, JavaResolveResult result, final PsiSubstitutor substitutor) {
        PsiElement element = result.getElement();
        if (element instanceof PsiMethod) {
            PsiParameter finalParameter;
            PsiType type;
            Pair<PsiType, ConstraintType> constraint;
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiParameter parameter = null;
            if (parameters.length > parameterIdx) {
                parameter = parameters[parameterIdx];
            } else if (method.isVarArgs()) {
                parameter = parameters[parameters.length - 1];
            }
            if (parameter != null && (constraint = PsiResolveHelperImpl.getSubstitutionForTypeParameterConstraint(typeParameter, innerReturnType, type = PsiResolveHelper.ourGuard.doPreventingRecursion(innerMethodCall, true, new Computable<PsiType>(finalParameter = parameter){
                final /* synthetic */ PsiParameter val$finalParameter;
                {
                    this.val$finalParameter = psiParameter;
                }

                @Override
                public PsiType compute() {
                    return substitutor.substitute(this.val$finalParameter.getType());
                }
            }), false, PsiUtil.getLanguageLevel(finalParameter))) != null) {
                return constraint;
            }
        }
        return null;
    }

    @NotNull
    protected JavaResolveResult[] getResults(PsiCallExpression contextCall, int exprIdx) throws MethodProcessorSetupFailedException {
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(contextCall);
        PsiScopesUtil.setupAndRunProcessor(processor, contextCall, false);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/ProcessCandidateParameterTypeInferencePolicy.getResults must not return null");
        }
        return javaResolveResultArray;
    }
}

