/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.LazyParseableElement");
    private final ChameleonLock lock;
    private CharSequence myText;
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type, CharSequence text) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseableElement.<init> must not be null");
        }
        super(type);
        ChameleonLock chameleonLock = this.lock = new ChameleonLock();
        synchronized (chameleonLock) {
            CharSequence charSequence = this.myText = text == null ? null : ((Object)text).toString();
            if (text != null) {
                this.setCachedLength(text.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        super.clearCaches();
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myText != null) {
                this.setCachedLength(this.myText.length());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String getText() {
        String string;
        CharSequence text = this.myText();
        if (text != null) {
            string = ((Object)text).toString();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseableElement.getText must not return null");
            return string;
        }
        string = super.getText();
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseableElement.getText must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence charSequence;
        CharSequence text = this.myText();
        if (text != null) {
            charSequence = text;
            if (charSequence == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseableElement.getChars must not return null");
            return charSequence;
        }
        charSequence = super.getText();
        if (charSequence != null) return charSequence;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/LazyParseableElement.getChars must not return null");
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int getNotCachedLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getNotCachedLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseableElement.textMatches must not be null");
        }
        CharSequence text = this.myText();
        if (text != null) {
            return LeafElement.leafTextMatches(text, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    public boolean isParsed() {
        return this.myText() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence myText() {
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            return this.myText;
        }
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParsed() {
        CharSequence text;
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        if ((text = this.myText()) == null) {
            return;
        }
        if (TreeUtil.getFileElement(this) == null) {
            LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ILazyParseableElementType type = (ILazyParseableElementType)this.getElementType();
        ASTNode parsedNode = type.parseContents(this);
        if (parsedNode == null && text.length() > 0) {
            CharSequence diagText = ApplicationManager.getApplication().isInternal() ? text : "";
            LOG.error("No parse for a non-empty string: " + diagText + "; type=" + LogUtil.objectAndClass(type));
        }
        ChameleonLock chameleonLock = this.lock;
        synchronized (chameleonLock) {
            if (this.myText == null) {
                return;
            }
            if (this.rawFirstChild() != null) {
                LOG.error("Reentrant parsing?");
            }
            this.myText = null;
            if (parsedNode == null) {
                return;
            }
            super.rawAddChildrenWithoutNotifications((TreeElement)parsedNode);
        }
        this.createAllChildrenPsiIfNecessary();
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/LazyParseableElement.rawAddChildrenWithoutNotifications must not be null");
        }
        if (this.myText() != null) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(@Nullable char[] buffer, int start) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars(text, buffer, start);
        }
        return start + text.length();
    }

    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static class ChameleonLock {
        private ChameleonLock() {
        }

        @NonNls
        public String toString() {
            return "chameleon parsing lock";
        }
    }
}

