/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.StringRef;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class StubInputStream
extends DataInputStream {
    private final AbstractStringEnumerator myNameStorage;
    private final byte[] myStringIOBuffer;

    public StubInputStream(@NotNull InputStream in, @NotNull AbstractStringEnumerator nameStorage) {
        if (in == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/stubs/StubInputStream.<init> must not be null");
        }
        if (nameStorage == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/stubs/StubInputStream.<init> must not be null");
        }
        super(in);
        this.myStringIOBuffer = IOUtil.allocReadWriteUTFBuffer();
        this.myNameStorage = nameStorage;
    }

    public String readUTFFast() throws IOException {
        return IOUtil.readUTFFast(this.myStringIOBuffer, this);
    }

    public StringRef readName() throws IOException {
        return DataInputOutputUtil.readNAME(this, this.myNameStorage);
    }

    public int readVarInt() throws IOException {
        return DataInputOutputUtil.readINT(this);
    }

    public String stringFromId(int id) throws IOException {
        return this.myNameStorage.valueOf(id);
    }
}

