/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConcurrencyUtil {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static <K, V> V cacheOrGet(@NotNull ConcurrentMap<K, V> map, @NotNull K key, @NotNull V defaultValue) {
        Object v;
        if (map == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.cacheOrGet must not be null");
        }
        Object v2 = map.get(key);
        if (v2 != null) {
            v = v2;
            if (v == null) throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.cacheOrGet must not return null");
            return v;
        }
        V prev = map.putIfAbsent(key, defaultValue);
        v = prev == null ? defaultValue : prev;
        if (v != null) return v;
        throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.cacheOrGet must not return null");
    }

    @NotNull
    public static ScheduledThreadPoolExecutor newSingleScheduledThreadExecutor(@NonNls @NotNull String threadFactoryName, int threadPriority) {
        if (threadFactoryName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.newSingleScheduledThreadExecutor must not be null");
        }
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ConcurrencyUtil.newNamedThreadFactory(threadFactoryName, true, threadPriority));
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = executor;
        if (scheduledThreadPoolExecutor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.newSingleScheduledThreadExecutor must not return null");
        }
        return scheduledThreadPoolExecutor;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String threadName, final boolean isDaemon, final int threadPriority) {
        if (threadName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.newNamedThreadFactory must not be null");
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil$1.newThread must not be null");
                }
                Thread thread = new Thread(r, threadName);
                thread.setDaemon(isDaemon);
                thread.setPriority(threadPriority);
                Thread thread2 = thread;
                if (thread2 == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil$1.newThread must not return null");
                }
                return thread2;
            }
        };
        if (threadFactory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.newNamedThreadFactory must not return null");
        }
        return threadFactory;
    }

    @NotNull
    public static ThreadFactory newNamedThreadFactory(final @NonNls @NotNull String threadName) {
        if (threadName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil.newNamedThreadFactory must not be null");
        }
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/ConcurrencyUtil$2.newThread must not be null");
                }
                Thread thread = new Thread(r, threadName);
                if (thread == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil$2.newThread must not return null");
                }
                return thread;
            }
        };
        if (threadFactory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ConcurrencyUtil.newNamedThreadFactory must not return null");
        }
        return threadFactory;
    }
}

