/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ConcurrentMostlySingularMultiMap<K, V>
extends MostlySingularMultiMap<K, V> {
    @Override
    @NotNull
    protected Map<K, Object> createMap() {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        if (concurrentHashMap == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/ConcurrentMostlySingularMultiMap.createMap must not return null");
        }
        return concurrentHashMap;
    }

    @Override
    public void add(@NotNull K key, @NotNull V value) {
        Object[] newArr;
        Object[] newArr2;
        Object[] curArr;
        Object current;
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentMostlySingularMultiMap.add must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentMostlySingularMultiMap.add must not be null");
        }
        ConcurrentMap map = (ConcurrentMap)this.myMap;
        while (!((current = map.get(key)) == null ? ConcurrencyUtil.cacheOrGet(map, key, value) == value : (current instanceof Object[] ? map.replace(key, curArr = (Object[])current, newArr2 = ArrayUtil.append(curArr, value, ArrayUtil.OBJECT_ARRAY_FACTORY)) : map.replace(key, current, newArr = new Object[]{current, value})))) {
        }
    }

    @Override
    public void compact() {
    }

    public boolean replace(@NotNull K key, @NotNull Collection<V> expectedValue, @NotNull Collection<V> newValue) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentMostlySingularMultiMap.replace must not be null");
        }
        if (expectedValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentMostlySingularMultiMap.replace must not be null");
        }
        if (newValue == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ConcurrentMostlySingularMultiMap.replace must not be null");
        }
        ConcurrentMap map = (ConcurrentMap)this.myMap;
        Object[] newArray = ArrayUtil.toObjectArray(newValue);
        Object[] newValueToPut = newArray.length == 0 ? null : (newArray.length == 1 ? newArray[0] : newArray);
        Object oldValue = map.get(key);
        List oldCollection = this.rawValueToCollection(oldValue);
        if (!((Object)oldCollection).equals(expectedValue)) {
            return false;
        }
        if (oldValue == null) {
            return newValueToPut == null || map.putIfAbsent(key, newValueToPut) == null;
        }
        if (newValueToPut == null) {
            return map.remove(key, oldValue);
        }
        return map.replace(key, oldValue, newValueToPut);
    }
}

