/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueHashMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentWeakValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    @Override
    protected ConcurrentRefValueHashMap.MyValueReference<K, V> createRef(@NotNull K key, @NotNull V value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.createRef must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap.createRef must not be null");
        }
        return new MyWeakReference(key, value, this.myQueue);
    }

    private static class MyWeakReference<K, T>
    extends WeakReference<T>
    implements ConcurrentRefValueHashMap.MyValueReference<K, T> {
        private final K key;

        private MyWeakReference(@NotNull K key, @NotNull T referent, @NotNull ReferenceQueue<T> q) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap$MyWeakReference.<init> must not be null");
            }
            if (referent == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap$MyWeakReference.<init> must not be null");
            }
            if (q == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/containers/ConcurrentWeakValueHashMap$MyWeakReference.<init> must not be null");
            }
            super(referent, q);
            this.key = key;
        }

        @Override
        @NotNull
        public K getKey() {
            K k = this.key;
            if (k == null) {
                throw new IllegalStateException("@NotNull method com/intellij/util/containers/ConcurrentWeakValueHashMap$MyWeakReference.getKey must not return null");
            }
            return k;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.MyValueReference that = (ConcurrentRefValueHashMap.MyValueReference)o;
            return this.key.equals(that.getKey()) && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }
}

